/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:answerInvite", flag=16)
public class InviteAnswerMessage
extends MessageContent {
    private static final String TAG = "InviteMessage";
    private String inviteSessionId;
    private String inviteContent;
    private int answerCode = 0;
    private PKInfo mPKInfo;
    public static final Parcelable.Creator<InviteAnswerMessage> CREATOR = new Parcelable.Creator<InviteAnswerMessage>(){

        public InviteAnswerMessage createFromParcel(Parcel source) {
            return new InviteAnswerMessage(source);
        }

        public InviteAnswerMessage[] newArray(int size) {
            return new InviteAnswerMessage[size];
        }
    };

    private InviteAnswerMessage(Parcel source) {
        this.inviteSessionId = source.readString();
        this.inviteContent = source.readString();
        this.answerCode = source.readInt();
        this.mPKInfo = (PKInfo)source.readParcelable(PKInfo.class.getClassLoader());
    }

    public InviteAnswerMessage(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("inviteSessionId")) {
                this.inviteSessionId = jsonObj.getString("inviteSessionId");
            }
            if (jsonObj.has("answerCode")) {
                this.answerCode = jsonObj.getInt("answerCode");
            }
            if (jsonObj.has("inviteContent")) {
                this.inviteContent = jsonObj.getString("inviteContent");
                if (!TextUtils.isEmpty((CharSequence)this.inviteContent)) {
                    JSONObject obj_inviteContent = new JSONObject(this.inviteContent);
                    String key = "";
                    if (obj_inviteContent.has("MultiRoomKey")) {
                        key = obj_inviteContent.getString("MultiRoomKey");
                    }
                    if (obj_inviteContent.has("MultiRoomValue")) {
                        String val = obj_inviteContent.getString("MultiRoomValue");
                        this.mPKInfo = new PKInfo(key, val);
                    }
                }
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("inviteSessionId", (Object)this.inviteSessionId);
            jsonObj.putOpt("inviteContent", (Object)this.inviteContent);
            jsonObj.putOpt("answerCode", (Object)this.answerCode);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.inviteSessionId);
        dest.writeString(this.inviteContent);
        dest.writeInt(this.answerCode);
        dest.writeParcelable((Parcelable)this.getPKInfo(), flags);
    }

    public String getInviteSessionId() {
        return this.inviteSessionId;
    }

    public int getAnswerCode() {
        return this.answerCode;
    }

    public String toString() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("inviteSessionId", (Object)this.inviteSessionId);
            jsonObj.putOpt("inviteContent", (Object)this.inviteContent);
            jsonObj.putOpt("answerCode", (Object)this.answerCode);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
            return "";
        }
        return jsonObj.toString();
    }

    public String getInviteContent() {
        return this.inviteContent;
    }

    public PKInfo getPKInfo() {
        return this.mPKInfo;
    }
}

