/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.os.Build;
import cn.rongcloud.rtc.utils.DeviceUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PerformanceMonitoring {
    private final boolean mAboveAndroidO = Build.VERSION.SDK_INT >= 26;
    private final int mPid;
    private long mTotalT;
    private long mTotalPre;
    private long mTotal;
    private long mIdlePre;
    private long mIdle;
    private long mAppWorkT;
    private long mAppWorkPre;
    private long mAppWork;
    private String[] mSa;
    private RandomAccessFile mAppStatFile;
    private RandomAccessFile mProcStatFile;
    private float mProcRate;
    private float mAppRate;
    private float mCpuRate;

    public PerformanceMonitoring(int pid) {
        this.mPid = pid;
    }

    public void countCpuData() {
        if (this.mAboveAndroidO) {
            this.onCountCpuDataForO();
        } else {
            this.onCountCpuData();
        }
    }

    private void onCountCpuDataForO() {
        this.mCpuRate = DeviceUtils.getProcessCpuRate(5);
    }

    private void onCountCpuData() {
        try {
            if (this.mProcStatFile == null || this.mAppStatFile == null) {
                this.mProcStatFile = new RandomAccessFile("/proc/stat", "r");
                this.mAppStatFile = new RandomAccessFile("/proc/" + this.mPid + "/stat", "r");
            } else {
                this.mProcStatFile.seek(0L);
                this.mAppStatFile.seek(0L);
            }
            String procStr = this.mProcStatFile.readLine();
            this.mSa = procStr.split("[ ]+", 9);
            this.mIdle = this.toLong(this.mSa[4]);
            this.mTotal = this.toLong(this.mSa[1]) + this.toLong(this.mSa[2]) + this.toLong(this.mSa[3]) + this.toLong(this.mSa[4]) + this.toLong(this.mSa[5]) + this.toLong(this.mSa[6]) + this.toLong(this.mSa[7]);
            String s = this.mAppStatFile.readLine();
            this.mSa = s.split("[ ]+", 18);
            this.mAppWork = this.toLong(this.mSa[13]) + this.toLong(this.mSa[14]) + this.toLong(this.mSa[15]) + this.toLong(this.mSa[16]);
            if (this.mTotalPre != 0L) {
                this.mTotalT = this.mTotal - this.mTotalPre;
                long idleT = this.mIdle - this.mIdlePre;
                this.mAppWorkT = this.mAppWork - this.mAppWorkPre;
                this.mProcRate = this.restrictPercentage((float)(this.mTotalT - idleT) * 100.0f / (float)this.mTotalT).floatValue();
                this.mAppRate = this.restrictPercentage((float)this.mAppWorkT * 100.0f / (float)this.mTotalT).floatValue();
            }
            this.mTotalPre = this.mTotal;
            this.mIdlePre = this.mIdle;
            this.mAppWorkPre = this.mAppWork;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Float restrictPercentage(float v) {
        if (v > 100.0f) {
            return Float.valueOf(100.0f);
        }
        if (v < 0.0f) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(v);
    }

    private Long toLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void relase() {
        this.close(this.mProcStatFile);
        this.close(this.mAppStatFile);
        this.mProcStatFile = null;
        this.mAppStatFile = null;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isAboveAndroidO() {
        return this.mAboveAndroidO;
    }

    public float getProcRate() {
        return this.mProcRate;
    }

    public float getAppRate() {
        return this.mAppRate;
    }

    public float getCpuRate() {
        return this.mCpuRate;
    }
}

