/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FFmpegAudioMixer {
    private final String TAG = FFmpegAudioMixer.class.getSimpleName();
    private long nativeFFmpegAudioMixerJni;
    private ByteBuffer mAudioDirectBuffer1;
    private ByteBuffer mAudioBuffTarget;
    private int mBufferSize1 = 0;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int init(int sizeInBytes, int sampleRate, int channels, int audioFormat) {
        Object object = this.lock;
        synchronized (object) {
            int ret = -1;
            this.nativeFFmpegAudioMixerJni = this.nativeCreateFFmpegAudioMixer();
            if (this.nativeFFmpegAudioMixerJni != 0L) {
                this.mAudioBuffTarget = ByteBuffer.allocateDirect((int)((double)sizeInBytes * 1.5)).order(ByteOrder.nativeOrder());
                this.nativeCacheDirectBufferTargetAddress(this.nativeFFmpegAudioMixerJni, this.mAudioBuffTarget);
                ret = this.nativeInit(this.nativeFFmpegAudioMixerJni, sampleRate, channels, audioFormat);
            }
            RLog.d((String)this.TAG, (String)("- init() ret:" + ret));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unInit() {
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeFFmpegAudioMixerJni != 0L) {
                this.nativeUninit(this.nativeFFmpegAudioMixerJni);
                this.nativeDestoryFFmpegAudioMixer(this.nativeFFmpegAudioMixerJni);
                this.nativeFFmpegAudioMixerJni = 0L;
            }
            RLog.d((String)this.TAG, (String)"- unInit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] mix(byte[] audioData1, ByteBuffer audioData2) throws IllegalStateException {
        if (audioData1.length != audioData2.capacity()) {
            ReportUtil.libError(ReportUtil.TAG.FFMPEGAUDIOMIXDATAINVALID, "method|status", "- FFmpegAudioMixer mix()", "audio1 length must be equal audio2 length !");
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            byte[] outSamples = null;
            if (this.nativeFFmpegAudioMixerJni != 0L) {
                int length = audioData1.length;
                if (length != this.mBufferSize1) {
                    this.mBufferSize1 = length;
                    this.mAudioDirectBuffer1 = ByteBuffer.allocateDirect(this.mBufferSize1).order(ByteOrder.nativeOrder());
                    this.nativeCacheDirectBufferAddress1(this.nativeFFmpegAudioMixerJni, this.mAudioDirectBuffer1);
                }
                this.mAudioDirectBuffer1.clear();
                this.mAudioDirectBuffer1.put(audioData1);
                int retSize = this.nativeFFmpegMix(this.nativeFFmpegAudioMixerJni, this.mAudioDirectBuffer1.capacity(), audioData2);
                outSamples = new byte[retSize];
                this.mAudioBuffTarget.clear();
                this.mAudioBuffTarget.get(outSamples);
            }
            return outSamples;
        }
    }

    private native int nativeInit(long var1, int var3, int var4, int var5);

    private native void nativeUninit(long var1);

    private native long nativeCreateFFmpegAudioMixer();

    private native void nativeDestoryFFmpegAudioMixer(long var1);

    private native void nativeCacheDirectBufferAddress1(long var1, ByteBuffer var3);

    private native void nativeCacheDirectBufferTargetAddress(long var1, ByteBuffer var3);

    private native int nativeFFmpegMix(long var1, int var3, ByteBuffer var4);
}

