/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.util;

import android.content.Context;
import com.cooleshow.ffmpegcmd.util.ScreenUtil;
import java.util.List;
import java.util.Locale;

public class FFmpegUtil {
    private static String[] insert(String[] cmd, int position, String inputPath) {
        return FFmpegUtil.insert(cmd, position, inputPath, null);
    }

    private static String[] insert(String[] cmd, int position, String inputPath, String outputPath) {
        if (cmd == null || inputPath == null || position < 2) {
            return cmd;
        }
        int len = outputPath != null ? cmd.length + 2 : cmd.length + 1;
        String[] result = new String[len];
        System.arraycopy(cmd, 0, result, 0, position);
        result[position] = inputPath;
        System.arraycopy(cmd, position, result, position + 1, cmd.length - position);
        if (outputPath != null) {
            result[result.length - 1] = outputPath;
        }
        return result;
    }

    public static String[] insert(String[] cmd, int position1, String inputPath1, int position2, String inputPath2, String outputPath) {
        if (cmd == null || inputPath1 == null || position1 < 2 || inputPath2 == null || position2 < 4) {
            return cmd;
        }
        int len = outputPath != null ? cmd.length + 3 : cmd.length + 2;
        String[] result = new String[len];
        System.arraycopy(cmd, 0, result, 0, position1);
        result[position1] = inputPath1;
        System.arraycopy(cmd, position1, result, position1 + 1, position2 - position1 - 1);
        result[position2] = inputPath2;
        System.arraycopy(cmd, position2 - 1, result, position2 + 1, cmd.length - (position2 - 1));
        if (outputPath != null) {
            result[result.length - 1] = outputPath;
        }
        return result;
    }

    public static String[] transformAudio(String inputPath, String outputPath) {
        String[] result = new String[]{"ffmpeg", "-i", inputPath, outputPath};
        return result;
    }

    public static String[] transformAudio(String inputPath, String acodec, String outputPath) {
        String transformAudioCmd = "ffmpeg -i -acodec %s -ac 2 -ar 44100";
        transformAudioCmd = String.format(transformAudioCmd, acodec);
        return FFmpegUtil.insert(transformAudioCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] cutAudio(String inputPath, float startTime, float duration, String outputPath) {
        String cutAudioCmd = "ffmpeg -i -ss %f -t %f -vn";
        cutAudioCmd = String.format(Locale.getDefault(), cutAudioCmd, Float.valueOf(startTime), Float.valueOf(duration));
        return FFmpegUtil.insert(cutAudioCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] getAudioDuration(String input) {
        String cmd = "ffmpeg -i %s -hide_banner -loglevel grep Duration | cut -d ' ' -f 4 | sed 's/,//'";
        cmd = String.format(Locale.getDefault(), cmd, input);
        return cmd.split(" ");
    }

    public static String[] concatAudio(List<String> fileList, String outputPath) {
        if (fileList == null || fileList.size() == 0) {
            return null;
        }
        StringBuilder concatBuilder = new StringBuilder();
        concatBuilder.append("concat:");
        for (String file : fileList) {
            concatBuilder.append(file).append("|");
        }
        String concatStr = concatBuilder.substring(0, concatBuilder.length() - 1);
        String concatAudioCmd = "ffmpeg -i -acodec copy";
        return FFmpegUtil.insert(concatAudioCmd.split(" "), 2, concatStr, outputPath);
    }

    public static String[] mixAudio(String inputPath, String mixPath, String outputPath) {
        return FFmpegUtil.mixAudio(inputPath, mixPath, 0, 0, false, outputPath);
    }

    public static String[] mixAudio(String inputPath, String mixPath, int weight1, int weight2, boolean disableThumb, String outputPath) {
        int len = 8;
        String amix = "amix=inputs=2:duration=shortest";
        if (disableThumb) {
            ++len;
        }
        String[] mixAudioCmd = new String[len];
        mixAudioCmd[0] = "ffmpeg";
        mixAudioCmd[1] = "-i";
        mixAudioCmd[2] = inputPath;
        mixAudioCmd[3] = "-i";
        mixAudioCmd[4] = mixPath;
        mixAudioCmd[5] = "-filter_complex";
        if (weight1 > 0 && weight2 > 0) {
            String weight = ":weights='" + weight1 + " " + weight2 + "'";
            amix = amix + weight;
        }
        mixAudioCmd[6] = amix;
        if (disableThumb) {
            mixAudioCmd[7] = "-vn";
        }
        mixAudioCmd[len - 1] = outputPath;
        return mixAudioCmd;
    }

    public static String[] mixAudio(String inputPath, String mixPath, int weight1, int weight2, float volume1, float volume2, boolean disableThumb, String outputPath, int delay, int delay2) {
        int len = 8;
        String amix = "[0]volume=%f,adelay=%d|%d[a];[1]volume=%f,adelay=%d|%d[b];[a][b]amix=inputs=2:duration=first";
        amix = String.format(Locale.getDefault(), amix, Float.valueOf(volume1), delay, delay, Float.valueOf(volume2), delay2, delay2);
        if (disableThumb) {
            ++len;
        }
        String[] mixAudioCmd = new String[len];
        mixAudioCmd[0] = "ffmpeg";
        mixAudioCmd[1] = "-i";
        mixAudioCmd[2] = inputPath;
        mixAudioCmd[3] = "-i";
        mixAudioCmd[4] = mixPath;
        mixAudioCmd[5] = "-filter_complex";
        if (weight1 > 0 && weight2 > 0) {
            String weight = ":weights='" + weight1 + " " + weight2 + "'";
            amix = amix + weight;
        }
        mixAudioCmd[6] = amix;
        if (disableThumb) {
            mixAudioCmd[7] = "-vn";
        }
        mixAudioCmd[len - 1] = outputPath;
        return mixAudioCmd;
    }

    public static String[] mergeAudio(String inputPath, String mergePath, String outputPath) {
        String mergeCmd = "ffmpeg -i %s -i %s -filter_complex [0:a][1:a]amerge=inputs=2[aout] -map [aout] %s";
        mergeCmd = String.format(mergeCmd, inputPath, mergePath, outputPath);
        return mergeCmd.split(" ");
    }

    public static String[] audioEcho(String inputPath, int delay, String outputPath) {
        String echoCmd = "ffmpeg -i -af aecho=0.8:0.8:%d:0.5";
        echoCmd = String.format(Locale.getDefault(), echoCmd, delay);
        return FFmpegUtil.insert(echoCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] audioTremolo(String inputPath, int frequency, float depth, String outputPath) {
        String tremoloCmd = "ffmpeg -i -af tremolo=%d:%f";
        tremoloCmd = String.format(Locale.getDefault(), tremoloCmd, frequency, Float.valueOf(depth));
        return FFmpegUtil.insert(tremoloCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] audioDenoise(String inputPath, String outputPath) {
        String fftDenoiseCmd = "ffmpeg -i -af afftdn";
        return FFmpegUtil.insert(fftDenoiseCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] audioSilenceDetect(String inputPath) {
        String silenceCmd = "ffmpeg -i -af silencedetect=noise=0.0001 -f null -";
        return FFmpegUtil.insert(silenceCmd.split(" "), 2, inputPath);
    }

    public static String[] audioVolume(String inputPath, float volume, String outputPath) {
        String volumeCmd = "ffmpeg -i -af volume=%f";
        volumeCmd = String.format(Locale.getDefault(), volumeCmd, Float.valueOf(volume));
        return FFmpegUtil.insert(volumeCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] audioEqualizer(String inputPath, List<String> bandList, String outputPath) {
        String bands = String.join((CharSequence)":", bandList);
        String equalizerCmd = "ffmpeg -i -af superequalizer=%s -y";
        equalizerCmd = String.format(Locale.getDefault(), equalizerCmd, bands);
        return FFmpegUtil.insert(equalizerCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] mediaMux(String videoFile, String audioFile, boolean copy, String muxFile) {
        String mediaMuxCmd = copy ? "ffmpeg -i %s -i %s -codec copy -shortest -y %s" : "ffmpeg -i %s -i %s -shortest -y %s";
        mediaMuxCmd = String.format(Locale.getDefault(), mediaMuxCmd, videoFile, audioFile, muxFile);
        return mediaMuxCmd.split(" ");
    }

    public static String[] mediaMux2(String videoFile, String audioFile, boolean copy, String muxFile, float videoDelay) {
        String mediaMuxCmd = copy ? "ffmpeg -itsoffset %f -i %s -itsoffset 0 -i %s -codec copy -shortest -y %s" : "ffmpeg -itsoffset %f -i %s -itsoffset 0 -i %s -shortest -y %s";
        mediaMuxCmd = String.format(Locale.getDefault(), mediaMuxCmd, Float.valueOf(videoDelay), videoFile, audioFile, muxFile);
        return mediaMuxCmd.split(" ");
    }

    public static String[] getVideoFrame(String input, String output) {
        String mediaMuxCmd = "ffmpeg -i %s -vf fps=1/1 %s";
        mediaMuxCmd = String.format(Locale.getDefault(), mediaMuxCmd, input, output);
        return mediaMuxCmd.split(" ");
    }

    public static String[] extractAudio(String inputPath, String outputPath) {
        String extractAudioCmd = "ffmpeg -i -vn";
        return FFmpegUtil.insert(extractAudioCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] extractVideo(String inputPath, String outputPath) {
        String extractVideoCmd = "ffmpeg -i -vcodec copy -an";
        return FFmpegUtil.insert(extractVideoCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] transformVideo(String inputPath, String outputPath) {
        String transformVideoCmd = "ffmpeg -i -vcodec libx264 -acodec libmp3lame";
        return FFmpegUtil.insert(transformVideoCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] transformVideoWithEncode(String inputPath, String outputPath) {
        return FFmpegUtil.transformVideoWithEncode(inputPath, 0, 0, outputPath);
    }

    public static String[] transformVideoWithEncode(String inputPath, int width, int height, String outputPath) {
        String transformVideoCmd;
        if (width > 0 && height > 0) {
            String scale = "-vf scale=" + width + ":" + height;
            transformVideoCmd = "ffmpeg -i -vcodec libx264 -acodec aac " + scale;
        } else {
            transformVideoCmd = "ffmpeg -i -vcodec libx264 -acodec aac";
        }
        return FFmpegUtil.insert(transformVideoCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] transformVideoWithResolution(String inputPath, int width, int height, String outputPath) {
        String scale = "-vf scale=" + width + ":" + -2;
        String transformVideoCmd = "ffmpeg -hwaccel auto -i -vcodec libx264 -r 15 -b:v 2m -preset ultrafast -acodec aac " + scale;
        return FFmpegUtil.insert(transformVideoCmd.split(" "), 4, inputPath, outputPath);
    }

    public static String[] jointVideo(String fileListPath, String outputPath) {
        String jointVideoCmd = "ffmpeg -f concat -safe 0 -i -c copy -y";
        return FFmpegUtil.insert(jointVideoCmd.split(" "), 6, fileListPath, outputPath);
    }

    public static String[] cutVideo(String inputPath, float startTime, float duration, String outputPath) {
        String cutVideoCmd = "ffmpeg -ss %f -accurate_seek -t %f -i -map 0 -codec copy -avoid_negative_ts 1";
        cutVideoCmd = String.format(Locale.getDefault(), cutVideoCmd, Float.valueOf(startTime), Float.valueOf(duration));
        return FFmpegUtil.insert(cutVideoCmd.split(" "), 7, inputPath, outputPath);
    }

    public static String[] screenShot(String inputPath, float offset, String outputPath) {
        String screenShotCmd = "ffmpeg -ss %f -i -f image2 -vframes 1 -an";
        screenShotCmd = String.format(Locale.getDefault(), screenShotCmd, Float.valueOf(offset));
        return FFmpegUtil.insert(screenShotCmd.split(" "), 4, inputPath, outputPath);
    }

    private static String obtainOverlay(int offsetX, int offsetY, int location) {
        switch (location) {
            case 2: {
                return "overlay='(main_w-overlay_w)-" + offsetX + ":" + offsetY + "'";
            }
            case 3: {
                return "overlay='" + offsetX + ":(main_h-overlay_h)-" + offsetY + "'";
            }
            case 4: {
                return "overlay='(main_w-overlay_w)-" + offsetX + ":(main_h-overlay_h)-" + offsetY + "'";
            }
        }
        return "overlay=(10+t*20):" + offsetY;
    }

    public static String[] addWaterMarkImg(String inputPath, String imgPath, int location, int bitRate, int offsetXY, String outputPath) {
        String mBitRate = bitRate + "k";
        String overlay = FFmpegUtil.obtainOverlay(offsetXY, offsetXY, location);
        String waterMarkCmd = "ffmpeg -i -i -b:v %s -filter_complex %s -preset:v superfast -y";
        waterMarkCmd = String.format(waterMarkCmd, mBitRate, overlay);
        return FFmpegUtil.insert(waterMarkCmd.split(" "), 2, inputPath, 4, imgPath, outputPath);
    }

    public static String[] addWaterMarkGif(Context context, String inputPath, String imgPath, int location, int bitRate, int offsetXY, String outputPath) {
        String mBitRate = bitRate + "k";
        int offset = ScreenUtil.INSTANCE.dp2px(context, offsetXY);
        String overlay = FFmpegUtil.obtainOverlay(offset, offset, location) + ":shortest=1";
        String waterMarkCmd = "ffmpeg -i -ignore_loop 0 -i -b:v %s -filter_complex %s -preset:v superfast";
        waterMarkCmd = String.format(waterMarkCmd, mBitRate, overlay);
        return FFmpegUtil.insert(waterMarkCmd.split(" "), 2, inputPath, 6, imgPath, outputPath);
    }

    public static String[] removeLogo(String inputPath, int x, int y, int width, int height, String outputPath) {
        String delogoCmd = "ffmpeg -i -filter_complex delogo=x=%d:y=%d:w=%d:h=%d";
        delogoCmd = String.format(Locale.getDefault(), delogoCmd, x, y, width, height);
        return FFmpegUtil.insert(delogoCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] generatePalette(String inputPath, int startTime, int duration, int frameRate, int width, String outputPath) {
        String paletteCmd = "ffmpeg -ss %d -accurate_seek -t %d -i -vf fps=%d,scale=%d:-1:flags=lanczos,palettegen";
        paletteCmd = String.format(Locale.getDefault(), paletteCmd, startTime, duration, frameRate, width);
        return FFmpegUtil.insert(paletteCmd.split(" "), 7, inputPath, outputPath);
    }

    public static String[] generateGifByPalette(String inputPath, String palette, int startTime, int duration, int frameRate, int width, String outputPath) {
        String paletteGifCmd = "ffmpeg -ss %d -accurate_seek -t %d -i -i -lavfi fps=%d,scale=%d:-1:flags=lanczos[x];[x][1:v]paletteuse=dither=bayer:bayer_scale=3";
        paletteGifCmd = String.format(Locale.getDefault(), paletteGifCmd, startTime, duration, frameRate, width);
        return FFmpegUtil.insert(paletteGifCmd.split(" "), 7, inputPath, 9, palette, outputPath);
    }

    public static String[] pictureToVideo(String inputPath, int frameRate, String outputPath) {
        String combineVideo = "ffmpeg -f image2 -r %d -i %simg#d.jpg -vcodec mpeg4 %s";
        combineVideo = String.format(Locale.getDefault(), combineVideo, frameRate, inputPath, outputPath);
        combineVideo = combineVideo.replace("#", "%");
        return combineVideo.split(" ");
    }

    public static String[] convertResolution(String inputPath, String resolution, String outputPath) {
        String convertCmd = "ffmpeg -i -s %s -pix_fmt yuv420p";
        convertCmd = String.format(Locale.getDefault(), convertCmd, resolution);
        return FFmpegUtil.insert(convertCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] encodeAudio(String inputPath, String outputPath, int sampleRate, int channel) {
        String encodeAudioCmd = "ffmpeg -f s16le -ar %d -ac %d -i";
        encodeAudioCmd = String.format(Locale.getDefault(), encodeAudioCmd, sampleRate, channel);
        return FFmpegUtil.insert(encodeAudioCmd.split(" "), 8, inputPath, outputPath);
    }

    public static String[] multiVideo(String input1, String input2, String outputPath, int videoLayout) {
        String multiVideo = "ffmpeg -i -i -filter_complex hstack";
        if (videoLayout == 2) {
            multiVideo = multiVideo.replace("hstack", "vstack");
        }
        return FFmpegUtil.insert(multiVideo.split(" "), 2, input1, 4, input2, outputPath);
    }

    public static String[] reverseVideo(String inputPath, String outputPath) {
        String reverseVideo = "ffmpeg -i -vf reverse -an";
        return FFmpegUtil.insert(reverseVideo.split(" "), 2, inputPath, outputPath);
    }

    public static String[] denoiseVideo(String inputPath, String outputPath) {
        String denoiseVideo = "ffmpeg -i -nr 500";
        return FFmpegUtil.insert(denoiseVideo.split(" "), 2, inputPath, outputPath);
    }

    public static String[] videoToImage(String inputPath, int startTime, int duration, int frameRate, String outputPath) {
        return FFmpegUtil.videoToImageWithScale(inputPath, startTime, duration, frameRate, 0, outputPath);
    }

    public static String[] videoToImageWithScale(String inputPath, int startTime, int duration, int frameRate, int width, String outputPath) {
        String toImage;
        if (width > 0) {
            toImage = "ffmpeg -ss %d -accurate_seek -t %d -i %s -an -vf fps=%d,scale=%d:-1 %s";
            toImage = String.format(Locale.CHINESE, toImage, startTime, duration, inputPath, frameRate, width, outputPath);
        } else {
            toImage = "ffmpeg -ss %d -accurate_seek -t %d -i %s -an -r %d %s";
            toImage = String.format(Locale.CHINESE, toImage, startTime, duration, inputPath, frameRate, outputPath);
        }
        toImage = toImage + "%3d.png";
        return toImage.split(" ");
    }

    public static String[] picInPicVideo(String inputPath1, String inputPath2, int x, int y, String outputPath) {
        String pipVideo = "ffmpeg -i -i -filter_complex overlay=%d:%d";
        pipVideo = String.format(Locale.getDefault(), pipVideo, x, y);
        return FFmpegUtil.insert(pipVideo.split(" "), 2, inputPath1, 4, inputPath2, outputPath);
    }

    public static String[] picInPicVideoInCorner(String inputPath1, String inputPath2, int whichCorner, String outputPath) {
        String pipCmd = "ffmpeg -i -i -filter_complex ";
        switch (whichCorner) {
            case 1: {
                pipCmd = pipCmd + "overlay=W-w";
                break;
            }
            case 2: {
                pipCmd = pipCmd + "overlay=0:H-h";
                break;
            }
            case 3: {
                pipCmd = pipCmd + "overlay=W-w:H-h";
                break;
            }
            default: {
                pipCmd = pipCmd + "overlay";
            }
        }
        return FFmpegUtil.insert(pipCmd.split(" "), 2, inputPath1, 4, inputPath2, outputPath);
    }

    public static String[] moveMoovAhead(String inputPath, String outputPath) {
        String moovCmd = "ffmpeg -i -movflags faststart -acodec copy -vcodec copy";
        return FFmpegUtil.insert(moovCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] toGrayVideo(String inputPath, String outputPath) {
        String grayCmd = "ffmpeg -i -vf lutyuv='u=128:v=128'";
        return FFmpegUtil.insert(grayCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] photoZoomToVideo(String inputPath, int position, String outputPath) {
        String zoomCmd = "ffmpeg -i -vf ";
        switch (position) {
            case 1: {
                zoomCmd = zoomCmd + "zoompan='1.3':x='if(lte(on,1),(iw/zoom)/2,x-0.5)':y='if(lte(on,1),(ih-ih/zoom)/2,y)':d=180";
                break;
            }
            case 2: {
                zoomCmd = zoomCmd + "zoompan='1.3':x='if(lte(on,-1),(iw-iw/zoom)/2,x+0.5)':y='if(lte(on,1),(ih-ih/zoom)/2,y)':d=180";
                break;
            }
            case 3: {
                zoomCmd = zoomCmd + "zoompan='1.3':x='if(lte(on,1),(iw-iw/zoom)/2,x)':y='if(lte(on,-1),(ih-ih/zoom)/2,y+0.5)':d=180";
                break;
            }
            case 4: {
                zoomCmd = zoomCmd + "zoompan='1.3':x='if(lte(on,1),(iw-iw/zoom)/2,x)':y='if(lte(on,1),(ih/zoom)/2,y-0.5)':d=180";
                break;
            }
            default: {
                zoomCmd = zoomCmd + "zoompan=z='min(zoom+0.0015,1.5)':x='iw/2-(iw/zoom/2)':y='ih/2-(ih/zoom/2)':d=180";
            }
        }
        return FFmpegUtil.insert(zoomCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] probeFormat(String inputPath) {
        String ffprobeCmd = "ffprobe -i -show_streams -show_format -print_format json";
        return FFmpegUtil.insert(ffprobeCmd.split(" "), 2, inputPath);
    }

    public static String[] changeSpeed(String inputPath, String outputPath, float speed, boolean pureVideo) {
        String speedCmd;
        if (pureVideo) {
            if (speed > 4.0f || (double)speed < 0.25) {
                throw new IllegalArgumentException("speed range is 0.25--4");
            }
        } else if (speed > 2.0f || (double)speed < 0.5) {
            throw new IllegalArgumentException("speed range is 0.5--2");
        }
        float ptsFactor = 1.0f / speed;
        if (pureVideo) {
            speedCmd = "ffmpeg -i -filter_complex [0:v]setpts=%.2f*PTS[v] -map [v]";
            speedCmd = String.format(Locale.getDefault(), speedCmd, Float.valueOf(ptsFactor));
        } else {
            speedCmd = "ffmpeg -i -filter_complex [0:v]setpts=%.2f*PTS[v];[0:a]atempo=%.2f[a] -map [v] -map [a]";
            speedCmd = String.format(Locale.getDefault(), speedCmd, Float.valueOf(ptsFactor), Float.valueOf(speed));
        }
        return FFmpegUtil.insert(speedCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] changeAudioSpeed(String inputPath, String outputPath, float speed) {
        if (speed > 100.0f || (double)speed < 0.5) {
            throw new IllegalArgumentException("audio speed range is from 0.5 to 100");
        }
        String speedCmd = "ffmpeg -i -filter_complex atempo=%.2f -c:a copy -b:a 192k";
        speedCmd = String.format(Locale.getDefault(), speedCmd, Float.valueOf(speed));
        return FFmpegUtil.insert(speedCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] changeAudioSpeed2(String inputPath, String outputPath, float speed) {
        if (speed > 100.0f) {
            throw new IllegalArgumentException("audio speed range is from 0.5 to 100");
        }
        if ((double)speed < 0.5) {
            String s = FFmpegUtil.buildAtempoFilters(speed);
            String command = "ffmpeg -i -filter:a %s -b:a 192k";
            String format = String.format(Locale.getDefault(), command, s);
            return FFmpegUtil.insert(format.split(" "), 2, inputPath, outputPath);
        }
        String speedCmd = "ffmpeg -i -filter:a atempo=%.2f -b:a 192k";
        speedCmd = String.format(Locale.getDefault(), speedCmd, Float.valueOf(speed));
        return FFmpegUtil.insert(speedCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] changeAudioSpeed3(String inputPath, String outputPath, float speed) {
        if (speed > 100.0f) {
            throw new IllegalArgumentException("audio speed range is from 0.5 to 100");
        }
        if ((double)speed < 0.5) {
            String s = FFmpegUtil.buildAtempoFilters(speed);
            String command = "ffmpeg -i -filter:a %s -b:a 192k -ar 44100 -ac 2 -acodec pcm_s16le";
            String format = String.format(Locale.getDefault(), command, s);
            return FFmpegUtil.insert(format.split(" "), 2, inputPath, outputPath);
        }
        String speedCmd = "ffmpeg -i -filter:a atempo=%.2f -b:a 192k -ar 44100 -ac 2 -acodec pcm_s16le";
        speedCmd = String.format(Locale.getDefault(), speedCmd, Float.valueOf(speed));
        return FFmpegUtil.insert(speedCmd.split(" "), 2, inputPath, outputPath);
    }

    private static String buildAtempoFilters(double speed) {
        double tempSpeed;
        StringBuilder filters = new StringBuilder();
        for (tempSpeed = speed; tempSpeed < 0.5; tempSpeed *= 2.0) {
            filters.append("atempo=0.5,");
        }
        filters.append(String.format("atempo=%.2f", tempSpeed));
        return filters.toString();
    }

    public static String[] insertPicIntoVideo(String inputPath, String picturePath, String outputPath) {
        String insertPicCmd = "ffmpeg -i -i -map 0 -map 1 -c copy -c:v:1 png -disposition:v:1 attached_pic";
        return FFmpegUtil.insert(insertPicCmd.split(" "), 2, inputPath, 4, picturePath, outputPath);
    }

    public static String[] addSubtitleIntoVideo(String inputPath, String subtitlePath, String outputPath) {
        String subtitleCmd = "ffmpeg -i -i -map 0:v -map 0:a -map 1:s -c copy";
        return FFmpegUtil.insert(subtitleCmd.split(" "), 2, inputPath, 4, subtitlePath, outputPath);
    }

    public static String[] pushMultiStreams(String inputPath, int duration, String streamUrl1, String streamUrl2) {
        String format = "flv";
        if (streamUrl1.startsWith("rtmp://")) {
            format = "flv";
        } else if (streamUrl1.startsWith("http://")) {
            format = "mpegts";
        }
        String pushStreams = "ffmpeg -i %s -vcodec libx264 -acodec aac -t %d -f %s \"tee:%s|%s\"";
        pushStreams = String.format(Locale.getDefault(), pushStreams, inputPath, duration, format, streamUrl1, streamUrl2);
        return pushStreams.split(" ");
    }

    public static String[] rotateVideo(String inputPath, int rotateDegree, String outputPath) {
        String rotateCmd = "ffmpeg -i -c copy -metadata:s:v:0 rotate=%d";
        rotateCmd = String.format(Locale.getDefault(), rotateCmd, rotateDegree);
        return FFmpegUtil.insert(rotateCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] trimVideo(String inputPath, int start1, int end1, int start2, int end2, String outputPath) {
        String trimCmd = "ffmpeg -i -filter_complex [0:v]trim=start=%d:end=%d,setpts=PTS-STARTPTS[v0];[0:a]atrim=start=%d:end=%d,asetpts=PTS-STARTPTS[a0];[0:v]trim=start=%d:end=%d,setpts=PTS-STARTPTS[v1];[0:a]atrim=start=%d:end=%d,asetpts=PTS-STARTPTS[a1];[v0][a0][v1][a1]concat=n=2:v=1:a=1[out] -map [out]";
        trimCmd = String.format(Locale.getDefault(), trimCmd, start1, end1, start1, end1, start2, end2, start2, end2);
        return FFmpegUtil.insert(trimCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] showAudioWaveform(String inputPath, String resolution, int splitChannels, String outputPath) {
        String waveformCmd = "ffmpeg -i -filter_complex showwavespic=s=%s:split_channels=%d";
        waveformCmd = String.format(Locale.getDefault(), waveformCmd, resolution, splitChannels);
        return FFmpegUtil.insert(waveformCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] videoStereo3D(String inputPath, String outputPath) {
        String stereo3dCmd = "ffmpeg -i -filter_complex stereo3d=sbsl:arbg";
        return FFmpegUtil.insert(stereo3dCmd.split(" "), 2, inputPath, outputPath);
    }

    public static String[] videoTransition(String inputPath1, int width, int height, int offset, String inputPath2, String outputPath) {
        String transitionCmd = "ffmpeg -i -i -filter_complex [0]settb=AVTB,fps=24000/1001[v0];[1]settb=AVTB,fps=24000/1001,scale=%d:%d[v1];[v0][v1]xfade=transition=radial:duration=1:offset=%d";
        transitionCmd = String.format(Locale.getDefault(), transitionCmd, width, height, offset);
        return FFmpegUtil.insert(transitionCmd.split(" "), 2, inputPath1, 4, inputPath2, outputPath);
    }
}

