/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.Keep;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lcom/cooleshow/ffmpegcmd/util/ScreenUtil;", "", "()V", "dp2px", "", "context", "Landroid/content/Context;", "dpValue", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getScreenHeight", "getScreenWidth", "px2dp", "pxValue", "ffmpegCmd_release"})
@Keep
public final class ScreenUtil {
    @NotNull
    public static final ScreenUtil INSTANCE = new ScreenUtil();

    private ScreenUtil() {
    }

    private final DisplayMetrics getDisplayMetrics(Context context) {
        Object object = context.getApplicationContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public final int getScreenWidth(@Nullable Context context) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return 0;
        }
        DisplayMetrics displayMetrics2 = displayMetrics = this.getDisplayMetrics(context);
        return displayMetrics2 != null ? displayMetrics2.widthPixels : 0;
    }

    public final int getScreenHeight(@Nullable Context context) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return 0;
        }
        DisplayMetrics displayMetrics2 = displayMetrics = this.getDisplayMetrics(context);
        return displayMetrics2 != null ? displayMetrics2.heightPixels : 0;
    }

    public final int dp2px(@Nullable Context context, int dpValue) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return 0;
        }
        DisplayMetrics displayMetrics2 = displayMetrics = this.getDisplayMetrics(context);
        float density = displayMetrics2 != null ? displayMetrics2.density : 0.0f;
        return (int)((float)dpValue * density + 0.5f);
    }

    public final int px2dp(@Nullable Context context, int pxValue) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return 0;
        }
        DisplayMetrics displayMetrics2 = displayMetrics = this.getDisplayMetrics(context);
        float density = displayMetrics2 != null ? displayMetrics2.density : 0.0f;
        return (int)((float)pxValue / density + 0.5f);
    }
}

