/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import android.graphics.Color;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.musictools.TimeSignature;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MidiOptions
implements Serializable {
    public static final int NoteNameNone = 0;
    public static final int NoteNameLetter = 1;
    public static final int NoteNameFixedDoReMi = 2;
    public static final int NoteNameMovableDoReMi = 3;
    public static final int NoteNameFixedNumber = 4;
    public static final int NoteNameMovableNumber = 5;
    public boolean showPiano;
    public boolean[] tracks;
    public int[] instruments;
    public boolean useDefaultInstruments;
    public boolean scrollVert;
    public boolean largeNoteSize;
    public boolean twoStaffs;
    public int showNoteLetters;
    public boolean showLyrics;
    public boolean showMeasures;
    public int shifttime;
    public int transpose;
    public int key;
    public TimeSignature time;
    public TimeSignature defaultTime;
    public int combineInterval;
    public int shade1Color;
    public int shade2Color;
    public boolean[] mute;
    public int tempo;
    public int pauseTime;
    public boolean playMeasuresInLoop;
    public int playMeasuresInLoopStart;
    public int playMeasuresInLoopEnd;
    public int lastMeasure;

    public MidiOptions() {
    }

    public MidiOptions(MidiFile midifile) {
        int i;
        this.showPiano = true;
        int num_tracks = midifile.getTracks().size();
        this.tracks = new boolean[num_tracks];
        this.mute = new boolean[num_tracks];
        for (i = 0; i < this.tracks.length; ++i) {
            this.tracks[i] = true;
            this.mute[i] = false;
            if (!midifile.getTracks().get(i).getInstrumentName().equals("Percussion")) continue;
            this.tracks[i] = false;
            this.mute[i] = true;
        }
        this.useDefaultInstruments = true;
        this.instruments = new int[num_tracks];
        for (i = 0; i < this.instruments.length; ++i) {
            this.instruments[i] = midifile.getTracks().get(i).getInstrument();
        }
        this.scrollVert = true;
        this.largeNoteSize = true;
        this.twoStaffs = this.tracks.length != 2;
        this.showNoteLetters = 0;
        this.showMeasures = false;
        this.showLyrics = true;
        this.shifttime = 0;
        this.transpose = 0;
        this.time = null;
        this.defaultTime = midifile.getTime();
        this.key = -1;
        this.combineInterval = 40;
        this.shade1Color = Color.rgb((int)69, (int)139, (int)0);
        this.shade2Color = Color.rgb((int)148, (int)0, (int)211);
        this.tempo = midifile.getTime().getTempo();
        this.pauseTime = 0;
        this.lastMeasure = midifile.EndTime() / midifile.getTime().getMeasure();
        this.playMeasuresInLoop = false;
        this.playMeasuresInLoopStart = 0;
        this.playMeasuresInLoopEnd = this.lastMeasure;
    }

    public String toJson() {
        try {
            JSONObject json = new JSONObject();
            JSONArray jsonTracks = new JSONArray();
            for (boolean value : this.tracks) {
                jsonTracks.put(value);
            }
            JSONArray jsonMute = new JSONArray();
            for (boolean value : this.mute) {
                jsonMute.put(value);
            }
            JSONArray jsonInstruments = new JSONArray();
            for (int value : this.instruments) {
                jsonInstruments.put(value);
            }
            if (this.time != null) {
                JSONObject jsonTime = new JSONObject();
                jsonTime.put("numerator", this.time.getNumerator());
                jsonTime.put("denominator", this.time.getDenominator());
                jsonTime.put("quarter", this.time.getQuarter());
                jsonTime.put("tempo", this.time.getTempo());
                json.put("time", (Object)jsonTime);
            }
            json.put("versionCode", 7);
            json.put("tracks", (Object)jsonTracks);
            json.put("mute", (Object)jsonMute);
            json.put("instruments", (Object)jsonInstruments);
            json.put("useDefaultInstruments", this.useDefaultInstruments);
            json.put("scrollVert", this.scrollVert);
            json.put("showPiano", this.showPiano);
            json.put("showLyrics", this.showLyrics);
            json.put("twoStaffs", this.twoStaffs);
            json.put("showNoteLetters", this.showNoteLetters);
            json.put("transpose", this.transpose);
            json.put("key", this.key);
            json.put("combineInterval", this.combineInterval);
            json.put("shade1Color", this.shade1Color);
            json.put("shade2Color", this.shade2Color);
            json.put("showMeasures", this.showMeasures);
            json.put("playMeasuresInLoop", this.playMeasuresInLoop);
            json.put("playMeasuresInLoopStart", this.playMeasuresInLoopStart);
            json.put("playMeasuresInLoopEnd", this.playMeasuresInLoopEnd);
            return json.toString();
        }
        catch (JSONException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static MidiOptions fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        MidiOptions options = new MidiOptions();
        try {
            JSONObject json = new JSONObject(jsonString);
            JSONArray jsonTracks = json.getJSONArray("tracks");
            options.tracks = new boolean[jsonTracks.length()];
            for (int i = 0; i < options.tracks.length; ++i) {
                options.tracks[i] = jsonTracks.getBoolean(i);
            }
            JSONArray jsonMute = json.getJSONArray("mute");
            options.mute = new boolean[jsonMute.length()];
            for (int i = 0; i < options.mute.length; ++i) {
                options.mute[i] = jsonMute.getBoolean(i);
            }
            JSONArray jsonInstruments = json.getJSONArray("instruments");
            options.instruments = new int[jsonInstruments.length()];
            for (int i = 0; i < options.instruments.length; ++i) {
                options.instruments[i] = jsonInstruments.getInt(i);
            }
            if (json.has("time")) {
                JSONObject jsonTime = json.getJSONObject("time");
                int numer = jsonTime.getInt("numerator");
                int denom = jsonTime.getInt("denominator");
                int quarter = jsonTime.getInt("quarter");
                int tempo = jsonTime.getInt("tempo");
                options.time = new TimeSignature(numer, denom, quarter, tempo);
            }
            options.useDefaultInstruments = json.getBoolean("useDefaultInstruments");
            options.scrollVert = json.getBoolean("scrollVert");
            options.showPiano = json.getBoolean("showPiano");
            options.showLyrics = json.getBoolean("showLyrics");
            options.twoStaffs = json.getBoolean("twoStaffs");
            options.showNoteLetters = json.getInt("showNoteLetters");
            options.transpose = json.getInt("transpose");
            options.key = json.getInt("key");
            options.combineInterval = json.getInt("combineInterval");
            options.shade1Color = json.getInt("shade1Color");
            options.shade2Color = json.getInt("shade2Color");
            options.showMeasures = json.getBoolean("showMeasures");
            options.playMeasuresInLoop = json.getBoolean("playMeasuresInLoop");
            options.playMeasuresInLoopStart = json.getInt("playMeasuresInLoopStart");
            options.playMeasuresInLoopEnd = json.getInt("playMeasuresInLoopEnd");
        }
        catch (Exception e) {
            return null;
        }
        return options;
    }

    public void merge(MidiOptions saved) {
        int i;
        if (saved.tracks.length == this.tracks.length) {
            for (i = 0; i < this.tracks.length; ++i) {
                this.tracks[i] = saved.tracks[i];
            }
        }
        if (saved.mute.length == this.mute.length) {
            for (i = 0; i < this.mute.length; ++i) {
                this.mute[i] = saved.mute[i];
            }
        }
        if (saved.instruments.length == this.instruments.length) {
            for (i = 0; i < this.instruments.length; ++i) {
                this.instruments[i] = saved.instruments[i];
            }
        }
        if (saved.time != null) {
            this.time = new TimeSignature(saved.time.getNumerator(), saved.time.getDenominator(), saved.time.getQuarter(), saved.time.getTempo());
        }
        this.useDefaultInstruments = saved.useDefaultInstruments;
        this.scrollVert = saved.scrollVert;
        this.showPiano = saved.showPiano;
        this.showLyrics = saved.showLyrics;
        this.twoStaffs = saved.twoStaffs;
        this.showNoteLetters = saved.showNoteLetters;
        this.transpose = saved.transpose;
        this.key = saved.key;
        this.combineInterval = saved.combineInterval;
        this.shade1Color = saved.shade1Color;
        this.shade2Color = saved.shade2Color;
        this.showMeasures = saved.showMeasures;
        this.playMeasuresInLoop = saved.playMeasuresInLoop;
        this.playMeasuresInLoopStart = saved.playMeasuresInLoopStart;
        this.playMeasuresInLoopEnd = saved.playMeasuresInLoopEnd;
    }

    public String toString() {
        int i;
        String result = "MidiOptions: tracks: ";
        for (i = 0; i < this.tracks.length; ++i) {
            result = result + this.tracks[i] + ", ";
        }
        result = result + " Instruments: ";
        for (i = 0; i < this.instruments.length; ++i) {
            result = result + this.instruments[i] + ", ";
        }
        result = result + " scrollVert " + this.scrollVert;
        result = result + " twoStaffs " + this.twoStaffs;
        result = result + " transpose" + this.transpose;
        result = result + " key " + this.key;
        result = result + " combine " + this.combineInterval;
        result = result + " tempo " + this.tempo;
        result = result + " pauseTime " + this.pauseTime;
        if (this.time != null) {
            result = result + " time " + this.time.toString();
        }
        return result;
    }

    public MidiOptions copy() {
        int i;
        MidiOptions options = new MidiOptions();
        options.tracks = new boolean[this.tracks.length];
        for (i = 0; i < this.tracks.length; ++i) {
            options.tracks[i] = this.tracks[i];
        }
        options.mute = new boolean[this.mute.length];
        for (i = 0; i < this.mute.length; ++i) {
            options.mute[i] = this.mute[i];
        }
        options.instruments = new int[this.instruments.length];
        for (i = 0; i < this.instruments.length; ++i) {
            options.instruments[i] = this.instruments[i];
        }
        options.defaultTime = this.defaultTime;
        options.time = this.time;
        options.useDefaultInstruments = this.useDefaultInstruments;
        options.scrollVert = this.scrollVert;
        options.showPiano = this.showPiano;
        options.showLyrics = this.showLyrics;
        options.twoStaffs = this.twoStaffs;
        options.showNoteLetters = this.showNoteLetters;
        options.transpose = this.transpose;
        options.key = this.key;
        options.combineInterval = this.combineInterval;
        options.shade1Color = this.shade1Color;
        options.shade2Color = this.shade2Color;
        options.showMeasures = this.showMeasures;
        options.playMeasuresInLoop = this.playMeasuresInLoop;
        options.playMeasuresInLoopStart = this.playMeasuresInLoopStart;
        options.playMeasuresInLoopEnd = this.playMeasuresInLoopEnd;
        options.lastMeasure = this.lastMeasure;
        options.tempo = this.tempo;
        options.pauseTime = this.pauseTime;
        options.shifttime = this.shifttime;
        options.largeNoteSize = this.largeNoteSize;
        return options;
    }
}

