/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;
import com.jinmingyunle.midiplaylib.view.Accid;
import com.jinmingyunle.midiplaylib.view.WhiteNote;

public class AccidSymbol
implements MusicSymbol {
    private Accid accid;
    private WhiteNote whitenote;
    private Clef clef;
    private int width;

    public AccidSymbol(Accid accid, WhiteNote note, Clef clef) {
        this.accid = accid;
        this.whitenote = note;
        this.clef = clef;
        this.width = this.getMinWidth();
    }

    public WhiteNote getNote() {
        return this.whitenote;
    }

    @Override
    public int getStartTime() {
        return -1;
    }

    @Override
    public int getMinWidth() {
        return 13;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getAboveStaff() {
        int dist = WhiteNote.Top(this.clef).Dist(this.whitenote) * 9 / 2;
        if (this.accid == Accid.Sharp || this.accid == Accid.Natural) {
            dist -= 9;
        } else if (this.accid == Accid.Flat) {
            dist -= 13;
        }
        if (dist < 0) {
            return -dist;
        }
        return 0;
    }

    @Override
    public int getBelowStaff() {
        int dist = WhiteNote.Bottom(this.clef).Dist(this.whitenote) * 9 / 2 + 9;
        if (this.accid == Accid.Sharp || this.accid == Accid.Natural) {
            dist += 9;
        }
        if (dist > 0) {
            return dist;
        }
        return 0;
    }

    @Override
    public void Draw(Canvas canvas, Paint paint, int ytop) {
        canvas.translate((float)(this.getWidth() - this.getMinWidth()), 0.0f);
        int ynote = ytop + WhiteNote.Top(this.clef).Dist(this.whitenote) * 9 / 2;
        if (this.accid == Accid.Sharp) {
            this.DrawSharp(canvas, paint, ynote);
        } else if (this.accid == Accid.Flat) {
            this.DrawFlat(canvas, paint, ynote);
        } else if (this.accid == Accid.Natural) {
            this.DrawNatural(canvas, paint, ynote);
        }
        canvas.translate((float)(-(this.getWidth() - this.getMinWidth())), 0.0f);
    }

    public void DrawSharp(Canvas canvas, Paint paint, int ynote) {
        int ystart = ynote - 9;
        int yend = ynote + 18;
        int x = 4;
        paint.setStrokeWidth(1.0f);
        canvas.drawLine((float)x, (float)(ystart + 2), (float)x, (float)yend, paint);
        canvas.drawLine((float)(x += 4), (float)ystart, (float)x, (float)(yend - 2), paint);
        int xstart = 2;
        int xend = 11;
        ystart = ynote + 2;
        yend = ystart - 2 - 1;
        paint.setStrokeWidth(3.0f);
        canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
        canvas.drawLine((float)xstart, (float)(ystart += 7), (float)xend, (float)(yend += 7), paint);
        paint.setStrokeWidth(1.0f);
    }

    public void DrawFlat(Canvas canvas, Paint paint, int ynote) {
        int x = 1;
        paint.setStrokeWidth(1.0f);
        canvas.drawLine((float)x, (float)(ynote - 9 - 4), (float)x, (float)(ynote + 9), paint);
        Path bezierPath = new Path();
        bezierPath.moveTo((float)x, (float)(ynote + 1));
        bezierPath.cubicTo((float)(x + 3), (float)(ynote - 3), (float)(x + 7), (float)(ynote + 2), (float)x, (float)(ynote + 7 + 2 + 1));
        canvas.drawPath(bezierPath, paint);
        bezierPath = new Path();
        bezierPath.moveTo((float)x, (float)(ynote + 1));
        bezierPath.cubicTo((float)(x + 3), (float)(ynote - 3), (float)(x + 7 + 1), (float)(ynote + 2 - 1), (float)x, (float)(ynote + 7 + 2 + 1));
        canvas.drawPath(bezierPath, paint);
        bezierPath = new Path();
        bezierPath.moveTo((float)x, (float)(ynote + 1));
        bezierPath.cubicTo((float)(x + 3), (float)(ynote - 3), (float)(x + 7 + 3), (float)(ynote + 2 - 3), (float)x, (float)(ynote + 7 + 2 + 1));
        canvas.drawPath(bezierPath, paint);
    }

    public void DrawNatural(Canvas canvas, Paint paint, int ynote) {
        int ystart = ynote - 7 - 2;
        int yend = ynote + 7 + 2;
        int x = 3;
        paint.setStrokeWidth(1.0f);
        canvas.drawLine((float)x, (float)ystart, (float)x, (float)yend, paint);
        ystart = ynote - 1;
        yend = ynote + 14 + 2 - 1;
        canvas.drawLine((float)(x += 6), (float)ystart, (float)x, (float)yend, paint);
        int xstart = 3;
        int xend = xstart + 7 - 1;
        ystart = ynote + 2;
        yend = ystart - 2 - 1;
        paint.setStrokeWidth(3.0f);
        canvas.drawLine((float)xstart, (float)ystart, (float)xend, (float)yend, paint);
        canvas.drawLine((float)xstart, (float)(ystart += 7), (float)xend, (float)(yend += 7), paint);
        paint.setStrokeWidth(1.0f);
    }

    public String toString() {
        return String.format("AccidSymbol accid={0} whitenote={1} clef={2} width={3}", new Object[]{this.accid, this.whitenote, this.clef, this.width});
    }
}

