/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.view;

import com.jinmingyunle.midiplaylib.midifile.MidiNote;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.view.WhiteNote;
import java.util.ArrayList;

public class ClefMeasures {
    private ArrayList<Clef> clefs;
    private int measure;

    public ClefMeasures(ArrayList<MidiNote> notes, int measurelen) {
        this.measure = measurelen;
        Clef mainclef = ClefMeasures.MainClef(notes);
        int nextmeasure = measurelen;
        int pos = 0;
        Clef clef = mainclef;
        this.clefs = new ArrayList();
        while (pos < notes.size()) {
            int avgnote;
            int sumnotes = 0;
            int notecount = 0;
            while (pos < notes.size() && notes.get(pos).getStartTime() < nextmeasure) {
                sumnotes += notes.get(pos).getNumber();
                ++notecount;
                ++pos;
            }
            if (notecount == 0) {
                notecount = 1;
            }
            if ((avgnote = sumnotes / notecount) != 0) {
                clef = avgnote >= WhiteNote.BottomTreble.getNumber() ? Clef.Treble : (avgnote <= WhiteNote.TopBass.getNumber() ? Clef.Bass : mainclef);
            }
            this.clefs.add(clef);
            nextmeasure += measurelen;
        }
        this.clefs.add(clef);
    }

    public Clef GetClef(int starttime) {
        if (starttime / this.measure >= this.clefs.size()) {
            return this.clefs.get(this.clefs.size() - 1);
        }
        return this.clefs.get(starttime / this.measure);
    }

    private static Clef MainClef(ArrayList<MidiNote> notes) {
        int middleC = WhiteNote.MiddleC.getNumber();
        int total = 0;
        for (MidiNote m : notes) {
            total += m.getNumber();
        }
        if (notes.size() == 0) {
            return Clef.Treble;
        }
        if (total / notes.size() >= middleC) {
            return Clef.Treble;
        }
        return Clef.Bass;
    }
}

