/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.view;

import android.os.Handler;
import android.view.MotionEvent;
import android.view.animation.AnimationUtils;
import com.jinmingyunle.midiplaylib.listener.ScrollAnimationListener;

public class ScrollAnimation {
    private final float timerInterval = 50.0f;
    private final float totalFlingTime = 3000.0f;
    ScrollAnimationListener listener;
    private boolean scrollVert;
    private boolean inMotion;
    private float downX;
    private float downY;
    private float moveX;
    private float moveY;
    private float prevMoveX;
    private float prevMoveY;
    private float upX;
    private float upY;
    private float deltaX;
    private float deltaY;
    private long downTime;
    private long moveTime;
    private long prevMoveTime;
    private long upTime;
    private long flingStartTime;
    private float flingVelocity;
    private float velocityX;
    private float velocityY;
    private Handler scrollTimer;
    Runnable flingScroll = new Runnable(){

        @Override
        public void run() {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            float percentDone = (float)(currentTime - ScrollAnimation.this.flingStartTime) / 3000.0f;
            if (percentDone >= 1.0f) {
                return;
            }
            float exp = -2.0f + percentDone * 2.0f;
            float scale = (float)(1.0 - Math.pow(Math.E, exp));
            float velocity = ScrollAnimation.this.flingVelocity * scale;
            float delta = velocity * 1.0f / 50.0f;
            if (ScrollAnimation.this.scrollVert) {
                ScrollAnimation.this.listener.scrollUpdate(0, (int)delta);
            } else if (!ScrollAnimation.this.scrollVert) {
                ScrollAnimation.this.listener.scrollUpdate((int)delta, 0);
            }
            if ((double)percentDone < 1.0) {
                ScrollAnimation.this.scrollTimer.postDelayed(ScrollAnimation.this.flingScroll, 50L);
            }
        }
    };

    public ScrollAnimation(ScrollAnimationListener listener, boolean scrollVert) {
        this.listener = listener;
        this.scrollVert = scrollVert;
        this.scrollTimer = new Handler();
    }

    public void stopMotion() {
        this.inMotion = false;
        this.velocityY = 0.0f;
        this.velocityX = 0.0f;
        this.deltaY = 0.0f;
        this.deltaX = 0.0f;
        this.upY = 0.0f;
        this.upX = 0.0f;
        this.prevMoveY = 0.0f;
        this.prevMoveX = 0.0f;
        this.moveY = 0.0f;
        this.moveX = 0.0f;
        this.downY = 0.0f;
        this.downX = 0.0f;
        this.flingStartTime = 0L;
        this.upTime = 0L;
        this.moveTime = 0L;
        this.prevMoveTime = 0L;
        this.downTime = 0L;
        this.flingVelocity = 0.0f;
        this.scrollTimer.removeCallbacks(this.flingScroll);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.stopMotion();
                this.inMotion = true;
                this.moveX = this.downX = event.getX();
                this.prevMoveX = this.downX;
                this.moveY = this.downY = event.getY();
                this.prevMoveY = this.downY;
                this.moveTime = this.downTime = AnimationUtils.currentAnimationTimeMillis();
                this.prevMoveTime = this.downTime;
                return true;
            }
            case 2: {
                if (!this.inMotion) {
                    return false;
                }
                long currentTime = AnimationUtils.currentAnimationTimeMillis();
                this.velocityX = (this.prevMoveX - event.getX()) * 1000.0f / (float)(currentTime - this.prevMoveTime);
                this.velocityY = (this.prevMoveY - event.getY()) * 1000.0f / (float)(currentTime - this.prevMoveTime);
                this.deltaX = this.moveX - event.getX();
                this.deltaY = this.moveY - event.getY();
                this.prevMoveX = this.moveX;
                this.prevMoveY = this.moveY;
                this.prevMoveTime = this.moveTime;
                this.moveX = event.getX();
                this.moveY = event.getY();
                this.moveTime = currentTime;
                if (this.scrollVert) {
                    this.listener.scrollUpdate(0, (int)this.deltaY);
                } else if (Math.abs(this.deltaY) > Math.abs(this.deltaX) || Math.abs(this.deltaY) > 4.0f) {
                    this.listener.scrollUpdate((int)this.deltaX, (int)this.deltaY);
                } else {
                    this.listener.scrollUpdate((int)this.deltaX, 0);
                }
                return true;
            }
            case 1: {
                if (!this.inMotion) {
                    return false;
                }
                this.inMotion = false;
                this.upTime = AnimationUtils.currentAnimationTimeMillis();
                this.upX = event.getX();
                this.upY = event.getY();
                float overallDeltaX = this.upX - this.downX;
                float overallDeltaY = this.upY - this.downY;
                if (this.upTime - this.downTime < 500L && Math.abs(overallDeltaX) <= 5.0f && Math.abs(overallDeltaY) <= 5.0f) {
                    this.listener.scrollTapped((int)this.downX, (int)this.downY);
                    return true;
                }
                if (this.scrollVert) {
                    if (Math.abs(overallDeltaY) <= 5.0f) {
                        return true;
                    }
                    if (Math.abs(this.velocityY) < 20.0f) {
                        return true;
                    }
                } else {
                    if (Math.abs(overallDeltaX) <= 5.0f) {
                        return true;
                    }
                    if (Math.abs(this.velocityX) < 20.0f) {
                        return true;
                    }
                }
                this.flingStartTime = this.upTime;
                float scale = 0.95f;
                this.flingVelocity = this.scrollVert ? scale * this.velocityY : scale * this.velocityX;
                this.scrollTimer.postDelayed(this.flingScroll, 50L);
                return true;
            }
        }
        return false;
    }
}

