/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.api.stream;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import cn.rongcloud.rtc.core.CreateEglContextException;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.GlUtil;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.TimestampAligner;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.YuvConverter;
import io.rong.common.rlog.RLog;
import java.util.concurrent.Callable;

public class RCRTCSurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter;
    private final TimestampAligner timestampAligner;
    private Sink listener;
    private boolean hasPendingTexture;
    private volatile boolean isTextureInUse;
    private boolean isQuitting;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    private Sink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.d(RCRTCSurfaceTextureHelper.TAG, "Setting listener to " + RCRTCSurfaceTextureHelper.this.pendingListener);
            RCRTCSurfaceTextureHelper.this.listener = RCRTCSurfaceTextureHelper.this.pendingListener;
            RCRTCSurfaceTextureHelper.this.pendingListener = null;
            if (RCRTCSurfaceTextureHelper.this.hasPendingTexture) {
                RCRTCSurfaceTextureHelper.this.updateTexImage();
                RCRTCSurfaceTextureHelper.this.hasPendingTexture = false;
            }
        }
    };

    public static RCRTCSurfaceTextureHelper create(final String threadName, final EglBase.Context sharedContext, final boolean alignTimestamps, final YuvConverter yuvConverter) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<RCRTCSurfaceTextureHelper>(){

            @Override
            public RCRTCSurfaceTextureHelper call() {
                try {
                    return new RCRTCSurfaceTextureHelper(sharedContext, handler, alignTimestamps, yuvConverter);
                }
                catch (Exception e) {
                    Logging.e(RCRTCSurfaceTextureHelper.TAG, threadName + " create failure", e);
                    return null;
                }
            }
        });
    }

    public static RCRTCSurfaceTextureHelper create(String threadName, EglBase.Context sharedContext) {
        return RCRTCSurfaceTextureHelper.create(threadName, sharedContext, false, new YuvConverter());
    }

    public static RCRTCSurfaceTextureHelper create(String threadName, EglBase.Context sharedContext, boolean alignTimestamps) {
        return RCRTCSurfaceTextureHelper.create(threadName, sharedContext, alignTimestamps, new YuvConverter());
    }

    private RCRTCSurfaceTextureHelper(EglBase.Context sharedContext, Handler handler, boolean alignTimestamps, YuvConverter yuvConverter) throws CreateEglContextException {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.timestampAligner = alignTimestamps ? new TimestampAligner() : null;
        this.yuvConverter = yuvConverter;
        this.eglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        RCRTCSurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                RCRTCSurfaceTextureHelper.this.hasPendingTexture = true;
                RCRTCSurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        }, handler);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    public void startListening(Sink listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper.this.listener = null;
                RCRTCSurfaceTextureHelper.this.pendingListener = null;
            }
        });
    }

    public void setTextureSize(final int textureWidth, final int textureHeight) {
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + textureWidth);
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + textureHeight);
        }
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper.this.textureWidth = textureWidth;
                RCRTCSurfaceTextureHelper.this.textureHeight = textureHeight;
            }
        });
    }

    public void setFrameRotation(final int rotation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper.this.frameRotation = rotation;
            }
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper.this.isTextureInUse = false;
                if (RCRTCSurfaceTextureHelper.this.isQuitting) {
                    RCRTCSurfaceTextureHelper.this.release();
                } else {
                    RCRTCSurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                RCRTCSurfaceTextureHelper.this.isQuitting = true;
                if (!RCRTCSurfaceTextureHelper.this.isTextureInUse) {
                    RCRTCSurfaceTextureHelper.this.release();
                }
            }
        });
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.shareTextureLock;
        synchronized (object) {
            try {
                this.surfaceTexture.updateTexImage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture || this.isTextureInUse || this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = this.surfaceTexture.getTimestamp();
        if (this.timestampAligner != null) {
            timestampNs = this.timestampAligner.translateTimestamp(timestampNs);
        }
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        if (this.listener != null) {
            this.listener.onTexture(this.textureWidth, this.textureHeight, this.oesTextureId, transformMatrix, this.frameRotation, timestampNs);
        }
        this.returnTextureFrame();
    }

    private void release() {
        RLog.d((String)TAG, (String)"release: ");
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
        if (this.timestampAligner != null) {
            this.timestampAligner.dispose();
        }
    }

    public static interface Sink {
        public void onTexture(int var1, int var2, int var3, float[] var4, int var5, long var6);
    }
}

