/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCOtherRoomEventsListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomListenerWrapper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RCOtherRoomImpl
implements RCRTCOtherRoom {
    private static final String TAG = "RCOtherRoomImpl";
    private String mRoomId;
    private Map<String, RCRTCRemoteUser> mRemoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
    private RCRoomListenerWrapper mRCRoomListenerWrapper;
    private String mSessionId;
    private RCRTCRoomType mRoomType;

    public RCOtherRoomImpl(String roomid, RCRTCRoomType roomType, Map<String, RCRTCRemoteUser> remoteUsers, String sessionId, Handler callbackHandler) {
        if (remoteUsers != null) {
            this.mRemoteUsers.putAll(remoteUsers);
        }
        this.mRoomId = roomid;
        this.mRCRoomListenerWrapper = new RCRoomListenerWrapper(roomid, callbackHandler);
        this.mSessionId = sessionId;
        this.mRoomType = roomType;
    }

    public RCRTCRoomType getRoomType() {
        return this.mRoomType;
    }

    @Override
    public void registerOtherRoomEventsListener(IRCRTCOtherRoomEventsListener listener) {
        if (listener != null) {
            this.mRCRoomListenerWrapper.setEventsListener(listener);
        }
    }

    @Override
    public void unregisterOtherRoomEventsListener() {
        if (this.mRCRoomListenerWrapper != null) {
            this.mRCRoomListenerWrapper.setEventsListener(null);
        }
    }

    @Override
    public String getRoomId() {
        return this.mRoomId;
    }

    @Override
    public List<RCRTCRemoteUser> getRemoteUsers() {
        ArrayList<RCRTCRemoteUser> rcRemoteUsers = new ArrayList<RCRTCRemoteUser>(this.mRemoteUsers.values().size());
        rcRemoteUsers.addAll(this.mRemoteUsers.values());
        return rcRemoteUsers;
    }

    @Override
    public RCRTCRemoteUser getRemoteUser(String userId) {
        return this.mRemoteUsers.get(userId);
    }

    @Override
    public String getSessionId() {
        return this.mSessionId;
    }

    public IRCRTCOtherRoomEventsListener getRCRoomListener() {
        return this.mRCRoomListenerWrapper;
    }

    public void addRemoteUser(RCRTCRemoteUser remoteUser) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mRemoteUsers.put(remoteUser.getUserId(), remoteUser);
    }

    public RCRTCRemoteUser removeRemoteUser(String userId) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        RCRemoteUserImpl user = (RCRemoteUserImpl)this.mRemoteUsers.remove(userId);
        if (user != null) {
            user.release();
        }
        return user;
    }

    @Override
    public void setRoomAttributeValue(String value, String key, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.mRoomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void setRoomAttribute(String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().setAttributeValue(this.mRoomId, RCAttributeType.ROOM, key, value, message, callback);
    }

    @Override
    public void deleteRoomAttributes(List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        RTCEngineImpl.getInstance().deleteAttributes(this.mRoomId, RCAttributeType.ROOM, attributeKeys, message, callback);
    }

    @Override
    public void getRoomAttributes(List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        RTCEngineImpl.getInstance().getAttributes(this.mRoomId, RCAttributeType.ROOM, attributeKeys, callback);
    }

    public void release() {
        FinLog.d(TAG, "otherRoom release :" + this.mRoomId);
        for (RCRTCRemoteUser remoteUser : this.mRemoteUsers.values()) {
            ((RCRemoteUserImpl)remoteUser).release();
        }
        this.mRemoteUsers.clear();
        if (this.mRCRoomListenerWrapper != null) {
            this.mRCRoomListenerWrapper.release();
        }
        this.mRCRoomListenerWrapper = null;
    }
}

