/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.callback.IRCRTCVideoInputFrameListener;
import cn.rongcloud.rtc.api.callback.RCRTCVideoInputStreamEventListener;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCRemoteVideoFrame;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.core.CreateEglContextException;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.OesToRgbFilter;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IRemoteVideoStreamResource;
import java.nio.ByteBuffer;

public class RCVideoInputStreamImpl
extends RCInputStreamImpl
implements RCRTCVideoInputStream,
IRemoteVideoStreamResource {
    private static final String TAG = "RCVideoInputStreamImpl";
    private RCRTCBaseView mVideoView;
    private RCRTCStreamType mStreamType = RCRTCStreamType.TINY;
    private IRCRTCVideoInputFrameListener inputFrameListener;
    private SwapFrameSink swapFrameSink = new SwapFrameSink();
    private OesToRgbFilter toRgbFilter;
    private EglBase eglBase = null;
    private RCRTCVideoInputStreamEventListener eventListener;

    public RCVideoInputStreamImpl(String userId, String tag, String streamId, String uri) {
        super(userId, tag, RCRTCMediaType.VIDEO, streamId, uri);
    }

    public RCVideoInputStreamImpl(String userId, String tag, String streamId) {
        super(userId, tag, RCRTCMediaType.VIDEO, streamId, "");
    }

    public RCVideoInputStreamImpl(String userId, MediaResourceInfo mediaResourceInfo) {
        super(userId, mediaResourceInfo.getTag(), RCRTCMediaType.VIDEO, mediaResourceInfo.getStreamId(), mediaResourceInfo.getUri());
        this.setResourceState(mediaResourceInfo.getRCRTCResourceState());
    }

    @Override
    public synchronized void setVideoView(RCRTCBaseView videoView) {
        ReportUtil.appStatus(ReportUtil.TAG.SETVIDEOVIEW, "streamId|view", this.streamId, RongRTCUtils.getObjectHashCode(videoView));
        this.onUnbindingSink(true);
        this.mVideoView = videoView;
        this.onBindingSink();
    }

    @Override
    public void setStreamEventListener(RCRTCVideoInputStreamEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public RCRTCVideoInputStreamEventListener getStreamEventListener() {
        return this.eventListener;
    }

    private synchronized void onUnbindingSink(boolean release) {
        final RCRTCBaseView videoView = this.mVideoView;
        MediaStreamTrack track = this.track;
        if (track == null || !(track instanceof VideoTrack) || videoView == null) {
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.UNBINDINGSINK, "streamId|trackId|videoView", this.streamId, this.getTrackId(), RongRTCUtils.getObjectHashCode(videoView));
        this.onRemoveSink(videoView);
        this.onRemoveSink(this.swapFrameSink);
        if (release) {
            RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                @Override
                public void run() {
                    if (videoView != null) {
                        videoView.release();
                    }
                }
            });
        }
    }

    private synchronized void onBindingSink() {
        RCRTCBaseView videoView = this.mVideoView;
        MediaStreamTrack track = this.track;
        if (track == null || !(track instanceof VideoTrack) || videoView == null) {
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.SETREMOTERENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
        RTCEngineImpl.getInstance().postUIThread(new Runnable(){

            @Override
            public void run() {
                MediaStreamTrack track = RCVideoInputStreamImpl.this.track;
                RCRTCBaseView videoView = RCVideoInputStreamImpl.this.mVideoView;
                if (track == null || videoView == null) {
                    ReportUtil.appError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                    return;
                }
                videoView.init(RTCEngineImpl.getInstance().getEglBaseContext(), RCVideoInputStreamImpl.this);
                try {
                    ((VideoTrack)track).addSink(videoView);
                    ((VideoTrack)track).addSink(RCVideoInputStreamImpl.this.swapFrameSink);
                    ReportUtil.libRes(ReportUtil.TAG.SETREMOTERENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
                }
                catch (Exception e) {
                    ReportUtil.libError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        this.onUnbindingSink(false);
        super.setTrack(track);
        this.onBindingSink();
        if (this.inputFrameListener != null && track != null) {
            ((VideoTrack)track).addSink(this.swapFrameSink);
        }
    }

    private void onRemoveSink(VideoSink sink) {
        MediaStreamTrack track = this.track;
        if (track == null || sink == null) {
            FinLog.e(TAG, "onRemoveSink track or sink is Null");
            return;
        }
        try {
            ((VideoTrack)track).removeSink(sink);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized RCRTCBaseView getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void setStreamType(RCRTCStreamType streamType) {
        this.mStreamType = streamType;
    }

    @Override
    public RCRTCStreamType getStreamType() {
        return this.mStreamType;
    }

    @Override
    public void setVideoFrameListener(IRCRTCVideoInputFrameListener frameListener) {
        this.inputFrameListener = frameListener;
        MediaStreamTrack track = this.track;
        if (track == null) {
            return;
        }
        if (frameListener != null) {
            ((VideoTrack)track).addSink(this.swapFrameSink);
        } else {
            ((VideoTrack)track).removeSink(this.swapFrameSink);
        }
    }

    @Override
    public void release() {
        this.onUnbindingSink(false);
        super.release();
        if (this.mVideoView != null) {
            this.mVideoView.release();
        }
        this.mVideoView = null;
        if (this.toRgbFilter != null) {
            this.toRgbFilter.destroy();
        }
        if (this.eglBase != null) {
            this.eglBase.release();
        }
    }

    class SwapFrameSink
    implements VideoSink {
        private ByteBuffer i420YData;
        private ByteBuffer i420UData;
        private ByteBuffer i420VData;
        private VideoFrame.I420Buffer preI420Buffer;

        SwapFrameSink() {
        }

        @Override
        public void onFrame(VideoFrame frame) {
            IRCRTCVideoInputFrameListener listener = RCVideoInputStreamImpl.this.inputFrameListener;
            if (listener != null) {
                if (frame.getBuffer() instanceof VideoFrame.TextureBuffer) {
                    TextureBufferImpl buffer = (TextureBufferImpl)frame.getBuffer();
                    if (RCVideoInputStreamImpl.this.toRgbFilter == null) {
                        try {
                            RCVideoInputStreamImpl.this.eglBase = EglBase.create(RTCEngineImpl.getInstance().getEglBaseContext(), EglBase.CONFIG_RGBA);
                            RCVideoInputStreamImpl.this.eglBase.createDummyPbufferSurface();
                            RCVideoInputStreamImpl.this.eglBase.makeCurrent();
                        }
                        catch (CreateEglContextException e) {
                            e.printStackTrace();
                            RCVideoInputStreamImpl.this.eglBase.release();
                        }
                        RCVideoInputStreamImpl.this.toRgbFilter = new OesToRgbFilter();
                        RCVideoInputStreamImpl.this.toRgbFilter.init();
                    }
                    RCVideoInputStreamImpl.this.toRgbFilter.onSizeChanged(buffer.getWidth(), buffer.getHeight());
                    int textureId = RCVideoInputStreamImpl.this.toRgbFilter.drawTexture(buffer.getTextureId(), buffer.getOriginalMatrix());
                    RCRTCRemoteVideoFrame.RTCRGBTextureBuffer rgbTextureBuf = new RCRTCRemoteVideoFrame.RTCRGBTextureBuffer(textureId, buffer.getTransformMatrix(), buffer.getOriginalMatrix(), buffer.getWidth(), buffer.getHeight());
                    listener.onFrame(new RCRTCRemoteVideoFrame(frame, rgbTextureBuf, RCRTCRemoteVideoFrame.RCRTCVideoFrameType.TEXTURE_2D));
                } else if (frame.getBuffer() instanceof VideoFrame.I420Buffer) {
                    VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)frame.getBuffer();
                    if (this.preI420Buffer == null || this.preI420Buffer.getWidth() != i420Buffer.getWidth() || this.preI420Buffer.getHeight() != i420Buffer.getHeight() || this.preI420Buffer.getStrideY() != i420Buffer.getStrideY() || this.preI420Buffer.getStrideU() != i420Buffer.getStrideU() || this.preI420Buffer.getStrideV() != i420Buffer.getStrideV()) {
                        this.i420YData = ByteBuffer.allocateDirect(i420Buffer.getDataY().limit());
                        this.i420UData = ByteBuffer.allocateDirect(i420Buffer.getDataU().limit());
                        this.i420VData = ByteBuffer.allocateDirect(i420Buffer.getDataV().limit());
                    }
                    this.i420YData.clear();
                    this.i420YData.put(i420Buffer.getDataY());
                    this.i420UData.clear();
                    this.i420UData.put(i420Buffer.getDataU());
                    this.i420VData.clear();
                    this.i420VData.put(i420Buffer.getDataV());
                    this.preI420Buffer = i420Buffer;
                    listener.onFrame(new RCRTCRemoteVideoFrame(frame, this.i420YData, this.i420UData, this.i420VData));
                } else {
                    listener.onFrame(new RCRTCRemoteVideoFrame(frame));
                }
            }
        }
    }
}

