/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioManager;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.core.audio.AudioMixerSourceEvents;
import cn.rongcloud.rtc.core.audio.CustomAudioRecord;
import cn.rongcloud.rtc.core.audio.CustomAudioTrack;
import cn.rongcloud.rtc.core.audio.CustomEchoAudioRecorder;
import cn.rongcloud.rtc.core.audio.EAudioInput;
import cn.rongcloud.rtc.core.audio.IAudioInput;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import cn.rongcloud.rtc.core.audio.RongRtcAudioManager;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.utils.ReportUtil;

public class CustomAudioDeviceModule
implements AudioDeviceModule {
    private static final String TAG = "CustomAudioDeviceModule";
    private final Context context;
    private final AudioManager audioManager;
    private int audioSource;
    private IAudioInput audioInput;
    private final CustomAudioTrack audioOutput;
    private final int sampleRate;
    private final boolean useStereoInput;
    private final boolean useStereoOutput;
    private final Object nativeLock = new Object();
    private long nativeAudioDeviceModule;
    private Builder builder;
    VoiceBeautifierPlugin mVoiceBeautifierPlugin;

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    private CustomAudioDeviceModule(Context context, AudioManager audioManager, int audioSource, IAudioInput audioInput, CustomAudioTrack audioOutput, int sampleRate, boolean useStereoInput, boolean useStereoOutput, Builder builder) {
        this.context = context;
        this.audioManager = audioManager;
        this.audioSource = audioSource;
        this.audioInput = audioInput;
        this.audioOutput = audioOutput;
        this.sampleRate = sampleRate;
        this.useStereoInput = useStereoInput;
        this.useStereoOutput = useStereoOutput;
        this.builder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNativeAudioDeviceModulePointer() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule == 0L) {
                this.nativeAudioDeviceModule = CustomAudioDeviceModule.nativeCreateAudioDeviceModule(this.context, this.audioManager, this.audioInput, this.audioOutput, this.audioSource, this.sampleRate, this.useStereoInput, this.useStereoOutput);
            }
            return this.nativeAudioDeviceModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule != 0L) {
                JniCommon.nativeReleaseRef(this.nativeAudioDeviceModule);
                this.nativeAudioDeviceModule = 0L;
            }
        }
    }

    @Override
    public void setSpeakerMute(boolean mute) {
        Logging.d(TAG, "setSpeakerMute: " + mute);
        this.audioOutput.setSpeakerMute(mute);
    }

    @Override
    public void setMicrophoneMute(boolean mute) {
        Logging.d(TAG, "setMicrophoneMute: " + mute);
        if (null != this.audioInput) {
            this.audioInput.setMicrophoneMute(mute);
        }
    }

    @Override
    public void setEcho(boolean enable) {
        if (this.audioInput == null) {
            ReportUtil.appError(ReportUtil.TAG.ENABLE_EAR_MONITOR, "msg", "audioInput is null");
            return;
        }
        this.audioInput.setEcho(enable);
    }

    @Override
    public void setVoiceBeautifier(VoiceBeautifierPlugin beautifier) {
        this.mVoiceBeautifierPlugin = beautifier;
        if (this.audioInput != null) {
            this.audioInput.setVoiceBeautifier(beautifier);
        }
    }

    @Override
    public void changeAudioInput(Builder builder) {
        if (this.audioInput == null) {
            return;
        }
        this.builder = builder;
        if (builder.getAudioInputType() == EAudioInput.AUDIORECORD) {
            this.audioInput = new CustomAudioRecord(builder.getPreListener(), builder.getPostListener(), this.context, builder.getAudioManager(), builder.getAudioRecordProxy(), builder.getAudioSource(), builder.getAudioFormat());
            this.audioInput.setMixerSourceEventsListener(builder.getMixerSourceEvents());
        } else if (builder.getAudioInputType() == EAudioInput.OPENSLES) {
            this.audioInput = new CustomEchoAudioRecorder(builder.getPreListener(), builder.getPostListener(), builder.getErrorListener());
            this.audioInput.setMixerSourceEventsListener(builder.getMixerSourceEvents());
        }
        CustomAudioDeviceModule.nativeChangeAudioInput(this.nativeAudioDeviceModule, this.context, builder.getAudioManager(), this.audioInput, builder.getAudioSource(), builder.getSampleRate(), builder.getUseStereoInput(), builder.getUseStereoOutput());
        this.audioInput.setVoiceBeautifier(this.mVoiceBeautifierPlugin);
        this.audioInput.setEcho(builder.getEcho());
        this.audioInput.setMicrophoneMute(builder.getMute());
        ReportUtil.libRes(ReportUtil.TAG.CHANGEAUDIOINPUT, "audioSource|isEcho|isMute|inputType", new Object[]{builder.getAudioSource(), builder.getEcho(), builder.getMute(), builder.getAudioInputType()});
    }

    public IAudioInput getAudioInput() {
        return this.audioInput;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    private static native long nativeCreateAudioDeviceModule(Context var0, AudioManager var1, IAudioInput var2, CustomAudioTrack var3, int var4, int var5, boolean var6, boolean var7);

    private static native void nativeChangeAudioInput(long var0, Context var2, AudioManager var3, IAudioInput var4, int var5, int var6, boolean var7, boolean var8);

    public static class Builder {
        private final Context context;
        private AudioManager audioManager;
        private int sampleRate;
        private int audioSource = 7;
        private int audioFormat = 2;
        private boolean useStereoInput;
        private boolean useStereoOutput;
        private EAudioInput eAudioInputType;
        private OnAudioBufferAvailableListener preListener;
        private OnAudioBufferAvailableListener postlistener;
        private OnAudioDeviceErrorListener onAudioDeviceErrorListener;
        private CustomAudioRecord.AudioRecordProxy aRecordProxy;
        private CustomAudioTrack.AudioTrackProxy aTrackProxy;
        private AudioMixerSourceEvents mixerSourceEvents;
        private boolean isEcho;
        private boolean isMute;

        private Builder(Context context) {
            this.context = context;
            this.audioManager = (AudioManager)context.getSystemService("audio");
            this.sampleRate = RongRtcAudioManager.getSampleRate(this.audioManager);
            this.eAudioInputType = EAudioInput.AUDIORECORD;
        }

        public Builder setAudioInputType(EAudioInput type) {
            Logging.d(CustomAudioDeviceModule.TAG, "EAudioInput type is : " + (Object)((Object)type));
            this.eAudioInputType = type;
            return this;
        }

        public Builder setPreListener(OnAudioBufferAvailableListener listener) {
            this.preListener = listener;
            return this;
        }

        public OnAudioBufferAvailableListener getPreListener() {
            return this.preListener;
        }

        public Builder setPostListener(OnAudioBufferAvailableListener listener) {
            this.postlistener = listener;
            return this;
        }

        public OnAudioBufferAvailableListener getPostListener() {
            return this.postlistener;
        }

        public Builder setErrorListener(OnAudioDeviceErrorListener listener) {
            this.onAudioDeviceErrorListener = listener;
            return this;
        }

        public OnAudioDeviceErrorListener getErrorListener() {
            return this.onAudioDeviceErrorListener;
        }

        public Builder setMixerSourceEvents(AudioMixerSourceEvents mixerSourceEvents) {
            this.mixerSourceEvents = mixerSourceEvents;
            return this;
        }

        public AudioMixerSourceEvents getMixerSourceEvents() {
            return this.mixerSourceEvents;
        }

        public Builder setAudioRecordProxy(CustomAudioRecord.AudioRecordProxy recordProxy) {
            this.aRecordProxy = recordProxy;
            return this;
        }

        public CustomAudioRecord.AudioRecordProxy getAudioRecordProxy() {
            return this.aRecordProxy;
        }

        public Builder setAudioTrackProxy(CustomAudioTrack.AudioTrackProxy trackProxy) {
            this.aTrackProxy = trackProxy;
            return this;
        }

        public CustomAudioTrack.AudioTrackProxy getAudioTrackProxy() {
            return this.aTrackProxy;
        }

        public EAudioInput getAudioInputType() {
            return this.eAudioInputType;
        }

        public Builder setSampleRate(int sampleRate) {
            Logging.d(CustomAudioDeviceModule.TAG, "Sample rate overridden to: " + sampleRate);
            this.sampleRate = sampleRate;
            return this;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        public int getAudioSource() {
            return this.audioSource;
        }

        public Builder setAudioManager(AudioManager manager) {
            this.audioManager = manager;
            return this;
        }

        public AudioManager getAudioManager() {
            return this.audioManager;
        }

        public Builder setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public Builder setUseStereoInput(boolean useStereoInput) {
            this.useStereoInput = useStereoInput;
            return this;
        }

        public boolean getUseStereoInput() {
            return this.useStereoInput;
        }

        public Builder setUseStereoOutput(boolean useStereoOutput) {
            this.useStereoOutput = useStereoOutput;
            return this;
        }

        public boolean getUseStereoOutput() {
            return this.useStereoOutput;
        }

        public Builder setEcho(boolean echo) {
            this.isEcho = echo;
            return this;
        }

        public boolean getEcho() {
            return this.isEcho;
        }

        public Builder setMute(boolean mute) {
            this.isMute = mute;
            return this;
        }

        public boolean getMute() {
            return this.isMute;
        }

        public AudioDeviceModule createAudioDeviceModule() {
            IAudioInput audioInput = null;
            if (this.eAudioInputType == EAudioInput.AUDIORECORD) {
                audioInput = new CustomAudioRecord(this.preListener, this.postlistener, this.context, this.audioManager, this.aRecordProxy, this.audioSource, this.audioFormat);
                audioInput.setMixerSourceEventsListener(this.mixerSourceEvents);
            } else if (this.eAudioInputType == EAudioInput.OPENSLES) {
                audioInput = new CustomEchoAudioRecorder(this.preListener, this.postlistener, this.onAudioDeviceErrorListener);
                audioInput.setMixerSourceEventsListener(this.mixerSourceEvents);
            }
            CustomAudioTrack audioOutput = new CustomAudioTrack(this.context, this.audioManager, this.aTrackProxy);
            return new CustomAudioDeviceModule(this.context, this.audioManager, this.audioSource, audioInput, audioOutput, this.sampleRate, this.useStereoInput, this.useStereoOutput, this);
        }
    }
}

