/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.model.result.policy;

import com.ksyun.ks3.model.result.policy.BucketPolicyActionCode;
import com.ksyun.ks3.model.result.policy.BucketPolicyCondition;
import com.ksyun.ks3.model.result.policy.BucketPolicyConditionRule;
import com.ksyun.ks3.model.result.policy.BucketPolicyPrincipalKscMap;
import com.ksyun.ks3.model.result.policy.BucketPolicyResourceList;
import java.util.ArrayList;
import java.util.List;

public class BucketPolicyRule {
    private String Effect;
    private List<String> Action;
    private BucketPolicyResourceList Resource;
    private BucketPolicyPrincipalKscMap Principal;
    private BucketPolicyCondition Condition;

    public String getEffect() {
        return this.Effect;
    }

    public BucketPolicyRule setEffect(String effect) {
        this.Effect = effect;
        return this;
    }

    public BucketPolicyRule addAction(BucketPolicyActionCode code) {
        this.Action.add(code.toString());
        return this;
    }

    public BucketPolicyRule addAllAction() {
        this.getAction().add("ks3:*");
        return this;
    }

    public BucketPolicyRule addResource(String resource) {
        this.getResource().addRecource(resource);
        return this;
    }

    public BucketPolicyRule addBucketResource(String bucketResource) {
        this.getResource().addBucket(bucketResource);
        return this;
    }

    public BucketPolicyRule addPrincipalByAccountId(String accountId) {
        this.getPrincipal().getRequestHeader().addAccountId(accountId);
        return this;
    }

    public BucketPolicyRule addPrincipalByAccountIdAndUserName(String accountId, String userName) {
        this.getPrincipal().getRequestHeader().addAccountIdAndUserName(accountId, userName);
        return this;
    }

    public BucketPolicyRule addPrincipalByAccountIdAndRoleName(String accountId, String roleName) {
        this.getPrincipal().getRequestHeader().addAccountIdAndRoleName(accountId, roleName);
        return this;
    }

    public BucketPolicyRule addConditionSouceIp(String content, boolean isIntercept) {
        this.getCondition().addSourceIp(content, isIntercept);
        return this;
    }

    public BucketPolicyRule addSourceHeader(String content, BucketPolicyConditionRule rule) {
        this.getCondition().addSourceHeader(content, rule);
        return this;
    }

    public BucketPolicyRule addSourceSubnet(String subnetID, String accountId, BucketPolicyConditionRule rule) {
        this.getCondition().addSourceBySubnetIDAndAccountId(subnetID, accountId, rule);
        return this;
    }

    public static BucketPolicyRule statement() {
        BucketPolicyRule policyStatement = new BucketPolicyRule();
        return policyStatement;
    }

    public BucketPolicyCondition getCondition() {
        if (this.Condition == null) {
            this.Condition = new BucketPolicyCondition();
        }
        return this.Condition;
    }

    public List<String> getAction() {
        if (this.Action == null) {
            this.Action = new ArrayList<String>();
        }
        return this.Action;
    }

    public BucketPolicyResourceList getResource() {
        if (this.Resource == null) {
            this.Resource = new BucketPolicyResourceList();
        }
        return this.Resource;
    }

    public BucketPolicyPrincipalKscMap getPrincipal() {
        if (this.Principal == null) {
            this.Principal = new BucketPolicyPrincipalKscMap();
        }
        return this.Principal;
    }
}

