/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.ObjectMetadata;
import com.ksyun.ks3.model.result.GetObjectResult;
import com.ksyun.ks3.util.Md5Utils;
import com.loopj.android.http.FileAsyncHttpResponseHandler;
import cz.msebera.android.httpclient.Header;
import java.io.File;

public abstract class GetObjectResponseHandler
extends FileAsyncHttpResponseHandler {
    private String mBucketName;
    private String mObjectKey;

    public GetObjectResponseHandler(File file, boolean append) {
        super(file, append);
    }

    public GetObjectResponseHandler(File file, String buckName, String objectKey) {
        this(file, false);
        this.mBucketName = buckName;
        this.mObjectKey = objectKey;
    }

    public abstract void onTaskProgress(double var1);

    public abstract void onTaskStart();

    public abstract void onTaskFinish();

    public abstract void onTaskCancel();

    public abstract void onTaskSuccess(int var1, Header[] var2, GetObjectResult var3);

    public abstract void onTaskFailure(int var1, Ks3Error var2, Header[] var3, Throwable var4, File var5);

    @Override
    public final void onFailure(int statesCode, Header[] paramArrayOfHeader, Throwable throwable, File paramFile) {
        Ks3Error error = new Ks3Error(statesCode, new byte[0], throwable);
        this.onTaskFailure(statesCode, error, paramArrayOfHeader, throwable, paramFile);
    }

    @Override
    public final void onSuccess(int paramInt, Header[] paramArrayOfHeader, File paramFile) {
        this.onTaskSuccess(paramInt, paramArrayOfHeader, this.parse(paramInt, paramArrayOfHeader, paramFile));
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
        double progress = totalSize > 0L ? (double)bytesWritten * 1.0 / (double)totalSize * 100.0 : -1.0;
        this.onTaskProgress(progress);
    }

    @Override
    public final void onStart() {
        this.onTaskStart();
    }

    @Override
    public final void onFinish() {
        this.onTaskFinish();
    }

    @Override
    public final void onCancel() {
        this.onTaskCancel();
    }

    @Override
    public final boolean deleteTargetFile() {
        return this.getTargetFile() != null && this.getTargetFile().delete();
    }

    @Override
    public final File getTargetFile() {
        assert (this.file != null);
        return this.file;
    }

    private GetObjectResult parse(int statesCode, Header[] responceHeaders, File file) {
        GetObjectResult result = new GetObjectResult();
        ObjectMetadata metaData = new ObjectMetadata();
        result.getObject().setBucketName(this.mBucketName);
        result.getObject().setKey(this.mObjectKey);
        if (statesCode == 200 || statesCode == 206) {
            result.getObject().setFile(file);
            Header[] headers = responceHeaders;
            for (int i = 0; i < headers.length; ++i) {
                String name = headers[i].getName();
                String value = headers[i].getValue();
                if (HttpHeaders.XKssWebsiteRedirectLocation.toString().equalsIgnoreCase(name)) {
                    result.getObject().setRedirectLocation(value);
                    continue;
                }
                if (name.startsWith("x-kss-meta-")) {
                    metaData.addOrEditUserMeta(headers[i].getName(), value);
                    continue;
                }
                if (name.equalsIgnoreCase(HttpHeaders.LastModified.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.LastModified, value);
                    continue;
                }
                if (name.equalsIgnoreCase(HttpHeaders.ETag.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.Etag, value.replace("\"", ""));
                    metaData.addOrEditMeta(ObjectMetadata.Meta.ContentMD5, Md5Utils.ETag2MD5(value));
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.CacheControl.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.CacheControl, value);
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.ContentDisposition.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.ContentDisposition, value);
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.ContentEncoding.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.ContentEncoding, value);
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.ContentLength.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.ContentLength, value);
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.ContentType.toString())) {
                    metaData.addOrEditMeta(ObjectMetadata.Meta.ContentType, value);
                    continue;
                }
                if (name.equalsIgnoreCase(ObjectMetadata.Meta.Expires.toString())) {
                    metaData.setExpires(value);
                    continue;
                }
                if (!name.equalsIgnoreCase(HttpHeaders.XKssObjectTagCount.toString())) continue;
                metaData.addOrEditMeta(ObjectMetadata.Meta.XKssObjectTagCount, value);
            }
            result.getObject().setObjectMetadata(metaData);
        } else if (statesCode == 304) {
            result.setIfModified(false);
        } else if (statesCode == 412) {
            result.setIfPreconditionSuccess(false);
        }
        return result;
    }
}

