/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.ObjectMetadata;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.CannedAccessControlList;
import com.ksyun.ks3.model.acl.Grant;
import com.ksyun.ks3.model.acl.Permission;
import com.ksyun.ks3.services.request.common.Ks3HttpObjectRequest;
import com.ksyun.ks3.services.request.tag.ObjectTagging;
import com.ksyun.ks3.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;

public class InitiateMultipartUploadRequest
extends Ks3HttpObjectRequest {
    private static final long serialVersionUID = 7282026856520472721L;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private AccessControlList acl = new AccessControlList();
    private CannedAccessControlList cannedAcl;

    public InitiateMultipartUploadRequest(String bucketName, String key) {
        this.setBucketname(bucketName);
        this.setObjectkey(key);
    }

    public InitiateMultipartUploadRequest(String bucketName, String key, ObjectTagging objectTagging) {
        this.setBucketname(bucketName);
        this.setObjectkey(key);
        if (objectTagging != null && objectTagging.getTagSet() != null && objectTagging.getTagSet().size() > 0) {
            this.setTagging(objectTagging);
        }
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.POST);
        this.addParams("uploads", null);
        if (StringUtils.isBlank(this.getContentType())) {
            this.addHeader(HttpHeaders.ContentType, "application/octet-stream");
        }
        for (Map.Entry<ObjectMetadata.Meta, String> entry : this.objectMeta.getMetadata().entrySet()) {
            if (entry.getKey().equals((Object)ObjectMetadata.Meta.ContentLength)) continue;
            this.addHeader(entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Object, String> entry : this.objectMeta.getUserMetadata().entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-kss-meta-")) continue;
            this.addHeader((String)entry.getKey(), entry.getValue());
        }
        if (this.cannedAcl != null) {
            this.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            ArrayList<String> grants_fullcontrol = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> grants_write = new ArrayList<String>();
            for (Grant grant : this.acl.getGrants()) {
                if (grant.getPermission().equals((Object)Permission.FullControl)) {
                    grants_fullcontrol.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (grant.getPermission().equals((Object)Permission.Read)) {
                    arrayList.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (!grant.getPermission().equals((Object)Permission.Write)) continue;
                grants_write.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
            }
            if (grants_fullcontrol.size() > 0) {
                this.addHeader(HttpHeaders.GrantFullControl, StringUtils.join(grants_fullcontrol, ","));
            }
            if (arrayList.size() > 0) {
                this.addHeader(HttpHeaders.GrantRead, StringUtils.join(arrayList, ","));
            }
            if (grants_write.size() > 0) {
                this.addHeader(HttpHeaders.GrantWrite, StringUtils.join(grants_write, ","));
            }
        }
        this.setTagHeader();
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (StringUtils.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("bucket name is not correct");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("object key can not be null");
        }
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }
}

