/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.ksyun.ks3.auth.ValidateUtil;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.Mimetypes;
import com.ksyun.ks3.model.ObjectMetadata;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.CannedAccessControlList;
import com.ksyun.ks3.model.acl.Grant;
import com.ksyun.ks3.model.acl.Permission;
import com.ksyun.ks3.model.transfer.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.model.transfer.RepeatableFileInputStream;
import com.ksyun.ks3.services.request.MD5CalculateAble;
import com.ksyun.ks3.services.request.adp.Adp;
import com.ksyun.ks3.services.request.common.Ks3HttpObjectRequest;
import com.ksyun.ks3.services.request.tag.ObjectTagging;
import com.ksyun.ks3.util.HttpUtils;
import com.ksyun.ks3.util.LengthCheckInputStream;
import com.ksyun.ks3.util.Md5Utils;
import com.ksyun.ks3.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutObjectRequest
extends Ks3HttpObjectRequest
implements MD5CalculateAble {
    private static final long serialVersionUID = 8398633676278496457L;
    private File file;
    private ObjectMetadata objectMeta = new ObjectMetadata();
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();
    private String redirectLocation;
    private String callBackUrl;
    private String callBackBody;
    private Map<String, String> callBackHeaders;
    private List<Adp> adps = new ArrayList<Adp>();
    private String notifyURL;
    private InputStream inputStream;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PutObjectRequest(String bucketname, String key, File file) {
        this.setBucketname(bucketname);
        this.setObjectkey(key);
        this.setFile(file);
    }

    public PutObjectRequest(String bucketname, String key, File file, ObjectMetadata metadata, ObjectTagging objectTagging) {
        this(bucketname, key, file);
        this.setObjectMeta(metadata == null ? this.objectMeta : metadata);
        if (objectTagging != null && objectTagging.getTagSet() != null && objectTagging.getTagSet().size() > 0) {
            this.setTagging(objectTagging);
        }
    }

    public PutObjectRequest(String bucketname, String key, File file, ObjectMetadata metadata) {
        this(bucketname, key, file);
        this.setObjectMeta(metadata == null ? this.objectMeta : metadata);
        if (metadata.getTagging() != null && metadata.getTagging().getTagSet() != null && metadata.getTagging().getTagSet().size() > 0) {
            this.setTagging(metadata.getTagging());
        }
    }

    public PutObjectRequest(String bucketname, String key, InputStream inputStream, ObjectMetadata metadata) {
        this.setBucketname(bucketname);
        this.setObjectkey(key);
        this.setInputStream(inputStream);
        this.setObjectMeta(metadata == null ? this.objectMeta : metadata);
    }

    public PutObjectRequest(String bucketname, String key, InputStream inputStream, ObjectMetadata metadata, ObjectTagging objectTagging) {
        this.setBucketname(bucketname);
        this.setObjectkey(key);
        this.setInputStream(inputStream);
        this.setObjectMeta(metadata == null ? this.objectMeta : metadata);
        if (objectTagging != null && objectTagging.getTagSet() != null && objectTagging.getTagSet().size() > 0) {
            this.setTagging(objectTagging);
        }
    }

    @Deprecated
    public PutObjectRequest(String bucketname, String key, InputStream inputStream, ObjectMetadata metadata, List<Adp> adps) {
        this.setBucketname(bucketname);
        this.setObjectkey(key);
        this.setInputStream(inputStream);
        this.setObjectMeta(metadata == null ? this.objectMeta : metadata);
        if (adps != null && adps.size() > 0) {
            this.adps = adps;
        }
    }

    public PutObjectRequest(String bucketName, String objectName, ObjectTagging objectTagging) {
        this.setBucketname(bucketName);
        this.setObjectkey(objectName);
        this.setTagging(objectTagging);
    }

    public void setCallBack(String callBackUrl, String callBackBody, Map<String, String> callBackHeaders, String notifyURL) {
        this.callBackUrl = callBackUrl;
        this.callBackBody = callBackBody;
        this.callBackHeaders = callBackHeaders;
        this.notifyURL = notifyURL;
    }

    public void setCallBack(String callBackUrl, String callBackBody, Map<String, String> callBackHeaders) {
        this.callBackUrl = callBackUrl;
        this.callBackBody = callBackBody;
        this.callBackHeaders = callBackHeaders;
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.PUT);
        try {
            if (this.file != null) {
                this.setRequestBody(new RepeatableFileInputStream(this.file));
                if (StringUtils.isBlank(this.getContentType())) {
                    this.objectMeta.setContentType(Mimetypes.getInstance().getMimetype(this.file));
                }
                this.objectMeta.setContentLength(String.valueOf(this.file.length()));
                this.addHeader(HttpHeaders.ContentLength, String.valueOf(this.file.length()));
                String contentMd5_b64 = Md5Utils.md5AsBase64(this.file);
                this.addHeader(HttpHeaders.ContentMD5.toString(), contentMd5_b64);
            } else if (this.inputStream != null) {
                this.objectMeta.setContentType("application/octet-stream");
                long length = this.objectMeta.getContentLength();
                if (length > 0L) {
                    this.setRequestBody(new LengthCheckInputStream(this.inputStream, length, false));
                    this.addHeader(HttpHeaders.ContentLength, String.valueOf(length));
                } else {
                    this.setRequestBody(this.inputStream);
                    this.addHeader(HttpHeaders.ContentLength, String.valueOf(this.inputStream.available()));
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Ks3ClientException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Ks3ClientException("calculate file md5 error (" + e + ")", e);
        }
        if (!StringUtils.isBlank(this.callBackUrl) && !StringUtils.isBlank(this.callBackBody)) {
            this.addHeader(HttpHeaders.XKssCallBackUrl, this.callBackUrl);
            this.addHeader(HttpHeaders.XKssCallBackBody, this.callBackBody);
            if (this.callBackHeaders != null && this.callBackHeaders.size() > 0) {
                for (Map.Entry<Object, String> entry : this.callBackHeaders.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = entry.getValue();
                    if (!StringUtils.isBlank(key) && key.startsWith("kss-") && !StringUtils.isBlank(val)) {
                        this.addHeader(key, val);
                        continue;
                    }
                    Log.e((String)"ks3_android_sdk", (String)("the header:" + key + "-" + val + " is not correct ,this head will be ignored"));
                }
            } else {
                Log.d((String)"ks3_android_sdk", (String)"the callbackheaders is null");
            }
        } else {
            Log.d((String)"ks3_android_sdk", (String)"the callbacurl or callbackbody is null , ignore set the callback");
        }
        if (this.adps != null && this.adps.size() > 0) {
            this.addHeader(HttpHeaders.AsynchronousProcessingList, URLEncoder.encode(HttpUtils.convertAdps2String(this.adps)));
            if (!StringUtils.isBlank(this.notifyURL)) {
                this.addHeader(HttpHeaders.NotifyURL, HttpUtils.urlEncode(this.notifyURL, false));
            }
        }
        for (Map.Entry<ObjectMetadata.Meta, String> entry : this.objectMeta.getMetadata().entrySet()) {
            if (entry.getKey().equals(ObjectMetadata.Meta.ContentLength.toString())) continue;
            this.addHeader(entry.getKey().toString(), entry.getValue());
        }
        for (Map.Entry<Object, String> entry : this.objectMeta.getUserMetadata().entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-kss-meta-")) continue;
            this.addHeader((String)entry.getKey(), entry.getValue());
        }
        if (this.cannedAcl != null) {
            this.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            ArrayList<String> grants_fullcontrol = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> grants_write = new ArrayList<String>();
            for (Grant grant : this.acl.getGrants()) {
                if (grant.getPermission().equals((Object)Permission.FullControl)) {
                    grants_fullcontrol.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (grant.getPermission().equals((Object)Permission.Read)) {
                    arrayList.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (!grant.getPermission().equals((Object)Permission.Write)) continue;
                grants_write.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
            }
            if (grants_fullcontrol.size() > 0) {
                this.addHeader(HttpHeaders.GrantFullControl, TextUtils.join((CharSequence)",", grants_fullcontrol));
            }
            if (arrayList.size() > 0) {
                this.addHeader(HttpHeaders.GrantRead, TextUtils.join((CharSequence)",", arrayList));
            }
            if (grants_write.size() > 0) {
                this.addHeader(HttpHeaders.GrantWrite, TextUtils.join((CharSequence)",", grants_write));
            }
        }
        if (this.redirectLocation != null) {
            this.addHeader(HttpHeaders.XKssWebsiteRedirectLocation, this.redirectLocation);
        }
        this.setTagHeader();
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (ValidateUtil.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("bucket name is not correct");
        }
        if (StringUtils.isBlank(this.getObjectkey())) {
            throw new Ks3ClientException("object key can not be null");
        }
        if (this.file == null && this.inputStream == null) {
            throw new Ks3ClientException("upload object can not be null");
        }
        if (this.acl != null && this.acl.getGrants() != null) {
            for (Grant grant : this.acl.getGrants()) {
                if (grant.getPermission() != null) continue;
                throw new Ks3ClientException("grant :" + grant.getGrantee() + ",permission can not be null");
            }
        }
        if (!(this.redirectLocation == null || this.redirectLocation.startsWith("/") || this.redirectLocation.startsWith("http://") || this.redirectLocation.startsWith("https://"))) {
            throw new Ks3ClientException("redirectLocation should start with / http:// or https://");
        }
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = file;
    }

    public ObjectMetadata getObjectMeta() {
        return this.objectMeta;
    }

    public void setObjectMeta(ObjectMetadata objectMeta) {
        this.objectMeta = objectMeta;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }

    public String getCallBackBody() {
        return this.callBackBody;
    }

    public void setCallBackBody(String callBackBody) {
        this.callBackBody = callBackBody;
    }

    public Map<String, String> getCallBackHeaders() {
        return this.callBackHeaders;
    }

    public void setCallBackHeaders(Map<String, String> callBackHeaders) {
        this.callBackHeaders = callBackHeaders;
    }

    public List<Adp> getAdps() {
        return this.adps;
    }

    public void setAdps(List<Adp> adps) {
        this.adps = adps;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    @Override
    public String getMd5() {
        return Base64.encodeToString((byte[])((MD5DigestCalculatingInputStream)super.getRequestBody()).getMd5Digest(), (int)0).trim();
    }
}

