/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.annotation.TargetApi;
import android.util.Log;
import com.loopj.android.http.LogInterface;

public class LogHandler
implements LogInterface {
    boolean mLoggingEnabled = true;
    int mLoggingLevel = 2;

    @Override
    public boolean isLoggingEnabled() {
        return this.mLoggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.mLoggingEnabled = loggingEnabled;
    }

    @Override
    public int getLoggingLevel() {
        return this.mLoggingLevel;
    }

    @Override
    public void setLoggingLevel(int loggingLevel) {
        this.mLoggingLevel = loggingLevel;
    }

    @Override
    public boolean shouldLog(int logLevel) {
        return logLevel >= this.mLoggingLevel;
    }

    public void log(int logLevel, String tag, String msg) {
        this.logWithThrowable(logLevel, tag, msg, null);
    }

    public void logWithThrowable(int logLevel, String tag, String msg, Throwable t) {
        if (this.isLoggingEnabled() && this.shouldLog(logLevel)) {
            switch (logLevel) {
                case 2: {
                    Log.v((String)tag, (String)msg, (Throwable)t);
                    break;
                }
                case 5: {
                    Log.w((String)tag, (String)msg, (Throwable)t);
                    break;
                }
                case 6: {
                    Log.e((String)tag, (String)msg, (Throwable)t);
                    break;
                }
                case 3: {
                    Log.d((String)tag, (String)msg, (Throwable)t);
                    break;
                }
                case 8: {
                    this.checkedWtf(tag, msg, t);
                    break;
                }
                case 4: {
                    Log.i((String)tag, (String)msg, (Throwable)t);
                }
            }
        }
    }

    @TargetApi(value=8)
    private void checkedWtf(String tag, String msg, Throwable t) {
        Log.wtf((String)tag, (String)msg, (Throwable)t);
    }

    @Override
    public void v(String tag, String msg) {
        this.log(2, tag, msg);
    }

    @Override
    public void v(String tag, String msg, Throwable t) {
        this.logWithThrowable(2, tag, msg, t);
    }

    @Override
    public void d(String tag, String msg) {
        this.log(2, tag, msg);
    }

    @Override
    public void d(String tag, String msg, Throwable t) {
        this.logWithThrowable(3, tag, msg, t);
    }

    @Override
    public void i(String tag, String msg) {
        this.log(4, tag, msg);
    }

    @Override
    public void i(String tag, String msg, Throwable t) {
        this.logWithThrowable(4, tag, msg, t);
    }

    @Override
    public void w(String tag, String msg) {
        this.log(5, tag, msg);
    }

    @Override
    public void w(String tag, String msg, Throwable t) {
        this.logWithThrowable(5, tag, msg, t);
    }

    @Override
    public void e(String tag, String msg) {
        this.log(6, tag, msg);
    }

    @Override
    public void e(String tag, String msg, Throwable t) {
        this.logWithThrowable(6, tag, msg, t);
    }

    @Override
    public void wtf(String tag, String msg) {
        this.log(8, tag, msg);
    }

    @Override
    public void wtf(String tag, String msg, Throwable t) {
        this.logWithThrowable(8, tag, msg, t);
    }
}

