/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.plugin.weex;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractScrollEventHandler;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.plugin.weex.WXModuleUtils;
import com.google.android.material.appbar.AppBarLayout;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceScrollerView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BindingXScrollHandler
extends AbstractScrollEventHandler {
    private RecyclerView.OnScrollListener mListOnScrollListener;
    private WXSwipeLayout.OnRefreshOffsetChangedListener mRefreshOffsetChangedListener;
    private WXScrollView.WXScrollViewListener mWxScrollViewListener;
    private WXHorizontalScrollView.ScrollViewListener mHorizontalViewScrollListener;
    private AppBarLayout.OnOffsetChangedListener mOnOffsetChangedListener;
    private static HashMap<String, ContentOffsetHolder> sOffsetHolderMap = new HashMap();
    private String mSourceRef;

    public BindingXScrollHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
    }

    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        WXComponent sourceComponent = WXModuleUtils.findComponentByRef(instanceId, sourceRef);
        if (sourceComponent == null) {
            LogProxy.e((String)"[ExpressionScrollHandler]source component not found.");
            return false;
        }
        this.mSourceRef = sourceRef;
        if (sourceComponent instanceof WXScroller) {
            ViewGroup innerView;
            WXSwipeLayout layout;
            WXScroller scroller = (WXScroller)sourceComponent;
            ViewGroup group = (ViewGroup)scroller.getHostView();
            if (group != null && group instanceof BounceScrollerView && (layout = ((BounceScrollerView)group).getSwipeLayout()) != null) {
                this.mRefreshOffsetChangedListener = new InnerSwipeOffsetListener();
                layout.addOnRefreshOffsetChangedListener(this.mRefreshOffsetChangedListener);
            }
            if ((innerView = scroller.getInnerView()) != null && innerView instanceof WXScrollView) {
                this.mWxScrollViewListener = new InnerScrollViewListener();
                ((WXScrollView)innerView).addScrollViewListener(this.mWxScrollViewListener);
                return true;
            }
            if (innerView != null && innerView instanceof WXHorizontalScrollView) {
                this.mHorizontalViewScrollListener = new InnerScrollViewListener();
                ((WXHorizontalScrollView)innerView).addScrollViewListener(this.mHorizontalViewScrollListener);
                return true;
            }
        } else if (sourceComponent instanceof WXListComponent) {
            WXListComponent list = (WXListComponent)sourceComponent;
            BounceRecyclerView hostView = (BounceRecyclerView)list.getHostView();
            if (hostView != null) {
                boolean isVertical;
                WXSwipeLayout layout = hostView.getSwipeLayout();
                if (layout != null) {
                    this.mRefreshOffsetChangedListener = new InnerSwipeOffsetListener();
                    layout.addOnRefreshOffsetChangedListener(this.mRefreshOffsetChangedListener);
                }
                WXRecyclerView recyclerView = (WXRecyclerView)hostView.getInnerView();
                boolean bl = isVertical = list.getOrientation() == 1;
                if (recyclerView != null) {
                    ContentOffsetHolder holder;
                    if (sOffsetHolderMap != null && (holder = sOffsetHolderMap.get(sourceRef)) == null) {
                        sOffsetHolderMap.put(sourceRef, new ContentOffsetHolder(0, 0));
                    }
                    this.mListOnScrollListener = new InnerListScrollListener(isVertical, new WeakReference<WXListComponent>(list));
                    recyclerView.addOnScrollListener(this.mListOnScrollListener);
                    return true;
                }
            }
        } else if (sourceComponent.getHostView() != null && sourceComponent.getHostView() instanceof AppBarLayout) {
            AppBarLayout appBarLayout = (AppBarLayout)sourceComponent.getHostView();
            this.mOnOffsetChangedListener = new InnerAppBarOffsetChangedListener();
            appBarLayout.addOnOffsetChangedListener(this.mOnOffsetChangedListener);
            return true;
        }
        return false;
    }

    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
    }

    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        super.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
    }

    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        WXListComponent list;
        BounceRecyclerView hostView;
        String instanceId;
        WXComponent sourceComponent;
        ContentOffsetHolder h;
        super.onDisable(sourceRef, eventType);
        if (sOffsetHolderMap != null && !TextUtils.isEmpty((CharSequence)this.mSourceRef) && (h = sOffsetHolderMap.get(this.mSourceRef)) != null) {
            h.x = this.mContentOffsetX;
            h.y = this.mContentOffsetY;
        }
        if ((sourceComponent = WXModuleUtils.findComponentByRef(instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId, sourceRef)) == null) {
            LogProxy.e((String)"[ExpressionScrollHandler]source component not found.");
            return false;
        }
        if (sourceComponent instanceof WXScroller) {
            ViewGroup innerView;
            WXSwipeLayout layout;
            WXScroller scroller = (WXScroller)sourceComponent;
            ViewGroup group = (ViewGroup)scroller.getHostView();
            if (group != null && group instanceof BounceScrollerView && (layout = ((BounceScrollerView)group).getSwipeLayout()) != null && this.mRefreshOffsetChangedListener != null) {
                layout.removeOnRefreshOffsetChangedListener(this.mRefreshOffsetChangedListener);
            }
            if ((innerView = scroller.getInnerView()) != null && innerView instanceof WXScrollView && this.mWxScrollViewListener != null) {
                ((WXScrollView)innerView).removeScrollViewListener(this.mWxScrollViewListener);
                return true;
            }
            if (innerView != null && innerView instanceof WXHorizontalScrollView && this.mHorizontalViewScrollListener != null) {
                ((WXHorizontalScrollView)innerView).removeScrollViewListener(this.mHorizontalViewScrollListener);
                return true;
            }
        } else if (sourceComponent instanceof WXListComponent && (hostView = (BounceRecyclerView)(list = (WXListComponent)sourceComponent).getHostView()) != null) {
            WXRecyclerView recyclerView;
            if (hostView.getSwipeLayout() != null && this.mRefreshOffsetChangedListener != null) {
                hostView.getSwipeLayout().removeOnRefreshOffsetChangedListener(this.mRefreshOffsetChangedListener);
            }
            if ((recyclerView = (WXRecyclerView)hostView.getInnerView()) != null && this.mListOnScrollListener != null) {
                recyclerView.removeOnScrollListener(this.mListOnScrollListener);
                return true;
            }
        }
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mListOnScrollListener = null;
        this.mWxScrollViewListener = null;
        this.mOnOffsetChangedListener = null;
        if (sOffsetHolderMap != null) {
            sOffsetHolderMap.clear();
        }
    }

    public void onActivityPause() {
    }

    public void onActivityResume() {
    }

    private boolean isSameDirection(int currentValue, int lastValue) {
        return currentValue > 0 && lastValue > 0 || currentValue < 0 && lastValue < 0;
    }

    private static class ContentOffsetHolder {
        int x;
        int y;

        ContentOffsetHolder(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private class InnerListScrollListener
    extends RecyclerView.OnScrollListener {
        private int mContentOffsetX = 0;
        private int mContentOffsetY = 0;
        private int mTx = 0;
        private int mTy = 0;
        private int mLastDx = 0;
        private int mLastDy = 0;
        private boolean isVertical;
        private WeakReference<WXListComponent> mComponentRef;

        InnerListScrollListener(boolean isVertical, WeakReference<WXListComponent> componentRef) {
            ContentOffsetHolder holder;
            this.isVertical = isVertical;
            this.mComponentRef = componentRef;
            if (!TextUtils.isEmpty((CharSequence)BindingXScrollHandler.this.mSourceRef) && sOffsetHolderMap != null && (holder = (ContentOffsetHolder)sOffsetHolderMap.get(BindingXScrollHandler.this.mSourceRef)) != null) {
                this.mContentOffsetX = holder.x;
                this.mContentOffsetY = holder.y;
            }
        }

        public void onScrolled(RecyclerView recyclerView, final int dx, final int dy) {
            this.mContentOffsetY = ViewCompat.isInLayout((View)recyclerView) && this.mComponentRef != null && this.mComponentRef.get() != null ? Math.abs(((WXListComponent)this.mComponentRef.get()).calcContentOffset(recyclerView)) : (this.mContentOffsetY += dy);
            this.mContentOffsetX += dx;
            boolean isTurning = false;
            if (!BindingXScrollHandler.this.isSameDirection(dx, this.mLastDx) && !this.isVertical) {
                this.mTx = this.mContentOffsetX;
                isTurning = true;
            }
            if (!BindingXScrollHandler.this.isSameDirection(dy, this.mLastDy) && this.isVertical) {
                this.mTy = this.mContentOffsetY;
                isTurning = true;
            }
            final int tdx = this.mContentOffsetX - this.mTx;
            final int tdy = this.mContentOffsetY - this.mTy;
            this.mLastDx = dx;
            this.mLastDy = dy;
            if (isTurning) {
                BindingXScrollHandler.this.fireEventByState("turn", this.mContentOffsetX, this.mContentOffsetY, dx, dy, tdx, tdy, new Object[0]);
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    BindingXScrollHandler.super.handleScrollEvent(InnerListScrollListener.this.mContentOffsetX, InnerListScrollListener.this.mContentOffsetY, dx, dy, tdx, tdy);
                }
            }, (Object)BindingXScrollHandler.this.mInstanceId);
        }
    }

    private class InnerSwipeOffsetListener
    implements WXSwipeLayout.OnRefreshOffsetChangedListener {
        private int mContentOffsetY = 0;
        private int mTy = 0;
        private int mLastDy = 0;

        private InnerSwipeOffsetListener() {
        }

        public void onOffsetChanged(int offset) {
            int normalizedOffset = -offset;
            final int dy = normalizedOffset - this.mContentOffsetY;
            this.mContentOffsetY = normalizedOffset;
            if (dy == 0) {
                return;
            }
            boolean isTurning = false;
            if (!BindingXScrollHandler.this.isSameDirection(dy, this.mLastDy)) {
                this.mTy = this.mContentOffsetY;
                isTurning = true;
            }
            final int tdy = this.mContentOffsetY - this.mTy;
            this.mLastDy = dy;
            if (isTurning) {
                BindingXScrollHandler.super.fireEventByState("turn", BindingXScrollHandler.this.mContentOffsetX, this.mContentOffsetY, 0.0, dy, 0.0, tdy, new Object[0]);
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    BindingXScrollHandler.super.handleScrollEvent(BindingXScrollHandler.this.mContentOffsetX, InnerSwipeOffsetListener.this.mContentOffsetY, 0, dy, 0, tdy);
                }
            }, (Object)BindingXScrollHandler.this.mInstanceId);
        }
    }

    private class InnerScrollViewListener
    implements WXScrollView.WXScrollViewListener,
    WXHorizontalScrollView.ScrollViewListener {
        private int mContentOffsetX = 0;
        private int mContentOffsetY = 0;
        private int mTx = 0;
        private int mTy = 0;
        private int mLastDx = 0;
        private int mLastDy = 0;

        private InnerScrollViewListener() {
        }

        public void onScroll(WXScrollView wxScrollView, int x, int y) {
            this.onScrollInternal(x, y);
        }

        public void onScrollChanged(WXHorizontalScrollView wxHorizontalScrollView, int x, int y, int oldX, int oldY) {
            this.onScrollInternal(x, y);
        }

        public void onScrollChanged(WXScrollView wxScrollView, int i, int i1, int i2, int i3) {
        }

        public void onScrollToBottom(WXScrollView wxScrollView, int i, int i1) {
        }

        public void onScrollStopped(WXScrollView wxScrollView, int i, int i1) {
        }

        private void onScrollInternal(int x, int y) {
            final int dx = x - this.mContentOffsetX;
            final int dy = y - this.mContentOffsetY;
            this.mContentOffsetX = x;
            this.mContentOffsetY = y;
            if (dx == 0 && dy == 0) {
                return;
            }
            boolean isTurning = false;
            if (!BindingXScrollHandler.this.isSameDirection(dy, this.mLastDy)) {
                this.mTy = this.mContentOffsetY;
                isTurning = true;
            }
            final int tdx = this.mContentOffsetX - this.mTx;
            final int tdy = this.mContentOffsetY - this.mTy;
            this.mLastDx = dx;
            this.mLastDy = dy;
            if (isTurning) {
                BindingXScrollHandler.super.fireEventByState("turn", this.mContentOffsetX, this.mContentOffsetY, dx, dy, tdx, tdy, new Object[0]);
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    BindingXScrollHandler.super.handleScrollEvent(InnerScrollViewListener.this.mContentOffsetX, InnerScrollViewListener.this.mContentOffsetY, dx, dy, tdx, tdy);
                }
            }, (Object)BindingXScrollHandler.this.mInstanceId);
        }
    }

    private class InnerAppBarOffsetChangedListener
    implements AppBarLayout.OnOffsetChangedListener {
        private int mContentOffsetY = 0;
        private int mTy = 0;
        private int mLastDy = 0;

        private InnerAppBarOffsetChangedListener() {
        }

        public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
            verticalOffset = -verticalOffset;
            final int dy = verticalOffset - this.mContentOffsetY;
            this.mContentOffsetY = verticalOffset;
            if (dy == 0) {
                return;
            }
            boolean isTurning = false;
            if (!BindingXScrollHandler.this.isSameDirection(dy, this.mLastDy)) {
                this.mTy = this.mContentOffsetY;
                isTurning = true;
            }
            final int tdy = this.mContentOffsetY - this.mTy;
            this.mLastDy = dy;
            if (isTurning) {
                BindingXScrollHandler.super.fireEventByState("turn", 0.0, this.mContentOffsetY, 0.0, dy, 0.0, tdy, new Object[0]);
            }
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    BindingXScrollHandler.super.handleScrollEvent(0, InnerAppBarOffsetChangedListener.this.mContentOffsetY, 0, dy, 0, tdy);
                }
            }, (Object)BindingXScrollHandler.this.mInstanceId);
        }
    }
}

