/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.ui.view.WXLoadingLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

@Component(lazyload=false)
public class WXLoading
extends WXBaseRefresh
implements WXSwipeLayout.WXOnLoadingListener {
    public static final String HIDE = "hide";

    public WXLoading(WXSDKInstance instance, WXVContainer parent, boolean lazy, BasicComponentData basicComponentData) {
        super(instance, parent, lazy, basicComponentData);
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        return new WXLoadingLayout(context);
    }

    @Override
    public void onLoading() {
        if (this.getEvents().contains("loading")) {
            this.fireEvent("loading");
        }
    }

    @Override
    protected void setHostLayoutParams(WXFrameLayout host, int width, int height, int left, int right, int top, int bottom) {
        super.setHostLayoutParams(host, width, height, 0, 0, 0, 0);
    }

    @Override
    public void onPullingUp(float dy, int pullOutDistance, float viewHeight) {
        if (this.getEvents().contains("pullingup")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("dy", Float.valueOf(dy));
            data.put("pullingDistance", pullOutDistance);
            data.put("viewHeight", Float.valueOf(viewHeight));
            this.fireEvent("pullingup", data);
        }
    }

    @Override
    public boolean canRecycled() {
        return false;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "display": {
                String display = WXUtils.getString(param, null);
                if (display != null) {
                    this.setDisplay(display);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="display")
    public void setDisplay(String display) {
        if (!TextUtils.isEmpty((CharSequence)display) && display.equals(HIDE) && (this.getParent() instanceof WXListComponent || this.getParent() instanceof WXBaseScroller) && ((BaseBounceView)((Object)this.getParent().getHostView())).getSwipeLayout().isRefreshing()) {
            ((BaseBounceView)((Object)this.getParent().getHostView())).finishPullLoad();
            ((BaseBounceView)((Object)this.getParent().getHostView())).onLoadmoreComplete();
        }
    }
}

