/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_scroller.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DCWXScrollView
extends ScrollView
implements Handler.Callback,
IWXScroller,
WXGestureObservable,
NestedScrollingChild {
    private NestedScrollingChildHelper childHelper;
    private float ox;
    private float oy;
    private int[] consumed = new int[2];
    private int[] offsetInWindow = new int[2];
    int mScrollX;
    int mScrollY;
    private WXGesture wxGesture;
    private List<WXScrollViewListener> mScrollViewListeners;
    private DCWXScroller mWAScroller;
    private View mCurrentStickyView;
    private boolean mRedirectTouchToStickyView;
    private int mStickyOffset;
    private boolean mHasNotDoneActionDown = true;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mScrollerTask;
    private int mInitialPosition;
    private int mCheckTime = 100;
    private int[] mStickyP = new int[2];
    private Rect mScrollRect;
    private int[] stickyScrollerP = new int[2];
    private int[] stickyViewP = new int[2];
    private boolean scrollable = true;
    private Field scroller = null;
    private boolean isTouch = false;
    private boolean isExecScrollerTask = false;
    private float decelerationRate = 1.0f;
    private boolean shouldBeTriggerUpper = true;
    private boolean shouldBeTriggerLower = true;
    private float upper = 50.0f;
    private float lowwer = 50.0f;

    public DCWXScrollView(Context context) {
        super(context);
        this.mScrollViewListeners = new ArrayList<WXScrollViewListener>();
        this.init();
        try {
            WXReflectionUtils.setValue(this, "mMinimumVelocity", 5);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXScrollView] WXScrollView: ", e);
        }
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setOverScrollMode(2);
        this.childHelper = new NestedScrollingChildHelper((View)this);
        this.childHelper.setNestedScrollingEnabled(true);
        try {
            this.scroller = ScrollView.class.getDeclaredField("mScroller");
            this.scroller.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopScroll() {
        if (this.scroller != null && !this.isTouch) {
            try {
                Class<?> clazz = this.scroller.getType();
                Method method = clazz.getMethod("abortAnimation", new Class[0]);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke(this.scroller.get(this), new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startScrollerTask() {
        if (this.isExecScrollerTask) {
            return;
        }
        this.isExecScrollerTask = true;
        if (this.mScrollerTask == null) {
            this.mScrollerTask = new Handler(WXThread.secure(this));
        }
        this.mInitialPosition = this.getScrollY();
        this.mScrollerTask.sendEmptyMessageDelayed(0, (long)this.mCheckTime);
    }

    public DCWXScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DCWXScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
    }

    public void addScrollViewListener(WXScrollViewListener scrollViewListener) {
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
        }
    }

    public void removeScrollViewListener(WXScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isScrollable()) {
            return false;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mRedirectTouchToStickyView = true;
        }
        if (this.mRedirectTouchToStickyView) {
            boolean bl = this.mRedirectTouchToStickyView = this.mCurrentStickyView != null;
            if (this.mRedirectTouchToStickyView) {
                boolean bl2 = this.mRedirectTouchToStickyView = ev.getY() <= (float)this.mCurrentStickyView.getHeight() && ev.getX() >= (float)this.mCurrentStickyView.getLeft() && ev.getX() <= (float)this.mCurrentStickyView.getRight();
            }
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                this.mScrollRect = new Rect();
                this.getGlobalVisibleRect(this.mScrollRect);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            ev.offsetLocation(0.0f, (float)(this.stickyViewP[1] - this.mScrollRect.top));
        }
        boolean result = super.dispatchTouchEvent(ev);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, ev);
        }
        return result;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mCurrentStickyView != null) {
            canvas.save();
            this.mCurrentStickyView.getLocationOnScreen(this.mStickyP);
            int realOffset = this.mStickyOffset <= 0 ? this.mStickyOffset : 0;
            canvas.translate((float)this.mStickyP[0], (float)(this.getScrollY() + realOffset));
            canvas.clipRect(0, realOffset, this.mCurrentStickyView.getWidth(), this.mCurrentStickyView.getHeight());
            this.mCurrentStickyView.draw(canvas);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.scrollable) {
            return true;
        }
        switch (ev.getAction()) {
            case 0: {
                this.isTouch = true;
                break;
            }
            case 1: 
            case 3: {
                this.isTouch = false;
            }
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                this.mScrollRect = new Rect();
                this.getGlobalVisibleRect(this.mScrollRect);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            ev.offsetLocation(0.0f, (float)(-(this.stickyViewP[1] - this.mScrollRect.top)));
        }
        if (ev.getAction() == 0) {
            this.mHasNotDoneActionDown = false;
        }
        if (this.mHasNotDoneActionDown) {
            MotionEvent down = MotionEvent.obtain((MotionEvent)ev);
            down.setAction(0);
            this.mHasNotDoneActionDown = false;
            down.recycle();
        }
        if (ev.getAction() == 0) {
            this.ox = ev.getX();
            this.oy = ev.getY();
            this.startNestedScroll(3);
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.isExecScrollerTask = false;
            this.mHasNotDoneActionDown = true;
            this.stopNestedScroll();
        }
        if (ev.getAction() == 2 && 19 >= Build.VERSION.SDK_INT) {
            float clampedY;
            int dy;
            float clampedX = ev.getX();
            int dx = (int)(this.ox - clampedX);
            if (this.dispatchNestedPreScroll(dx, dy = (int)(this.oy - (clampedY = ev.getY())), this.consumed, this.offsetInWindow)) {
                ev.setLocation(clampedX + (float)this.consumed[0], clampedY + (float)this.consumed[1]);
            }
            this.ox = ev.getX();
            this.oy = ev.getY();
        }
        return super.onTouchEvent(ev);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.childHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.childHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.childHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.childHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.childHelper.hasNestedScrollingParent();
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.childHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.childHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.childHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.childHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public void setRate(float picker) {
        this.decelerationRate = picker;
    }

    public void fling(int velocityY) {
        super.fling((int)((float)velocityY * this.decelerationRate));
        if (this.mScrollerTask != null) {
            this.mScrollerTask.removeMessages(0);
        }
        this.startScrollerTask();
    }

    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        AppEventForBlurManager.onScrollChanged((int)x, (int)y);
        this.startScrollerTask();
        this.mScrollX = this.getScrollX();
        this.mScrollY = this.getScrollY();
        this.onScroll(this, this.mScrollX, this.mScrollY);
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view == null) {
            return;
        }
        int d = view.getBottom();
        if ((float)(d -= this.getHeight() + this.mScrollY) <= this.lowwer && !this.shouldBeTriggerLower) {
            this.shouldBeTriggerLower = true;
            this.onScrollToBottom(this.mScrollX, this.mScrollY);
        } else if ((float)d > this.lowwer) {
            this.shouldBeTriggerLower = false;
        }
        if ((float)this.getScrollY() <= this.upper && !this.shouldBeTriggerUpper) {
            this.shouldBeTriggerUpper = true;
            this.onScrollToTop(this.mScrollX, this.mScrollY);
        } else if ((float)this.getScrollY() > this.upper) {
            this.shouldBeTriggerUpper = false;
        }
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollChanged(this, x, y, oldx - x, oldy - y);
        }
        this.showStickyView();
    }

    public void setUpperLength(float length) {
        this.upper = length;
    }

    public void setLowwerLength(float length) {
        this.lowwer = length;
    }

    protected void onScroll(DCWXScrollView scrollView, int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScroll(this, x, y);
        }
    }

    protected void onScrollToBottom(int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollToBottom(this, x, y);
        }
    }

    protected void onScrollToTop(int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollToTop(this, x, y);
        }
    }

    private void showStickyView() {
        if (this.mWAScroller == null) {
            return;
        }
        View curStickyView = this.procSticky(this.mWAScroller.getStickMap());
        this.mCurrentStickyView = curStickyView != null ? curStickyView : null;
    }

    private View procSticky(Map<String, Map<String, WXComponent>> mStickyMap) {
        if (mStickyMap == null) {
            return null;
        }
        Map<String, WXComponent> stickyMap = mStickyMap.get(this.mWAScroller.getRef());
        if (stickyMap == null) {
            return null;
        }
        Iterator<Map.Entry<String, WXComponent>> iterator = stickyMap.entrySet().iterator();
        Map.Entry<String, WXComponent> entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            WXComponent stickyData = entry.getValue();
            this.getLocationOnScreen(this.stickyScrollerP);
            stickyData.getHostView().getLocationOnScreen(this.stickyViewP);
            int parentH = 0;
            if (stickyData.getParent() != null && stickyData.getParent().getRealView() != null) {
                parentH = stickyData.getParent().getRealView().getHeight();
            }
            int stickyViewH = stickyData.getHostView().getHeight();
            int stickyShowPos = this.stickyScrollerP[1];
            int stickyStartHidePos = -parentH + this.stickyScrollerP[1] + stickyViewH;
            if (this.stickyViewP[1] <= stickyShowPos && this.stickyViewP[1] >= stickyStartHidePos - stickyViewH) {
                this.mStickyOffset = this.stickyViewP[1] - stickyStartHidePos;
                stickyData.setStickyOffset(this.stickyViewP[1] - this.stickyScrollerP[1]);
                return stickyData.getHostView();
            }
            stickyData.setStickyOffset(0);
        }
        return null;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                int newPosition;
                if (this.mScrollerTask != null) {
                    this.mScrollerTask.removeMessages(0);
                }
                if (this.mInitialPosition - (newPosition = this.getScrollY()) == 0) {
                    this.isExecScrollerTask = false;
                    this.onScrollStopped(this, this.getScrollX(), this.getScrollY());
                    break;
                }
                this.onScroll(this, this.getScrollX(), this.getScrollY());
                this.mInitialPosition = this.getScrollY();
                if (this.mScrollerTask == null) break;
                this.mScrollerTask.sendEmptyMessageDelayed(0, (long)this.mCheckTime);
                break;
            }
        }
        return true;
    }

    protected void onScrollStopped(DCWXScrollView scrollView, int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollStopped(this, x, y);
        }
    }

    @Override
    public void destroy() {
        this.mScrollViewListeners.clear();
        if (this.mScrollerTask != null) {
            this.mScrollerTask.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public Rect getContentFrame() {
        return new Rect(0, 0, this.computeHorizontalScrollRange(), this.computeVerticalScrollRange());
    }

    public void setWAScroller(DCWXScroller mWAScroller) {
        this.mWAScroller = mWAScroller;
        this.upper = WXViewUtils.getRealPxByWidth(50.0f, this.mWAScroller.getViewPortWidth());
        this.lowwer = WXViewUtils.getRealPxByWidth(50.0f, this.mWAScroller.getViewPortWidth());
    }

    public static interface WXScrollViewListener {
        public void onScrollChanged(DCWXScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollToBottom(DCWXScrollView var1, int var2, int var3);

        public void onScrollToTop(DCWXScrollView var1, int var2, int var3);

        public void onScrollStopped(DCWXScrollView var1, int var2, int var3);

        public void onScroll(DCWXScrollView var1, int var2, int var3);
    }
}

