/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.internal.Euler;
import com.alibaba.android.bindingx.core.internal.Quaternion;
import com.alibaba.android.bindingx.core.internal.Vector3;

class OrientationEvaluator {
    private Quaternion quaternion = new Quaternion(0.0, 0.0, 0.0, 1.0);
    private Double constraintAlpha = null;
    private Double constraintBeta = null;
    private Double constraintGamma = null;
    private double constraintAlphaOffset = 0.0;
    private double constraintBetaOffset = 0.0;
    private double constraintGammaOffset = 0.0;
    private final Vector3 ZEE = new Vector3(0.0, 0.0, 1.0);
    private final Euler EULER = new Euler();
    private final Quaternion Q0 = new Quaternion();
    private final Quaternion Q1 = new Quaternion(-Math.sqrt(0.5), 0.0, 0.0, Math.sqrt(0.5));

    OrientationEvaluator(@Nullable Double constraintAlpha, @Nullable Double constraintBeta, @Nullable Double constraintGamma) {
        this.constraintAlpha = constraintAlpha;
        this.constraintBeta = constraintBeta;
        this.constraintGamma = constraintGamma;
    }

    Quaternion calculate(double deviceAlpha, double deviceBeta, double deviceGamma, double normalizedAlpha) {
        double alpha = Math.toRadians(this.constraintAlpha != null ? this.constraintAlpha : normalizedAlpha + this.constraintAlphaOffset);
        double beta = Math.toRadians(this.constraintBeta != null ? this.constraintBeta : deviceBeta + this.constraintBetaOffset);
        double gamma = Math.toRadians(this.constraintGamma != null ? this.constraintGamma : deviceGamma + this.constraintGammaOffset);
        this.setObjectQuaternion(this.quaternion, alpha, beta, gamma, 0.0);
        return this.quaternion;
    }

    private void setObjectQuaternion(Quaternion quaternion, double alpha, double beta, double gamma, double orient) {
        this.EULER.setValue(beta, alpha, -gamma, "YXZ");
        quaternion.setFromEuler(this.EULER);
        quaternion.multiply(this.Q1);
        quaternion.multiply(this.Q0.setFromAxisAngle(this.ZEE, -orient));
    }
}

