/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.widget.EditText;
import com.vanniktech.emoji.OnlyEmojisInputFilter;
import java.util.ArrayList;
import java.util.Arrays;

public final class SingleEmojiTrait
implements TextWatcher {
    final EditText editText;

    public static void install(EditText editText) {
        new SingleEmojiTrait(editText);
    }

    private SingleEmojiTrait(EditText editText) {
        this.editText = editText;
        ArrayList<InputFilter> filters = new ArrayList<InputFilter>(Arrays.asList(editText.getFilters()));
        filters.add(new OnlyEmojisInputFilter());
        editText.setFilters(filters.toArray(new InputFilter[0]));
        editText.addTextChangedListener((TextWatcher)this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.editText.removeTextChangedListener((TextWatcher)this);
        CharSequence emoji = s.subSequence(start, start + count);
        this.editText.setText(null);
        this.editText.append(emoji);
        this.editText.addTextChangedListener((TextWatcher)this);
    }

    public void afterTextChanged(Editable s) {
    }
}

