/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.JavaI420Buffer;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.RefCountDelegate;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.YuvHelper;
import java.nio.ByteBuffer;

public class JavaRGBABuffer
implements VideoFrame.Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer data;
    private final RefCountDelegate refCountDelegate;

    public static JavaRGBABuffer wrapFromI420(VideoFrame.I420Buffer i420Buffer) {
        int width = i420Buffer.getWidth();
        int height = i420Buffer.getHeight();
        int dataLength = width * height * 4;
        final ByteBuffer data = JniCommon.nativeAllocateByteBuffer(dataLength);
        data.clear();
        YuvHelper.I420ToRGBA(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), data, width, height);
        data.position(0);
        data.limit(dataLength);
        return new JavaRGBABuffer(width, height, data.slice(), new Runnable(){

            @Override
            public void run() {
                JniCommon.nativeFreeByteBuffer(data);
            }
        });
    }

    public static JavaRGBABuffer wrapFromData(int width, int height, byte[] data) {
        final ByteBuffer dataBuf = JniCommon.nativeAllocateByteBuffer(width * height * 4);
        dataBuf.put(data);
        return new JavaRGBABuffer(width, height, dataBuf, new Runnable(){

            @Override
            public void run() {
                JniCommon.nativeFreeByteBuffer(dataBuf);
            }
        });
    }

    public JavaRGBABuffer(int width, int height, ByteBuffer data, Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(this.width, this.height);
        YuvHelper.RGBAToI420(this.data, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), this.width, this.height);
        return javaI420Buffer;
    }

    public byte[] getData() {
        byte[] dataArray = new byte[this.width * this.height * 4];
        this.data.get(dataArray);
        this.data.flip();
        return dataArray;
    }

    public ByteBuffer getBufData() {
        return this.data;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        return null;
    }
}

