/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.utils;

import android.content.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class Utils {
    public static String bytes2hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        for (byte b : bytes) {
            tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = "0" + tmp + " ";
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static <T> List<T> distinct(Collection<T> datas) {
        if (datas == null) {
            return new ArrayList();
        }
        TreeSet<T> set = new TreeSet<T>(datas);
        return new ArrayList<T>(set);
    }

    public static String getMidMusicSourcePath(Context context) {
        String musicSource = Utils.getCacheDir(context, "ms");
        return musicSource + File.separator + "dysf.sf2";
    }

    public static String getCacheDir(Context context, String directory) {
        try {
            File file = new File(context.getExternalCacheDir() + File.separator + directory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String fileDir = file.getAbsolutePath();
            return fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }
}

