/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.core.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.AbstractEventHandler;
import com.alibaba.android.bindingx.core.internal.ExpressionPair;
import com.alibaba.android.bindingx.core.internal.JSMath;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BindingXTouchHandler
extends AbstractEventHandler
implements View.OnTouchListener,
GestureDetector.OnGestureListener {
    private float mDownX;
    private float mDownY;
    private double mDx;
    private double mDy;
    private GestureDetector mGestureDetector;
    private boolean isPanGestureAvailable;
    private boolean isFlickGestureAvailable;
    private long downTimeMillis = 0L;
    private float downX = 0.0f;
    private float downY = 0.0f;
    private float upX = 0.0f;
    private float upY = 0.0f;
    private int touchTime = 0;
    private int movetime = 0;

    public BindingXTouchHandler(Context context, PlatformManager manager, Object ... extension) {
        super(context, manager, extension);
        Handler handler = new Handler(Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper());
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this, handler);
    }

    void setPanGestureAvailable(boolean available) {
        this.isPanGestureAvailable = available;
    }

    void setFlickGestureAvailable(boolean available) {
        this.isFlickGestureAvailable = available;
    }

    boolean isPanGestureAvailable() {
        return this.isPanGestureAvailable;
    }

    boolean isFlickGestureAvailable() {
        return this.isFlickGestureAvailable;
    }

    public boolean onTouch(View v, MotionEvent event) {
        try {
            switch (event.getActionMasked()) {
                case 0: {
                    this.mDownX = event.getRawX();
                    this.mDownY = event.getRawY();
                    this.fireEventByState("start", 0.0, 0.0, new Object[0]);
                    this.downTimeMillis = System.currentTimeMillis();
                    this.downX = event.getRawX();
                    this.downY = event.getRawY();
                    break;
                }
                case 2: {
                    if (this.mDownX == 0.0f && this.mDownY == 0.0f) {
                        this.mDownX = event.getRawX();
                        this.mDownY = event.getRawY();
                        this.fireEventByState("start", 0.0, 0.0, new Object[0]);
                        break;
                    }
                    this.mDx = event.getRawX() - this.mDownX;
                    this.mDy = event.getRawY() - this.mDownY;
                    break;
                }
                case 1: {
                    this.mDownX = 0.0f;
                    this.mDownY = 0.0f;
                    this.upX = event.getRawX();
                    this.upY = event.getRawY();
                    this.clearExpressions();
                    this.fireEventByState("end", this.mDx, this.mDy, new Object[0]);
                    this.mDx = 0.0;
                    this.mDy = 0.0;
                    break;
                }
                case 3: {
                    this.mDownX = 0.0f;
                    this.mDownY = 0.0f;
                    this.clearExpressions();
                    this.fireEventByState("cancel", this.mDx, this.mDy, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error ", e);
        }
        return this.mGestureDetector.onTouchEvent(event);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float downY;
        float downX;
        ++this.movetime;
        if (!this.isPanGestureAvailable) {
            LogProxy.d("pan gesture is not enabled");
            return false;
        }
        if (e1 == null) {
            downX = this.mDownX;
            downY = this.mDownY;
        } else {
            downX = e1.getRawX();
            downY = e1.getRawY();
        }
        if (e2 == null) {
            return false;
        }
        float curX = e2.getRawX();
        float curY = e2.getRawY();
        float deltaX = curX - downX;
        float deltaY = curY - downY;
        try {
            if (LogProxy.sEnableLog) {
                LogProxy.d(String.format(Locale.getDefault(), "[TouchHandler] pan moved. (x:%f,y:%f)", Float.valueOf(deltaX), Float.valueOf(deltaY)));
            }
            JSMath.applyXYToScope(this.mScope, deltaX, deltaY, this.mPlatformManager.getResolutionTranslator());
            if (!this.evaluateExitExpression(this.mExitExpressionPair, this.mScope)) {
                this.consumeExpression(this.mExpressionHoldersMap, this.mScope, "pan");
            }
        }
        catch (Exception e) {
            LogProxy.e("runtime error", e);
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.isFlickGestureAvailable) {
            return false;
        }
        return false;
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    @Override
    public boolean onCreate(@NonNull String sourceRef, @NonNull String eventType) {
        String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
        View sourceView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
        if (sourceView == null) {
            LogProxy.e("[ExpressionTouchHandler] onCreate failed. sourceView not found:" + sourceRef);
            return false;
        }
        this.movetime = 0;
        sourceView.setOnTouchListener((View.OnTouchListener)this);
        try {
            Method m = sourceView.getClass().getDeclaredMethod("addPan", Object.class);
            if (m != null) {
                m.setAccessible(true);
                m.invoke((Object)sourceView, this);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        LogProxy.d("[ExpressionTouchHandler] onCreate success. {source:" + sourceRef + ",type:" + eventType + "}");
        return true;
    }

    @Override
    public void onStart(@NonNull String sourceRef, @NonNull String eventType) {
        switch (eventType) {
            case "pan": {
                this.setPanGestureAvailable(true);
                break;
            }
            case "flick": {
                this.setFlickGestureAvailable(true);
            }
        }
    }

    @Override
    public void onBindExpression(@NonNull String eventType, @Nullable Map<String, Object> globalConfig, @Nullable ExpressionPair exitExpressionPair, @NonNull List<Map<String, Object>> expressionArgs, @Nullable BindingXCore.JavaScriptCallback callback) {
        super.onBindExpression(eventType, globalConfig, exitExpressionPair, expressionArgs, callback);
    }

    @Override
    public boolean onDisable(@NonNull String sourceRef, @NonNull String eventType) {
        switch (eventType) {
            case "pan": {
                this.setPanGestureAvailable(false);
                break;
            }
            case "flick": {
                this.setFlickGestureAvailable(false);
            }
        }
        if (!this.isPanGestureAvailable() && !this.isFlickGestureAvailable()) {
            String instanceId = TextUtils.isEmpty((CharSequence)this.mAnchorInstanceId) ? this.mInstanceId : this.mAnchorInstanceId;
            View hostView = this.mPlatformManager.getViewFinder().findViewBy(sourceRef, instanceId);
            if (hostView != null) {
                hostView.setOnTouchListener(null);
                this.movetime = 0;
                try {
                    Method m = hostView.getClass().getDeclaredMethod("removePan", new Class[0]);
                    if (m != null) {
                        m.setAccessible(true);
                        m.invoke((Object)hostView, new Object[0]);
                    }
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
            LogProxy.d("remove touch listener success.[" + sourceRef + "," + eventType + "]");
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mExpressionHoldersMap != null) {
            this.mExpressionHoldersMap.clear();
            this.mExpressionHoldersMap = null;
        }
        this.mExitExpressionPair = null;
        this.mCallback = null;
        this.isFlickGestureAvailable = false;
        this.isPanGestureAvailable = false;
    }

    @Override
    protected void onExit(@NonNull Map<String, Object> scope) {
        double deltaX = (Double)scope.get("internal_x");
        double deltaY = (Double)scope.get("internal_y");
        this.fireEventByState("exit", deltaX, deltaY, new Object[0]);
    }

    @Override
    protected void onUserIntercept(String interceptorName, @NonNull Map<String, Object> scope) {
        double deltaX = (Double)scope.get("internal_x");
        double deltaY = (Double)scope.get("internal_y");
        this.fireEventByState("interceptor", deltaX, deltaY, Collections.singletonMap("interceptor", interceptorName));
    }

    private void fireEventByState(String state, double dx, double dy, Object ... extension) {
        if (this.mCallback != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("state", state);
            double x = this.mPlatformManager.getResolutionTranslator().nativeToWeb(dx, new Object[0]);
            double y = this.mPlatformManager.getResolutionTranslator().nativeToWeb(dy, new Object[0]);
            param.put("deltaX", x);
            param.put("deltaY", y);
            param.put("token", this.mToken);
            if (extension != null && extension.length > 0 && extension[0] instanceof Map) {
                param.putAll((Map)extension[0]);
            }
            this.mCallback.callback(param);
            LogProxy.d(">>>>>>>>>>>fire event:(" + state + "," + x + "," + y + ")");
        }
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }
}

