/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.jinmingyunle.midiplaylib.midifile.MidiFile;
import com.jinmingyunle.midiplaylib.midifile.MidiNote;
import com.jinmingyunle.midiplaylib.midifile.MidiOptions;
import com.jinmingyunle.midiplaylib.midifile.MidiPlayer;
import com.jinmingyunle.midiplaylib.midifile.MidiTrack;
import java.util.ArrayList;

public class Piano
extends SurfaceView
implements SurfaceHolder.Callback {
    public static final int KeysPerOctave = 7;
    public static final int MaxOctave = 6;
    private static int WhiteKeyWidth;
    private static int WhiteKeyHeight;
    private static int BlackKeyWidth;
    private static int BlackKeyHeight;
    private static int margin;
    private static int BlackBorder;
    private static int[] blackKeyOffsets;
    private int gray1;
    private int gray2;
    private int gray3;
    private int shade1;
    private int shade2;
    private boolean useTwoColors;
    private ArrayList<MidiNote> notes;
    private int maxShadeDuration;
    private int showNoteLetters;
    private Paint paint;
    private boolean surfaceReady;
    private Bitmap bufferBitmap;
    private Canvas bufferCanvas;
    private MidiPlayer player;

    public Piano(Context context) {
        super(context);
        WhiteKeyWidth = 0;
        blackKeyOffsets = null;
        this.paint = new Paint();
        this.paint.setAntiAlias(false);
        this.paint.setTextSize(9.0f);
        this.gray1 = Color.rgb((int)16, (int)16, (int)16);
        this.gray2 = Color.rgb((int)90, (int)90, (int)90);
        this.gray3 = Color.rgb((int)200, (int)200, (int)200);
        this.shade1 = Color.rgb((int)210, (int)205, (int)220);
        this.shade2 = Color.rgb((int)150, (int)200, (int)220);
        this.showNoteLetters = 0;
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
    }

    public Piano(Context context, AttributeSet attrs) {
        super(context, attrs);
        WhiteKeyWidth = 0;
        blackKeyOffsets = null;
        this.paint = new Paint();
        this.paint.setTextSize(10.0f);
        this.paint.setAntiAlias(false);
        this.gray1 = Color.rgb((int)16, (int)16, (int)16);
        this.gray2 = Color.rgb((int)90, (int)90, (int)90);
        this.gray3 = Color.rgb((int)200, (int)200, (int)200);
        this.shade1 = Color.rgb((int)210, (int)205, (int)220);
        this.shade2 = Color.rgb((int)150, (int)200, (int)220);
        this.showNoteLetters = 0;
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
    }

    public static Point getPreferredSize(int screenwidth, int screenheight) {
        int keywidth = (int)((double)screenwidth / 44.0);
        if (keywidth % 2 != 0) {
            --keywidth;
        }
        int margin = 0;
        int border = keywidth / 2;
        Point result = new Point();
        result.x = margin * 2 + border * 2 + keywidth * 7 * 6;
        result.y = margin * 2 + border * 3 + WhiteKeyHeight;
        return result;
    }

    protected void onMeasure(int widthspec, int heightspec) {
        int screenwidth = View.MeasureSpec.getSize((int)widthspec);
        int screenheight = View.MeasureSpec.getSize((int)heightspec);
        WhiteKeyWidth = (int)((double)screenwidth / 44.0);
        if (WhiteKeyWidth % 2 != 0) {
            --WhiteKeyWidth;
        }
        margin = 0;
        BlackBorder = WhiteKeyWidth / 2;
        WhiteKeyHeight = WhiteKeyWidth * 5;
        BlackKeyWidth = WhiteKeyWidth / 2;
        BlackKeyHeight = WhiteKeyHeight * 5 / 9;
        blackKeyOffsets = new int[]{WhiteKeyWidth - BlackKeyWidth / 2 - 1, WhiteKeyWidth + BlackKeyWidth / 2 - 1, 2 * WhiteKeyWidth - BlackKeyWidth / 2, 2 * WhiteKeyWidth + BlackKeyWidth / 2, 4 * WhiteKeyWidth - BlackKeyWidth / 2 - 1, 4 * WhiteKeyWidth + BlackKeyWidth / 2 - 1, 5 * WhiteKeyWidth - BlackKeyWidth / 2, 5 * WhiteKeyWidth + BlackKeyWidth / 2, 6 * WhiteKeyWidth - BlackKeyWidth / 2, 6 * WhiteKeyWidth + BlackKeyWidth / 2};
        int width = margin * 2 + BlackBorder * 2 + WhiteKeyWidth * 7 * 6;
        int height = margin * 2 + BlackBorder * 3 + WhiteKeyHeight;
        this.setMeasuredDimension(width, height);
        this.bufferBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.bufferCanvas = new Canvas(this.bufferBitmap);
        this.invalidate();
        this.draw();
    }

    protected void onSizeChanged(int newwidth, int newheight, int oldwidth, int oldheight) {
        super.onSizeChanged(newwidth, newheight, oldwidth, oldheight);
    }

    public void SetMidiFile(MidiFile midifile, MidiOptions options, MidiPlayer player) {
        if (midifile == null) {
            this.notes = null;
            this.useTwoColors = false;
            return;
        }
        this.player = player;
        ArrayList<MidiTrack> tracks = midifile.ChangeMidiNotes(options);
        MidiTrack track = MidiFile.CombineToSingleTrack(tracks);
        this.notes = track.getNotes();
        this.maxShadeDuration = midifile.getTime().getQuarter() * 2;
        for (int tracknum = 0; tracknum < tracks.size(); ++tracknum) {
            for (MidiNote note : tracks.get(tracknum).getNotes()) {
                note.setChannel(tracknum);
            }
        }
        this.useTwoColors = false;
        if (tracks.size() == 2) {
            this.useTwoColors = true;
        }
        this.showNoteLetters = options.showNoteLetters;
        this.invalidate();
    }

    public void SetShadeColors(int c1, int c2) {
        this.shade1 = c1;
        this.shade2 = c2;
    }

    private void DrawOctaveOutline(Canvas canvas) {
        int i;
        int right = WhiteKeyWidth * 7;
        this.paint.setColor(this.gray1);
        canvas.drawLine(0.0f, 0.0f, 0.0f, (float)WhiteKeyHeight, this.paint);
        canvas.drawLine((float)right, 0.0f, (float)right, (float)WhiteKeyHeight, this.paint);
        canvas.drawLine(0.0f, (float)WhiteKeyHeight, (float)right, (float)WhiteKeyHeight, this.paint);
        this.paint.setColor(this.gray3);
        canvas.drawLine((float)(right - 1), 0.0f, (float)(right - 1), (float)WhiteKeyHeight, this.paint);
        canvas.drawLine(1.0f, 0.0f, 1.0f, (float)WhiteKeyHeight, this.paint);
        this.paint.setColor(this.gray1);
        canvas.drawLine((float)(3 * WhiteKeyWidth), 0.0f, (float)(3 * WhiteKeyWidth), (float)WhiteKeyHeight, this.paint);
        this.paint.setColor(this.gray3);
        canvas.drawLine((float)(3 * WhiteKeyWidth - 1), 0.0f, (float)(3 * WhiteKeyWidth - 1), (float)WhiteKeyHeight, this.paint);
        canvas.drawLine((float)(3 * WhiteKeyWidth + 1), 0.0f, (float)(3 * WhiteKeyWidth + 1), (float)WhiteKeyHeight, this.paint);
        for (i = 0; i < 10; i += 2) {
            int x1 = blackKeyOffsets[i];
            int x2 = blackKeyOffsets[i + 1];
            this.paint.setColor(this.gray1);
            canvas.drawLine((float)x1, 0.0f, (float)x1, (float)BlackKeyHeight, this.paint);
            canvas.drawLine((float)x2, 0.0f, (float)x2, (float)BlackKeyHeight, this.paint);
            canvas.drawLine((float)x1, (float)BlackKeyHeight, (float)x2, (float)BlackKeyHeight, this.paint);
            this.paint.setColor(this.gray2);
            canvas.drawLine((float)(x1 - 1), 0.0f, (float)(x1 - 1), (float)(BlackKeyHeight + 1), this.paint);
            canvas.drawLine((float)(x2 + 1), 0.0f, (float)(x2 + 1), (float)(BlackKeyHeight + 1), this.paint);
            canvas.drawLine((float)(x1 - 1), (float)(BlackKeyHeight + 1), (float)(x2 + 1), (float)(BlackKeyHeight + 1), this.paint);
            this.paint.setColor(this.gray3);
            canvas.drawLine((float)(x1 - 2), 0.0f, (float)(x1 - 2), (float)(BlackKeyHeight + 2), this.paint);
            canvas.drawLine((float)(x2 + 2), 0.0f, (float)(x2 + 2), (float)(BlackKeyHeight + 2), this.paint);
            canvas.drawLine((float)(x1 - 2), (float)(BlackKeyHeight + 2), (float)(x2 + 2), (float)(BlackKeyHeight + 2), this.paint);
        }
        for (i = 1; i < 7; ++i) {
            if (i == 3) continue;
            this.paint.setColor(this.gray1);
            canvas.drawLine((float)(i * WhiteKeyWidth), (float)BlackKeyHeight, (float)(i * WhiteKeyWidth), (float)WhiteKeyHeight, this.paint);
            this.paint.setColor(this.gray2);
            canvas.drawLine((float)(i * WhiteKeyWidth - 1), (float)(BlackKeyHeight + 1), (float)(i * WhiteKeyWidth - 1), (float)WhiteKeyHeight, this.paint);
            this.paint.setColor(this.gray3);
            canvas.drawLine((float)(i * WhiteKeyWidth + 1), (float)(BlackKeyHeight + 1), (float)(i * WhiteKeyWidth + 1), (float)WhiteKeyHeight, this.paint);
        }
    }

    private void DrawOutline(Canvas canvas) {
        for (int octave = 0; octave < 6; ++octave) {
            canvas.translate((float)(octave * WhiteKeyWidth * 7), 0.0f);
            this.DrawOctaveOutline(canvas);
            canvas.translate((float)(-(octave * WhiteKeyWidth * 7)), 0.0f);
        }
    }

    private void DrawBlackKeys(Canvas canvas) {
        this.paint.setStyle(Paint.Style.FILL);
        for (int octave = 0; octave < 6; ++octave) {
            canvas.translate((float)(octave * WhiteKeyWidth * 7), 0.0f);
            for (int i = 0; i < 10; i += 2) {
                int x1 = blackKeyOffsets[i];
                int x2 = blackKeyOffsets[i + 1];
                this.paint.setColor(this.gray1);
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + BlackKeyWidth), (float)BlackKeyHeight, this.paint);
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
            }
            canvas.translate((float)(-(octave * WhiteKeyWidth * 7)), 0.0f);
        }
        this.paint.setStyle(Paint.Style.STROKE);
    }

    private void DrawBlackBorder(Canvas canvas) {
        int PianoWidth = WhiteKeyWidth * 7 * 6;
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.gray1);
        canvas.drawRect((float)margin, (float)margin, (float)(margin + PianoWidth + BlackBorder * 2), (float)(margin + BlackBorder - 2), this.paint);
        canvas.drawRect((float)margin, (float)margin, (float)(margin + BlackBorder), (float)(margin + WhiteKeyHeight + BlackBorder * 3), this.paint);
        canvas.drawRect((float)margin, (float)(margin + BlackBorder + WhiteKeyHeight), (float)(margin + BlackBorder * 2 + PianoWidth), (float)(margin + BlackBorder + WhiteKeyHeight + BlackBorder * 2), this.paint);
        canvas.drawRect((float)(margin + BlackBorder + PianoWidth), (float)margin, (float)(margin + BlackBorder + PianoWidth + BlackBorder), (float)(margin + WhiteKeyHeight + BlackBorder * 3), this.paint);
        this.paint.setColor(this.gray2);
        canvas.drawLine((float)(margin + BlackBorder), (float)(margin + BlackBorder - 1), (float)(margin + BlackBorder + PianoWidth), (float)(margin + BlackBorder - 1), this.paint);
        canvas.translate((float)(margin + BlackBorder), (float)(margin + BlackBorder));
        for (int i = 0; i < 42; ++i) {
            canvas.drawRect((float)(i * WhiteKeyWidth + 1), (float)(WhiteKeyHeight + 2), (float)(i * WhiteKeyWidth + 1 + WhiteKeyWidth - 2), (float)(WhiteKeyHeight + 2 + BlackBorder / 2), this.paint);
        }
        canvas.translate((float)(-(margin + BlackBorder)), (float)(-(margin + BlackBorder)));
    }

    private void DrawNoteLetters(Canvas canvas) {
        String[] names;
        String[] letters = new String[]{"C", "D", "E", "F", "G", "A", "B"};
        String[] numbers = new String[]{"1", "3", "5", "6", "8", "10", "12"};
        if (this.showNoteLetters == 1) {
            names = letters;
        } else if (this.showNoteLetters == 4) {
            names = numbers;
        } else {
            return;
        }
        canvas.translate((float)(margin + BlackBorder), (float)(margin + BlackBorder));
        this.paint.setColor(-1);
        for (int octave = 0; octave < 6; ++octave) {
            for (int i = 0; i < 7; ++i) {
                canvas.drawText(names[i], (float)((octave * 7 + i) * WhiteKeyWidth + WhiteKeyWidth / 3), (float)(WhiteKeyHeight + BlackBorder + 4), this.paint);
            }
        }
        canvas.translate((float)(-(margin + BlackBorder)), (float)(-(margin + BlackBorder)));
        this.paint.setColor(-16777216);
    }

    void draw() {
        if (!this.surfaceReady) {
            return;
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas = holder.lockCanvas();
        if (canvas == null) {
            return;
        }
        this.onDraw(canvas);
        holder.unlockCanvasAndPost(canvas);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.surfaceReady || this.bufferBitmap == null) {
            return;
        }
        if (WhiteKeyWidth == 0) {
            return;
        }
        this.paint.setAntiAlias(false);
        this.bufferCanvas.translate((float)(margin + BlackBorder), (float)(margin + BlackBorder));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-1);
        this.bufferCanvas.drawRect(0.0f, 0.0f, (float)(0 + WhiteKeyWidth * 7 * 6), (float)WhiteKeyHeight, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.gray1);
        this.DrawBlackKeys(this.bufferCanvas);
        this.DrawOutline(this.bufferCanvas);
        this.bufferCanvas.translate((float)(-(margin + BlackBorder)), (float)(-(margin + BlackBorder)));
        this.DrawBlackBorder(this.bufferCanvas);
        canvas.drawBitmap(this.bufferBitmap, 0.0f, 0.0f, this.paint);
        if (this.showNoteLetters != 0) {
            this.DrawNoteLetters(canvas);
        }
    }

    private void ShadeOneNote(Canvas canvas, int notenumber, int color) {
        int octave = notenumber / 12;
        int notescale = notenumber % 12;
        if ((octave -= 2) < 0 || octave >= 6) {
            return;
        }
        this.paint.setColor(color);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.translate((float)(octave * WhiteKeyWidth * 7), 0.0f);
        int bottomHalfHeight = WhiteKeyHeight - (BlackKeyHeight + 3);
        switch (notescale) {
            case 0: {
                int x1 = 2;
                int x2 = blackKeyOffsets[0] - 2;
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + x2 - x1), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 1: {
                int x1 = blackKeyOffsets[0];
                int x2 = blackKeyOffsets[1];
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + x2 - x1), (float)(0 + BlackKeyHeight), this.paint);
                if (color != this.gray1) break;
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
                break;
            }
            case 2: {
                int x1 = WhiteKeyWidth + 2;
                int x2 = blackKeyOffsets[1] + 3;
                int x3 = blackKeyOffsets[2] - 2;
                canvas.drawRect((float)x2, 0.0f, (float)(x2 + x3 - x2), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 3: {
                int x1 = blackKeyOffsets[2];
                int x2 = blackKeyOffsets[3];
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + BlackKeyWidth), (float)(0 + BlackKeyHeight), this.paint);
                if (color != this.gray1) break;
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
                break;
            }
            case 4: {
                int x1 = WhiteKeyWidth * 2 + 2;
                int x2 = blackKeyOffsets[3] + 3;
                int x3 = WhiteKeyWidth * 3 - 1;
                canvas.drawRect((float)x2, 0.0f, (float)(x2 + x3 - x2), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 5: {
                int x1 = WhiteKeyWidth * 3 + 2;
                int x2 = blackKeyOffsets[4] - 2;
                int x3 = WhiteKeyWidth * 4 - 2;
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + x2 - x1), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 6: {
                int x1 = blackKeyOffsets[4];
                int x2 = blackKeyOffsets[5];
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + BlackKeyWidth), (float)(0 + BlackKeyHeight), this.paint);
                if (color != this.gray1) break;
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
                break;
            }
            case 7: {
                int x1 = WhiteKeyWidth * 4 + 2;
                int x2 = blackKeyOffsets[5] + 3;
                int x3 = blackKeyOffsets[6] - 2;
                canvas.drawRect((float)x2, 0.0f, (float)(x2 + x3 - x2), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 8: {
                int x1 = blackKeyOffsets[6];
                int x2 = blackKeyOffsets[7];
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + BlackKeyWidth), (float)(0 + BlackKeyHeight), this.paint);
                if (color != this.gray1) break;
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
                break;
            }
            case 9: {
                int x1 = WhiteKeyWidth * 5 + 2;
                int x2 = blackKeyOffsets[7] + 3;
                int x3 = blackKeyOffsets[8] - 2;
                canvas.drawRect((float)x2, 0.0f, (float)(x2 + x3 - x2), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
            case 10: {
                int x1 = blackKeyOffsets[8];
                int x2 = blackKeyOffsets[9];
                canvas.drawRect((float)x1, 0.0f, (float)(x1 + BlackKeyWidth), (float)(0 + BlackKeyHeight), this.paint);
                if (color != this.gray1) break;
                this.paint.setColor(this.gray2);
                canvas.drawRect((float)(x1 + 1), (float)(BlackKeyHeight - BlackKeyHeight / 8), (float)(x1 + 1 + BlackKeyWidth - 2), (float)(BlackKeyHeight - BlackKeyHeight / 8 + BlackKeyHeight / 8), this.paint);
                break;
            }
            case 11: {
                int x1 = WhiteKeyWidth * 6 + 2;
                int x2 = blackKeyOffsets[9] + 3;
                int x3 = WhiteKeyWidth * 7 - 1;
                canvas.drawRect((float)x2, 0.0f, (float)(x2 + x3 - x2), (float)(0 + BlackKeyHeight + 3), this.paint);
                canvas.drawRect((float)x1, (float)(BlackKeyHeight + 3), (float)(x1 + WhiteKeyWidth - 3), (float)(BlackKeyHeight + 3 + bottomHalfHeight), this.paint);
                break;
            }
        }
        canvas.translate((float)(-(octave * WhiteKeyWidth * 7)), 0.0f);
    }

    private int FindClosestStartTime(int pulseTime) {
        int left = 0;
        int right = this.notes.size() - 1;
        while (right - left > 1) {
            int i = (right + left) / 2;
            if (this.notes.get(left).getStartTime() == pulseTime) break;
            if (this.notes.get(i).getStartTime() <= pulseTime) {
                left = i;
                continue;
            }
            right = i;
        }
        while (left >= 1 && this.notes.get(left - 1).getStartTime() == this.notes.get(left).getStartTime()) {
            --left;
        }
        return left;
    }

    private int NextStartTimeSameTrack(int i) {
        int start = this.notes.get(i).getStartTime();
        int end = this.notes.get(i).getEndTime();
        int track = this.notes.get(i).getChannel();
        while (i < this.notes.size()) {
            if (this.notes.get(i).getChannel() != track) {
                ++i;
                continue;
            }
            if (this.notes.get(i).getStartTime() > start) {
                return this.notes.get(i).getStartTime();
            }
            end = Math.max(end, this.notes.get(i).getEndTime());
            ++i;
        }
        return end;
    }

    private int NextStartTime(int i) {
        int start = this.notes.get(i).getStartTime();
        int end = this.notes.get(i).getEndTime();
        while (i < this.notes.size()) {
            if (this.notes.get(i).getStartTime() > start) {
                return this.notes.get(i).getStartTime();
            }
            end = Math.max(end, this.notes.get(i).getEndTime());
            ++i;
        }
        return end;
    }

    public void ShadeNotes(int currentPulseTime, int prevPulseTime) {
        int lastShadedIndex;
        if (this.notes == null || this.notes.size() == 0 || !this.surfaceReady || this.bufferBitmap == null) {
            return;
        }
        SurfaceHolder holder = this.getHolder();
        Canvas canvas = holder.lockCanvas();
        if (canvas == null) {
            return;
        }
        this.bufferCanvas.translate((float)(margin + BlackBorder), (float)(margin + BlackBorder));
        for (int i = lastShadedIndex = this.FindClosestStartTime(prevPulseTime - this.maxShadeDuration * 2); i < this.notes.size(); ++i) {
            int start = this.notes.get(i).getStartTime();
            int end = this.notes.get(i).getEndTime();
            int notenumber = this.notes.get(i).getNumber();
            int nextStart = this.NextStartTime(i);
            int nextStartTrack = this.NextStartTimeSameTrack(i);
            end = Math.max(end, nextStartTrack);
            end = Math.min(end, start + this.maxShadeDuration - 1);
            if (start > prevPulseTime && start > currentPulseTime || start <= currentPulseTime && currentPulseTime < nextStart && currentPulseTime < end && start <= prevPulseTime && prevPulseTime < nextStart && prevPulseTime < end) break;
            if (start <= currentPulseTime && currentPulseTime < end) {
                if (this.useTwoColors) {
                    if (this.notes.get(i).getChannel() == 1) {
                        this.ShadeOneNote(this.bufferCanvas, notenumber, this.shade2);
                        continue;
                    }
                    this.ShadeOneNote(this.bufferCanvas, notenumber, this.shade1);
                    continue;
                }
                this.ShadeOneNote(this.bufferCanvas, notenumber, this.shade1);
                continue;
            }
            if (start > prevPulseTime || prevPulseTime >= end) continue;
            int num = notenumber % 12;
            if (num == 1 || num == 3 || num == 6 || num == 8 || num == 10) {
                this.ShadeOneNote(this.bufferCanvas, notenumber, this.gray1);
                continue;
            }
            this.ShadeOneNote(this.bufferCanvas, notenumber, -1);
        }
        this.bufferCanvas.translate((float)(-(margin + BlackBorder)), (float)(-(margin + BlackBorder)));
        canvas.drawBitmap(this.bufferBitmap, 0.0f, 0.0f, this.paint);
        holder.unlockCanvasAndPost(canvas);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.draw();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.surfaceReady = true;
        this.draw();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceReady = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 0 && this.player != null) {
            this.player.Pause();
        }
        return super.onTouchEvent(event);
    }
}

