/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.auth;

import android.util.Log;
import com.ksyun.ks3.model.transfer.RequestProgressListener;
import cz.msebera.android.httpclient.entity.BasicHttpEntity;
import cz.msebera.android.httpclient.entity.InputStreamEntity;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private IOException originalException;
    private RequestProgressListener progressLisener;
    private long contentLength;

    public RepeatableInputStreamRequestEntity(InputStream content, String length) {
        this.setChunked(false);
        long contentLength = -1L;
        try {
            String contentLengthString = length;
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.inputStreamRequestEntity = new InputStreamEntity(content, contentLength);
        this.inputStreamRequestEntity.setContentType(this.contentType);
        this.content = content;
        this.contentLength = contentLength;
        this.setContent(content);
        this.setContentType(this.contentType);
        this.setContentLength(contentLength);
    }

    public void setProgressLisener(RequestProgressListener progressLisener) {
        this.progressLisener = progressLisener;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            if (this.progressLisener != null) {
                this.inputStreamRequestEntity.writeTo(output instanceof CountingOutputStream ? output : new CountingOutputStream(output, this.contentLength, this.progressLisener));
            } else {
                this.inputStreamRequestEntity.writeTo(output);
            }
        }
        catch (IOException ioe) {
            if (this.originalException == null) {
                this.originalException = ioe;
            }
            throw this.originalException;
        }
        finally {
            this.progressLisener = null;
            this.content.close();
            output.close();
        }
    }

    protected void finalize() throws Throwable {
        Log.d((String)"RepeatableInputStreamRequestEntity", (String)("RepeatableInputStreamRequestEntity finalize:" + this));
        super.finalize();
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final RequestProgressListener listener;
        private long uploaded;
        private long length;

        protected void finalize() throws Throwable {
            Log.d((String)"CountingOutputStream", (String)("CountingOutputStream finalize:" + this));
            super.finalize();
        }

        CountingOutputStream(OutputStream out, long length, RequestProgressListener listener) {
            super(out);
            this.listener = listener;
            this.length = length;
            this.uploaded = 0L;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.uploaded += (long)len;
            if (this.length > 0L) {
                double progress = this.length > 0L ? (double)this.uploaded * 1.0 / (double)this.length * 100.0 : -1.0;
                this.listener.onTaskProgress(progress);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.uploaded;
            if (this.length > 0L) {
                double progress = this.length > 0L ? (double)this.uploaded * 1.0 / (double)this.length * 100.0 : -1.0;
                this.listener.onTaskProgress(progress);
            }
        }
    }
}

