/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.daasuu.mp4compose.FillMode;
import com.daasuu.mp4compose.FillModeCustomItem;
import com.daasuu.mp4compose.Rotation;
import com.daasuu.mp4compose.VideoFormatMimeType;
import com.daasuu.mp4compose.composer.Mp4ComposerEngine;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.logger.AndroidLogger;
import com.daasuu.mp4compose.logger.Logger;
import com.daasuu.mp4compose.source.DataSource;
import com.daasuu.mp4compose.source.FileDescriptorDataSource;
import com.daasuu.mp4compose.source.FilePathDataSource;
import com.daasuu.mp4compose.source.UriDataSource;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Mp4Composer {
    private static final String TAG = Mp4Composer.class.getSimpleName();
    private final DataSource srcDataSource;
    private final String destPath;
    private FileDescriptor destFileDescriptor;
    private GlFilter filter;
    private Size outputResolution;
    private int bitrate = -1;
    private boolean mute = false;
    private Rotation rotation = Rotation.NORMAL;
    private Listener listener;
    private FillMode fillMode = FillMode.PRESERVE_ASPECT_FIT;
    private FillModeCustomItem fillModeCustomItem;
    private float timeScale = 1.0f;
    private boolean isPitchChanged = false;
    private boolean flipVertical = false;
    private boolean flipHorizontal = false;
    private long trimStartMs = 0L;
    private long trimEndMs = -1L;
    private VideoFormatMimeType videoFormatMimeType = VideoFormatMimeType.AUTO;
    private EGLContext shareContext;
    private ExecutorService executorService;
    private Mp4ComposerEngine engine;
    private Logger logger;
    private DataSource.Listener errorDataSource = new DataSource.Listener(){

        @Override
        public void onError(Exception e) {
            Mp4Composer.this.notifyListenerOfFailureAndShutdown(e);
        }
    };

    public Mp4Composer(@NonNull String srcPath, @NonNull String destPath) {
        this(srcPath, destPath, new AndroidLogger());
    }

    public Mp4Composer(@NonNull String srcPath, @NonNull String destPath, @NonNull Logger logger) {
        this.logger = logger;
        this.srcDataSource = new FilePathDataSource(srcPath, logger, this.errorDataSource);
        this.destPath = destPath;
    }

    public Mp4Composer(@NonNull FileDescriptor srcFileDescriptor, @NonNull String destPath) {
        this.srcDataSource = new FileDescriptorDataSource(srcFileDescriptor);
        this.destPath = destPath;
    }

    public Mp4Composer(@NonNull Uri srcUri, @NonNull String destPath, @NonNull Context context) {
        this(srcUri, destPath, context, (Logger)new AndroidLogger());
    }

    public Mp4Composer(@NonNull Uri srcUri, @NonNull String destPath, @NonNull Context context, @NonNull Logger logger) {
        this.logger = logger;
        this.srcDataSource = new UriDataSource(srcUri, context, logger, this.errorDataSource);
        this.destPath = destPath;
    }

    @TargetApi(value=26)
    public Mp4Composer(@NonNull FileDescriptor srcFileDescriptor, @NonNull FileDescriptor destFileDescriptor) {
        if (Build.VERSION.SDK_INT < 26) {
            throw new IllegalArgumentException("destFileDescriptor can not use");
        }
        this.srcDataSource = new FileDescriptorDataSource(srcFileDescriptor);
        this.destPath = null;
        this.destFileDescriptor = destFileDescriptor;
    }

    @TargetApi(value=26)
    public Mp4Composer(@NonNull Uri srcUri, @NonNull FileDescriptor destFileDescriptor, @NonNull Context context) {
        this(srcUri, destFileDescriptor, context, (Logger)new AndroidLogger());
    }

    @TargetApi(value=26)
    public Mp4Composer(@NonNull Uri srcUri, @NonNull FileDescriptor destFileDescriptor, @NonNull Context context, @NonNull Logger logger) {
        if (Build.VERSION.SDK_INT < 26) {
            throw new IllegalArgumentException("destFileDescriptor can not use");
        }
        this.logger = logger;
        this.srcDataSource = new UriDataSource(srcUri, context, logger, this.errorDataSource);
        this.destPath = null;
        this.destFileDescriptor = destFileDescriptor;
    }

    public Mp4Composer filter(@NonNull GlFilter filter) {
        this.filter = filter;
        return this;
    }

    public Mp4Composer size(int width, int height) {
        this.outputResolution = new Size(width, height);
        return this;
    }

    public Mp4Composer videoBitrate(int bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public Mp4Composer mute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public Mp4Composer flipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
        return this;
    }

    public Mp4Composer flipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
        return this;
    }

    public Mp4Composer rotation(@NonNull Rotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public Mp4Composer fillMode(@NonNull FillMode fillMode) {
        this.fillMode = fillMode;
        return this;
    }

    public Mp4Composer customFillMode(@NonNull FillModeCustomItem fillModeCustomItem) {
        this.fillModeCustomItem = fillModeCustomItem;
        this.fillMode = FillMode.CUSTOM;
        return this;
    }

    public Mp4Composer listener(@NonNull Listener listener) {
        this.listener = listener;
        return this;
    }

    public Mp4Composer timeScale(float timeScale) {
        this.timeScale = timeScale;
        return this;
    }

    public Mp4Composer changePitch(boolean isPitchChanged) {
        this.isPitchChanged = isPitchChanged;
        return this;
    }

    public Mp4Composer videoFormatMimeType(@NonNull VideoFormatMimeType videoFormatMimeType) {
        this.videoFormatMimeType = videoFormatMimeType;
        return this;
    }

    public Mp4Composer logger(@NonNull Logger logger) {
        this.logger = logger;
        return this;
    }

    public Mp4Composer trim(long trimStartMs, long trimEndMs) {
        this.trimStartMs = trimStartMs;
        this.trimEndMs = trimEndMs;
        return this;
    }

    public Mp4Composer shareContext(@NonNull EGLContext shareContext) {
        this.shareContext = shareContext;
        return this;
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        return this.executorService;
    }

    public void startCurrentThread() {
        if (this.engine != null) {
            return;
        }
        if (this.logger == null) {
            this.logger = new AndroidLogger();
        }
        this.engine = new Mp4ComposerEngine(this.logger);
        this.engine.setProgressCallback(new Mp4ComposerEngine.ProgressCallback(){

            @Override
            public void onProgress(double progress) {
                if (Mp4Composer.this.listener != null) {
                    Mp4Composer.this.listener.onProgress(progress);
                }
            }

            @Override
            public void onCurrentWrittenVideoTime(long timeUs) {
                if (Mp4Composer.this.listener != null) {
                    Mp4Composer.this.listener.onCurrentWrittenVideoTime(timeUs);
                }
            }
        });
        Integer videoRotate = this.getVideoRotation(this.srcDataSource);
        Size srcVideoResolution = this.getVideoResolution(this.srcDataSource);
        if (srcVideoResolution == null || videoRotate == null) {
            this.notifyListenerOfFailureAndShutdown(new UnsupportedOperationException("File type unsupported, path: " + this.srcDataSource));
            return;
        }
        if (this.filter == null) {
            this.filter = new GlFilter();
        }
        if (this.fillMode == null) {
            this.fillMode = FillMode.PRESERVE_ASPECT_FIT;
        }
        if (this.fillMode == FillMode.CUSTOM && this.fillModeCustomItem == null) {
            this.notifyListenerOfFailureAndShutdown(new IllegalAccessException("FillMode.CUSTOM must need fillModeCustomItem."));
            return;
        }
        if (this.fillModeCustomItem != null) {
            this.fillMode = FillMode.CUSTOM;
        }
        if (this.outputResolution == null) {
            Rotation rotate;
            this.outputResolution = this.fillMode == FillMode.CUSTOM ? srcVideoResolution : ((rotate = Rotation.fromInt(this.rotation.getRotation() + videoRotate)) == Rotation.ROTATION_90 || rotate == Rotation.ROTATION_270 ? new Size(srcVideoResolution.getHeight(), srcVideoResolution.getWidth()) : srcVideoResolution);
        }
        if (this.timeScale < 0.125f) {
            this.timeScale = 0.125f;
        } else if (this.timeScale > 8.0f) {
            this.timeScale = 8.0f;
        }
        if (this.shareContext == null) {
            this.shareContext = EGL14.EGL_NO_CONTEXT;
        }
        this.logger.debug(TAG, "rotation = " + (this.rotation.getRotation() + videoRotate));
        this.logger.debug(TAG, "rotation = " + (Object)((Object)Rotation.fromInt(this.rotation.getRotation() + videoRotate)));
        this.logger.debug(TAG, "inputResolution width = " + srcVideoResolution.getWidth() + " height = " + srcVideoResolution.getHeight());
        this.logger.debug(TAG, "outputResolution width = " + this.outputResolution.getWidth() + " height = " + this.outputResolution.getHeight());
        this.logger.debug(TAG, "fillMode = " + (Object)((Object)this.fillMode));
        try {
            if (this.bitrate < 0) {
                this.bitrate = this.calcBitRate(this.outputResolution.getWidth(), this.outputResolution.getHeight());
            }
            this.engine.compose(this.srcDataSource, this.destPath, this.destFileDescriptor, this.outputResolution, this.filter, this.bitrate, this.mute, Rotation.fromInt(this.rotation.getRotation() + videoRotate), srcVideoResolution, this.fillMode, this.fillModeCustomItem, this.timeScale, this.isPitchChanged, this.flipVertical, this.flipHorizontal, this.trimStartMs, this.trimEndMs, this.videoFormatMimeType, this.shareContext);
        }
        catch (Exception e) {
            if (e instanceof MediaCodec.CodecException) {
                this.logger.error(TAG, "This devicel cannot codec with that setting. Check width, height, bitrate and video format.", e);
                this.notifyListenerOfFailureAndShutdown(e);
                return;
            }
            this.logger.error(TAG, "Unable to compose the engine", e);
            this.notifyListenerOfFailureAndShutdown(e);
            return;
        }
        if (this.listener != null) {
            if (this.engine.isCanceled()) {
                this.listener.onCanceled();
            } else {
                this.listener.onCompleted();
            }
        }
        this.engine = null;
    }

    public Mp4Composer start() {
        if (this.engine != null) {
            return this;
        }
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (Mp4Composer.this.logger == null) {
                    Mp4Composer.this.logger = new AndroidLogger();
                }
                Mp4Composer.this.engine = new Mp4ComposerEngine(Mp4Composer.this.logger);
                Mp4Composer.this.engine.setProgressCallback(new Mp4ComposerEngine.ProgressCallback(){

                    @Override
                    public void onProgress(double progress) {
                        if (Mp4Composer.this.listener != null) {
                            Mp4Composer.this.listener.onProgress(progress);
                        }
                    }

                    @Override
                    public void onCurrentWrittenVideoTime(long timeUs) {
                        if (Mp4Composer.this.listener != null) {
                            Mp4Composer.this.listener.onCurrentWrittenVideoTime(timeUs);
                        }
                    }
                });
                Integer videoRotate = Mp4Composer.this.getVideoRotation(Mp4Composer.this.srcDataSource);
                Size srcVideoResolution = Mp4Composer.this.getVideoResolution(Mp4Composer.this.srcDataSource);
                if (srcVideoResolution == null || videoRotate == null) {
                    Mp4Composer.this.notifyListenerOfFailureAndShutdown(new UnsupportedOperationException("File type unsupported, path: " + Mp4Composer.this.srcDataSource));
                    return;
                }
                if (Mp4Composer.this.filter == null) {
                    Mp4Composer.this.filter = new GlFilter();
                }
                if (Mp4Composer.this.fillMode == null) {
                    Mp4Composer.this.fillMode = FillMode.PRESERVE_ASPECT_FIT;
                }
                if (Mp4Composer.this.fillMode == FillMode.CUSTOM && Mp4Composer.this.fillModeCustomItem == null) {
                    Mp4Composer.this.notifyListenerOfFailureAndShutdown(new IllegalAccessException("FillMode.CUSTOM must need fillModeCustomItem."));
                    return;
                }
                if (Mp4Composer.this.fillModeCustomItem != null) {
                    Mp4Composer.this.fillMode = FillMode.CUSTOM;
                }
                if (Mp4Composer.this.outputResolution == null) {
                    if (Mp4Composer.this.fillMode == FillMode.CUSTOM) {
                        Mp4Composer.this.outputResolution = srcVideoResolution;
                    } else {
                        Rotation rotate = Rotation.fromInt(Mp4Composer.this.rotation.getRotation() + videoRotate);
                        if (rotate == Rotation.ROTATION_90 || rotate == Rotation.ROTATION_270) {
                            Mp4Composer.this.outputResolution = new Size(srcVideoResolution.getHeight(), srcVideoResolution.getWidth());
                        } else {
                            Mp4Composer.this.outputResolution = srcVideoResolution;
                        }
                    }
                }
                if (Mp4Composer.this.timeScale < 0.125f) {
                    Mp4Composer.this.timeScale = 0.125f;
                } else if (Mp4Composer.this.timeScale > 8.0f) {
                    Mp4Composer.this.timeScale = 8.0f;
                }
                if (Mp4Composer.this.shareContext == null) {
                    Mp4Composer.this.shareContext = EGL14.EGL_NO_CONTEXT;
                }
                Mp4Composer.this.logger.debug(TAG, "rotation = " + (Mp4Composer.this.rotation.getRotation() + videoRotate));
                Mp4Composer.this.logger.debug(TAG, "rotation = " + (Object)((Object)Rotation.fromInt(Mp4Composer.this.rotation.getRotation() + videoRotate)));
                Mp4Composer.this.logger.debug(TAG, "inputResolution width = " + srcVideoResolution.getWidth() + " height = " + srcVideoResolution.getHeight());
                Mp4Composer.this.logger.debug(TAG, "outputResolution width = " + Mp4Composer.this.outputResolution.getWidth() + " height = " + Mp4Composer.this.outputResolution.getHeight());
                Mp4Composer.this.logger.debug(TAG, "fillMode = " + (Object)((Object)Mp4Composer.this.fillMode));
                try {
                    if (Mp4Composer.this.bitrate < 0) {
                        Mp4Composer.this.bitrate = Mp4Composer.this.calcBitRate(Mp4Composer.this.outputResolution.getWidth(), Mp4Composer.this.outputResolution.getHeight());
                    }
                    Mp4Composer.this.engine.compose(Mp4Composer.this.srcDataSource, Mp4Composer.this.destPath, Mp4Composer.this.destFileDescriptor, Mp4Composer.this.outputResolution, Mp4Composer.this.filter, Mp4Composer.this.bitrate, Mp4Composer.this.mute, Rotation.fromInt(Mp4Composer.this.rotation.getRotation() + videoRotate), srcVideoResolution, Mp4Composer.this.fillMode, Mp4Composer.this.fillModeCustomItem, Mp4Composer.this.timeScale, Mp4Composer.this.isPitchChanged, Mp4Composer.this.flipVertical, Mp4Composer.this.flipHorizontal, Mp4Composer.this.trimStartMs, Mp4Composer.this.trimEndMs, Mp4Composer.this.videoFormatMimeType, Mp4Composer.this.shareContext);
                }
                catch (Exception e) {
                    if (e instanceof MediaCodec.CodecException) {
                        Mp4Composer.this.logger.error(TAG, "This devicel cannot codec with that setting. Check width, height, bitrate and video format.", e);
                        Mp4Composer.this.notifyListenerOfFailureAndShutdown(e);
                        return;
                    }
                    Mp4Composer.this.logger.error(TAG, "Unable to compose the engine", e);
                    Mp4Composer.this.notifyListenerOfFailureAndShutdown(e);
                    return;
                }
                if (Mp4Composer.this.listener != null) {
                    if (Mp4Composer.this.engine.isCanceled()) {
                        Mp4Composer.this.listener.onCanceled();
                    } else {
                        Mp4Composer.this.listener.onCompleted();
                    }
                }
                Mp4Composer.this.executorService.shutdown();
                Mp4Composer.this.engine = null;
            }
        });
        return this;
    }

    private void notifyListenerOfFailureAndShutdown(Exception failure) {
        if (this.listener != null) {
            this.listener.onFailed(failure);
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public void cancel() {
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getVideoRotation(DataSource dataSource) {
        MediaMetadataRetriever mediaMetadataRetriever = null;
        try {
            mediaMetadataRetriever = new MediaMetadataRetriever();
            mediaMetadataRetriever.setDataSource(dataSource.getFileDescriptor());
            String orientation = mediaMetadataRetriever.extractMetadata(24);
            if (orientation == null) {
                Integer n = null;
                return n;
            }
            Integer n = Integer.valueOf(orientation);
            return n;
        }
        catch (IllegalArgumentException e) {
            this.logger.error("MediaMetadataRetriever", "getVideoRotation IllegalArgumentException", e);
            Integer n = 0;
            return n;
        }
        catch (RuntimeException e) {
            this.logger.error("MediaMetadataRetriever", "getVideoRotation RuntimeException", e);
            Integer n = 0;
            return n;
        }
        catch (Exception e) {
            this.logger.error("MediaMetadataRetriever", "getVideoRotation Exception", e);
            Integer n = 0;
            return n;
        }
        finally {
            try {
                if (mediaMetadataRetriever != null) {
                    mediaMetadataRetriever.release();
                }
            }
            catch (RuntimeException e) {
                this.logger.error(TAG, "Failed to release mediaMetadataRetriever.", e);
            }
        }
    }

    private int calcBitRate(int width, int height) {
        int bitrate = (int)(7.5 * (double)width * (double)height);
        this.logger.debug(TAG, "bitrate=" + bitrate);
        return bitrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Size getVideoResolution(DataSource dataSource) {
        Size size;
        MediaMetadataRetriever retriever = null;
        try {
            retriever = new MediaMetadataRetriever();
            retriever.setDataSource(dataSource.getFileDescriptor());
            String rawWidth = retriever.extractMetadata(18);
            String rawHeight = retriever.extractMetadata(19);
            if (rawWidth == null || rawHeight == null) {
                Size size2 = null;
                return size2;
            }
            int width = Integer.parseInt(rawWidth);
            int height = Integer.parseInt(rawHeight);
            Size size3 = new Size(width, height);
            return size3;
        }
        catch (IllegalArgumentException e) {
            this.logger.error("MediaMetadataRetriever", "getVideoResolution IllegalArgumentException", e);
            size = null;
            return size;
        }
        catch (RuntimeException e) {
            this.logger.error("MediaMetadataRetriever", "getVideoResolution RuntimeException", e);
            size = null;
            return size;
        }
        catch (Exception e) {
            this.logger.error("MediaMetadataRetriever", "getVideoResolution Exception", e);
            size = null;
            return size;
        }
        finally {
            try {
                if (retriever != null) {
                    retriever.release();
                }
            }
            catch (RuntimeException e) {
                this.logger.error(TAG, "Failed to release mediaMetadataRetriever.", e);
            }
        }
    }

    public static interface Listener {
        public void onProgress(double var1);

        public void onCurrentWrittenVideoTime(long var1);

        public void onCompleted();

        public void onCanceled();

        public void onFailed(Exception var1);
    }
}

