/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.processor;

import android.content.Context;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.mode.CallBackResult;
import com.heytap.mcssdk.processor.Processor;
import com.heytap.mcssdk.utils.LogUtil;
import com.heytap.mcssdk.utils.ThreadUtil;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.callback.IDataMessageCallBackService;
import com.heytap.msp.push.callback.IGetAppNotificationCallBackService;
import com.heytap.msp.push.callback.ISetAppNotificationCallBackService;
import com.heytap.msp.push.mode.BaseMode;

public class CallBackResultProcessor
implements Processor {
    @Override
    public void process(Context context, BaseMode baseMode, IDataMessageCallBackService IDataMessageCallBackService2) {
        if (null == baseMode) {
            return;
        }
        if (baseMode.getType() == 4105) {
            final CallBackResult callBackResult = (CallBackResult)baseMode;
            LogUtil.d("mcssdk-CallBackResultProcessor:" + callBackResult.toString());
            ThreadUtil.executeOnUiThread(new Runnable(){

                @Override
                public void run() {
                    CallBackResultProcessor.this.processCallBackResult(callBackResult, PushService.getInstance());
                }
            });
        }
    }

    private void processCallBackResult(CallBackResult message, PushService pushService) {
        if (message == null) {
            LogUtil.e("message is null , please check param of parseCommandMessage(2)");
            return;
        }
        if (pushService == null) {
            LogUtil.e("pushService is null , please check param of parseCommandMessage(2)");
            return;
        }
        if (pushService.getPushCallback() == null) {
            LogUtil.e("pushService.getPushCallback() is null , please check param of parseCommandMessage(2)");
            return;
        }
        switch (message.getCommand()) {
            case 12289: {
                if (0 == message.getResponseCode()) {
                    pushService.setRegisterID(message.getContent());
                }
                pushService.getPushCallback().onRegister(message.getResponseCode(), message.getContent());
                break;
            }
            case 12290: {
                pushService.getPushCallback().onUnRegister(message.getResponseCode());
                break;
            }
            case 12306: {
                pushService.getPushCallback().onGetPushStatus(message.getResponseCode(), Utils.parseInt(message.getContent()));
                break;
            }
            case 12298: {
                pushService.getPushCallback().onSetPushTime(message.getResponseCode(), message.getContent());
                break;
            }
            case 12309: {
                pushService.getPushCallback().onGetNotificationStatus(message.getResponseCode(), Utils.parseInt(message.getContent()));
                break;
            }
            case 12318: {
                int appConfigNotificationSwitch = 0;
                try {
                    appConfigNotificationSwitch = Integer.parseInt(message.getContent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IGetAppNotificationCallBackService getCallBackService = pushService.getPushGetAppNotificationCallBack();
                if (getCallBackService == null) break;
                getCallBackService.onGetAppNotificationSwitch(message.getResponseCode(), appConfigNotificationSwitch);
                break;
            }
            case 12316: 
            case 12317: {
                ISetAppNotificationCallBackService setCallBackService = pushService.getPushSetAppNotificationCallBack();
                if (setCallBackService == null) break;
                setCallBackService.onSetAppNotificationSwitch(message.getResponseCode());
                break;
            }
            case 12287: {
                ICallBackResultService errorCallBack = pushService.getPushCallback();
                if (errorCallBack == null) break;
                errorCallBack.onError(message.getResponseCode(), message.getContent());
            }
        }
    }
}

