/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_text;

import android.text.Html;
import android.text.Spannable;
import android.text.Spanned;
import android.text.style.AlignmentSpan;
import androidx.annotation.NonNull;
import com.taobao.weex.dom.TextDecorationSpan;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.layout.measurefunc.TextContentBoxMeasurement;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXViewUtils;

public class DCTextContentBoxMeasurement
extends TextContentBoxMeasurement {
    private String space = "";
    private boolean decode = false;

    public DCTextContentBoxMeasurement(WXComponent component) {
        super(component);
    }

    @Override
    public void layoutBefore() {
        WXAttr attr2 = this.mComponent.getAttrs();
        this.space = (String)attr2.get("space");
        this.decode = Boolean.valueOf(attr2.containsKey("decode") ? attr2.get("decode").toString() : "false");
        super.layoutBefore();
    }

    @Override
    @NonNull
    protected Spanned createSpanned(String text) {
        if (this.space != null) {
            if (this.space.equals("ensp")) {
                text = text.replaceAll(" ", "&ensp;");
                text = Html.fromHtml((String)text).toString();
            } else if (this.space.equals("emsp")) {
                text = text.replaceAll(" ", "&emsp;");
                text = Html.fromHtml((String)text).toString();
            }
        }
        return super.createSpanned(text);
    }

    @Override
    protected void updateSpannable(Spannable spannable, int spanFlag) {
        if (this.mComponent == null || this.mComponent.getInstance() == null) {
            return;
        }
        int end = spannable.length();
        if (this.mFontSize == -1) {
            this.mTextPaint.setTextSize(WXViewUtils.getRealPxByWidth((float)this.mComponent.getInstance().getDefaultFontSize(), this.mComponent.getInstance().getInstanceViewPortWidthWithFloat()));
        } else {
            this.mTextPaint.setTextSize((float)this.mFontSize);
        }
        if (this.mLineHeight != -1) {
            this.setSpan(spannable, new WXLineHeightSpan(this.mLineHeight), 0, end, spanFlag);
        }
        this.setSpan(spannable, new AlignmentSpan.Standard(this.mAlignment), 0, end, spanFlag);
        if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
            this.setSpan(spannable, (Object)new WXCustomStyleSpan(this.mFontStyle, this.mFontWeight, this.mFontFamily), 0, end, spanFlag);
        }
        if (this.mIsColorSet) {
            this.mTextPaint.setColor(this.mColor);
        }
        if (this.mTextDecoration == WXTextDecoration.UNDERLINE || this.mTextDecoration == WXTextDecoration.LINETHROUGH) {
            this.setSpan(spannable, (Object)new TextDecorationSpan(this.mTextDecoration), 0, end, spanFlag);
        }
    }
}

