/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.web;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.airbnb.lottie.LottieAnimationView;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.base.BaseFragment;
import com.daya.orchestra.accompany.bean.MusicSaveParams;
import com.daya.orchestra.accompany.callback.ResultCallback;
import com.daya.orchestra.accompany.common.AccompanyError;
import com.daya.orchestra.accompany.common.AccompanyManager;
import com.daya.orchestra.accompany.common.Config;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.common.MidHelper;
import com.daya.orchestra.accompany.common.PermissionType;
import com.daya.orchestra.accompany.common.SocketStatus;
import com.daya.orchestra.accompany.common.WebConstants;
import com.daya.orchestra.accompany.databinding.AccFragmentAccompanyBinding;
import com.daya.orchestra.accompany.helper.AccompanyPlayHelper;
import com.daya.orchestra.accompany.helper.CacheHelper;
import com.daya.orchestra.accompany.helper.MusicTunerHelper;
import com.daya.orchestra.accompany.js.JsInterfaceAccomPanyUtils;
import com.daya.orchestra.accompany.receiver.HeadsetPlugListener;
import com.daya.orchestra.accompany.receiver.HeadsetPlugReceiver;
import com.daya.orchestra.accompany.recorder.AudioChunk;
import com.daya.orchestra.accompany.recorder.AudioRecordConfig;
import com.daya.orchestra.accompany.recorder.MsRecorder;
import com.daya.orchestra.accompany.recorder.PullTransport;
import com.daya.orchestra.accompany.recorder.Recorder;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.EncodeUtils;
import com.daya.orchestra.accompany.utils.EncryptUtils;
import com.daya.orchestra.accompany.utils.MyFileUtils;
import com.daya.orchestra.accompany.utils.ToastUtil;
import com.daya.orchestra.accompany.utils.Utils;
import com.daya.orchestra.accompany.websocket.JWebSocketClient;
import com.daya.orchestra.accompany.widget.CommonDialog;
import com.daya.orchestra.accompany.widget.LollipopFixedWebView;
import com.daya.orchestra.accompany.widget.ViewConvertListener;
import com.daya.orchestra.accompany.widget.ViewHolder;
import com.jinmingyunle.midiplaylib.MidiPlayerUtils;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.tbruyelle.rxpermissions3.RxPermissions;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import okhttp3.ResponseBody;
import org.java_websocket.enums.ReadyState;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccompanyFragment
extends BaseFragment<AccFragmentAccompanyBinding>
implements JsInterfaceAccomPanyUtils.onGetMethodsListener {
    private static final String TAG = "AccompanyFragmenttag";
    private static final int SDK_PAY_FLAG = 1;
    private static final int SDK_AUTH_FLAG = 2;
    public static final int SHARE_CHAT_REQUEST_CODE = 501;
    public static final int MESSAGE_TYPE_UPDATE_LOADING_START = 5010;
    public static final int MESSAGE_TYPE_UPDATE_LOADING = 5011;
    public static final int MESSAGE_TYPE_UPDATE_LOADING_COMPLETE = 5012;
    public static final int MESSAGE_TYPE_HIDE_LOADING = 5013;
    public static final int MESSAGE_TYPE_SEND_WEBSOCKET_HEARTBEAT = 5014;
    public static final int MESSAGE_WHAT_PLAY_MID_PROGRESS = 1;
    FrameLayout viewParent;
    WebView webView;
    private String url;
    private Recorder wavRecorder;
    private JWebSocketClient webSocketClient;
    private URI webSocketUri = URI.create("BuildConfig.BASE_STU_SOCKET_URL");
    private String mImageBase64;
    private MusicTunerHelper mMusicTunerHelper;
    private int currentProgressCount = 0;
    private boolean webSocketInitFlag = false;
    boolean isSendRecordStartTime = false;
    boolean isSendStartEvaluatingMessage = false;
    JSONObject msg = null;
    private Handler mLoadHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            if (msg.what == 5011) {
                AccompanyFragment.this.currentProgressCount++;
                if (AccompanyFragment.this.currentProgressCount <= 10) {
                    AccompanyFragment.this.updateProgress(4);
                } else if (AccompanyFragment.this.currentProgressCount <= 30) {
                    AccompanyFragment.this.updateProgress(2);
                } else {
                    AccompanyFragment.this.updateProgress(1);
                }
                AccompanyFragment.this.sendProgressMessage(5011, 1000);
                return;
            }
            if (msg.what == 5010) {
                AccompanyFragment.this.showLoadingAnim();
                AccompanyFragment.this.sendProgressMessage(5011, 1000);
                return;
            }
            if (msg.what == 5012) {
                AccompanyFragment.this.progressView.setProgress(100);
                AccompanyFragment.this.sendProgressMessage(5013, 300);
                return;
            }
            if (msg.what == 5013) {
                AccompanyFragment.this.hideLoadingAnim();
                return;
            }
            if (msg.what == 5014) {
                AccompanyFragment.this.sendWebSocketHeartbeat();
                return;
            }
            if (msg.what == 1) {
                AccompanyFragment.this.checkPrecess();
                AccompanyFragment.this.removePlayMidProgressMsg();
                AccompanyFragment.this.sendProgressMessage(1, AccompanyFragment.this.processInterval);
                return;
            }
        }
    };
    private AccompanyPlayHelper mPlayHelper;
    private HeadsetPlugReceiver mHeadsetPlugReceiver;
    private TextView tvLoadingTip;
    private LottieAnimationView viewLoadingAnim;
    private ProgressBar progressView;
    boolean isSoundCheckStartTime = false;
    private ValueCallback mUploadCallbackAboveL;
    private ActivityResultLauncher<Intent> imgSelectResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(){

        public void onActivityResult(ActivityResult result) {
            if (result.getResultCode() == -1 && result.getData() != null) {
                Intent data = result.getData();
                List selectList = PictureSelector.obtainMultipleResult((Intent)data);
                String avatar = null;
                if (selectList != null && selectList.size() > 0) {
                    avatar = ((LocalMedia)selectList.get(0)).getCompressPath();
                }
                if (avatar != null) {
                    AccompanyFragment.this.mUploadCallbackAboveL.onReceiveValue((Object)new Uri[]{PictureFileUtils.parUri((Context)AccompanyFragment.this.getContext(), (File)new File(avatar))});
                } else {
                    AccompanyFragment.this.mUploadCallbackAboveL.onReceiveValue((Object)new Uri[0]);
                }
                AccompanyFragment.this.mUploadCallbackAboveL = null;
            } else {
                AccompanyFragment.this.clearUploadMessage();
            }
        }
    });
    public onListener onAccompanyListener;
    public WebViewListener listener;
    private String midiFilePath = null;
    private int midiFileOriginalSpeed = 120;
    private int midiFileSpeed = 120;
    private long midiFileDuration = 0L;
    int processInterval = 16;
    private String midiSongId = null;
    private int hertz = 440;
    private SoundPool soundpool = new SoundPool(2, 3, 0);
    private boolean isReady = true;
    private CommonDialog preCountDialog;
    private ImageView iv1;
    private ImageView iv2;
    private ImageView iv3;
    private ImageView iv4;
    private ImageView iv5;
    private ImageView iv6;

    public static AccompanyFragment newInstance(String url, boolean isShowAnim) {
        AccompanyFragment fragment = new AccompanyFragment();
        Bundle args = new Bundle();
        args.putString("url", url);
        args.putBoolean("showLoadingAnim", isShowAnim);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected AccFragmentAccompanyBinding getLayoutView() {
        return AccFragmentAccompanyBinding.inflate(this.getLayoutInflater());
    }

    @Override
    protected void initView(View rootView) {
        this.viewParent = ((AccFragmentAccompanyBinding)this.mViewBinding).viewParent;
        if (this.getArguments() != null) {
            this.url = this.getArguments().getString("url");
        }
        String localUserId = CacheHelper.getUserId();
        this.webSocketUri = URI.create(WebConstants.getWebSocketUrl() + "/" + localUserId);
        ALOG.i("webSocketUri:" + this.webSocketUri);
        try {
            this.webView = Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 23 ? new LollipopFixedWebView((Context)this.getActivity()) : new WebView((Context)this.getActivity());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.webView) {
            return;
        }
        JsInterfaceAccomPanyUtils jsInterfaceUtils = new JsInterfaceAccomPanyUtils((Activity)this.getActivity());
        jsInterfaceUtils.setOnGetMethodsListener(this);
        this.webView.addJavascriptInterface((Object)jsInterfaceUtils, WebConstants.WEB_JS_INTERFACE);
        this.viewParent.addView((View)this.webView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.webView.setBackgroundColor(0);
        this.initWebView();
        this.webView.setWebViewClient((WebViewClient)new WebClient());
        this.webView.setWebChromeClient((WebChromeClient)new MyWebChromeClient());
        ALOG.i("accompany url:" + this.url);
        this.webView.loadUrl(this.url);
    }

    @Override
    protected void initData() {
        boolean isShowLoadingAnim;
        this.initLoadingStyle();
        Bundle arguments = this.getArguments();
        if (arguments != null && (isShowLoadingAnim = arguments.getBoolean("showLoadingAnim", false))) {
            this.sendProgressMessage(5010, 0);
        }
        this.mPlayHelper = new AccompanyPlayHelper(this.getContext(), this.webSocketClient, this.webView, (ViewGroup)((AccFragmentAccompanyBinding)this.mViewBinding).flDelayCheck, new AccompanyPlayHelper.OnEventListener(){

            @Override
            public SocketStatus getWebSocketStatus() {
                if (AccompanyFragment.this.webSocketClient == null) {
                    AccompanyFragment.this.startWebSocketClient(null);
                    return SocketStatus.CLOSED;
                }
                return AccompanyFragment.this.checkWebSocketStatus();
            }
        });
        ((AccFragmentAccompanyBinding)this.mViewBinding).ivLoadingBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AccompanyFragment.this.getActivity() != null) {
                    AccompanyFragment.this.getActivity().onBackPressed();
                }
            }
        });
        this.registReceiver();
        if (Constants.DEBUG) {
            ((AccFragmentAccompanyBinding)this.mViewBinding).btTest.setVisibility(0);
            ((AccFragmentAccompanyBinding)this.mViewBinding).btTest.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AccompanyFragment.this.closeWebSocket();
                }
            });
            ((AccFragmentAccompanyBinding)this.mViewBinding).btTest2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AccompanyFragment.this.startDelayCheck(null);
                }
            });
        }
    }

    private void initLoadingStyle() {
        int loadingLayoutRes;
        int loadingRes = Config.getInstance().getLoadingRes();
        int loadingBackIconRes = Config.getInstance().getLoadingBackIconRes();
        if (loadingBackIconRes != 0) {
            ((AccFragmentAccompanyBinding)this.mViewBinding).ivLoadingBack.setImageResource(loadingBackIconRes);
        }
        int n = loadingLayoutRes = loadingRes != 0 ? loadingRes : R.layout.acc_loading_layout;
        if (loadingLayoutRes != 0) {
            View loadingView = this.getLayoutInflater().inflate(loadingLayoutRes, (ViewGroup)((AccFragmentAccompanyBinding)this.mViewBinding).llLoading, false);
            this.tvLoadingTip = (TextView)loadingView.findViewById(R.id.tv_loading_tip);
            this.viewLoadingAnim = (LottieAnimationView)loadingView.findViewById(R.id.view_loading_anim);
            this.progressView = (ProgressBar)loadingView.findViewById(R.id.progress);
            ((AccFragmentAccompanyBinding)this.mViewBinding).llLoading.removeAllViews();
            ((AccFragmentAccompanyBinding)this.mViewBinding).llLoading.addView(loadingView);
        }
    }

    private void initWebView() {
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setUserAgentString(webSettings.getUserAgentString() + WebConstants.getCustomUAParams());
        webSettings.setGeolocationDatabasePath(this.getContext().getFilesDir().getPath());
        webSettings.setGeolocationEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        webSettings.setAppCacheEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSupportZoom(false);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setCacheMode(-1);
        webSettings.setAllowFileAccess(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setDefaultTextEncodingName("UTF-8");
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSettings.setAppCacheMaxSize(Long.MAX_VALUE);
        webSettings.setAppCachePath(this.getActivity().getDir("appcache", 0).getPath());
        webSettings.setDatabasePath(this.getActivity().getDir("databases", 0).getPath());
        webSettings.setGeolocationDatabasePath(this.getActivity().getDir("geolocation", 0).getPath());
        webSettings.setPluginState(WebSettings.PluginState.ON_DEMAND);
        if (Constants.DEBUG) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        webSettings.setTextZoom(100);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setVerticalScrollBarEnabled(false);
    }

    private void updateProgress(int progress) {
        if (this.mViewBinding == null || this.isDetached()) {
            return;
        }
        if (this.progressView != null) {
            int currentProgress = this.progressView.getProgress();
            int totalProgress = currentProgress + progress;
            if (totalProgress > 99) {
                totalProgress = 99;
            }
            this.progressView.setProgress(totalProgress);
        }
    }

    @Override
    public void onSendMessage(String message) {
        if (this.isDetached()) {
            return;
        }
        if (this.webView != null) {
            this.sendMessage(message);
        }
    }

    @Override
    public void setStatusBarTextColor(boolean statusBarTextColor, JSONObject message) {
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void startEvaluating(JSONObject message) {
        this.isSendStartEvaluatingMessage = true;
        new RxPermissions((Fragment)this).request(new String[]{"android.permission.RECORD_AUDIO", "android.permission.WRITE_EXTERNAL_STORAGE"}).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                if (this.webSocketClient != null) {
                    SocketStatus socketStatus = this.checkWebSocketStatus();
                    if (socketStatus == SocketStatus.CONNECTED) {
                        this.onSendMessage(message.toString());
                        this.sendMusicXmlMessage(message);
                    } else {
                        this.msg = message;
                    }
                } else {
                    this.startWebSocketClient(message);
                }
            } else {
                this.sendNoPermissionMsg(message, PermissionType.MICUNABLE, PermissionType.STORAGEUNABLE);
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u9ea6\u514b\u98ce,\u50a8\u5b58");
            }
        });
    }

    private SocketStatus checkWebSocketStatus() {
        if (this.webSocketClient != null) {
            ReadyState readyState = this.webSocketClient.getReadyState();
            if (this.webSocketClient.isOpen()) {
                return SocketStatus.CONNECTED;
            }
            if (readyState == ReadyState.NOT_YET_CONNECTED) {
                this.reConnectWebSocket();
                return SocketStatus.CLOSED;
            }
            if (readyState == ReadyState.CLOSING) {
                this.reConnectWebSocket();
                return SocketStatus.CLOSING;
            }
            if (readyState == ReadyState.CLOSED) {
                this.reConnectWebSocket();
                return SocketStatus.CLOSED;
            }
        }
        return SocketStatus.CLOSED;
    }

    @Override
    public void cloudLoading(JSONObject jsonObject) {
        try {
            JSONObject content = jsonObject.getJSONObject("content");
            boolean show = content.optBoolean("show", false);
            if (this.mLoadHandler != null) {
                this.mLoadHandler.removeCallbacksAndMessages(null);
                if (show) {
                    this.sendProgressMessage(5010, 0);
                } else {
                    this.sendProgressMessage(5012, 0);
                }
            }
            this.onSendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            this.sendProgressMessage(5013, 0);
            e.printStackTrace();
        }
    }

    private void showLoadingAnim() {
        if (this.mViewBinding == null || this.isDetached()) {
            return;
        }
        if (((AccFragmentAccompanyBinding)this.mViewBinding).llLoading.getVisibility() != 0) {
            this.currentProgressCount = 0;
            this.progressView.setProgress(0);
            ((AccFragmentAccompanyBinding)this.mViewBinding).ivLoadingBack.setVisibility(0);
            ((AccFragmentAccompanyBinding)this.mViewBinding).llLoading.setVisibility(0);
            this.viewLoadingAnim.playAnimation();
        }
    }

    private void sendProgressMessage(int type, int delayedTime) {
        Message message = Message.obtain();
        message.what = type;
        this.mLoadHandler.sendMessageDelayed(message, (long)delayedTime);
    }

    private void hideLoadingAnim() {
        if (this.mViewBinding == null || this.isDetached()) {
            return;
        }
        this.currentProgressCount = 0;
        ((AccFragmentAccompanyBinding)this.mViewBinding).ivLoadingBack.setVisibility(8);
        this.viewLoadingAnim.cancelAnimation();
        this.viewLoadingAnim.clearAnimation();
        ((AccFragmentAccompanyBinding)this.mViewBinding).llLoading.setVisibility(8);
    }

    private void startWebSocketClient(JSONObject message) {
        this.msg = message;
        if (this.webSocketClient == null) {
            if (this.webSocketInitFlag) {
                return;
            }
            this.webSocketInitFlag = true;
            Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(final @io.reactivex.rxjava3.annotations.NonNull ObservableEmitter<String> emitter) throws Exception {
                    HashMap<String, String> httpHeaders = new HashMap<String, String>();
                    httpHeaders.put("Authorization", CacheHelper.getUserToken());
                    AccompanyFragment.this.webSocketClient = new JWebSocketClient(AccompanyFragment.this.webSocketUri, httpHeaders){

                        @Override
                        public void onMessage(String message) {
                            emitter.onNext((Object)message);
                        }

                        @Override
                        public void onError(Exception ex) {
                            super.onError(ex);
                            emitter.onNext((Object)SocketStatus.CLOSED.getStatus());
                            ex.printStackTrace();
                            ALOG.i("webSocket onError");
                        }

                        @Override
                        public void onOpen(ServerHandshake handshakedata) {
                            super.onOpen(handshakedata);
                            ALOG.i("webSocket open");
                            emitter.onNext((Object)SocketStatus.CONNECTED.getStatus());
                        }

                        @Override
                        public void onClose(int code, String reason, boolean remote) {
                            super.onClose(code, reason, remote);
                            ALOG.i("webSocket onClose code:" + code + "-reason:" + reason + "-remote:" + remote);
                            emitter.onNext((Object)SocketStatus.CLOSED.getStatus());
                        }
                    };
                    AccompanyFragment.this.webSocketClient.setConnectionLostTimeout(60000);
                    AccompanyFragment.this.webSocketClient.connect();
                    AccompanyFragment.this.mPlayHelper.setWebSocketClient(AccompanyFragment.this.webSocketClient);
                }
            }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

                public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
                }

                public void onNext(@io.reactivex.rxjava3.annotations.NonNull String message) {
                    if (TextUtils.equals((CharSequence)SocketStatus.CONNECTED.getStatus(), (CharSequence)message)) {
                        if (AccompanyFragment.this.mPlayHelper != null) {
                            AccompanyFragment.this.mPlayHelper.notifyWebSocketConnected();
                        }
                        AccompanyFragment.this.sendNormalCallBack("socketConnectSuccessReport", SocketStatus.CONNECTED.getStatus());
                        if (AccompanyFragment.this.isSendStartEvaluatingMessage && AccompanyFragment.this.msg != null) {
                            AccompanyFragment.this.onSendMessage(AccompanyFragment.this.msg.toString());
                            AccompanyFragment.this.sendMusicXmlMessage(AccompanyFragment.this.msg);
                            AccompanyFragment.this.isSendStartEvaluatingMessage = false;
                        }
                        AccompanyFragment.this.startWebSocketHeartbeatTimer();
                    } else if (TextUtils.equals((CharSequence)SocketStatus.CLOSED.getStatus(), (CharSequence)message)) {
                        AccompanyFragment.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                        AccompanyFragment.this.mLoadHandler.removeMessages(5014);
                        if (AccompanyFragment.this.isSendStartEvaluatingMessage) {
                            AccompanyFragment.this.isSendStartEvaluatingMessage = false;
                        }
                    } else {
                        JSONObject object = new JSONObject();
                        try {
                            object.put("api", (Object)"sendResult");
                            object.put("content", (Object)new JSONObject(message));
                            AccompanyFragment.this.onSendMessage(object.toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (AccompanyFragment.this.mPlayHelper != null) {
                            AccompanyFragment.this.mPlayHelper.parseServerMsg(message);
                        }
                    }
                    AccompanyFragment.this.msg = null;
                }

                public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                    e.printStackTrace();
                    AccompanyFragment.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                    AccompanyFragment.this.msg = null;
                }

                public void onComplete() {
                }
            });
        } else if (this.webSocketClient.isOpen()) {
            if (this.isSendStartEvaluatingMessage) {
                this.sendMusicXmlMessage(message);
                this.isSendStartEvaluatingMessage = false;
            }
            this.onSendMessage(message.toString());
        } else {
            this.reConnectWebSocket();
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void reConnectWebSocket() {
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(@io.reactivex.rxjava3.annotations.NonNull ObservableEmitter<Object> emitter) throws Throwable {
                ReadyState readyState = AccompanyFragment.this.webSocketClient.getReadyState();
                if (readyState == ReadyState.NOT_YET_CONNECTED) {
                    ALOG.i("webSocketClient connectBlocking");
                    AccompanyFragment.this.webSocketClient.connectBlocking();
                } else if (readyState == ReadyState.CLOSED || readyState == ReadyState.CLOSING) {
                    ALOG.i("webSocketClient reconnectBlocking");
                    AccompanyFragment.this.webSocketClient.reconnectBlocking();
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<Object>(){

            public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
            }

            public void onNext(@io.reactivex.rxjava3.annotations.NonNull Object o) {
            }

            public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                e.printStackTrace();
            }

            public void onComplete() {
            }
        });
    }

    private void sendMusicXmlMessage(JSONObject message) {
        if (message == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject headerObject = new JSONObject();
            headerObject.put("commond", (Object)"musicXml");
            headerObject.put("type", (Object)"SOUND_COMPARE");
            headerObject.put("status", 200);
            jsonObject.put("header", (Object)headerObject);
            jsonObject.put("body", (Object)message.getJSONObject("content"));
            this.sendWebSocketMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startRecording(final JSONObject message) {
        this.onSendMessage(message.toString());
        this.isSendRecordStartTime = true;
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                JSONObject jsonObject = new JSONObject();
                JSONObject headerObject = new JSONObject();
                headerObject.put("commond", (Object)"recordStart");
                headerObject.put("type", (Object)"SOUND_COMPARE");
                headerObject.put("status", 200);
                jsonObject.put("header", (Object)headerObject);
                this.sendWebSocketMessage(jsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.wavRecorder != null) {
            this.wavRecorder.stopRecording();
            MyFileUtils.deleteFile(this.getVoicePath());
            this.wavRecorder.startRecording(this.getContext());
        } else {
            Observable.create(emitter -> {
                this.wavRecorder = MsRecorder.wav(new File(this.getVoicePath()), new AudioRecordConfig(), new PullTransport.Default().setOnAudioChunkPulledListener(new PullTransport.OnAudioChunkPulledListener(){

                    @Override
                    public void onAudioChunkPulled(AudioChunk audioChunk) {
                        if (AccompanyFragment.this.webSocketClient != null && AccompanyFragment.this.webSocketClient.isOpen()) {
                            AccompanyFragment.this.webSocketClient.send(audioChunk.toBytes());
                            if (AccompanyFragment.this.isSendRecordStartTime) {
                                AccompanyFragment.this.isSendRecordStartTime = false;
                                emitter.onNext((Object)"record_success");
                            }
                        } else {
                            emitter.onNext((Object)"record_error");
                        }
                    }
                }));
                if (this.wavRecorder != null) {
                    this.wavRecorder.startRecording(this.getContext());
                }
            }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

                public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
                }

                public void onNext(@io.reactivex.rxjava3.annotations.NonNull String recorder) {
                    if (TextUtils.equals((CharSequence)"record_success", (CharSequence)recorder)) {
                        long bufferDuration = AccompanyFragment.this.wavRecorder != null ? (long)AccompanyFragment.this.wavRecorder.getBufferDuration() : 0L;
                        long time = System.currentTimeMillis();
                        long result = time - bufferDuration;
                        AccompanyFragment.this.mPlayHelper.toPlayMusic(result, AccompanyFragment.this.getFirstNoteTime(message), AccompanyFragment.this.getPlaySpeed(message), AccompanyFragment.this.isMuteMode(message));
                    } else {
                        AccompanyFragment.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                        AccompanyFragment.this.stopRecordEvent();
                    }
                }

                public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                    AccompanyFragment.this.sendAccompanyError(AccompanyError.RECORDERROR);
                    AccompanyFragment.this.stopRecordEvent();
                }

                public void onComplete() {
                }
            });
        }
    }

    private int getFirstNoteTime(JSONObject jsonObject) {
        if (jsonObject == null) {
            return 0;
        }
        JSONObject contentJson = jsonObject.optJSONObject("content");
        if (contentJson != null) {
            int firstNoteTime = contentJson.optInt("firstNoteTime", 0);
            return firstNoteTime;
        }
        return 0;
    }

    private float getPlaySpeed(JSONObject jsonObject) {
        if (jsonObject == null) {
            return 0.0f;
        }
        JSONObject contentJson = jsonObject.optJSONObject("content");
        if (contentJson != null) {
            float firstNoteTime = (float)contentJson.optDouble("speedRate", 1.0);
            return firstNoteTime;
        }
        return 1.0f;
    }

    private boolean isMuteMode(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        JSONObject contentJson = jsonObject.optJSONObject("content");
        if (contentJson == null) {
            return false;
        }
        int accompanimentState = contentJson.optInt("accompanimentState", 1);
        return accompanimentState == 0;
    }

    @Override
    @Deprecated
    public void endRecording(JSONObject message) {
        if (this.wavRecorder == null) {
            return;
        }
        this.stopRecordEvent();
        this.closeWebSocket();
        this.onSendMessage(message.toString());
    }

    @Override
    public void keepScreenLongLight(JSONObject message) {
        this.onSendMessage(message.toString());
    }

    @Override
    public void startSoundCheck(JSONObject message) {
        this.onSendMessage(message.toString());
        this.isSoundCheckStartTime = true;
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                JSONObject jsonObject2 = new JSONObject();
                JSONObject headerObject2 = new JSONObject();
                headerObject2.put("commond", (Object)"start");
                headerObject2.put("type", (Object)"PITCH_DETECTION");
                headerObject2.put("status", 200);
                jsonObject2.put("header", (Object)headerObject2);
                this.sendWebSocketMessage(jsonObject2.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.wavRecorder != null) {
            this.wavRecorder.stopRecording();
            MyFileUtils.deleteFile(this.getVoicePath());
            this.wavRecorder.startRecording(this.getContext());
        } else {
            Observable.create(emitter -> {
                this.wavRecorder = MsRecorder.wav(new File(this.getVoicePath()), new AudioRecordConfig(), new PullTransport.Default().setOnAudioChunkPulledListener(new PullTransport.OnAudioChunkPulledListener(){

                    @Override
                    public void onAudioChunkPulled(AudioChunk audioChunk) {
                        if (AccompanyFragment.this.webSocketClient != null && AccompanyFragment.this.webSocketClient.isOpen()) {
                            AccompanyFragment.this.webSocketClient.send(audioChunk.toBytes());
                            if (AccompanyFragment.this.isSoundCheckStartTime) {
                                AccompanyFragment.this.isSoundCheckStartTime = false;
                                emitter.onNext((Object)"record_success");
                            }
                        } else {
                            emitter.onNext((Object)"record_error");
                        }
                    }
                }));
                if (this.wavRecorder != null) {
                    this.wavRecorder.startRecording(this.getContext());
                }
            }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

                public void onSubscribe(@io.reactivex.rxjava3.annotations.NonNull Disposable d) {
                }

                public void onNext(@io.reactivex.rxjava3.annotations.NonNull String recorder) {
                    if (TextUtils.equals((CharSequence)"record_success", (CharSequence)recorder)) {
                        try {
                            JSONObject json = new JSONObject();
                            JSONObject content = new JSONObject();
                            content.put("inteveral", System.currentTimeMillis());
                            json.put("api", (Object)"recordStartTime");
                            json.put("content", (Object)content);
                            AccompanyFragment.this.onSendMessage(json.toString());
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else {
                        AccompanyFragment.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                        AccompanyFragment.this.stopRecordEvent();
                    }
                }

                public void onError(@io.reactivex.rxjava3.annotations.NonNull Throwable e) {
                    AccompanyFragment.this.sendAccompanyError(AccompanyError.SOCKETERROR);
                    AccompanyFragment.this.stopRecordEvent();
                }

                public void onComplete() {
                }
            });
        }
    }

    @Override
    public void endSoundCheck(JSONObject message) {
        this.onSendMessage(message.toString());
        this.stopRecordEvent();
        this.wavRecorder = null;
    }

    private String getVoicePath() {
        return MyFileUtils.getRecordFilePath();
    }

    @Override
    public void endEvaluating(final JSONObject jsonObject) {
        if (this.wavRecorder == null) {
            return;
        }
        if (this.mPlayHelper != null) {
            this.mPlayHelper.stop();
        }
        this.mLoadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AccompanyFragment.this.stopRecordEvent();
                AccompanyFragment.this.wavRecorder = null;
                if (AccompanyFragment.this.webSocketClient != null && AccompanyFragment.this.webSocketClient.isOpen()) {
                    try {
                        JSONObject jsonObject2 = new JSONObject();
                        JSONObject headerObject = new JSONObject();
                        headerObject.put("commond", (Object)"recordEnd");
                        headerObject.put("type", (Object)"SOUND_COMPARE");
                        headerObject.put("status", 200);
                        jsonObject2.put("header", (Object)headerObject);
                        AccompanyFragment.this.sendWebSocketMessage(jsonObject2.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AccompanyFragment.this.onSendMessage(jsonObject.toString());
            }
        }, 1000L);
    }

    private void stopRecordEvent() {
        if (this.wavRecorder != null) {
            this.wavRecorder.stopRecording();
        }
    }

    @Override
    public void cancelEvaluating() {
        this.stopRecordEvent();
        MyFileUtils.deleteFile(this.getVoicePath());
    }

    @Override
    @Deprecated
    public void resumeRecording(JSONObject jsonObject) {
        if (this.wavRecorder != null) {
            this.wavRecorder.resumeRecording(this.getContext());
            this.onSendMessage(jsonObject.toString());
        }
    }

    @Override
    @Deprecated
    public void pauseRecording(JSONObject jsonObject) {
        if (this.wavRecorder != null) {
            this.wavRecorder.pauseRecording();
            this.onSendMessage(jsonObject.toString());
        }
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void isWiredHeadsetOn(JSONObject jsonObject) {
        try {
            JSONObject content = jsonObject.getJSONObject("content");
            String s = Utils.checkType(this.getContext());
            content.put("checkIsWired", !TextUtils.isEmpty((CharSequence)s));
            content.put("type", (Object)s);
            this.onSendMessage(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public void proxyMessage(JSONObject jsonObject) {
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                JSONObject json = new JSONObject();
                JSONObject headerObject = new JSONObject();
                headerObject.put("commond", (Object)"proxyMessage");
                json.put("header", (Object)headerObject);
                json.put("body", (Object)jsonObject.getJSONObject("content"));
                this.sendWebSocketMessage(json.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void proxyServiceMessage(final JSONObject mesage) {
        try {
            JSONObject content = null;
            content = mesage.getJSONObject("content");
            String type = content.getJSONObject("header").getString("type");
            if ("SOUND_CHECK".equals(type)) {
                return;
            }
            this.mLoadHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (AccompanyFragment.this.webSocketClient != null && AccompanyFragment.this.webSocketClient.isOpen()) {
                        try {
                            JSONObject content = null;
                            content = mesage.getJSONObject("content");
                            AccompanyFragment.this.sendWebSocketMessage(content.toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    AccompanyFragment.this.onSendMessage(mesage.toString());
                }
            }, 1000L);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void openCamera(JSONObject message) {
        new RxPermissions((Fragment)this).request(new String[]{"android.permission.CAMERA"}).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                if (this.onAccompanyListener != null) {
                    this.onAccompanyListener.openCamera();
                }
                this.onSendMessage(message.toString());
            } else {
                this.sendNoPermissionMsg(message, PermissionType.CAMERAUNABLE);
                this.isSendStartEvaluatingMessage = false;
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u76f8\u673a");
            }
        });
    }

    @Override
    public void closeCamera(JSONObject jsonObject) {
        if (this.onAccompanyListener != null) {
            this.onAccompanyListener.closeCamera();
            this.onSendMessage(jsonObject.toString());
        }
    }

    @Override
    public void startCapture(JSONObject message) {
        new RxPermissions((Fragment)this).request(new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO"}).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                if (this.onAccompanyListener != null) {
                    this.onAccompanyListener.startCapture();
                    this.onSendMessage(message.toString());
                }
            } else {
                this.sendNoPermissionMsg(message, PermissionType.CAMERAUNABLE, PermissionType.MICUNABLE);
                this.isSendStartEvaluatingMessage = false;
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "", "\u5f00\u542f\u76f8\u673a\u3001\u9ea6\u514b\u98ce");
            }
        });
    }

    @Override
    public void endCapture(final JSONObject jsonObject) {
        if (this.onAccompanyListener != null) {
            this.onAccompanyListener.endCapture();
        }
        this.mLoadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AccompanyFragment.this.onSendMessage(jsonObject.toString());
            }
        }, 1500L);
    }

    @Override
    public void videoUpdate(JSONObject jsonObject) {
        if (this.onAccompanyListener != null) {
            this.onAccompanyListener.videoUpdate(jsonObject);
        }
    }

    public void setUploadMsg(ValueCallback uploadMsg) {
        this.mUploadCallbackAboveL = uploadMsg;
    }

    private void addPermissions() {
        String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        new RxPermissions((Fragment)this).request(permissions).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                AccompanyManager.getInstance().selectPicture(this, this.imgSelectResultLauncher);
            } else {
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u76f8\u673a\u3001\u50a8\u5b58\u6743\u9650");
                this.clearUploadMessage();
            }
        });
    }

    public void sendMessage(final String message) {
        boolean mainThread = Utils.isMainThread();
        if (mainThread) {
            this.toSendMessage(message);
        } else {
            this.webView.post(new Runnable(){

                @Override
                public void run() {
                    AccompanyFragment.this.toSendMessage(message);
                }
            });
        }
    }

    private void sendWebSocketMessage(String text) {
        if (this.webSocketClient != null) {
            ALOG.i("sendWebSocketMessage:" + text);
            this.webSocketClient.send(text);
        }
    }

    private void sendWebSocketHeartbeat() {
        try {
            if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
                ALOG.i("webSocket sendPing");
                this.webSocketClient.sendPing();
                this.startWebSocketHeartbeatTimer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startWebSocketHeartbeatTimer() {
        this.mLoadHandler.removeMessages(5014);
        Message obtain = Message.obtain();
        obtain.what = 5014;
        this.mLoadHandler.sendMessageDelayed(obtain, 30000L);
    }

    private void toSendMessage(String message) {
        ALOG.i("sendMessage:" + message);
        if (this.webView != null) {
            this.webView.evaluateJavascript("postMessage('" + message + "','*')", (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String s) {
                }
            });
        }
    }

    public void registReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        this.mHeadsetPlugReceiver = new HeadsetPlugReceiver(new HeadsetPlugListener(){

            @Override
            public void onHeadsetPlug(boolean isPlug, String type) {
                ALOG.i("onHeadsetPlug:" + isPlug + "-type:" + type);
                AccompanyFragment.this.sendAccompanyError(AccompanyError.PLAYERROR);
                if (AccompanyFragment.this.mPlayHelper != null) {
                    AccompanyFragment.this.mPlayHelper.stop();
                }
            }
        });
        this.mContext.registerReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver, intentFilter);
        ALOG.i("registerReceiver mHeadsetPlugReceiver");
    }

    public void onPause() {
        super.onPause();
        ALOG.i("onPause");
    }

    private void unregisterReceiver() {
        try {
            if (this.mHeadsetPlugReceiver != null) {
                ALOG.i("unregisterReceiver");
                this.getContext().unregisterReceiver((BroadcastReceiver)this.mHeadsetPlugReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onStop() {
        super.onStop();
        ALOG.i("onStop");
        this.sendAccompanyError(AccompanyError.ENTERBACKGROUND);
        this.isReady = true;
        if (null != this.soundpool) {
            this.soundpool.release();
        }
        this.removePlayMidProgressMsg();
        if (MidiPlayerUtils.getInstance().isPlaying()) {
            MidiPlayerUtils.getInstance().pausePlay();
            this.removePlayMidProgressMsg();
        }
    }

    private void removePlayMidProgressMsg() {
        this.mLoadHandler.removeMessages(1);
    }

    public void setOnAccompanyListener(onListener onAccompanyListener) {
        this.onAccompanyListener = onAccompanyListener;
    }

    public void setOnWebViewListener(WebViewListener listener) {
        this.listener = listener;
    }

    @Override
    public void shareAchievements(JSONObject message) {
    }

    public void onConfigurationChanged(@NonNull @NotNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void measureStart(JSONObject message) {
    }

    @Override
    public void allMeasureEnd(JSONObject message) {
    }

    @Override
    public void cloudDetail(final JSONObject message) {
        try {
            JSONObject obj = message.optJSONObject("content");
            final String midiFile = obj.optString("midi");
            this.midiFileSpeed = this.midiFileOriginalSpeed = obj.optInt("originalSpeed", 120);
            this.midiFileDuration = obj.optLong("duration");
            this.processInterval = obj.optInt("interval", 16);
            if (TextUtils.isEmpty((CharSequence)midiFile)) {
                ToastUtil.getInstance().showShort("\u6587\u4ef6\u5f02\u5e38");
                return;
            }
            new RxPermissions((Fragment)this).request(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}).subscribe(permission2 -> {
                block8: {
                    if (permission2.booleanValue()) {
                        try {
                            String name;
                            String type = midiFile.substring(midiFile.lastIndexOf(".") + 1);
                            if (TextUtils.isEmpty((CharSequence)type)) {
                                ToastUtil.getInstance().showShort("\u6587\u4ef6\u5f02\u5e38");
                                return;
                            }
                            final String path = MyFileUtils.getPublicDirectory("file");
                            final File file = new File(path, name = EncryptUtils.hashKeyForDisk(midiFile) + "." + type);
                            if (file.exists() && file.length() > 0L) {
                                JSONObject contentJsonObject;
                                ALOG.i("file exists:" + file.getAbsolutePath());
                                this.midiFilePath = file.getAbsolutePath();
                                MidiPlayerUtils.getInstance().init((Context)Utils.getApp(), this.midiFilePath);
                                double tempDuration = MidiPlayerUtils.getInstance().getTotalLength2Second();
                                if (Math.abs((double)this.midiFileDuration - tempDuration * 1000.0) > 2000.0) {
                                    this.midiFileDuration = (long)(tempDuration * 1000.0);
                                }
                                if ((contentJsonObject = message.optJSONObject("content")) != null) {
                                    contentJsonObject.put("midiDuration", this.midiFileDuration);
                                    contentJsonObject.put("midi", (Object)EncodeUtils.urlEncode(midiFile));
                                }
                                this.onSendMessage(message.toString());
                                break block8;
                            }
                            MidHelper.getInstance().startDownloadMidFile(midiFile, new ResultCallback<ResponseBody>(){

                                @Override
                                public void onSuccess(ResponseBody response) {
                                    if (MyFileUtils.writeFileToSDCard(response, path, name)) {
                                        AccompanyFragment.this.runOnUiThread(() -> {
                                            AccompanyFragment.this.midiFilePath = file.getAbsolutePath();
                                            MidiPlayerUtils.getInstance().init(AccompanyFragment.this.getContext().getApplicationContext(), AccompanyFragment.this.midiFilePath);
                                            double tempDuration = MidiPlayerUtils.getInstance().getTotalLength2Second();
                                            if (Math.abs((double)AccompanyFragment.this.midiFileDuration - tempDuration * 1000.0) > 2000.0) {
                                                AccompanyFragment.this.midiFileDuration = (long)(tempDuration * 1000.0);
                                            }
                                            try {
                                                JSONObject contentJsonObject = message.optJSONObject("content");
                                                if (contentJsonObject != null) {
                                                    contentJsonObject.put("midiDuration", AccompanyFragment.this.midiFileDuration);
                                                    contentJsonObject.put("midi", (Object)EncodeUtils.urlEncode(midiFile));
                                                }
                                            }
                                            catch (JSONException e) {
                                                e.printStackTrace();
                                            }
                                            finally {
                                                AccompanyFragment.this.onSendMessage(message.toString());
                                            }
                                        });
                                    } else {
                                        AccompanyFragment.this.runOnUiThread(() -> {
                                            ToastUtil.getInstance().showShort("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
                                            AccompanyFragment.this.midiFilePath = null;
                                            AccompanyFragment.this.onSendMessage(message.toString());
                                        });
                                    }
                                }

                                @Override
                                public void onFail(int errorCode, String errorStr) {
                                    AccompanyFragment.this.runOnUiThread(() -> {
                                        ToastUtil.getInstance().showShort("\u6587\u4ef6\u5f02\u5e38");
                                        AccompanyFragment.this.midiFilePath = null;
                                        AccompanyFragment.this.onSendMessage(message.toString());
                                    });
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.sendNoPermissionMsg(message, PermissionType.STORAGEUNABLE);
                        AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "", "\u5f00\u542f\u50a8\u5b58");
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int convertPlayMidPosFromTime(int time) {
        return (int)((long)time * MidiPlayerUtils.getInstance().getTotalLength() / this.midiFileDuration);
    }

    @Override
    public void cloudPlay(JSONObject message) {
        try {
            JSONObject obj = message.optJSONObject("content");
            this.midiFileSpeed = obj.optInt("speed", 120);
            this.midiSongId = obj.optString("songID");
            this.hertz = obj.optInt("hertz", 440);
            int startTime = obj.optInt("startTime", 0);
            startTime = this.convertPlayMidPosFromTime(startTime);
            if (MidiPlayerUtils.getInstance().isPause()) {
                MidiPlayerUtils.getInstance().resumePlay(startTime);
                this.sendGetPlayMidProgressMsg();
                this.onSendMessage(message.toString());
            } else {
                this.removePlayMidProgressMsg();
                MidiPlayerUtils.getInstance().playSound(startTime, (float)this.midiFileSpeed / (float)this.midiFileOriginalSpeed, this.hertz, fp -> {
                    this.onSendMessage(message.toString());
                    this.sendGetPlayMidProgressMsg();
                }, fp -> {
                    this.removePlayMidProgressMsg();
                    String songID = obj.optString("songID");
                    this.sendPlayMidCompletedMes(songID);
                });
                this.onSendMessage(message.toString());
                this.sendGetPlayMidProgressMsg();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendGetPlayMidProgressMsg() {
        this.sendProgressMessage(1, 0);
    }

    private void sendPlayMidCompletedMes(String songID) {
        try {
            JSONObject content = new JSONObject();
            content.put("songID", (Object)songID);
            JSONObject json = new JSONObject();
            json.put("api", (Object)"cloudplayed");
            json.put("content", (Object)content);
            this.onSendMessage(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void cloudSuspend(JSONObject message) {
        block10: {
            MidiPlayerUtils.getInstance().pausePlay();
            this.removePlayMidProgressMsg();
            try {
                message.optJSONObject("content").put("currentTime", MidiPlayerUtils.getInstance().getCurrentPosition() * (this.midiFileDuration == 0L ? (long)MidiPlayerUtils.getInstance().midiTotalTime : this.midiFileDuration) / MidiPlayerUtils.getInstance().getTotalLength());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.onSendMessage(message.toString());
            break block10;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        message.optJSONObject("content").put("currentTime", MidiPlayerUtils.getInstance().getCurrentPosition() * (this.midiFileDuration == 0L ? (long)MidiPlayerUtils.getInstance().midiTotalTime : this.midiFileDuration) / MidiPlayerUtils.getInstance().getTotalLength());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    this.onSendMessage(message.toString());
                    throw throwable;
                }
                try {
                    message.optJSONObject("content").put("currentTime", MidiPlayerUtils.getInstance().getCurrentPosition() * (this.midiFileDuration == 0L ? (long)MidiPlayerUtils.getInstance().midiTotalTime : this.midiFileDuration) / MidiPlayerUtils.getInstance().getTotalLength());
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                this.onSendMessage(message.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloudSetCurrentTime(JSONObject message) {
        try {
            JSONObject contentJsonObject = message.optJSONObject("content");
            int currentTime = contentJsonObject.optInt("currentTime", 0);
            int pos = this.convertPlayMidPosFromTime(currentTime);
            MidiPlayerUtils.getInstance().seekTo((long)pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.onSendMessage(message.toString());
        }
    }

    @Override
    public void cloudChangeSpeed(JSONObject message) {
        try {
            JSONObject obj = message.optJSONObject("content");
            this.midiFileSpeed = obj.optInt("speed", 120);
            MidiPlayerUtils.getInstance().setSpeed((float)this.midiFileSpeed / (float)this.midiFileOriginalSpeed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.toSendMessage(message.toString());
        }
    }

    @Override
    public void cloudSwitch(JSONObject message) {
        try {
            int i;
            JSONObject obj = message.optJSONObject("content");
            JSONArray array = obj.optJSONArray("parts");
            for (i = 0; i < MidiPlayerUtils.getInstance().getMidiTracks().size(); ++i) {
                MidiPlayerUtils.getInstance().setTrackVolume(i, 0.7f);
            }
            for (i = 0; i < array.length(); ++i) {
                MidiPlayerUtils.getInstance().setTrackVolumeByName(array.optString(i), 0.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloudVolume(JSONObject message) {
        block8: {
            try {
                JSONObject obj = message.optJSONObject("content");
                if (obj == null) break block8;
                int activeMidiId = obj.optInt("activeMidiId");
                int activeMidiVolume = obj.optInt("activeMidiVolume", 70);
                if (activeMidiId == -1) {
                    return;
                }
                MidiPlayerUtils.getInstance().setTrackVolumeById(activeMidiId, (float)activeMidiVolume / 100.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.sendMessage(message.toString());
                for (int i = 0; i < MidiPlayerUtils.getInstance().getMidiTracks().size(); ++i) {
                    ALOG.i(TAG, "track " + i + " vol is " + MidiPlayerUtils.getInstance().getTrackVolume(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloudGetMediaStatus(JSONObject message) {
        try {
            String midStatus = "suspend";
            midStatus = MidiPlayerUtils.getInstance().isPlaying() ? "play" : (MidiPlayerUtils.getInstance().isPause() ? "suspend" : (MidiPlayerUtils.getInstance().isStop() ? "suspend" : "suspend"));
            JSONObject jsonObject = message.optJSONObject("content");
            if (jsonObject != null) {
                jsonObject.put("status", (Object)midStatus);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sendMessage(message.toString());
        }
    }

    @Override
    public void cloudDestroy(JSONObject message) {
        try {
            MidiPlayerUtils.getInstance().stopPlay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sendMessage(message.toString());
        }
    }

    @Override
    public void joinLiveRoom(String roomId, String teacherId) {
    }

    @Override
    public void joinChatGroup(String type, String id2) {
    }

    public void selectAddress(String addressJson) {
        this.onSendMessage("'getAddress'," + addressJson);
    }

    @Override
    public void paymentOrder(String orderNo, String payChannel, String payInfo) {
    }

    @Override
    public void savePicture(String base64, String uuid) {
        try {
            File file = MyFileUtils.saveBase64ImgToLocalFile(base64);
            this.sendSavePicCallBack("savePicture", "success", uuid);
        }
        catch (Exception e) {
            this.sendSavePicCallBack("savePicture", "fail", uuid);
            e.printStackTrace();
        }
    }

    @Override
    public void cloudToggleFollow(JSONObject jsonObject) {
        try {
            JSONObject content = jsonObject.getJSONObject("content");
            String mode = content.getString("state");
            new RxPermissions((Fragment)this).request(new String[]{"android.permission.RECORD_AUDIO"}).subscribe(permission2 -> {
                if (permission2.booleanValue()) {
                    this.onSendMessage(jsonObject.toString());
                    this.handleCloudFollow(mode);
                } else {
                    this.sendNoPermissionMsg(jsonObject, PermissionType.MICUNABLE);
                    AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u9ea6\u514b\u98ce");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startTune(JSONObject message) {
        new RxPermissions((Fragment)this).request(new String[]{"android.permission.RECORD_AUDIO"}).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                if (this.mPlayHelper != null) {
                    this.mPlayHelper.startTune(message);
                }
            } else {
                this.sendNoPermissionMsg(message, PermissionType.MICUNABLE);
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u9ea6\u514b\u98ce");
            }
        });
    }

    private void sendNoPermissionMsg(JSONObject message, PermissionType ... tips) {
        try {
            StringBuilder sb = new StringBuilder();
            StringBuilder desSb = new StringBuilder();
            for (int i = 0; i < tips.length; ++i) {
                PermissionType p = tips[i];
                sb.append(p.getType());
                desSb.append(p.getDes());
                if (i == tips.length - 1) continue;
                sb.append(",");
            }
            JSONObject content = message.getJSONObject("content");
            content.put("reson", (Object)sb.toString());
            content.put("des", (Object)desSb.toString());
            this.onSendMessage(message.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endTune(JSONObject message) {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.endTune(message);
        }
    }

    @Override
    public void createMusicPlayer(JSONObject message) {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.createMusicPlayer(message);
        }
        if (this.onAccompanyListener != null) {
            this.onAccompanyListener.onDownloadAccompaniment(message);
        }
    }

    @Override
    public void getDeviceDelay(JSONObject jsonObject) {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.getDeviceDelay(jsonObject);
        }
    }

    @Override
    public void onFinishTune(JSONObject jsonObject) {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.onFinishTune(jsonObject);
        }
    }

    @Override
    public void checkSocketStatus(JSONObject jsonObject) {
        try {
            if (this.webSocketClient != null) {
                SocketStatus socketStatus = this.checkWebSocketStatus();
                this.sendWebSocketStatusMessage(socketStatus, jsonObject);
            } else {
                this.sendWebSocketStatusMessage(SocketStatus.CLOSED, jsonObject);
                this.startWebSocketClient(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void disconnectWebSocket() {
        this.closeWebSocket();
    }

    @Override
    public void startDelayCheck(JSONObject message) {
        new RxPermissions((Fragment)this).request(new String[]{"android.permission.RECORD_AUDIO"}).subscribe(permission2 -> {
            if (permission2.booleanValue()) {
                if (this.mPlayHelper != null) {
                    this.mPlayHelper.showDelayView();
                }
            } else {
                this.sendNoPermissionMsg(message, PermissionType.MICUNABLE);
                AccompanyManager.getInstance().showPermissionTipDialog(this.getChildFragmentManager(), this.getContext(), "\u63d0\u793a", "\u5f00\u542f\u9ea6\u514b\u98ce");
            }
        });
    }

    @Override
    public void closeDelayCheck() {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.hideDelayView();
        }
    }

    private void closeWebSocket() {
        if (this.webSocketClient != null) {
            ALOG.i("closeWebSocket");
            this.webSocketClient.close();
        }
    }

    @Override
    public void openAdjustRecording(JSONObject message) {
        JSONObject contentJson;
        if (message != null && (contentJson = message.optJSONObject("content")) != null) {
            String recordId = contentJson.optString("recordId");
            String title = contentJson.optString("title");
            String coverImg = contentJson.optString("coverImg");
            String musicSheetId = contentJson.optString("musicSheetId");
            String musicRenderType = contentJson.optString("musicRenderType");
            float speedRate = (float)contentJson.optDouble("speedRate", 1.0);
            int partIndex = contentJson.optInt("part-index", 0);
            if (this.onAccompanyListener != null) {
                MusicSaveParams musicSaveParams = new MusicSaveParams();
                musicSaveParams.setRecordId(recordId);
                musicSaveParams.setTitle(title);
                musicSaveParams.setCoverImg(coverImg);
                musicSaveParams.setMusicSheetId(musicSheetId);
                musicSaveParams.setMusicRenderType(musicRenderType);
                musicSaveParams.setEvaluationSpeed(speedRate);
                musicSaveParams.setPartIndex(partIndex);
                this.onAccompanyListener.openAdjustRecording(musicSaveParams);
            }
        }
    }

    @Override
    public void onBackPress() {
        if (this.webView != null) {
            if (this.webView.canGoBack()) {
                this.webView.goBack();
                return;
            }
            if (this.getActivity() != null) {
                this.getActivity().onBackPressed();
            }
        }
    }

    private void handleCloudFollow(String mode) {
        if (this.mMusicTunerHelper == null) {
            this.mMusicTunerHelper = new MusicTunerHelper(new MusicTunerHelper.OnEventListener(){

                @Override
                public void onResult(final float pitchInHz) {
                    AccompanyFragment.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AccompanyFragment.this.sendCloudToggleFollowResult(pitchInHz);
                        }
                    });
                }
            });
        }
        if (TextUtils.equals((CharSequence)mode, (CharSequence)"start")) {
            this.mMusicTunerHelper.start();
        } else {
            this.mMusicTunerHelper.stop();
        }
    }

    private void sendSavePicCallBack(String api, String result, String uuid) {
        JSONObject jsonObject = new JSONObject();
        JSONObject contentJson = new JSONObject();
        try {
            jsonObject.put("api", (Object)api);
            contentJson.put("status", (Object)result);
            contentJson.put("uuid", (Object)uuid);
            jsonObject.put("content", (Object)contentJson);
            this.sendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public void cloudMetronome(JSONObject message) {
        try {
            JSONObject obj = message.optJSONObject("content");
            int repeat = obj.optInt("repeat", 1);
            int denominator = obj.optInt("denominator", 4);
            int numerator = obj.optInt("repeat", 4);
            if (this.soundpool != null) {
                this.soundpool.release();
                this.soundpool = null;
            }
            this.isReady = false;
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            if (numerator == 2) {
                this.soundpool = new SoundPool(2, 3, 0);
                map.put(0, this.soundpool.load(this.getContext(), R.raw.midstrong, 1));
                map.put(1, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
            } else if (numerator == 3) {
                this.soundpool = new SoundPool(3, 3, 0);
                map.put(0, this.soundpool.load(this.getContext(), R.raw.midstrong, 1));
                map.put(1, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(2, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
            } else if (numerator == 6) {
                this.soundpool = new SoundPool(6, 3, 0);
                map.put(0, this.soundpool.load(this.getContext(), R.raw.midstrong, 1));
                map.put(1, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(2, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(3, this.soundpool.load(this.getContext(), R.raw.midstrong, 1));
                map.put(4, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(5, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
            } else {
                this.soundpool = new SoundPool(4, 3, 0);
                map.put(0, this.soundpool.load(this.getContext(), R.raw.midstrong, 1));
                map.put(1, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(2, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
                map.put(3, this.soundpool.load(this.getContext(), R.raw.feeble, 1));
            }
            int speed = denominator == 4 ? (this.midiFileSpeed > 0 ? this.midiFileSpeed : 60) : (this.midiFileSpeed * 2 > 0 ? this.midiFileSpeed * 2 : 60);
            long sleepTime = (long)(60000.0 / (double)speed);
            this.showCountDownDialog(map.size(), message);
            new Thread(() -> {
                this.playPreSound(map, sleepTime, repeat);
                this.runOnUiThread(() -> {
                    if (null != this.preCountDialog) {
                        this.preCountDialog.dismiss();
                    }
                    if (this.soundpool != null) {
                        try {
                            message.optJSONObject("content").put("status", (Object)"finish");
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        this.onSendMessage(message.toString());
                    }
                });
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runOnUiThread(Runnable runnable) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(runnable);
        }
    }

    private void showCountDownDialog(final int count, final JSONObject message) {
        this.preCountDialog = CommonDialog.init().setLayoutId(R.layout.acc_dialog_student_precount);
        this.preCountDialog.setConvertListener(new ViewConvertListener(){

            @Override
            public void convertView(ViewHolder holder, DialogFragment dialog) {
                if (count == 2) {
                    AccompanyFragment.this.iv1 = (ImageView)holder.getView(R.id.iv_3);
                    AccompanyFragment.this.iv2 = (ImageView)holder.getView(R.id.iv_4);
                    AccompanyFragment.this.iv3 = (ImageView)holder.getView(R.id.iv_1);
                    AccompanyFragment.this.iv4 = (ImageView)holder.getView(R.id.iv_2);
                    AccompanyFragment.this.iv5 = (ImageView)holder.getView(R.id.iv_5);
                    AccompanyFragment.this.iv6 = (ImageView)holder.getView(R.id.iv_6);
                    AccompanyFragment.this.iv3.setVisibility(4);
                    AccompanyFragment.this.iv4.setVisibility(4);
                    AccompanyFragment.this.iv5.setVisibility(4);
                    AccompanyFragment.this.iv6.setVisibility(4);
                } else if (count == 3) {
                    AccompanyFragment.this.iv1 = (ImageView)holder.getView(R.id.iv_3);
                    AccompanyFragment.this.iv2 = (ImageView)holder.getView(R.id.iv_4);
                    AccompanyFragment.this.iv3 = (ImageView)holder.getView(R.id.iv_5);
                    AccompanyFragment.this.iv4 = (ImageView)holder.getView(R.id.iv_2);
                    AccompanyFragment.this.iv5 = (ImageView)holder.getView(R.id.iv_1);
                    AccompanyFragment.this.iv6 = (ImageView)holder.getView(R.id.iv_6);
                    AccompanyFragment.this.iv4.setVisibility(4);
                    AccompanyFragment.this.iv5.setVisibility(4);
                    AccompanyFragment.this.iv6.setVisibility(4);
                } else if (count == 4) {
                    AccompanyFragment.this.iv1 = (ImageView)holder.getView(R.id.iv_2);
                    AccompanyFragment.this.iv2 = (ImageView)holder.getView(R.id.iv_3);
                    AccompanyFragment.this.iv3 = (ImageView)holder.getView(R.id.iv_4);
                    AccompanyFragment.this.iv4 = (ImageView)holder.getView(R.id.iv_5);
                    AccompanyFragment.this.iv5 = (ImageView)holder.getView(R.id.iv_1);
                    AccompanyFragment.this.iv6 = (ImageView)holder.getView(R.id.iv_6);
                    AccompanyFragment.this.iv5.setVisibility(4);
                    AccompanyFragment.this.iv6.setVisibility(4);
                }
                AccompanyFragment.this.iv1.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                AccompanyFragment.this.iv2.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                AccompanyFragment.this.iv3.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                AccompanyFragment.this.iv4.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                AccompanyFragment.this.iv5.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                AccompanyFragment.this.iv6.setImageResource(R.drawable.bg_play_metronome_gray_dots_shape);
                ImageView iv_dialog_student_precount = (ImageView)holder.getView(R.id.iv_dialog_student_precount);
                iv_dialog_student_precount.setOnClickListener(v -> {
                    dialog.dismiss();
                    if (AccompanyFragment.this.soundpool != null) {
                        AccompanyFragment.this.soundpool.release();
                        AccompanyFragment.this.soundpool = null;
                    }
                    try {
                        message.optJSONObject("content").put("status", (Object)"cancel");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    AccompanyFragment.this.onSendMessage(message.toString());
                });
            }
        }).setDimAmount(0.6f).setOutCancel(true).setGravity(17).show(this.getChildFragmentManager());
    }

    private void changeImageState(int size, int now) {
        if (null != this.preCountDialog && this.preCountDialog.isVisible()) {
            int resId = -1;
            if (now < size) {
                resId = R.drawable.bg_play_metronome_white_dots_shape;
            }
            if ((now %= size) == 0) {
                this.iv1.setImageResource(R.drawable.bg_play_metronome_green_dots_shape);
            } else if (now == 1) {
                this.iv2.setImageResource(resId);
            } else if (now == 2) {
                this.iv3.setImageResource(resId);
            } else if (now == 3) {
                this.iv4.setImageResource(resId);
            } else if (now == 4) {
                this.iv5.setImageResource(resId);
            } else if (now == 5) {
                this.iv6.setImageResource(resId);
            }
        }
    }

    private void playPreSound(HashMap<Integer, Integer> map, long sleepTime, int repeat) {
        SystemClock.sleep((long)500L);
        --repeat;
        for (int i = 0; i < map.size(); ++i) {
            if (this.isReady) continue;
            SystemClock.sleep((long)sleepTime);
            if (this.soundpool != null) {
                this.soundpool.play(map.get(i).intValue(), 1.0f, 1.0f, 0, 0, 1.0f);
                int finalI = i;
                this.runOnUiThread(() -> this.changeImageState(map.size(), finalI));
                continue;
            }
            return;
        }
        if (repeat > 0) {
            this.playPreSound(map, sleepTime, repeat);
        } else {
            SystemClock.sleep((long)sleepTime);
        }
    }

    private void checkPrecess() {
        if (!MidiPlayerUtils.getInstance().isPlaying()) {
            return;
        }
        int tick = MidiPlayerUtils.getInstance().getCurrentTICK();
        int totalTick = MidiPlayerUtils.getInstance().getTotalTICK();
        float percent = (float)tick / (float)totalTick;
        long totalTime = this.midiFileDuration == 0L ? (long)MidiPlayerUtils.getInstance().midiTotalTime : this.midiFileDuration;
        long dur = (long)(percent * (float)totalTime);
        ALOG.i("pq", "dur:" + dur);
        try {
            if (TextUtils.isEmpty((CharSequence)this.midiSongId)) {
                return;
            }
            JSONObject content = new JSONObject();
            content.put("currentTime", dur);
            content.put("songID", (Object)this.midiSongId);
            JSONObject json = new JSONObject();
            json.put("api", (Object)"cloudTimeUpdae");
            json.put("content", (Object)content);
            this.onSendMessage(json.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendNormalCallBack(String api, String result) {
        JSONObject jsonObject = new JSONObject();
        JSONObject contentJson = new JSONObject();
        try {
            jsonObject.put("api", (Object)api);
            contentJson.put("status", (Object)result);
            jsonObject.put("content", (Object)contentJson);
            this.sendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendCloudToggleFollowResult(float result) {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject contentJson = new JSONObject();
            jsonObject.put("api", (Object)"cloudFollowTime");
            contentJson.put("frequency", (double)result);
            jsonObject.put("content", (Object)contentJson);
            this.onSendMessage(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendWebSocketStatusMessage(SocketStatus socketStatus, JSONObject jsonObject) {
        try {
            JSONObject contentJson = jsonObject.optJSONObject("content");
            jsonObject.put("api", (Object)"checkSocketStatus");
            contentJson.put("status", (Object)socketStatus.getStatus());
            contentJson.put("reson", (Object)socketStatus.getDes());
            jsonObject.put("content", (Object)contentJson);
            this.onSendMessage(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendAccompanyError(AccompanyError accompanyError) {
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject contentJson = new JSONObject();
            jsonObject.put("api", (Object)"accompanyError");
            contentJson.put("type", (Object)accompanyError.getType());
            contentJson.put("reson", (Object)accompanyError.getReason());
            jsonObject.put("content", (Object)contentJson);
            this.onSendMessage(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void clearUploadMessage() {
        if (this.mUploadCallbackAboveL != null) {
            this.mUploadCallbackAboveL.onReceiveValue(null);
            this.mUploadCallbackAboveL = null;
        }
    }

    @Override
    public void onDestroy() {
        if (this.mPlayHelper != null) {
            this.mPlayHelper.release();
        }
        if (this.mLoadHandler != null) {
            this.mLoadHandler.removeCallbacksAndMessages(null);
        }
        this.viewLoadingAnim.cancelAnimation();
        this.unregisterReceiver();
        super.onDestroy();
        if (null != this.webView) {
            this.webView.destroy();
        }
        this.stopRecordEvent();
        this.wavRecorder = null;
        if (this.webSocketClient != null) {
            this.webSocketClient.close();
            this.webSocketClient = null;
        }
        MidiPlayerUtils.getInstance().destroy();
        if (this.mMusicTunerHelper != null) {
            this.mMusicTunerHelper.release();
        }
    }

    private class WebClient
    extends WebViewClient {
        private int webViewPreviousState;
        private final int PAGE_STARTED = 1;
        private final int PAGE_REDIRECTED = 2;

        private WebClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            this.webViewPreviousState = 1;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.webViewPreviousState == 1 && AccompanyFragment.this.listener != null) {
                AccompanyFragment.this.listener.onPageFinished();
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String request) {
            this.webViewPreviousState = 2;
            view.loadUrl(request);
            return true;
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
        }

        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            ALOG.i("accom", "onReceivedClientCertRequest");
            boolean isCert = AccompanyManager.getInstance().onReceivedClientCertRequest(view, request);
            if (!isCert) {
                super.onReceivedClientCertRequest(view, request);
            }
        }
    }

    private class MyWebChromeClient
    extends WebChromeClient {
        private MyWebChromeClient() {
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            AccompanyFragment.this.setUploadMsg(filePathCallback);
            AccompanyFragment.this.addPermissions();
            return true;
        }
    }

    public static interface onListener {
        public void setStatusBarTextColor(boolean var1);

        public void openCamera();

        public void closeCamera();

        public void startCapture();

        public void endCapture();

        public void videoUpdate(JSONObject var1);

        public void onDownloadAccompaniment(JSONObject var1);

        public void openAdjustRecording(MusicSaveParams var1);
    }

    public static interface WebViewListener {
        public void onPageFinished();
    }
}

