/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.beauty.b;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;

public class n
extends b {
    private static final String TAG = "TXCGPUWatermarkFilter";
    protected static final short[] DRAW_ORDER = new short[]{1, 2, 0, 2, 0, 3};
    private static final float[] VERTICES_COORDS = new float[8];
    private static final float[] TEXTURE_COORDS = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    protected static final FloatBuffer TEXTURE_COORDS_BUFFER = (FloatBuffer)ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer().put(TEXTURE_COORDS).asReadOnlyBuffer().position(0);
    protected static final ShortBuffer DRAW_ORDER_BUFFER = (ShortBuffer)ByteBuffer.allocateDirect(DRAW_ORDER.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer().put(DRAW_ORDER).asReadOnlyBuffer().position(0);
    public a[] mRenderObjects = null;
    private a mBaseWaterMark = null;
    protected List<o> mWaterMarkList = null;
    protected boolean mDrawWaterMarkEnabled = false;
    protected int mSrcBlendMode = 1;
    private int mBaseMarkOffset = 1;
    private o mWatermark = null;

    public n() {
        this("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}");
    }

    public n(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.releaseWaterMark();
    }

    @Override
    public void onInit(e texturePool) {
        super.onInit(texturePool);
        if (this.mWatermark != null) {
            n n2 = this;
            n2.setWatermark(n2.mWatermark.a, this.mWatermark.b, this.mWatermark.c, this.mWatermark.d);
        }
        if (this.mWaterMarkList != null) {
            n n3 = this;
            n3.setWaterMarkList(n3.mWaterMarkList);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        LiteavLog.i(TAG, "onOutputSizeChanged,width=%d,height=%d", width, height);
        super.onOutputSizeChanged(width, height);
        if (this.mRenderObjects == null) {
            return;
        }
        if (this.mWatermark != null && this.mWatermark.a != null) {
            n n2 = this;
            n2.calculateOffsetMatrix(n2.mWatermark.a.getWidth(), this.mWatermark.a.getHeight(), this.mWatermark.b, this.mWatermark.c, this.mWatermark.d, 0);
        }
        if (this.mWaterMarkList == null) {
            return;
        }
        for (int i2 = 0; i2 < this.mWaterMarkList.size(); ++i2) {
            o o2 = this.mWaterMarkList.get(i2);
            if (o2 == null || o2.a == null) continue;
            this.calculateOffsetMatrix(o2.a.getWidth(), o2.a.getHeight(), o2.b, o2.c, o2.d, i2 + this.mBaseMarkOffset);
        }
    }

    public void enableWatermark(boolean enable) {
        this.mDrawWaterMarkEnabled = enable;
    }

    private void setWatermark(Bitmap bitmap, float x2, float y2, float width, int index) {
        if (this.mRenderObjects == null || index >= this.mRenderObjects.length || null == this.mRenderObjects[index]) {
            LiteavLog.e(TAG, "index is too large for mRenderObjects!");
            return;
        }
        if (bitmap == null) {
            LiteavLog.i(TAG, "release %d watermark!", index);
            this.mRenderObjects[index].a();
            this.mRenderObjects[index] = null;
            return;
        }
        this.calculateOffsetMatrix(bitmap.getWidth(), bitmap.getHeight(), x2, y2, width, index);
        a a2 = this.mRenderObjects[index];
        if (a2.b == null || !a2.b.equals(bitmap)) {
            if (a2.c != -1 && a2.b != null && (a2.b.getWidth() != bitmap.getWidth() || a2.b.getHeight() != bitmap.getHeight())) {
                OpenGlUtils.deleteTexture(a2.c);
                a2.c = -1;
            }
            a2.c = OpenGlUtils.loadTexture(bitmap, a2.c, false);
        }
        a2.b = bitmap;
    }

    public void setWatermark(Bitmap bitmap, float x2, float y2, float width) {
        if (this.mRenderObjects == null) {
            this.mRenderObjects = new a[1];
        }
        if (null == this.mRenderObjects[0]) {
            this.mRenderObjects[0] = new a();
        }
        this.setWatermark(bitmap, x2, y2, width, 0);
        this.mBaseWaterMark = this.mRenderObjects[0];
        if (bitmap == null) {
            this.mWatermark = null;
            return;
        }
        if (this.mWatermark == null) {
            this.mWatermark = new o();
        }
        this.mWatermark.a = bitmap;
        this.mWatermark.b = x2;
        this.mWatermark.c = y2;
        this.mWatermark.d = width;
    }

    public void calculateOffsetMatrix(int dataWidth, int dataHeight, float x2, float y2, float width, int index) {
        if (this.mRenderObjects == null || index >= this.mRenderObjects.length || this.mRenderObjects[index] == null) {
            LiteavLog.e(TAG, "calculateOffsetMatrix,index[%d],mRenderObjects=%s", index, Arrays.toString(this.mRenderObjects));
            return;
        }
        this.mRenderObjects[index].a = ByteBuffer.allocateDirect(VERTICES_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        float[] fArray = new float[VERTICES_COORDS.length];
        float[] fArray2 = fArray;
        fArray[0] = 2.0f * x2 - 1.0f;
        fArray2[1] = 1.0f - 2.0f * y2;
        fArray2[2] = fArray2[0];
        float f2 = (float)dataHeight / (float)dataWidth * width * (float)this.mOutputSize.width / (float)this.mOutputSize.height;
        fArray2[3] = fArray2[1] - 2.0f * f2;
        fArray2[4] = fArray2[0] + 2.0f * width;
        fArray2[5] = fArray2[3];
        fArray2[6] = fArray2[4];
        fArray2[7] = fArray2[1];
        for (int i2 = 1; i2 <= 7; i2 += 2) {
            int n2 = i2;
            fArray2[n2] = fArray2[n2] * -1.0f;
        }
        this.mRenderObjects[index].a.put(fArray2).position(0);
    }

    public void setWaterMarkList(List<o> markList) {
        int n2;
        if (this.mWaterMarkList != null) {
            n n3 = this;
            if (n3.compareWaterMarkList(n3.mWaterMarkList, markList)) {
                LiteavLog.i(TAG, "Same markList");
                return;
            }
        }
        this.mWaterMarkList = markList;
        if (this.mRenderObjects != null) {
            for (n2 = this.mBaseMarkOffset; n2 < this.mRenderObjects.length; ++n2) {
                OpenGlUtils.deleteTexture(this.mRenderObjects[n2].c);
                this.mRenderObjects[n2].c = -1;
            }
        }
        this.mRenderObjects = new a[markList.size() + this.mBaseMarkOffset];
        this.mRenderObjects[0] = this.mBaseWaterMark;
        for (n2 = 0; n2 < markList.size(); ++n2) {
            o o2 = markList.get(n2);
            if (o2 == null) continue;
            this.mRenderObjects[n2 + this.mBaseMarkOffset] = new a();
            this.setWatermark(o2.a, o2.b, o2.c, o2.d, n2 + this.mBaseMarkOffset);
        }
    }

    private boolean compareWaterMarkList(List<o> src1, List<o> src2) {
        if (src1.size() != src2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < src1.size(); ++i2) {
            o o2 = src1.get(i2);
            o o3 = src2.get(i2);
            if (o2.a.equals(o3.a) && o2.b == o3.b && o2.c == o3.c && o2.d == o3.d) continue;
            return false;
        }
        return true;
    }

    private void releaseWaterMark() {
        if (this.mRenderObjects == null || this.mRenderObjects.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.mRenderObjects.length; ++i2) {
            if (null == this.mRenderObjects[i2]) continue;
            this.mRenderObjects[i2].a();
            this.mRenderObjects[i2] = null;
        }
        this.mRenderObjects = null;
    }

    @Override
    public void afterDrawArrays() {
        super.afterDrawArrays();
        if (!this.mDrawWaterMarkEnabled) {
            return;
        }
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)this.mSrcBlendMode, (int)771);
        for (int i2 = 0; i2 < this.mRenderObjects.length; ++i2) {
            if (this.mRenderObjects[i2] == null) continue;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mRenderObjects[i2].c);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
            GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mRenderObjects[i2].a);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoord, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)TEXTURE_COORDS_BUFFER);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoord);
            GLES20.glDrawElements((int)4, (int)DRAW_ORDER.length, (int)5123, (Buffer)DRAW_ORDER_BUFFER);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoord);
        }
        GLES20.glDisable((int)3042);
    }

    public static final class a {
        public FloatBuffer a = null;
        public Bitmap b;
        public int c = -1;

        public final void a() {
            this.b = null;
            OpenGlUtils.deleteTexture(this.c);
            this.c = -1;
        }
    }
}

