/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import android.content.Context;
import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.videobase.a.b;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.d;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.k;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.c;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import com.tencent.ugc.videoprocessor.videoeffect.data.Motion;
import com.tencent.ugc.videoprocessor.videoeffect.data.MotionFilterConfig;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUDarkFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUGhostFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUGhostShadowFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUIllusionFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPULightingFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPULinearShadowFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUMirrorFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUPhontomFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPURockFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUSpiritOutFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUSplitScreenFilter;
import java.nio.FloatBuffer;
import java.util.List;

public class VideoEffectProcessor {
    private static final String TAG = "VideoEffectProcessor";
    private final MotionFilterConfig mMotionFilterConfig;
    private boolean mReverse = false;
    private final Context mContext;
    private b mCurrentEffect;
    private int mCurrentEffectType = -1;
    private long mTotalDuration = -1L;

    public VideoEffectProcessor(Context context) {
        this.mContext = context.getApplicationContext();
        this.mMotionFilterConfig = new MotionFilterConfig();
    }

    public void startEffect(int type, long startTime) {
        LiteavLog.i(TAG, "startEffect: type" + type + "  startTime:" + startTime);
        Motion motion = new Motion(type);
        new Motion(type).startTime = startTime;
        this.mMotionFilterConfig.addMotion(motion);
    }

    public void setReverse(boolean reverse, long totalDuration) {
        this.mReverse = reverse;
        if (!reverse) {
            this.mTotalDuration = -1L;
            return;
        }
        this.mTotalDuration = totalDuration;
    }

    private long getVideoPts(long pts) {
        if (this.mTotalDuration == -1L) {
            return pts;
        }
        return h.a(this.mTotalDuration - pts, 0L, this.mTotalDuration);
    }

    public void stopEffect(int type, long endTime) {
        LiteavLog.i(TAG, "stopEffect type: " + type + ", endTime: " + endTime);
        Motion motion = this.mMotionFilterConfig.getCurrentMotion();
        if (motion != null) {
            motion.endTime = endTime;
        }
    }

    public void deleteLastEffect() {
        LiteavLog.i(TAG, "==== deleteLastEffect ====");
        this.mMotionFilterConfig.deleteLastMotionEffect();
    }

    public void deleteAllEffect() {
        LiteavLog.i(TAG, "==== deleteAllEffect ====");
        this.mMotionFilterConfig.clear();
    }

    private long getMotionPts(Motion motion, long videoPts) {
        long l2;
        if (motion.startTime == -1L) {
            return -1L;
        }
        if (motion.endTime > 0L) {
            l2 = Math.min(motion.startTime, motion.endTime);
            long l3 = Math.max(motion.startTime, motion.endTime);
            if (videoPts < l2 || videoPts > l3) {
                return -1L;
            }
        }
        l2 = Math.abs(videoPts - motion.startTime);
        return motion.startTime + l2;
    }

    public PixelFrame processFrame(PixelFrame frame, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer, e pool) {
        Object object;
        long l2 = this.getVideoPts(frame.getTimestamp());
        Motion motion = this.getCurrentMotion(l2);
        if (motion == null || !this.isInMotionTime(motion, l2) || frame.getTimestamp() == 0L) {
            this.destroyCurrentEffect();
            return null;
        }
        if (this.mCurrentEffectType != motion.type) {
            this.destroyCurrentEffect();
        }
        boolean bl2 = false;
        if (this.mCurrentEffect == null) {
            this.mCurrentEffectType = motion.type;
            this.mCurrentEffect = this.createEffect(this.mCurrentEffectType);
            this.mCurrentEffect.initialize(pool);
            bl2 = true;
        }
        this.mCurrentEffect.onOutputSizeChanged(frame.getWidth(), frame.getHeight());
        if (this.mCurrentEffect instanceof TXCGPUEffectFilterBase) {
            object = (TXCGPUEffectFilterBase)this.mCurrentEffect;
            if (bl2) {
                ((TXCGPUEffectFilterBase)object).setNextFrameTimestamp(motion.startTime);
            } else {
                ((TXCGPUEffectFilterBase)object).setNextFrameTimestamp(this.getMotionPts(motion, l2));
            }
        }
        object = pool.a(frame.getWidth(), frame.getHeight());
        GLES20.glViewport((int)0, (int)0, (int)frame.getWidth(), (int)frame.getHeight());
        this.mCurrentEffect.onDraw(frame.getTextureId(), (d)object, cubeCoordsBuffer, textureCoordsBuffer);
        PixelFrame pixelFrame = ((d)object).a(OpenGlUtils.getCurrentContext());
        pixelFrame.setTimestamp(frame.getTimestamp());
        ((k)object).release();
        return pixelFrame;
    }

    public int getCurrentMotionType(long timestamp) {
        Motion motion = this.getCurrentMotion(timestamp = this.getVideoPts(timestamp));
        if (motion == null) {
            return -1;
        }
        return motion.type;
    }

    private Motion getCurrentMotion(long timestamp) {
        List<Motion> list = this.mMotionFilterConfig.getMotionList();
        if (c.a(list)) {
            return null;
        }
        Motion motion = null;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Motion motion2 = list.get(i2);
            if (this.getMotionPts(motion2, timestamp) <= 0L) continue;
            motion = motion2;
            break;
        }
        Motion motion3 = this.mMotionFilterConfig.getCurrentMotion();
        if (motion3.endTime == -1L) {
            motion = motion3;
        }
        return motion;
    }

    private boolean isInMotionTime(Motion motion, long timestamp) {
        return this.getMotionPts(motion, timestamp) > 0L;
    }

    public void destroy() {
        this.destroyCurrentEffect();
    }

    @NonNull
    private b createEffect(int effectType) {
        switch (effectType) {
            case 7: {
                return new TXCGPUGhostFilter();
            }
            case 10: {
                return new TXCGPUIllusionFilter();
            }
            case 9: {
                return new TXCGPUMirrorFilter();
            }
            case 8: {
                return new TXCGPULightingFilter(this.mContext);
            }
            case 5: {
                return new TXCGPUGhostShadowFilter();
            }
            case 4: {
                return new TXCGPULinearShadowFilter();
            }
            case 3: {
                return new TXCGPURockFilter();
            }
            case 6: {
                return new TXCGPUPhontomFilter();
            }
            case 0: {
                return new TXCGPUSpiritOutFilter();
            }
            case 1: {
                return new TXCGPUSplitScreenFilter();
            }
            case 2: {
                return new TXCGPUDarkFilter();
            }
        }
        return new b();
    }

    private void destroyCurrentEffect() {
        if (this.mCurrentEffect != null) {
            this.mCurrentEffect.uninitialize();
            this.mCurrentEffect = null;
        }
    }
}

