/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.api;

import android.text.TextUtils;
import android.view.Surface;
import cn.rongcloud.rtc.api.stream.RCRTCSurfaceTextureHelper;
import cn.rongcloud.rtc.api.stream.view.RCRTCBaseView;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.media.player.IMediaPlayer;
import cn.rongcloud.rtc.media.player.RCMediaPlayer;
import cn.rongcloud.rtc.media.player.api.PlayerEventListener;
import cn.rongcloud.rtc.media.player.api.PlayerModuleUtils;
import cn.rongcloud.rtc.plugin.player.IPlayer;
import cn.rongcloud.rtc.plugin.player.IPlayerPrepareListener;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;

public class RCPlayer
implements IPlayer {
    private RCMediaPlayer mMediaPlayer;
    private static final String TAG = RCPlayer.class.getSimpleName();
    private RCRTCBaseView mVideoView;
    private PlayerEventListener mPlayerEventListener;
    private String mPath = "";
    private int mFPS = 0;
    private RCRTCSurfaceTextureHelper textureHelper;

    protected RCPlayer() {
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"RCPlayer init"});
    }

    public void prepare(String path, RCRTCBaseView videoView, int videoFps, int startOnPrepared, IPlayerPrepareListener prepareListener) {
        long start = System.currentTimeMillis();
        this.prepare_internal(path, videoView, videoFps, startOnPrepared, prepareListener);
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"path|videoFps|logLevel|prepareTime", (Object[])new Object[]{path, videoFps, PlayerModuleUtils.getPlayerLogLevel().getCode(), System.currentTimeMillis() - start});
    }

    public void release() {
        long start = System.currentTimeMillis();
        this.release_internal();
        this.mPath = "";
        this.mFPS = 0;
        this.textureHelper = null;
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|releaseTime", (Object[])new Object[]{"release", System.currentTimeMillis() - start});
    }

    public void start() {
        if (this.mPlayerEventListener != null) {
            this.mPlayerEventListener.setStartState(1);
        }
        this._start();
    }

    public void restore(String newPath, IPlayerPrepareListener prepareListener) {
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|path|fps|newPath", (Object[])new Object[]{"restore", this.mPath, this.mFPS, newPath});
        String tmpPath = this.mPath;
        if (!(TextUtils.isEmpty((CharSequence)newPath) || !TextUtils.isEmpty((CharSequence)this.mPath) && TextUtils.equals((CharSequence)this.mPath, (CharSequence)newPath))) {
            tmpPath = newPath;
        }
        this.prepare_internal(tmpPath, this.mVideoView, this.mFPS, 1, prepareListener);
    }

    public void pause() {
        if (this.mMediaPlayer != null) {
            try {
                long start = System.currentTimeMillis();
                this.release_internal();
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|pauseTime", (Object[])new Object[]{"pause", System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                e.printStackTrace();
                ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"player pause error : " + e.getMessage()});
            }
        }
    }

    public void quitLooper() {
    }

    private void _start() {
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.start();
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"_start"});
            }
            catch (Exception e) {
                e.printStackTrace();
                ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"player _start error : " + e.getMessage()});
            }
        }
    }

    public void switchPlaybackAddress(String path, int videoFps, IPlayerPrepareListener prepareListener) {
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"switchPlaybackAddress. mMediaPlayer : " + (this.mMediaPlayer != null)});
        this.switchPlaybackAddress_internal(path, videoFps);
        this.prepare_internal(path, this.mVideoView, videoFps, 1, prepareListener);
    }

    private void switchPlaybackAddress_internal(String path, int videoFps) {
        this.releaseVideoView();
        try {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setOnErrorListener(null);
                this.mMediaPlayer.setOnPreparedListener(null);
                this.mMediaPlayer.setOnInfoListener(null);
                this.mMediaPlayer.setOnVideoSizeChangedListener(null);
                this.mMediaPlayer.stop();
                this.mMediaPlayer.reset();
                this.mMediaPlayer.release();
                RCMediaPlayer.native_profileEnd();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mMediaPlayer = null;
        PlayerModuleUtils.init(this.mMediaPlayer);
        this.mPlayerEventListener = null;
    }

    private void prepare_internal(String path, RCRTCBaseView videoView, int videoFps, int startOnPrepared, IPlayerPrepareListener prepareListener) {
        block5: {
            try {
                if (this.mMediaPlayer != null) {
                    this.mMediaPlayer.stop();
                    this.mMediaPlayer.reset();
                    this.mMediaPlayer.release();
                    this.mMediaPlayer = null;
                }
                RCMediaPlayer.loadLibrariesOnce(null);
                RCMediaPlayer.native_profileBegin("lib_RongRTC_player.so");
                this.mFPS = videoFps;
                this.mMediaPlayer = new RCMediaPlayer();
                PlayerModuleUtils.init(this.mMediaPlayer);
                RCMediaPlayer.native_setLogLevel(PlayerModuleUtils.getPlayerLogLevel().getCode());
                this.mMediaPlayer.setOption(4, "start-on-prepared", startOnPrepared);
                this.mMediaPlayer.setOption(4, "mediacodec", 0L);
                this.mMediaPlayer.setOption(1, "max-fps", videoFps);
                this.mMediaPlayer.setOption(1, "http-detect-range-support", 0L);
                this.mMediaPlayer.setOption(2, "skip_loop_filter", 48L);
                this.mMediaPlayer.setOption(4, "framedrop", 5L);
                this.mMediaPlayer.setLooping(true);
                this.mMediaPlayer.setOption(1, "max-buffer-size", 0x100000L);
                this.mMediaPlayer.setOption(4, "packet-buffering", 0L);
                this.mMediaPlayer.setOption(4, "min-frames", 50000L);
                this.mVideoView = videoView;
                if (this.mVideoView != null) {
                    this.onSetSurface();
                }
                this.mPath = path;
                this.mMediaPlayer.setDataSource(this.mPath);
                this.mPlayerEventListener = new PlayerEventListener(this){

                    @Override
                    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
                        super.onVideoSizeChanged(mp, width, height, sar_num, sar_den);
                        RCRTCSurfaceTextureHelper surfaceTextureHelper = RCPlayer.this.textureHelper;
                        if (surfaceTextureHelper != null) {
                            surfaceTextureHelper.setTextureSize(mp.getVideoWidth(), mp.getVideoHeight());
                        }
                    }
                };
                this.mMediaPlayer.setOnErrorListener(this.mPlayerEventListener);
                this.mMediaPlayer.setOnPreparedListener(this.mPlayerEventListener);
                this.mMediaPlayer.setOnInfoListener(this.mPlayerEventListener);
                this.mMediaPlayer.setOnVideoSizeChangedListener(this.mPlayerEventListener);
                this.mMediaPlayer.prepareAsync();
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|time", (Object[])new Object[]{"prepareAsync()", System.currentTimeMillis()});
                if (prepareListener != null) {
                    prepareListener.onCompletion();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"player module init error : " + e});
                if (prepareListener == null) break block5;
                prepareListener.onError();
            }
        }
    }

    private void onSetSurface() {
        this.textureHelper = RCRTCSurfaceTextureHelper.create((String)"RCPlayer_TextureHelperThread", (EglBase.Context)RTCEngineImpl.getInstance().getEglBaseContext());
        if (null == this.textureHelper) {
            ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"create RCRTCSurfaceTextureHelper failed"});
            return;
        }
        this.textureHelper.startListening(new RCRTCSurfaceTextureHelper.Sink(){

            public void onTexture(int textureWidth, int textureHeight, int oexTextureId, float[] transformMatrix, int rotation, long timestampNs) {
                RCPlayer.this.onSink(textureWidth, textureHeight, oexTextureId, transformMatrix, rotation, timestampNs);
            }
        });
        Surface surface = new Surface(this.textureHelper.getSurfaceTexture());
        this.mMediaPlayer.setSurface(surface);
    }

    private void onSink(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
        RCRTCBaseView mVideoView = this.mVideoView;
        RCRTCSurfaceTextureHelper textureHelper = this.textureHelper;
        if (mVideoView == null) {
            FinLog.e((String)TAG, (String)"RCRTCBaseView is null");
            return;
        }
        TextureBufferImpl frameBuffer = new TextureBufferImpl(width, height, VideoFrame.TextureBuffer.Type.OES, oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix((float[])transformMatrix), textureHelper.getHandler(), textureHelper.getYuvConverter(), null);
        VideoFrame frame = new VideoFrame((VideoFrame.Buffer)frameBuffer, rotation, timestamp);
        mVideoView.onFrame(frame);
    }

    private void release_internal() {
        this.releaseVideoView();
        try {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setOnErrorListener(null);
                this.mMediaPlayer.setOnPreparedListener(null);
                this.mMediaPlayer.setOnInfoListener(null);
                this.mMediaPlayer.setOnVideoSizeChangedListener(null);
                this.mMediaPlayer.stop();
                this.mMediaPlayer.reset();
                this.mMediaPlayer.release();
                RCMediaPlayer.native_profileEnd();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PlayerModuleUtils.setPlayerLogLevel(PlayerModuleUtils.PlayerLogLevel.LOG_ERROR);
        this.mMediaPlayer = null;
        PlayerModuleUtils.init(null);
        this.mPlayerEventListener = null;
    }

    private void releaseVideoView() {
        RCRTCBaseView mVideoView;
        RCRTCSurfaceTextureHelper textureHelper = this.textureHelper;
        if (textureHelper != null) {
            textureHelper.stopListening();
            textureHelper.dispose();
        }
        if ((mVideoView = this.mVideoView) != null) {
            mVideoView.release();
        }
    }

    public long getTcpSpeed() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getTcpSpeed();
        }
        return -1L;
    }
}

