/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

import android.graphics.Matrix;
import cn.rongcloud.rtc.core.NV12Buffer;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.utils.FinLog;
import java.nio.ByteBuffer;

public class RCRTCRemoteVideoFrame {
    private static final String TAG = "RCRTCRemoteVideoFrame";
    private final VideoFrame mVideoFrame;
    private final RTCBuffer mBuffer;
    private RCRTCVideoFrameType frameType = RCRTCVideoFrameType.UNKNOW;

    public RCRTCRemoteVideoFrame(VideoFrame videoFrame) {
        this.mVideoFrame = videoFrame;
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        if (buffer == null) {
            this.mBuffer = null;
            FinLog.e(TAG, "VideoFrame Buffer Is Null");
            return;
        }
        if (buffer instanceof VideoFrame.TextureBuffer) {
            this.frameType = RCRTCVideoFrameType.TEXTURE_OES;
            this.mBuffer = new RTCOESTextureBuffer((VideoFrame.TextureBuffer)buffer);
        } else if (buffer instanceof NV12Buffer) {
            this.frameType = RCRTCVideoFrameType.NV12;
            this.mBuffer = new RTCBufferNV12(videoFrame);
        } else {
            this.frameType = RCRTCVideoFrameType.UNKNOW;
            this.mBuffer = null;
        }
    }

    public RCRTCRemoteVideoFrame(VideoFrame videoFrame, RTCBuffer buffer, RCRTCVideoFrameType type) {
        this.frameType = type;
        this.mVideoFrame = videoFrame;
        this.mBuffer = buffer;
    }

    public RCRTCRemoteVideoFrame(VideoFrame videoFrame, ByteBuffer dataY, ByteBuffer dataU, ByteBuffer dataV) {
        this.frameType = RCRTCVideoFrameType.I420;
        this.mVideoFrame = videoFrame;
        VideoFrame.I420Buffer buffer = (VideoFrame.I420Buffer)videoFrame.getBuffer();
        this.mBuffer = new RTCBufferI420(buffer.getWidth(), buffer.getHeight(), dataY, buffer.getStrideY(), dataU, buffer.getStrideU(), dataV, buffer.getStrideV());
    }

    public RTCBuffer getBuffer() {
        return this.mBuffer;
    }

    public RCRTCVideoFrameType getFrameType() {
        return this.frameType;
    }

    public int getRotation() {
        return this.mVideoFrame.getRotation();
    }

    public long getTimestampNs() {
        return this.mVideoFrame.getTimestampNs();
    }

    public int getRotatedWidth() {
        return this.mVideoFrame.getRotatedWidth();
    }

    public int getRotatedHeight() {
        return this.mVideoFrame.getRotatedHeight();
    }

    public static interface RTCBuffer {
        public int getWidth();

        public int getHeight();
    }

    public class RTCBufferNV12
    implements RTCBuffer {
        VideoFrame frame;
        NV12Buffer buffer;

        RTCBufferNV12(VideoFrame frame) {
            this.frame = frame;
            this.buffer = (NV12Buffer)frame.getBuffer();
        }

        @Override
        public int getWidth() {
            return this.buffer.getWidth();
        }

        @Override
        public int getHeight() {
            return this.buffer.getHeight();
        }

        public ByteBuffer getData() {
            return this.buffer.getData();
        }

        public int getStride() {
            return this.buffer.getStride();
        }

        public int getSliceHeight() {
            return this.buffer.getSliceHeight();
        }
    }

    public class RTCBufferI420
    implements RTCBuffer {
        private final int width;
        private final int height;
        private final ByteBuffer dataY;
        private final int strideY;
        private final ByteBuffer dataU;
        private final int strideU;
        private final ByteBuffer dataV;
        private final int strideV;

        public RTCBufferI420(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV) {
            this.width = width;
            this.height = height;
            this.dataY = dataY;
            this.strideY = strideY;
            this.dataU = dataU;
            this.strideU = strideU;
            this.dataV = dataV;
            this.strideV = strideV;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public ByteBuffer getDataY() {
            return this.dataY;
        }

        public ByteBuffer getDataU() {
            return this.dataU;
        }

        public ByteBuffer getDataV() {
            return this.dataV;
        }

        public int getStrideY() {
            return this.strideY;
        }

        public int getStrideU() {
            return this.strideU;
        }

        public int getStrideV() {
            return this.strideV;
        }
    }

    public class RTCOESTextureBuffer
    implements RTCBuffer {
        private final VideoFrame.TextureBuffer mTextureBuffer;

        RTCOESTextureBuffer(VideoFrame.TextureBuffer textureBuffer) {
            this.mTextureBuffer = textureBuffer;
        }

        public VideoFrame.TextureBuffer.Type getType() {
            return this.mTextureBuffer.getType();
        }

        public int getTextureId() {
            return this.mTextureBuffer.getTextureId();
        }

        public Matrix getTransformMatrix() {
            return this.mTextureBuffer.getTransformMatrix();
        }

        public float[] getOriginalMatrix() {
            return this.mTextureBuffer.getOriginalMatrix();
        }

        @Override
        public int getWidth() {
            return this.mTextureBuffer.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mTextureBuffer.getHeight();
        }
    }

    public static class RTCRGBTextureBuffer
    implements RTCBuffer {
        private int textureId;
        private Matrix transformMatrix;
        private float[] originalMatrix;
        private int width;
        private int height;

        public RTCRGBTextureBuffer(int textureId, Matrix transformMatrix, float[] originalMatrix, int width, int height) {
            this.textureId = textureId;
            this.transformMatrix = transformMatrix;
            this.originalMatrix = originalMatrix;
            this.width = width;
            this.height = height;
        }

        public int getTextureId() {
            return this.textureId;
        }

        public Matrix getTransformMatrix() {
            return this.transformMatrix;
        }

        public float[] getOriginalMatrix() {
            return this.originalMatrix;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }
    }

    public static enum RCRTCVideoFrameType {
        NV12,
        I420,
        TEXTURE_2D,
        TEXTURE_OES,
        UNKNOW;

    }
}

