/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.base;

public enum RTCErrorCode {
    UnknownError("unknown error, please check the error code", -1),
    RongRTCCodeNoMatchedRoom("no matched room", 40003),
    ServiceNotOpened("not open voip service", 40010),
    ServerUserBlocked("user is blocked", 40021),
    RongRTCCodeTokenExpired("token expired", 42002),
    RongRTCCodeTokenNotInRoom("token not in the room", 42003),
    RongRTCCodeSignalServerNotConnect("init error, IM server not connected", 50000),
    RongRTCCodeParameterError("parameter error", 50001),
    RongRTCCodeJoinRepeatedRoom("join same rooms", 50002),
    RongRTCCodeNotInRoom("user not in room", 50003),
    RongRTCCodeVoIPNotAvailable("please check whether is VoIP service available", 50004),
    RongRTCCodeRTCTokenIsNull("rtc token is null", 50006),
    ILLEGALSTATE("IllegalState", 50007),
    JOIN_CHAT_ROOM_TIMEOUT("join chat room timeout", 50008),
    JOIN_CHAT_ROOM_INVOKE_IM_FAILED("join chat room invoke im failed", 50009),
    RongRTCCodeHttpTimeoutError("http request timeout ", 50010),
    RongRTCCodeHttpError("http response error", 50011),
    RongRTCCodeNetworkUnavailable("net work unavailable", 50012),
    InvalidProtocolMessageError("Invalid parsing protocol message error", 50013),
    RongRTCCodePublishDuplicateResources("publish duplicate resource", 50020),
    RongRTCCodeSessionNegotiateOfferError("set local sdp error", 50021),
    RongRTCCodeSessionNegotiateSetRemoteError("set remote sdp error", 50022),
    RongRTCCodePublishStreamsHasReachedMaxCount("publish stream reached max count", 50023),
    RongRTCCodeUnpublishNotExistStream("unpublish not exist stream", 50024),
    INCOMPATIBLE_WITH_PRIVATE_SERVER("public SDK can't be used as private", 50027),
    RongRTCCodeSubscribeNotExistResources("subscribe not exist resource", 50030),
    RongRTCCodeSubscribeDuplicateResources("subscribe duplicate resource", 50031),
    RongRTCCodeUnsubscribeNotExistResources("unsubscribe not exist resource", 50032),
    LIVEURLNOTINCURRENTROOM("LiveUrl not in current room", 50033),
    RongRTCCodeRTCConnectionIsNull("RTC connection is null", 50065),
    PublishMediaStreamIsNull("PublishMediaStreamIsNull", 50066),
    JsonParseError("parse json data error", 50069),
    LiveInfoIsNull("Live Info is Null", 50070),
    ConnectionAddStreamFailed("PeerConnection AddStream Failed", 50071),
    RongRTCCodeIMError("IM error", 50072),
    RongRTCTokenError("rtc token error", 50073),
    NOT_JOINED_MAIN_ROOM("Not joined the main room", 50074),
    OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM("Other room numbers cannot be the main room", 50075),
    CANCELLED_INVITATION_DOES_NOT_EXIST("The cancelled invitation does not exist", 50076),
    RESPONDING_INVITATION_DOES_NOT_EXIST("The responding invitation does not exist", 50077),
    MCU_PUBLISH_LIST_IS_NULL("mcu publish list is null", 50079),
    RongRTCCodeCDNCountReachToLimit("RongRTCCodeCDNCountReachToLimit", 50080),
    RECONNECT_ERROR("reconnect error", 50100),
    HARDWARE_VIDEO_ENCODER_INIT_ERROR("video hardware encoder init error", 51000),
    HARDWARE_VIDEO_ENCODER_ERROR("video hardware encoder error", 51001),
    HARDWARE_VIDEO_DECODER_INIT_ERROR("video hardware decoder init error", 51002),
    HARDWARE_VIDEO_DECODER_ERROR("video hardware decoder error", 51003),
    CAMERA_ID_NOT_AVAILABLE("cameraId not available", 51004),
    NO_CAMERA_DEVICE("no camera device", 51005),
    OPEN_CAMERA_FAILED("open camera failed", 51006),
    RTC_INIT_TIMEOUT("rtc init timeout", 51007),
    OPEN_CAMERA_NO_PERMISSION("open camera failed, no grant CAMERA permission !", 51008),
    CREATE_ANSWER_FAILURE("create Answer Failed", 51100),
    CAMERA_IS_RELEASED("camera is released", 51200),
    CANCEL_OPERATOR("cancel operator", 51201),
    AUDIO_MANAGER_IS_RELEASED("audioManager is released", 51202),
    STOP_CAMERA_FAILED("stop camera failed", 51203),
    OS_NOT_SUPPORT_FUNCTION("current OS not support this function", 51204),
    START_SCREEN_CAPTURE_FIRST("must start screen capture first", 51205),
    START_SCREEN_CAPTURE_UNKNOWN_MIXING_RULE("must start screen capture first", 51206),
    PLAYER_MODULE_NOT_FOUND("player module not found", 54001),
    CDN_ERROR_SERVER_DIED("CDN server died", 54002),
    CDN_INFO_VIDEO_INTERRUPT("media info video interrupt", 54008),
    PLAYER_MODULE_INIT_ERROR("player module init error", 54009),
    SCREEN_SHARE_NO_PERMISSION_ERROR("screen share no permission", 54010),
    SCREEN_SHARE_ALREADY_CAPTURE("already capture_screen", 54011),
    START_PRETEST_HARDWARE_FAILED("start pretest hardware failed", 54012),
    ROOM_TYPE_ERROR("room type error", 55001),
    SAME_ROLE_ERROR("same role error", 55002),
    SERVER_NOT_CONFIG_WISSE("server not config wisse", 56000),
    RTC_PROBE_TEST_NOT_START("RTC probe test not start", 56001),
    RTC_PROBE_TEST_STARTED("RTC Probe Testing", 56002),
    RTC_ICE_DISCONNECT("RTC Ice DisConnect", 56003),
    RTC_PROBE_INTERRUPT_BY_INTERNAL("RTC Probe Interrupt By Internal", 56004),
    ILLEGAL_OPERATION_FOR_JOINING("Illegal operation For Joining", 56005);

    private String reason;
    private int value;

    private RTCErrorCode(String reason, int value) {
        this.reason = reason;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getReason() {
        return this.reason;
    }

    public static RTCErrorCode valueOf(int value) {
        for (RTCErrorCode errorCode : RTCErrorCode.values()) {
            if (errorCode.value != value) continue;
            return errorCode;
        }
        UnknownError.setValue(value);
        return UnknownError;
    }

    public String toString() {
        return "RTCErrorCode{code: " + this.value + ", reason: '" + this.reason + "'}";
    }
}

