/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.HardwareVideoDecoderFactory;
import cn.rongcloud.rtc.core.PlatformSoftwareVideoDecoderFactory;
import cn.rongcloud.rtc.core.SoftwareVideoDecoderFactory;
import cn.rongcloud.rtc.core.VideoCodecInfo;
import cn.rongcloud.rtc.core.VideoDecoder;
import cn.rongcloud.rtc.core.VideoDecoderFactory;
import cn.rongcloud.rtc.core.VideoDecoderFallback;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class DefaultVideoDecoderFactory
extends VideoDecoderFactory {
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
    private final VideoDecoderFactory platformSoftwareVideoDecoderFactory;

    public DefaultVideoDecoderFactory(EglBase.Context eglContext) {
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(eglContext);
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(eglContext);
    }

    DefaultVideoDecoderFactory(VideoDecoderFactory hardwareVideoDecoderFactory) {
        this.hardwareVideoDecoderFactory = hardwareVideoDecoderFactory;
        this.platformSoftwareVideoDecoderFactory = null;
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoDecoder softwareDecoder = this.softwareVideoDecoderFactory.createDecoder(codecType);
        VideoDecoder hardwareDecoder = this.hardwareVideoDecoderFactory.createDecoder(codecType);
        if (softwareDecoder == null && this.platformSoftwareVideoDecoderFactory != null) {
            softwareDecoder = this.platformSoftwareVideoDecoderFactory.createDecoder(codecType);
        }
        if (hardwareDecoder != null && softwareDecoder != null) {
            ReportUtil.libStatus(ReportUtil.TAG.DECODER_SELECTED, "method|status", "- createDecoder()", "fallback:soft, primary:hard");
            return new VideoDecoderFallback(softwareDecoder, hardwareDecoder);
        }
        String mode = hardwareDecoder != null ? "hard" : "soft";
        ReportUtil.libStatus(ReportUtil.TAG.DECODER_SELECTED, "method|status", "- createDecoder()", mode);
        return hardwareDecoder != null ? hardwareDecoder : softwareDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> supportedCodecInfos = new LinkedHashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        supportedCodecInfos.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        if (this.platformSoftwareVideoDecoderFactory != null) {
            supportedCodecInfos.addAll(Arrays.asList(this.platformSoftwareVideoDecoderFactory.getSupportedCodecs()));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }
}

