/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.CalledByNative;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionDescription {
    public final Type type;
    public final String description;

    @CalledByNative
    public SessionDescription(Type type, String description) {
        this.type = type;
        this.description = description;
    }

    @CalledByNative
    String getDescription() {
        return this.description;
    }

    @CalledByNative
    String getTypeInCanonicalForm() {
        return this.type.canonicalForm();
    }

    public String toJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("description", (Object)this.description);
            return jsonObject.toString(4);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static enum Type {
        OFFER,
        PRANSWER,
        ANSWER;


        public String canonicalForm() {
            return this.name().toLowerCase(Locale.US);
        }

        @CalledByNative(value="Type")
        public static Type fromCanonicalForm(String canonical) {
            return Type.valueOf(Type.class, canonical.toUpperCase(Locale.US));
        }
    }
}

