/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.action;

import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.engine.InRoomState;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubAction;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class PubSubActionQueue {
    private static final String TAG = "PubSubActionQueue";
    private Queue<PubSubAction> mQueue = new LinkedList<PubSubAction>();
    @Deprecated
    private InRoomState mInRoomState;
    private boolean mActionRunning = false;

    @Deprecated
    public PubSubActionQueue(InRoomState inRoomState) {
        this.mInRoomState = inRoomState;
    }

    public PubSubActionQueue() {
    }

    @Deprecated
    public void offer(int actionType, List<? extends RCRTCStream> streams, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, null, true);
    }

    @Deprecated
    public void offer(int actionType, List<? extends RCRTCStream> streams, boolean switchCallbackThread, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, null, switchCallbackThread);
    }

    @Deprecated
    public void offer(int actionType, List<? extends RCRTCStream> streams, Object extra, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, extra, true);
    }

    @Deprecated
    public void offer(int actionType, List<? extends RCRTCStream> streams, IRCRTCFailedCallback callback, Object extra, boolean switchCallbackThread) {
        this.offer(new PubSubAction(actionType, switchCallbackThread, streams, extra, callback){

            @Override
            protected void execute() {
                switch (this.getActionType()) {
                    case 1: {
                        PubSubActionQueue.this.mInRoomState.publishStreams(this.getStreams(), this.getCallback());
                        break;
                    }
                    case 2: {
                        PubSubActionQueue.this.mInRoomState.unpublishedStreams(this.getStreams(), this.getCallback());
                        break;
                    }
                    case 3: {
                        PubSubActionQueue.this.mInRoomState.subscribeStreams(this.getStreams(), this.getCallback());
                        break;
                    }
                    case 5: {
                        PubSubActionQueue.this.mInRoomState.unsubscribeStreams(this.getStreams(), false, "", this.getCallback());
                        break;
                    }
                    case 6: {
                        PubSubActionQueue.this.mInRoomState.switchStream((Boolean)this.getExtra(), this.getStreams(), this.getCallback());
                        break;
                    }
                    case 7: {
                        PubSubActionQueue.this.mInRoomState.exchangeVideoSize(this.getCallback());
                        break;
                    }
                    case 4: {
                        PubSubActionQueue.this.mInRoomState.resubscribeStreams(this.getCallback());
                        break;
                    }
                    case 8: {
                        PubSubActionQueue.this.mInRoomState.joinOtherExchangeRemoteSDP(this.getCallback());
                        break;
                    }
                    case 9: {
                        PubSubActionQueue.this.mInRoomState.unsubscribeStreams(this.getStreams(), (Boolean)this.getExtra(), "", this.getCallback());
                        break;
                    }
                    case 10: {
                        PubSubActionQueue.this.mInRoomState.reExchangeSDP(this.getCallback());
                    }
                }
            }
        });
    }

    private void nextPubSubAction() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        if (this.mActionRunning) {
            return;
        }
        PubSubAction action = this.poll();
        if (action == null) {
            return;
        }
        this.mActionRunning = true;
        ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUEPOLL, "type|size", action.getActionType(), this.mQueue.size());
        action.execute();
    }

    public boolean offer(PubSubAction action) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUEOFFER, "type|size", action.getActionType(), this.mQueue.size());
        action.setCompleteListener(new PubSubAction.ICompleteListener(){

            @Override
            public void onComplete() {
                PubSubActionQueue.this.mActionRunning = false;
                PubSubActionQueue.this.nextPubSubAction();
            }
        });
        boolean res = this.mQueue.offer(action);
        this.nextPubSubAction();
        return res;
    }

    public void checkIsAllowNeutralize(PubSubAction action) {
        for (PubSubAction ac : this.mQueue) {
            switch (action.getActionType()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private PubSubAction poll() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        return this.mQueue.poll();
    }

    public void clear() {
        PubSubAction action;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        while ((action = this.mQueue.poll()) != null) {
            ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUECANCEL, "type", action.getActionType());
            action.cancel();
        }
        this.mActionRunning = false;
        this.mQueue.clear();
    }

    public boolean hasPubAction() {
        for (PubSubAction pubSubAction : this.mQueue) {
            if (pubSubAction.getActionType() != 1) continue;
            return true;
        }
        return false;
    }
}

