/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import io.rong.common.RLog;

public class RongRTCGestureDetector
implements ScaleGestureDetector.OnScaleGestureListener,
GestureDetector.OnGestureListener {
    private static final String TAG = "RongRTCGestureDetector";
    private Matrix matrix;
    private final float[] matrixValues = new float[9];
    private int layoutWidth;
    private int layoutHeight;
    private float preScale = 1.0f;
    private ScaleGestureDetector mScaleGesture;
    private GestureDetector mGesture;
    private Context mContext;
    private RongRTCGestureEvents gestureEvents;
    private RongRTCGestureLayoutEvents layoutEvents;
    private boolean scaling = true;
    private boolean isCheckTopAndBottom = true;
    private boolean isCheckLeftAndRight = true;
    private boolean checkBox = true;
    private float minScale = 1.0f;
    private float maxScale = 4.0f;

    public RongRTCGestureDetector(Context context) {
        this(context, null);
    }

    public RongRTCGestureDetector(Context context, RongRTCGestureEvents events) {
        this.mContext = context;
        this.gestureEvents = events;
        this.init();
    }

    public void setLayoutEvents(RongRTCGestureLayoutEvents layoutEvents) {
        this.layoutEvents = layoutEvents;
    }

    private synchronized void init() {
        this.matrix = new Matrix();
        this.matrix.reset();
        this.mScaleGesture = new ScaleGestureDetector(this.mContext, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mGesture = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)this);
    }

    public synchronized void setLayoutSize(int layoutWidth, int layoutHeight) {
        this.layoutWidth = layoutWidth;
        this.layoutHeight = layoutHeight;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    public void setCheckTopAndBottom(boolean checkTopAndBottom) {
        this.isCheckTopAndBottom = checkTopAndBottom;
    }

    public void setCheckLeftAndRight(boolean checkLeftAndRight) {
        this.isCheckLeftAndRight = checkLeftAndRight;
    }

    public void setCheckBox(boolean checkBox) {
        this.checkBox = checkBox;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public void requestSize() {
        this.updateTranslateAction();
    }

    public void setGestureEvents(RongRTCGestureEvents gestureEvents) {
        this.gestureEvents = gestureEvents;
    }

    public synchronized boolean onTouchEvent(MotionEvent event) {
        if (null == this.mScaleGesture || null == this.mGesture) {
            return false;
        }
        this.mScaleGesture.onTouchEvent(event);
        return this.mGesture.onTouchEvent(event);
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (!this.scaling) {
            return true;
        }
        float scaleFactor = detector.getScaleFactor();
        float scale = scaleFactor / this.preScale;
        float focusX = detector.getFocusX();
        float focusY = detector.getFocusY();
        RLog.d((String)TAG, (String)("onScale: " + scale + " focusX : " + focusX + " focusY:" + focusY + " factorScale : " + scaleFactor));
        this.matrix.postScale(scale, scale, focusX, focusY);
        this.checkScale(focusX, focusY);
        this.checkMatrixBounds();
        this.updateScaleGestureAction(focusX, focusY);
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        RLog.d((String)TAG, (String)"onScaleBegin: ");
        this.scaling = true;
        this.preScale = 1.0f;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        RLog.d((String)TAG, (String)"onScaleEnd: ");
        this.scaling = false;
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.scaling) {
            return true;
        }
        float scrollDx = distanceX * -1.0f;
        float scrollDy = distanceY * -1.0f;
        this.matrix.postTranslate(scrollDx, scrollDy);
        this.checkMatrixBounds();
        this.updateTranslateAction();
        return true;
    }

    public void onLongPress(MotionEvent e) {
        RLog.d((String)TAG, (String)"onLongPress: ");
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    private void updateTranslateAction() {
        RectF rect = this.getMatrixRectF();
        if (this.gestureEvents != null) {
            float width = rect.width();
            float height = rect.height();
            float translateX = this.getMatrixTranslateX();
            float translateY = this.getMatrixTranslateY();
            RLog.d((String)TAG, (String)("updateTranslateAction: translateX: " + translateX + " translateY " + translateY));
            float transPercentX = translateX / width;
            float transPercentY = translateY / height;
            this.gestureEvents.onTranslate(transPercentX, transPercentY);
        }
        if (this.layoutEvents != null) {
            this.layoutEvents.onGestureLayout((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
        }
    }

    private void updateScaleGestureAction(float focusX, float focusY) {
        float totalScale = this.getScale();
        RLog.d((String)TAG, (String)("updateGestureAction: scale : " + totalScale));
        if (this.gestureEvents != null) {
            this.gestureEvents.onScale(totalScale, focusX, focusX);
        }
        this.updateTranslateAction();
    }

    public final float getScale() {
        this.matrix.getValues(this.matrixValues);
        return this.matrixValues[0];
    }

    public final float getMatrixTranslateX() {
        this.matrix.getValues(this.matrixValues);
        return this.matrixValues[2];
    }

    public final float getMatrixTranslateY() {
        this.matrix.getValues(this.matrixValues);
        return this.matrixValues[5];
    }

    private void checkScale(float focusX, float focusY) {
        float currentScale = this.getScale();
        float needScale = 1.0f;
        if (currentScale < this.minScale) {
            needScale = this.minScale / currentScale;
        } else if (currentScale > this.maxScale) {
            needScale = this.maxScale / currentScale;
        }
        this.matrix.postScale(needScale, needScale, focusX, focusY);
    }

    private void checkMatrixBounds() {
        if (!this.checkBox) {
            return;
        }
        RectF rect = this.getMatrixRectF();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (rect.top > 0.0f && this.isCheckTopAndBottom) {
            deltaY = -rect.top;
        }
        if (rect.bottom < (float)this.layoutHeight && this.isCheckTopAndBottom) {
            deltaY = (float)this.layoutHeight - rect.bottom;
        }
        if (rect.left > 0.0f && this.isCheckLeftAndRight) {
            deltaX = -rect.left;
        }
        if (rect.right < (float)this.layoutWidth && this.isCheckLeftAndRight) {
            deltaX = (float)this.layoutWidth - rect.right;
        }
        this.matrix.postTranslate(deltaX, deltaY);
    }

    private RectF getMatrixRectF() {
        RectF rect = new RectF();
        rect.set(0.0f, 0.0f, (float)this.layoutWidth, (float)this.layoutHeight);
        this.matrix.mapRect(rect);
        RLog.d((String)TAG, (String)("scroll left : " + rect.left + " top: " + rect.top + " right : " + rect.right + " bottom : " + rect.bottom));
        return rect;
    }

    public static interface RongRTCGestureLayoutEvents {
        public void onGestureLayout(int var1, int var2, int var3, int var4);
    }

    public static interface RongRTCGestureEvents {
        public void onScale(float var1, float var2, float var3);

        public void onTranslate(float var1, float var2);
    }
}

