/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.os.SystemClock;

public class TimeCorrector {
    private long baseTime = 0L;
    private long interval;
    private long elapsedTime = 0L;

    public TimeCorrector(long interval) {
        this.interval = interval;
    }

    public long waitToNextInterval() {
        if (this.baseTime == 0L) {
            this.baseTime = SystemClock.elapsedRealtime();
        }
        this.elapsedTime += this.interval;
        long waitTime = this.baseTime + this.elapsedTime - SystemClock.elapsedRealtime();
        SystemClock.sleep((long)(waitTime > 0L ? waitTime : 0L));
        return this.elapsedTime;
    }

    public void increaseTime(boolean isWait) {
        if (this.baseTime == 0L) {
            this.baseTime = SystemClock.elapsedRealtime();
        }
        this.baseTime += this.interval;
        long waitTime = this.baseTime - SystemClock.elapsedRealtime();
        if (isWait) {
            SystemClock.sleep((long)(waitTime > 0L ? waitTime : 0L));
        }
    }
}

