/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.handler;

import android.os.Handler;
import android.util.Log;
import com.cooleshow.ffmpegcmd.FFmpegCmd;
import com.cooleshow.ffmpegcmd.listener.OnHandleListener;
import com.cooleshow.ffmpegcmd.model.MediaBean;
import com.cooleshow.ffmpegcmd.tools.JsonParseTool;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FFmpegHandler {
    private static final String TAG = FFmpegHandler.class.getSimpleName();
    public static final int MSG_BEGIN = 9012;
    public static final int MSG_PROGRESS = 1002;
    public static final int MSG_FINISH = 1112;
    public static final int MSG_CONTINUE = 2012;
    public static final int MSG_TOAST = 5432;
    public static final int MSG_INFO = 2222;
    private final Handler mHandler;
    private boolean isContinue = false;

    public FFmpegHandler(Handler mHandler) {
        this.mHandler = mHandler;
    }

    public void isContinue(boolean isContinue) {
        this.isContinue = isContinue;
    }

    public int executeFFmpegCmdSync(String[] commandLine) {
        return FFmpegCmd.executeSync(commandLine);
    }

    public void executeFFmpegCmd(String[] commandLine) {
        if (commandLine == null) {
            return;
        }
        this.mHandler.removeMessages(1002);
        this.mHandler.removeCallbacksAndMessages(null);
        FFmpegCmd.execute(commandLine, new OnHandleListener(){

            @Override
            public void onBegin() {
                Log.i((String)TAG, (String)"handle onBegin...");
                FFmpegHandler.this.mHandler.obtainMessage(9012).sendToTarget();
            }

            @Override
            public void onMsg(@NotNull String msg) {
                FFmpegHandler.this.mHandler.obtainMessage(2222, (Object)msg).sendToTarget();
            }

            @Override
            public void onProgress(int progress, int duration) {
                FFmpegHandler.this.mHandler.obtainMessage(1002, progress, duration).sendToTarget();
            }

            @Override
            public void onEnd(int resultCode, String resultMsg) {
                Log.i((String)TAG, (String)"handle onEnd...");
                if (FFmpegHandler.this.isContinue) {
                    FFmpegHandler.this.mHandler.obtainMessage(2012).sendToTarget();
                } else {
                    FFmpegHandler.this.mHandler.obtainMessage(1112).sendToTarget();
                }
            }
        });
    }

    public void cancelExecute(boolean cancel) {
        FFmpegCmd.cancelTask(cancel);
    }

    public void executeFFmpegCmds(List<String[]> commandList) {
        if (commandList == null) {
            return;
        }
        FFmpegCmd.execute(commandList, new OnHandleListener(){

            @Override
            public void onBegin() {
                Log.i((String)TAG, (String)"handle onBegin...");
                FFmpegHandler.this.mHandler.obtainMessage(9012).sendToTarget();
            }

            @Override
            public void onMsg(@NotNull String msg) {
            }

            @Override
            public void onProgress(int progress, int duration) {
                FFmpegHandler.this.mHandler.obtainMessage(1002, progress, duration).sendToTarget();
            }

            @Override
            public void onEnd(int resultCode, String resultMsg) {
                Log.i((String)TAG, (String)"handle onEnd...");
                if (FFmpegHandler.this.isContinue) {
                    FFmpegHandler.this.mHandler.obtainMessage(2012).sendToTarget();
                } else {
                    FFmpegHandler.this.mHandler.obtainMessage(1112).sendToTarget();
                }
            }
        });
    }

    public void executeFFprobeCmd(String[] commandLine) {
        if (commandLine == null) {
            return;
        }
        FFmpegCmd.executeProbe(commandLine, new OnHandleListener(){

            @Override
            public void onBegin() {
                Log.i((String)TAG, (String)"handle ffprobe onBegin...");
                FFmpegHandler.this.mHandler.obtainMessage(9012).sendToTarget();
            }

            @Override
            public void onMsg(@NotNull String msg) {
            }

            @Override
            public void onProgress(int progress, int duration) {
            }

            @Override
            public void onEnd(int resultCode, String resultMsg) {
                Log.i((String)TAG, (String)("handle ffprobe onEnd result=" + resultMsg));
                MediaBean mediaBean = null;
                if (resultMsg != null && !resultMsg.isEmpty()) {
                    mediaBean = JsonParseTool.INSTANCE.parseMediaFormat(resultMsg);
                }
                FFmpegHandler.this.mHandler.obtainMessage(1112, mediaBean).sendToTarget();
            }
        });
    }
}

