/*
 * Decompiled with CFR 0.152.
 */
package com.cooleshow.ffmpegcmd.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import androidx.annotation.Keep;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@Keep
public class ImageConverter {
    private byte[] yuv;
    private int[] argb;
    private Rect mRect;
    private int[] pixels;
    private final Matrix mMatrix = new Matrix();
    private ByteArrayOutputStream mOutputStream;
    private static final boolean useSystem = false;

    public Bitmap yuv2bitmap(byte[] data, int width, int height) {
        return this.yuvToBitmapFormula(data, width, height);
    }

    private Bitmap yuv2bitmapSystem(byte[] data, int width, int height) {
        Bitmap bmp = null;
        try {
            YuvImage image = new YuvImage(data, 17, width, height, null);
            if (this.mRect == null) {
                this.mRect = new Rect(0, 0, width, height);
            }
            if (this.mOutputStream == null) {
                this.mOutputStream = new ByteArrayOutputStream();
            } else {
                this.mOutputStream.reset();
            }
            image.compressToJpeg(this.mRect, 100, (OutputStream)this.mOutputStream);
            bmp = BitmapFactory.decodeByteArray((byte[])this.mOutputStream.toByteArray(), (int)0, (int)this.mOutputStream.size());
        }
        catch (Exception ex) {
            Log.e((String)"ImageConverter", (String)("Error:" + ex.getMessage()));
        }
        return bmp;
    }

    private int yuvToARGB(int y, int u, int v) {
        int r = y + (int)(1.402f * (float)u);
        int g = y - (int)(0.344f * (float)v + 0.714f * (float)u);
        int b = y + (int)(1.772f * (float)v);
        r = r > 255 ? 255 : Math.max(r, 0);
        g = g > 255 ? 255 : Math.max(g, 0);
        b = b > 255 ? 255 : Math.max(b, 0);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private Bitmap yuvToBitmapFormula(byte[] data, int width, int height) {
        int size;
        if (this.pixels == null) {
            this.pixels = new int[width * height];
        }
        int offset = size = width * height;
        int i = 0;
        int k = 0;
        while (i < size) {
            int y1 = data[i] & 0xFF;
            int y2 = data[i + 1] & 0xFF;
            int y3 = data[width + i] & 0xFF;
            int y4 = data[width + i + 1] & 0xFF;
            int u = data[offset + k] & 0xFF;
            int v = data[offset + k + 1] & 0xFF;
            this.pixels[i] = this.yuvToARGB(y1, u -= 128, v -= 128);
            this.pixels[i + 1] = this.yuvToARGB(y2, u, v);
            this.pixels[width + i] = this.yuvToARGB(y3, u, v);
            this.pixels[width + i + 1] = this.yuvToARGB(y4, u, v);
            if (i != 0 && (i + 2) % width == 0) {
                i += width;
            }
            i += 2;
            k += 2;
        }
        return Bitmap.createBitmap((int[])this.pixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public Bitmap rotateBitmap(Bitmap source, float angle) {
        this.mMatrix.reset();
        this.mMatrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)this.mMatrix, (boolean)true);
    }

    public Bitmap rotateAndFlipBitmap(Bitmap source, float angle, boolean xFlip, boolean yFlip) {
        this.mMatrix.reset();
        this.mMatrix.postRotate(angle);
        this.mMatrix.postScale(xFlip ? -1.0f : 1.0f, yFlip ? -1.0f : 1.0f, (float)source.getWidth() / 2.0f, (float)source.getHeight() / 2.0f);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)this.mMatrix, (boolean)true);
    }

    public byte[] rgbaToYUV420p(Bitmap bitmap, int width, int height) {
        int frameSize = width * height;
        int index = 0;
        int yIndex = 0;
        int uIndex = frameSize;
        int vIndex = frameSize * 5 / 4;
        if (this.argb == null) {
            this.argb = new int[width * height];
        }
        if (this.yuv == null) {
            this.yuv = new byte[width * height * 3 / 2];
        }
        bitmap.getPixels(this.argb, 0, width, 0, 0, width, height);
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int R = (this.argb[index] & 0xFF0000) >> 16;
                int G = (this.argb[index] & 0xFF00) >> 8;
                int B = this.argb[index] & 0xFF;
                int Y = (66 * R + 129 * G + 25 * B + 128 >> 8) + 16;
                this.yuv[yIndex++] = (byte)Y;
                if (j % 2 == 0 && i % 2 == 0) {
                    int U = (-38 * R - 74 * G + 112 * B + 128 >> 8) + 128;
                    int V = (112 * R - 94 * G - 18 * B + 128 >> 8) + 128;
                    this.yuv[uIndex++] = (byte)U;
                    this.yuv[vIndex++] = (byte)V;
                }
                ++index;
            }
        }
        return this.yuv;
    }

    public void close() {
        if (this.mOutputStream != null) {
            try {
                this.mOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

