/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.midifile;

import java.util.Comparator;

public class MidiNote
implements Comparator<MidiNote> {
    private int starttime;
    private int channel;
    private int notenumber;
    private int duration;

    public MidiNote(int starttime, int channel, int notenumber, int duration) {
        this.starttime = starttime;
        this.channel = channel;
        this.notenumber = notenumber;
        this.duration = duration;
    }

    public int getStartTime() {
        return this.starttime;
    }

    public void setStartTime(int value) {
        this.starttime = value;
    }

    public int getEndTime() {
        return this.starttime + this.duration;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int value) {
        this.channel = value;
    }

    public int getNumber() {
        return this.notenumber;
    }

    public void setNumber(int value) {
        this.notenumber = value;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int value) {
        this.duration = value;
    }

    public void NoteOff(int endtime) {
        this.duration = endtime - this.starttime;
    }

    @Override
    public int compare(MidiNote x, MidiNote y) {
        if (x.getStartTime() == y.getStartTime()) {
            return x.getNumber() - y.getNumber();
        }
        return x.getStartTime() - y.getStartTime();
    }

    public MidiNote Clone() {
        return new MidiNote(this.starttime, this.channel, this.notenumber, this.duration);
    }

    public String toString() {
        String[] scale = new String[]{"A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#"};
        return String.format("MidiNote channel=%1$s number=%2$s %3$s start=%4$s duration=%5$s", this.channel, this.notenumber, scale[(this.notenumber + 3) % 12], this.starttime, this.duration);
    }
}

