/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.view;

import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.utils.NoteScale;
import java.util.Comparator;

public class WhiteNote
implements Comparator<WhiteNote> {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    public static final int E = 4;
    public static final int F = 5;
    public static final int G = 6;
    public static WhiteNote TopTreble = new WhiteNote(4, 5);
    public static WhiteNote BottomTreble = new WhiteNote(5, 4);
    public static WhiteNote TopBass = new WhiteNote(6, 3);
    public static WhiteNote BottomBass = new WhiteNote(0, 3);
    public static WhiteNote MiddleC = new WhiteNote(2, 4);
    private int letter;
    private int octave;

    public int getLetter() {
        return this.letter;
    }

    public int getOctave() {
        return this.octave;
    }

    public WhiteNote(int letter, int octave) {
        if (letter < 0 || letter > 6) {
            throw new IllegalArgumentException();
        }
        this.letter = letter;
        this.octave = octave;
    }

    public int Dist(WhiteNote w) {
        return (this.octave - w.octave) * 7 + (this.letter - w.letter);
    }

    public WhiteNote Add(int amount) {
        int num = this.octave * 7 + this.letter;
        if ((num += amount) < 0) {
            num = 0;
        }
        return new WhiteNote(num % 7, num / 7);
    }

    public int getNumber() {
        int offset = 0;
        switch (this.letter) {
            case 0: {
                offset = 0;
                break;
            }
            case 1: {
                offset = 2;
                break;
            }
            case 2: {
                offset = 3;
                break;
            }
            case 3: {
                offset = 5;
                break;
            }
            case 4: {
                offset = 7;
                break;
            }
            case 5: {
                offset = 8;
                break;
            }
            case 6: {
                offset = 10;
                break;
            }
            default: {
                offset = 0;
            }
        }
        return NoteScale.ToNumber(offset, this.octave);
    }

    @Override
    public int compare(WhiteNote x, WhiteNote y) {
        return x.Dist(y);
    }

    public static WhiteNote Max(WhiteNote x, WhiteNote y) {
        if (x.Dist(y) > 0) {
            return x;
        }
        return y;
    }

    public static WhiteNote Min(WhiteNote x, WhiteNote y) {
        if (x.Dist(y) < 0) {
            return x;
        }
        return y;
    }

    public static WhiteNote Top(Clef clef) {
        if (clef == Clef.Treble) {
            return TopTreble;
        }
        return TopBass;
    }

    public static WhiteNote Bottom(Clef clef) {
        if (clef == Clef.Treble) {
            return BottomTreble;
        }
        return BottomBass;
    }

    public String toString() {
        String[] s = new String[]{"A", "B", "C", "D", "E", "F", "G"};
        return s[this.letter] + this.octave;
    }
}

