/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.IAudioEffectManager;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCMicOutputStream;
import cn.rongcloud.rtc.audioroute.RCAudioRouteChangeListener;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCSyncCallBack;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCAudioOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCAudioStreamConfigImpl;
import cn.rongcloud.rtc.center.stream.RCDefaultStream;
import cn.rongcloud.rtc.core.AudioTrack;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.audio.AudioEffectManager;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.earmonitor.EarMonitorManager;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class RCMicOutputStreamImpl
extends RCAudioOutputStreamImpl
implements RCRTCMicOutputStream,
RCDefaultStream {
    private static final String TAG = "RCMicOutputStreamImpl";
    private AudioDeviceManager mAudioDeviceManager;
    private AudioEffectManager mAudioEffectManager;
    private EarMonitorManager mEarMonitorManager;
    private RCRTCAudioStreamConfig audioConfig;
    private AtomicBoolean needUpdateConfig = new AtomicBoolean(false);
    private RCRTCParamsType.AudioQuality audioQuality = RCRTCParamsType.AudioQuality.SPEECH;
    private RCRTCParamsType.AudioScenario audioScenario = RCRTCParamsType.AudioScenario.DEFAULT;

    public RCMicOutputStreamImpl(String userId, AudioDeviceManager audioDeviceManager, AudioEffectManager audioEffectManager) {
        super("RongCloudRTC", userId);
        this.mAudioEffectManager = audioEffectManager;
        this.mAudioDeviceManager = audioDeviceManager;
        this.mAudioDeviceManager.registerAudioBufferListener(this.mAudioEffectManager);
        this.mAudioDeviceManager.setAudioDataListener(new IRCRTCAudioDataListener(){

            @Override
            public byte[] onAudioFrame(RCRTCAudioFrame rcRTCAudioFrame) {
                IRCRTCAudioDataListener audioDataListener = RCMicOutputStreamImpl.this.mAudioDataListener;
                if (audioDataListener != null) {
                    return audioDataListener.onAudioFrame(rcRTCAudioFrame);
                }
                return null;
            }
        });
        this.mAudioDeviceManager.setMixedAudioDataListener(new IRCRTCAudioDataListener(){

            @Override
            public byte[] onAudioFrame(RCRTCAudioFrame rcRTCAudioFrame) {
                IRCRTCAudioDataListener audioDataListener = RCMicOutputStreamImpl.this.mMixedAudioDataListener;
                if (audioDataListener != null) {
                    return audioDataListener.onAudioFrame(rcRTCAudioFrame);
                }
                return null;
            }
        });
        RCRTCConfigImpl rtcConfig = RTCEngineImpl.getInstance().getRTCConfig();
        if (rtcConfig != null) {
            this.mEarMonitorManager = new EarMonitorManager();
            this.mEarMonitorManager.init(RTCEngineImpl.getInstance().getContext(), this.mAudioDeviceManager);
        }
    }

    @Override
    public void adjustRecordingVolume(int volume) {
        ReportUtil.appTask(ReportUtil.TAG.ADJUSTRECORDINGVOLUME, "volume", volume);
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.adjustRecordingVolume(volume);
            ReportUtil.appRes(ReportUtil.TAG.ADJUSTRECORDINGVOLUME, "code", 0);
        } else {
            ReportUtil.appError(ReportUtil.TAG.ADJUSTRECORDINGVOLUME, RTCErrorCode.AUDIO_MANAGER_IS_RELEASED);
        }
    }

    @Override
    public int getRecordingVolume() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.getRecodVolume();
        }
        return 0;
    }

    @Override
    public void release() {
        EarMonitorManager earMonitorManager;
        AudioEffectManager audioEffectManager;
        super.release();
        this.resetStream();
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.setAudioDataListener(null);
            audioDeviceManager.release();
            this.mAudioDeviceManager = null;
        }
        if ((audioEffectManager = this.mAudioEffectManager) != null) {
            audioEffectManager.release();
            this.mAudioEffectManager = null;
        }
        if ((earMonitorManager = this.mEarMonitorManager) != null) {
            earMonitorManager.release();
            this.mEarMonitorManager = null;
        }
        this.audioQuality = RCRTCParamsType.AudioQuality.SPEECH;
        this.audioScenario = RCRTCParamsType.AudioScenario.DEFAULT;
    }

    @Override
    public void resetStream() {
        EarMonitorManager earMonitorManager;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        this.setResourceState(RCRTCResourceState.NORMAL);
        if (audioDeviceManager != null && this.isMicrophoneDisable()) {
            audioDeviceManager.resetData();
        }
        this.setRemoteAudioPCMBufferListener(null);
        this.track = null;
        this.mAudioDataListener = null;
        AudioEffectManager audioEffectManager = this.mAudioEffectManager;
        if (audioEffectManager != null) {
            audioEffectManager.stopAllEffects();
        }
        if ((earMonitorManager = this.mEarMonitorManager) != null) {
            earMonitorManager.reclaim();
        }
    }

    public void switchToAudienceResetStream() {
        EarMonitorManager earMonitorManager;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null && this.isMicrophoneDisable()) {
            audioDeviceManager.muteAudio(false);
        }
        this.track = null;
        this.mAudioDataListener = null;
        AudioEffectManager audioEffectManager = this.mAudioEffectManager;
        if (audioEffectManager != null) {
            audioEffectManager.stopAllEffects();
        }
        if ((earMonitorManager = this.mEarMonitorManager) != null) {
            earMonitorManager.reclaim();
        }
    }

    @Override
    public void setAudioConfig(RCRTCAudioStreamConfig config) {
        if (config == null) {
            FinLog.e(TAG, "setAudioConfig: RCRTCAudioStreamConfig is Null");
            return;
        }
        this.audioConfig = config;
        ((RCAudioStreamConfigImpl)this.audioConfig).updateServerConfig();
        this.needUpdateConfig.set(true);
        ReportUtil.libStatus(ReportUtil.TAG.RTCAUDIOCONFIG, "config", ((RCAudioStreamConfigImpl)config).formatLogString());
        this.onUpdateAudioConfig();
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        super.setTrack(track);
        this.onUpdateAudioConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateAudioConfig() {
        AtomicBoolean atomicBoolean = this.needUpdateConfig;
        synchronized (atomicBoolean) {
            if (!this.needUpdateConfig.get()) {
                return;
            }
            AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
            AudioTrack track = (AudioTrack)this.getTrack();
            if (audioDeviceManager != null && track != null) {
                audioDeviceManager.updateAudioConfig(this.audioConfig, track);
                this.needUpdateConfig.set(false);
            } else {
                FinLog.w(TAG, "onUpdateAudio Failed: AudioDeviceManager or AudioTrack is Null");
            }
        }
    }

    @Override
    public void setMicrophoneDisable(boolean disable) {
        ReportUtil.appStatus(ReportUtil.TAG.SETMICROPHONEDISABLE, "disable", disable);
        if (this.isMicrophoneDisable() == disable) {
            return;
        }
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.muteAudio(disable);
            RTCEngineImpl.getInstance().modifyResource(this, disable);
        } else {
            FinLog.e(TAG, "setMicrophoneDisable Failed: AudioDeviceManager is Null");
        }
    }

    @Override
    public boolean isMicrophoneDisable() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.isAudioMute();
        }
        return false;
    }

    @Override
    public void changeAudioScenario(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        ReportUtil.appStatus(ReportUtil.TAG.CHANGEAUDIOSCENARIO, "mode", audioScenario.getValue());
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.switchSpeechMusicMode((AudioTrack)this.getTrack(), audioScenario, otherActions);
        } else {
            FinLog.e(TAG, "changeAudioScenario Failed: AudioDeviceManager is Null");
        }
    }

    @Override
    public void setAudioQuality(RCRTCParamsType.AudioQuality audioQuality, RCRTCParamsType.AudioScenario audioScenario) {
        ReportUtil.appStatus(ReportUtil.TAG.SETAUDIOQUALITY, "quality | scenario", (Object)((Object)audioQuality) + " | " + (Object)((Object)audioScenario));
        if (audioQuality != null) {
            this.audioQuality = audioQuality;
            RTCEngineImpl.getInstance().sendMessage(2061, (Object)audioQuality);
        }
        if (audioScenario != null && audioScenario != this.audioScenario) {
            this.audioScenario = audioScenario;
            AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
            if (audioDeviceManager != null) {
                audioDeviceManager.switchSpeechMusicMode((AudioTrack)this.getTrack(), audioScenario, null);
            }
        }
        RTCEngineImpl.getInstance().sendMessage(2065, (Object)this.audioQuality.getBitrate());
    }

    public void setRemoteAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        FinLog.i(TAG, "setRemoteAudioPCMBufferListener listener = " + listener);
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.setRemoteAudioPCMBufferListener(listener);
        }
    }

    public RCAudioRouteChangeListener getAudioRouteChangeListener() {
        return this.mAudioDeviceManager;
    }

    public void muteAllRemoteAudio(boolean mute) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.muteAllRemoteAudio(mute);
        }
    }

    public void resetAudioInput() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.resetAudioInput();
        }
    }

    public void registerAudioBufferListener(OnAudioBufferAvailableListener listener) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.registerAudioBufferListener(listener);
        }
    }

    public void unregisterAudioBufferListener(OnAudioBufferAvailableListener listener) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.unregisterAudioBufferListener(listener);
        }
    }

    public boolean isRecording() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.isRecording();
        }
        return false;
    }

    public IAudioEffectManager getAudioEffectManager() {
        return this.mAudioEffectManager;
    }

    @Override
    public void enableEarMonitoring(boolean enable) {
        EarMonitorManager earMonitorManager = this.mEarMonitorManager;
        if (earMonitorManager != null) {
            RTCEngineImpl.getInstance().sendMessage(6000, earMonitorManager, enable);
        }
    }

    @Override
    public RCRTCParamsType.AudioScenario getAudioScenario() {
        return this.audioScenario;
    }

    @Override
    public RCRTCParamsType.AudioQuality getAudioQuality() {
        return this.audioQuality;
    }
}

