/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.bindingx.plugin.weex;

import android.content.Context;
import android.graphics.Color;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.alibaba.android.bindingx.core.BindingXCore;
import com.alibaba.android.bindingx.core.IEventHandler;
import com.alibaba.android.bindingx.core.LogProxy;
import com.alibaba.android.bindingx.core.PlatformManager;
import com.alibaba.android.bindingx.core.internal.Utils;
import com.alibaba.android.bindingx.plugin.weex.BindingXGestureHandler;
import com.alibaba.android.bindingx.plugin.weex.BindingXScrollHandler;
import com.alibaba.android.bindingx.plugin.weex.WXModuleUtils;
import com.alibaba.android.bindingx.plugin.weex.WXViewUpdateService;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.dom.AbsCSSShorthand;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WXBindingXModule
extends WXSDKEngine.DestroyableModule {
    private BindingXCore mBindingXCore;
    private PlatformManager mPlatformManager;

    public WXBindingXModule() {
    }

    @VisibleForTesting
    WXBindingXModule(BindingXCore core) {
        this.mBindingXCore = core;
    }

    private void prepareInternal() {
        if (this.mPlatformManager == null) {
            this.mPlatformManager = WXBindingXModule.createPlatformManager(this.mWXSDKInstance);
        }
        if (this.mBindingXCore == null) {
            this.mBindingXCore = new BindingXCore(this.mPlatformManager);
            this.mBindingXCore.registerEventHandler("scroll", (BindingXCore.ObjectCreator)new BindingXCore.ObjectCreator<IEventHandler, Context, PlatformManager>(){

                public IEventHandler createWith(@NonNull Context context, @NonNull PlatformManager manager, Object ... extension) {
                    return new BindingXScrollHandler(context, manager, extension);
                }
            });
            this.mBindingXCore.registerEventHandler("pan", (BindingXCore.ObjectCreator)new BindingXCore.ObjectCreator<IEventHandler, Context, PlatformManager>(){

                public IEventHandler createWith(@NonNull Context context, @NonNull PlatformManager manager, Object ... extension) {
                    return new BindingXGestureHandler(context, manager, extension);
                }
            });
        }
    }

    @JSMethod(uiThread=false)
    public void prepare(Map<String, Object> params) {
        this.prepareInternal();
    }

    @JSMethod(uiThread=false)
    public Map<String, String> bind(Map<String, Object> params, final JSCallback callback) {
        this.prepareInternal();
        String token = this.mBindingXCore.doBind(this.mWXSDKInstance == null ? null : this.mWXSDKInstance.getContext(), this.mWXSDKInstance == null ? null : this.mWXSDKInstance.getInstanceId(), params == null ? Collections.emptyMap() : params, new BindingXCore.JavaScriptCallback(){

            public void callback(Object params) {
                if (callback != null) {
                    Log.e((String)"\u89e6\u53d1\u53bb\u5f80\u524d\u7aef\u7684\u56de\u8c03", (String)"callback");
                    callback.invokeAndKeepAlive(params);
                }
            }
        }, new Object[0]);
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("token", token);
        return result;
    }

    @JSMethod(uiThread=false)
    public void bindAsync(Map<String, Object> params, JSCallback callback, JSCallback tokenCallback) {
        Map<String, String> result = this.bind(params, callback);
        if (tokenCallback != null && result != null) {
            tokenCallback.invoke(result);
        }
    }

    @JSMethod(uiThread=false)
    public void unbind(Map<String, Object> params) {
        if (this.mBindingXCore != null) {
            this.mBindingXCore.doUnbind(params);
        }
    }

    @JSMethod(uiThread=false)
    public void unbindAll() {
        if (this.mBindingXCore != null) {
            this.mBindingXCore.doRelease();
        }
    }

    @JSMethod(uiThread=false)
    public List<String> supportFeatures() {
        return Arrays.asList("pan", "orientation", "timing", "scroll", "experimentalGestureFeatures");
    }

    @JSMethod(uiThread=false)
    public void getComputedStyleAsync(@Nullable String ref, @Nullable JSCallback callback) {
        Map<String, Object> result = this.getComputedStyle(ref);
        if (callback != null) {
            callback.invoke(result);
        }
    }

    @JSMethod(uiThread=false)
    public Map<String, Object> getComputedStyle(@Nullable String ref) {
        ForegroundColorSpan[] spans;
        CharSequence sequence;
        Layout layout;
        BorderDrawable borderDrawable;
        float[] result;
        this.prepareInternal();
        PlatformManager.IDeviceResolutionTranslator resolutionTranslator = this.mPlatformManager.getResolutionTranslator();
        WXComponent component = WXModuleUtils.findComponentByRef(this.mWXSDKInstance.getInstanceId(), ref);
        if (component == null) {
            return Collections.emptyMap();
        }
        View sourceView = component.getHostView();
        if (sourceView == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", resolutionTranslator.nativeToWeb((double)component.getLayoutWidth(), new Object[0]));
        map.put("height", resolutionTranslator.nativeToWeb((double)component.getLayoutHeight(), new Object[0]));
        map.put("padding-left", resolutionTranslator.nativeToWeb((double)component.getPadding().get((Enum)AbsCSSShorthand.EDGE.LEFT), new Object[0]));
        map.put("padding-top", resolutionTranslator.nativeToWeb((double)component.getPadding().get((Enum)AbsCSSShorthand.EDGE.TOP), new Object[0]));
        map.put("padding-right", resolutionTranslator.nativeToWeb((double)component.getPadding().get((Enum)AbsCSSShorthand.EDGE.RIGHT), new Object[0]));
        map.put("padding-bottom", resolutionTranslator.nativeToWeb((double)component.getPadding().get((Enum)AbsCSSShorthand.EDGE.BOTTOM), new Object[0]));
        map.put("margin-left", resolutionTranslator.nativeToWeb((double)component.getMargin().get((Enum)AbsCSSShorthand.EDGE.LEFT), new Object[0]));
        map.put("margin-top", resolutionTranslator.nativeToWeb((double)component.getMargin().get((Enum)AbsCSSShorthand.EDGE.TOP), new Object[0]));
        map.put("margin-right", resolutionTranslator.nativeToWeb((double)component.getMargin().get((Enum)AbsCSSShorthand.EDGE.RIGHT), new Object[0]));
        map.put("margin-bottom", resolutionTranslator.nativeToWeb((double)component.getMargin().get((Enum)AbsCSSShorthand.EDGE.BOTTOM), new Object[0]));
        map.put("translateX", resolutionTranslator.nativeToWeb((double)sourceView.getTranslationX(), new Object[0]));
        map.put("translateY", resolutionTranslator.nativeToWeb((double)sourceView.getTranslationY(), new Object[0]));
        map.put("rotateX", Float.valueOf(Utils.normalizeRotation((float)sourceView.getRotationX())));
        map.put("rotateY", Float.valueOf(Utils.normalizeRotation((float)sourceView.getRotationY())));
        map.put("rotateZ", Float.valueOf(Utils.normalizeRotation((float)sourceView.getRotation())));
        map.put("scaleX", Float.valueOf(sourceView.getScaleX()));
        map.put("scaleY", Float.valueOf(sourceView.getScaleY()));
        map.put("opacity", Float.valueOf(sourceView.getAlpha()));
        Drawable drawable = sourceView.getBackground();
        double topLeft = 0.0;
        double topRight = 0.0;
        double bottomLeft = 0.0;
        double bottomRight = 0.0;
        if (drawable != null && drawable instanceof BorderDrawable && (result = (borderDrawable = (BorderDrawable)drawable).getBorderRadius(new RectF(0.0f, 0.0f, (float)sourceView.getWidth(), (float)sourceView.getHeight()))).length == 8) {
            topLeft = result[0];
            topRight = result[2];
            bottomLeft = result[6];
            bottomRight = result[4];
        }
        map.put("border-top-left-radius", resolutionTranslator.nativeToWeb(topLeft, new Object[0]));
        map.put("border-top-right-radius", resolutionTranslator.nativeToWeb(topRight, new Object[0]));
        map.put("border-bottom-left-radius", resolutionTranslator.nativeToWeb(bottomLeft, new Object[0]));
        map.put("border-bottom-right-radius", resolutionTranslator.nativeToWeb(bottomRight, new Object[0]));
        if (sourceView.getBackground() != null) {
            int backgroundColor = -16777216;
            if (sourceView.getBackground() instanceof ColorDrawable) {
                backgroundColor = ((ColorDrawable)sourceView.getBackground()).getColor();
            } else if (sourceView.getBackground() instanceof BorderDrawable) {
                backgroundColor = ((BorderDrawable)sourceView.getBackground()).getColor();
            }
            double a = (double)Color.alpha((int)backgroundColor) / 255.0;
            int r = Color.red((int)backgroundColor);
            int g = Color.green((int)backgroundColor);
            int b = Color.blue((int)backgroundColor);
            map.put("background-color", String.format(Locale.getDefault(), "rgba(%d,%d,%d,%f)", r, g, b, a));
        }
        if (component instanceof WXText && sourceView instanceof WXTextView && (layout = ((WXTextView)sourceView).getTextLayout()) != null && (sequence = layout.getText()) != null && sequence instanceof SpannableString && (spans = (ForegroundColorSpan[])((SpannableString)sequence).getSpans(0, sequence.length(), ForegroundColorSpan.class)) != null && spans.length == 1) {
            int fontColor = spans[0].getForegroundColor();
            double a = (double)Color.alpha((int)fontColor) / 255.0;
            int r = Color.red((int)fontColor);
            int g = Color.green((int)fontColor);
            int b = Color.blue((int)fontColor);
            map.put("color", String.format(Locale.getDefault(), "rgba(%d,%d,%d,%f)", r, g, b, a));
        }
        return map;
    }

    public void destroy() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.doRelease();
                    WXBindingXModule.this.mBindingXCore = null;
                }
                WXViewUpdateService.clearCallbacks();
            }
        }, null);
    }

    @NonNull
    static PlatformManager createPlatformManager(WXSDKInstance instance) {
        final int viewPort = instance == null ? 750 : instance.getInstanceViewPortWidth();
        return new PlatformManager.Builder().withViewFinder(new PlatformManager.IViewFinder(){

            @Nullable
            public View findViewBy(String ref, Object ... extension) {
                if (extension.length <= 0 || !(extension[0] instanceof String)) {
                    return null;
                }
                String instanceId = (String)extension[0];
                return WXModuleUtils.findViewByRef(instanceId, ref);
            }
        }).withViewUpdater(new PlatformManager.IViewUpdater(){

            public void synchronouslyUpdateViewOnUIThread(@NonNull View targetView, @NonNull String propertyName, @NonNull Object propertyValue, @NonNull PlatformManager.IDeviceResolutionTranslator translator, @NonNull Map<String, Object> config, Object ... extension) {
                if (extension == null || extension.length < 2 || !(extension[0] instanceof String) || !(extension[1] instanceof String)) {
                    return;
                }
                String instanceId = (String)extension[1];
                String ref = (String)extension[0];
                WXComponent targetComponent = WXModuleUtils.findComponentByRef(instanceId, ref);
                if (targetComponent == null) {
                    LogProxy.e((String)("unexpected error. component not found [ref:" + ref + ",instanceId:" + instanceId + "]"));
                    return;
                }
                WXViewUpdateService.findUpdater(propertyName).update(targetComponent, targetView, propertyValue, translator, config);
            }
        }).withDeviceResolutionTranslator(new PlatformManager.IDeviceResolutionTranslator(){

            public double webToNative(double rawSize, Object ... extension) {
                return WXViewUtils.getRealPxByWidth((float)((float)rawSize), (int)viewPort);
            }

            public double nativeToWeb(double rawSize, Object ... extension) {
                return WXViewUtils.getWebPxByWidth((float)((float)rawSize), (int)viewPort);
            }
        }).build();
    }

    public void onActivityPause() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.onActivityPause();
                }
            }
        }, null);
    }

    public void onActivityResume() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (WXBindingXModule.this.mBindingXCore != null) {
                    WXBindingXModule.this.mBindingXCore.onActivityResume();
                }
            }
        }, null);
    }
}

