/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.StateListAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ComponentObserver;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXAccessibilityRoleAdapter;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.transition.WXTransition;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.tracing.Stopwatch;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicActionAnimation;
import com.taobao.weex.ui.action.GraphicActionUpdateStyle;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.basic.WXBasicComponent;
import com.taobao.weex.ui.component.binding.Statements;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.template.jni.NativeRenderObjectUtils;
import com.taobao.weex.ui.component.pesudo.OnActivePseudoListner;
import com.taobao.weex.ui.component.pesudo.PesudoStatus;
import com.taobao.weex.ui.component.pesudo.TouchActivePseudoListener;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.flat.widget.AndroidViewWidget;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.feature.uniapp.dom.AbsCSSShorthand;
import io.dcloud.feature.uniapp.ui.AbsAnimationHolder;
import io.dcloud.feature.uniapp.ui.action.UniMethodData;
import io.dcloud.feature.uniapp.ui.component.AbsBasicComponent;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowData;
import io.dcloud.feature.uniapp.ui.shadow.UniInsetBoxShadowLayer;
import io.dcloud.feature.uniapp.ui.shadow.UniNormalBoxShadowDrawable;
import io.dcloud.feature.uniapp.utils.UniBoxShadowUtil;
import io.dcloud.weex.ViewHover;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class WXComponent<T extends View>
extends WXBasicComponent<T>
implements IWXObject,
IWXActivityStateListener,
OnActivePseudoListner {
    public static final String PROP_FIXED_SIZE = "fixedSize";
    public static final String PROP_FS_MATCH_PARENT = "m";
    public static final String PROP_FS_WRAP_CONTENT = "w";
    public static final String TYPE = "type";
    public static final String ROOT = "_root";
    private int mFixedProp = 0;
    T mHost;
    private volatile WXVContainer mParent;
    private WXSDKInstance mInstance;
    private Context mContext;
    private int mAbsoluteY = 0;
    private int mAbsoluteX = 0;
    private boolean isLastLayoutDirectionRTL = false;
    @Nullable
    private Set<String> mGestureType;
    private UniBoxShadowData mBoxShadowData;
    private BorderDrawable mBackgroundDrawable;
    private UniNormalBoxShadowDrawable mBoxShadowDrawable;
    private UniInsetBoxShadowLayer mInsetBoxShadowDrawable;
    private Drawable mRippleBackground;
    private int mPreRealWidth = 0;
    private int mPreRealHeight = 0;
    private int mPreRealLeft = 0;
    private int mPreRealRight = 0;
    private int mPreRealTop = 0;
    private int mStickyOffset = 0;
    protected WXGesture mGesture;
    private IFComponentHolder mHolder;
    private boolean isUsing = false;
    private List<OnClickListener> mHostClickListeners;
    private List<OnFocusChangeListener> mFocusChangeListeners;
    private Set<String> mAppendEvents;
    private AbsAnimationHolder mAnimationHolder;
    private PesudoStatus mPesudoStatus;
    private boolean mIsDestroyed = false;
    private boolean mIsDisabled = false;
    private int mType = 0;
    private boolean mNeedLayoutOnAnimation = false;
    private String mLastBoxShadowId;
    public int mDeepInComponentTree = 0;
    public boolean mIsAddElementToTree = false;
    public int interactionAbsoluteX = 0;
    public int interactionAbsoluteY = 0;
    private boolean mHasAddFocusListener = false;
    public WXTracing.TraceInfo mTraceInfo = new WXTracing.TraceInfo();
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_VIRTUAL = 1;
    private boolean waste = false;
    public boolean isIgnoreInteraction = false;
    protected ContentBoxMeasurement contentBoxMeasurement;
    private WXTransition mTransition;
    private GraphicSize mPseudoResetGraphicSize;
    @Nullable
    private ConcurrentLinkedQueue<Pair<String, Map<String, Object>>> animations;
    private ConcurrentLinkedQueue<UniMethodData> mPendingComponetMethodQueue = new ConcurrentLinkedQueue();
    private OnClickListenerImp mClickEventListener;
    private long PRESSED_ANIM_DURATION = 100L;
    private long PRESSED_ANIM_DELAY = 100L;
    private int[] ENABLED_STATE_SET = new int[]{16842910};
    private int[] EMPTY_STATE_SET = new int[0];
    private int[] PRESSED_ENABLED_STATE_SET = new int[]{16842919, 16842910};
    private int[] FOCUSED_ENABLED_STATE_SET = new int[]{16842908, 16842910};
    private float mElevation = 0.0f;
    public static final int STATE_DOM_FINISH = 0;
    public static final int STATE_UI_FINISH = 1;
    public static final int STATE_ALL_FINISH = 2;
    private String mViewTreeKey;
    private boolean mLazy = false;
    private ViewHover mHover;
    private boolean isPreventGesture = false;

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXVContainer parent, String instanceId, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, isLazy, basicComponentData);
    }

    @Deprecated
    public WXComponent(WXSDKInstance instance, WXVContainer parent, boolean isLazy, BasicComponentData basicComponentData) {
        this(instance, parent, basicComponentData);
    }

    public WXComponent(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        this(instance, parent, 0, basicComponentData);
    }

    public WXComponent(WXSDKInstance instance, WXVContainer parent, int type, BasicComponentData basicComponentData) {
        super(basicComponentData);
        this.mInstance = instance;
        this.mContext = this.mInstance.getContext();
        this.mParent = parent;
        this.mType = type;
        if (instance != null) {
            this.setViewPortWidth(instance.getInstanceViewPortWidthWithFloat());
        }
        this.onCreate();
        ComponentObserver observer = this.getInstance().getComponentObserver();
        if (observer != null) {
            observer.onCreate(this);
        }
    }

    @Override
    protected final void bindComponent(AbsBasicComponent component) {
        super.bindComponent(component);
        if (this.getInstance() != null) {
            this.setViewPortWidth(this.getInstance().getInstanceViewPortWidthWithFloat());
        }
        WXComponent ct = (WXComponent)component;
        this.mParent = ct.getParent();
        this.mType = ct.getType();
    }

    protected void setContentBoxMeasurement(ContentBoxMeasurement contentBoxMeasurement) {
        this.contentBoxMeasurement = contentBoxMeasurement;
        this.mInstance.addContentBoxMeasurement(this.getRenderObjectPtr(), contentBoxMeasurement);
        WXBridgeManager.getInstance().bindMeasurementToRenderObject(this.getRenderObjectPtr());
    }

    public void setMarginsSupportRTL(ViewGroup.MarginLayoutParams lp, int left, int top, int right, int bottom) {
        lp.setMargins(left, top, right, bottom);
        if (lp instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams lp_frameLayout = (FrameLayout.LayoutParams)lp;
            lp_frameLayout.gravity = 51;
        }
    }

    public void updateStyles(WXComponent component) {
        if (component != null) {
            this.updateProperties(component.getStyles());
            this.applyBorder(component);
        }
    }

    public void updateStyles(Map<String, Object> styles) {
        if (styles != null) {
            this.updateProperties(styles);
            this.applyBorder(this);
        }
    }

    public void updateAttrs(AbsBasicComponent component) {
        if (component != null) {
            this.updateProperties(component.getAttrs());
        }
    }

    public void updateAttrs(Map<String, Object> attrs) {
        if (attrs != null) {
            this.updateProperties(attrs);
        }
    }

    private void applyBorder(AbsBasicComponent component) {
        AbsCSSShorthand border = component.getBorder();
        float left = border.get(CSSShorthand.EDGE.LEFT);
        float top = border.get(CSSShorthand.EDGE.TOP);
        float right = border.get(CSSShorthand.EDGE.RIGHT);
        float bottom = border.get(CSSShorthand.EDGE.BOTTOM);
        if (this.mHost == null) {
            return;
        }
        this.setBorderWidth("borderLeftWidth", left);
        this.setBorderWidth("borderTopWidth", top);
        this.setBorderWidth("borderRightWidth", right);
        this.setBorderWidth("borderBottomWidth", bottom);
    }

    public void setPadding(AbsCSSShorthand padding, AbsCSSShorthand border) {
        int left = (int)(padding.get(CSSShorthand.EDGE.LEFT) + border.get(CSSShorthand.EDGE.LEFT));
        int top = (int)(padding.get(CSSShorthand.EDGE.TOP) + border.get(CSSShorthand.EDGE.TOP));
        int right = (int)(padding.get(CSSShorthand.EDGE.RIGHT) + border.get(CSSShorthand.EDGE.RIGHT));
        int bottom = (int)(padding.get(CSSShorthand.EDGE.BOTTOM) + border.get(CSSShorthand.EDGE.BOTTOM));
        if (this instanceof FlatComponent && !((FlatComponent)((Object)this)).promoteToView(true)) {
            ((FlatComponent)((Object)this)).getOrCreateFlatWidget().setContentBox(left, top, right, bottom);
        } else if (this.mHost != null) {
            if (this.mBoxShadowData != null) {
                int offset;
                if (this.mBoxShadowData.getNormalLeft() > 0) {
                    offset = this.mBoxShadowData.getNormalLeft() / 2;
                    left += offset;
                    right += offset;
                }
                if (this.mBoxShadowData.getNormalTop() > 0) {
                    offset = this.mBoxShadowData.getNormalTop() / 2;
                    top += offset;
                    bottom += offset;
                }
            }
            this.mHost.setPadding(left, top, right, bottom);
        }
    }

    public void applyComponentEvents() {
        this.applyEvents();
    }

    private void applyEvents() {
        if (this.getEvents() == null || this.getEvents().isEmpty()) {
            return;
        }
        WXEvent event = this.getEvents();
        int size = event.size();
        for (int i = 0; i < size && i < event.size(); ++i) {
            String type = (String)event.get(i);
            this.addEvent(type);
        }
        this.setActiveTouchListener();
    }

    public void addEvent(String type) {
        if (this.mAppendEvents == null) {
            this.mAppendEvents = new HashSet<String>();
        }
        if (TextUtils.isEmpty((CharSequence)type) || this.mAppendEvents.contains(type)) {
            return;
        }
        View view = this.getRealView();
        if (type.equals("layeroverflow")) {
            this.addLayerOverFlowListener(this.getRef());
        }
        if (type.equals("click")) {
            if (view == null) {
                return;
            }
            if (this.mClickEventListener == null) {
                this.mClickEventListener = new OnClickListenerImp();
            }
            this.addClickListener(this.mClickEventListener);
        } else if (type.equals("focus") || type.equals("blur")) {
            if (!this.mHasAddFocusListener) {
                this.mHasAddFocusListener = true;
                this.addFocusChangeListener(new OnFocusChangeListener(){

                    @Override
                    public void onFocusChange(boolean hasFocus) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("timeStamp", System.currentTimeMillis());
                        WXComponent.this.fireEvent(hasFocus ? "focus" : "blur", params);
                    }
                });
            }
        } else if (this.needGestureDetector(type)) {
            if (null == view) {
                return;
            }
            if (view instanceof WXGestureObservable) {
                if (this.mGesture == null) {
                    this.mGesture = new WXGesture(this, this.mContext);
                    boolean isPreventMove = WXUtils.getBoolean(this.getAttrs().get("preventMoveEvent"), false);
                    this.mGesture.setPreventMoveEvent(isPreventMove);
                }
                if (this.mGestureType == null) {
                    this.mGestureType = new HashSet<String>();
                }
                if (!"view_hover_event".equals(type)) {
                    this.mGestureType.add(type);
                }
                ((WXGestureObservable)view).registerGestureListener(this.mGesture);
            } else {
                WXLogUtils.e(view.getClass().getSimpleName() + " don't implement WXGestureObservable, so no gesture is supported.");
            }
        } else {
            Scrollable scroller = this.getParentScroller();
            if (scroller == null) {
                return;
            }
            if (type.equals("appear")) {
                scroller.bindAppearEvent(this);
            } else if (type.equals("disappear")) {
                scroller.bindDisappearEvent(this);
            }
        }
        this.mAppendEvents.add(type);
    }

    public void interceptFocusAndBlurEvent() {
        this.mHasAddFocusListener = true;
    }

    protected void onCreate() {
    }

    public void bindHolder(IFComponentHolder holder) {
        this.mHolder = holder;
    }

    public WXSDKInstance getInstance() {
        return this.mInstance;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected final WXComponent findComponent(String ref) {
        if (this.mInstance != null && ref != null) {
            return WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.mInstance.getInstanceId(), ref);
        }
        return null;
    }

    public String getAttrByKey(String key) {
        return "default";
    }

    public void postAnimation(AbsAnimationHolder holder) {
        this.mAnimationHolder = holder;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFlatUIEnabled() {
        return this.mParent != null && this.mParent.isFlatUIEnabled();
    }

    public String getInstanceId() {
        return this.mInstance.getInstanceId();
    }

    public Rect getComponentSize() {
        Rect size = new Rect();
        if (this.mHost != null && this.mInstance.getContainerView() != null) {
            int[] location = new int[2];
            int[] anchor = new int[2];
            this.mHost.getLocationOnScreen(location);
            this.mInstance.getContainerView().getLocationOnScreen(anchor);
            int left = location[0] - anchor[0];
            int top = location[1] - this.mStickyOffset - anchor[1];
            int width = (int)this.getLayoutWidth();
            int height = (int)this.getLayoutHeight();
            size.set(left, top, left + width, top + height);
        }
        return size;
    }

    public final void invoke(String method, JSONArray args) {
        if (this.getHostView() == null || this.getRealView() == null) {
            UniMethodData data = new UniMethodData(method, args);
            this.mPendingComponetMethodQueue.offer(data);
        } else {
            Invoker invoker = this.mHolder.getMethodInvoker(method);
            if (invoker != null) {
                try {
                    this.getInstance().getNativeInvokeHelper().invoke(this, invoker, args);
                }
                catch (Exception e) {
                    WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
                }
            } else {
                this.onInvokeUnknownMethod(method, args);
            }
        }
    }

    protected void onInvokeUnknownMethod(String method, JSONArray args) {
    }

    public final void fireEvent(String type) {
        this.fireEvent(type, null);
    }

    public final void fireEvent(String type, Map<String, Object> params) {
        if (WXUtils.getBoolean(this.getAttrs().get("fireEventSyn"), false).booleanValue()) {
            this.fireEventWait(type, params);
        } else {
            this.fireEvent(type, params, null, null);
        }
    }

    public final EventResult fireEventWait(String type, Map<String, Object> params) {
        final CountDownLatch waitLatch = new CountDownLatch(1);
        EventResult callback = new EventResult(){

            @Override
            public void onCallback(Object result) {
                super.onCallback(result);
                waitLatch.countDown();
            }
        };
        try {
            this.fireEvent(type, params, null, callback);
            waitLatch.await(50L, TimeUnit.MILLISECONDS);
            return callback;
        }
        catch (Exception e) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("fireEventWait", e);
            }
            return callback;
        }
    }

    protected final void fireEvent(String type, Map<String, Object> params, Map<String, Object> domChanges) {
        this.fireEvent(type, params, domChanges, null);
    }

    private final void fireEvent(String type, Map<String, Object> params, Map<String, Object> domChanges, EventResult callback) {
        if (this.mInstance != null) {
            String componentId;
            List eventArgsValues = null;
            if (this.getEvents() != null && this.getEvents().getEventBindingArgsValues() != null) {
                eventArgsValues = (List)this.getEvents().getEventBindingArgsValues().get((Object)type);
            }
            if (params != null && (componentId = Statements.getComponentId(this)) != null) {
                params.put("componentId", componentId);
            }
            this.mInstance.fireEvent(this.getRef(), type, params, domChanges, eventArgsValues, callback);
        }
    }

    public Object findTypeParent(AbsBasicComponent component, Class type) {
        if (component.getClass() == type) {
            return component;
        }
        WXComponent ct = (WXComponent)component;
        if (ct.getParent() != null) {
            this.findTypeParent(ct.getParent(), type);
        }
        return null;
    }

    public boolean isLazy() {
        if (this.mLazy) {
            return true;
        }
        return this.mParent != null && this.mParent.isLazy();
    }

    protected final void addFocusChangeListener(OnFocusChangeListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mFocusChangeListeners == null) {
                this.mFocusChangeListeners = new ArrayList<OnFocusChangeListener>();
                view.setFocusable(true);
                view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View v, boolean hasFocus) {
                        for (OnFocusChangeListener listener : WXComponent.this.mFocusChangeListeners) {
                            if (listener == null) continue;
                            listener.onFocusChange(hasFocus);
                        }
                    }
                });
            }
            this.mFocusChangeListeners.add(l);
        }
    }

    protected boolean ismHasFocusChangeListener(OnFocusChangeListener l) {
        if (this.mFocusChangeListeners != null) {
            return this.mFocusChangeListeners.contains(l);
        }
        return false;
    }

    protected final void addClickListener(OnClickListener l) {
        View view;
        if (l != null && (view = this.getRealView()) != null) {
            if (this.mHostClickListeners == null) {
                this.mHostClickListeners = new ArrayList<OnClickListener>();
            }
            if (!view.hasOnClickListeners()) {
                view.setClickable(true);
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (WXComponent.this.mGesture != null && WXComponent.this.mGesture.isTouchEventConsumedByAdvancedGesture()) {
                            return;
                        }
                        for (OnClickListener listener : WXComponent.this.mHostClickListeners) {
                            if (listener == null) continue;
                            listener.onHostViewClick();
                        }
                    }
                });
            }
            this.mHostClickListeners.add(l);
        }
    }

    protected final void removeClickListener(OnClickListener l) {
        this.mHostClickListeners.remove(l);
    }

    public void bindData(WXComponent component) {
        this.bindComponentData(component);
    }

    protected void bindComponentData(AbsBasicComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            WXComponent ct = (WXComponent)component;
            this.bindComponent(ct);
            this.updateStyles(ct);
            this.updateAttrs(component);
            this.updateExtra(component.getExtra());
        }
    }

    public void applyLayoutAndEvent(AbsBasicComponent component) {
        if (!this.isLazy()) {
            if (component == null) {
                component = this;
            }
            WXComponent ct = (WXComponent)component;
            this.bindComponent(ct);
            this.setSafeLayout(ct);
            this.setPadding(component.getPadding(), component.getBorder());
            this.applyEvents();
        }
    }

    public void setDemission(GraphicSize size, GraphicPosition position) {
        this.setLayoutPosition(position);
        this.setLayoutSize(size);
    }

    public void updateDemission(float top, float bottom, float left, float right, float height, float width) {
        this.getLayoutPosition().update(top, bottom, left, right);
        this.getLayoutSize().update(width, height);
    }

    public void applyLayoutOnly() {
        if (!this.isLazy()) {
            this.setSafeLayout(this);
            this.setPadding(this.getPadding(), this.getBorder());
        }
    }

    public void refreshData(WXComponent component) {
    }

    @Deprecated
    public void updateProperties(Map<String, Object> props) {
        FlatComponent flatComponent;
        if (props == null || this.mHost == null && !this.isVirtualComponent() || this.getInstance() == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object param = entry.getValue();
            String value = WXUtils.getString(param, null);
            if (key == null) {
                WXExceptionUtils.commitCriticalExceptionRT(this.getInstanceId(), WXErrorCode.WX_RENDER_ERR_NULL_KEY, "updateProperties", WXErrorCode.WX_RENDER_ERR_NULL_KEY.getErrorMsg(), null);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)value)) {
                param = this.convertEmptyProperty(key, value);
            }
            if (this.setProperty(key, param)) continue;
            if (this.mHolder == null || this.getInstance() == null) {
                return;
            }
            Invoker invoker = this.mHolder.getPropertyInvoker(key);
            if (invoker == null) continue;
            try {
                Type[] paramClazzs = invoker.getParameterTypes();
                if (paramClazzs.length != 1) {
                    WXLogUtils.e("[WXComponent] setX method only one parameter\uff1a" + invoker);
                    return;
                }
                param = WXReflectionUtils.parseArgument(paramClazzs[0], param);
                invoker.invoke(this, param);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + invoker.toString() + " function " + WXLogUtils.getStackTrace(e));
            }
        }
        this.readyToRender();
        if (this instanceof FlatComponent && this.mBackgroundDrawable != null && !(flatComponent = (FlatComponent)((Object)this)).promoteToView(true) && !(flatComponent.getOrCreateFlatWidget() instanceof AndroidViewWidget)) {
            flatComponent.getOrCreateFlatWidget().setBackgroundAndBorder(this.mBackgroundDrawable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean setProperty(String key, Object param) {
        if (key == null || this.getInstance() == null) {
            return true;
        }
        switch (key) {
            case "preventMoveEvent": {
                if (this.mGesture == null) return true;
                this.mGesture.setPreventMoveEvent(WXUtils.getBoolean(param, false));
                return true;
            }
            case "disabled": {
                Boolean disabled = WXUtils.getBoolean(param, null);
                if (disabled == null) return true;
                this.setDisabled(disabled);
                this.setPseudoClassStatus(":disabled", disabled);
                return true;
            }
            case "position": {
                String position = WXUtils.getString(param, null);
                if (position == null) return true;
                this.setSticky(position);
                return true;
            }
            case "backgroundColor": {
                String bgColor = WXUtils.getString(param, null);
                if (bgColor == null) return true;
                this.setBackgroundColor(bgColor);
                return true;
            }
            case "backgroundImage": {
                String bgImage = WXUtils.getString(param, null);
                if (bgImage == null || this.mHost == null) return true;
                this.setBackgroundImage(bgImage);
                return true;
            }
            case "opacity": {
                Float opacity = WXUtils.getFloat(param, Float.valueOf(1.0f));
                if (opacity == null) return true;
                this.setOpacity(opacity.floatValue());
                return true;
            }
            case "borderRadius": 
            case "borderTopLeftRadius": 
            case "borderTopRightRadius": 
            case "borderBottomRightRadius": 
            case "borderBottomLeftRadius": {
                Float radius = WXUtils.getFloat(param, null);
                if (radius == null) return true;
                this.setBorderRadius(key, radius.floatValue());
                return true;
            }
            case "borderStyle": 
            case "borderRightStyle": 
            case "borderBottomStyle": 
            case "borderLeftStyle": 
            case "borderTopStyle": {
                String border_style = WXUtils.getString(param, null);
                if (border_style == null) return true;
                this.setBorderStyle(key, border_style);
                return true;
            }
            case "borderColor": 
            case "borderTopColor": 
            case "borderRightColor": 
            case "borderBottomColor": 
            case "borderLeftColor": {
                String border_color = WXUtils.getString(param, null);
                if (border_color == null) return true;
                this.setBorderColor(key, border_color);
                return true;
            }
            case "visibility": {
                String visibility = WXUtils.getString(param, null);
                if (visibility == null) return true;
                this.setVisibility(visibility);
                return true;
            }
            case "fixedSize": {
                String fixedSize = WXUtils.getString(param, PROP_FS_MATCH_PARENT);
                this.setFixedSize(fixedSize);
                return true;
            }
            case "ariaLabel": {
                String label = WXUtils.getString(param, "");
                this.setAriaLabel(label);
                return true;
            }
            case "ariaHidden": {
                boolean isHidden = WXUtils.getBoolean(param, false);
                this.setAriaHidden(isHidden);
                return true;
            }
            case "width": 
            case "minWidth": 
            case "maxWidth": 
            case "height": 
            case "minHeight": 
            case "maxHeight": 
            case "alignItems": 
            case "alignSelf": 
            case "flex": 
            case "flexDirection": 
            case "justifyContent": 
            case "flexWrap": 
            case "margin": 
            case "marginTop": 
            case "marginLeft": 
            case "marginRight": 
            case "marginBottom": 
            case "padding": 
            case "paddingTop": 
            case "paddingLeft": 
            case "paddingRight": 
            case "paddingBottom": 
            case "borderWidth": 
            case "borderTopWidth": 
            case "borderRightWidth": 
            case "borderBottomWidth": 
            case "borderLeftWidth": 
            case "left": 
            case "top": 
            case "right": 
            case "bottom": {
                return true;
            }
            case "boxShadow": {
                try {
                    if (this.getHostView() == null) return true;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return true;
            }
            case "role": {
                this.setRole(WXUtils.getString(param, ""));
                return true;
            }
        }
        return false;
    }

    @WXComponentProp(name="elevation")
    public void setElevation(String str) {
        this.initElevation(str);
    }

    protected void initElevation(String str) {
        if (!TextUtils.isEmpty((CharSequence)str) && Build.VERSION.SDK_INT > 20) {
            float shadow_android = WXUtils.getFloat(str, Float.valueOf(0.0f)).floatValue();
            this.mElevation = WXViewUtils.getRealSubPxByWidth(shadow_android, this.mInstance.getInstanceViewPortWidthWithFloat());
            if (Build.VERSION.SDK_INT == 21) {
                this.getHostView().setElevation(this.mElevation);
            } else {
                StateListAnimator stateListAnimator = new StateListAnimator();
                AnimatorSet set = new AnimatorSet();
                set.play((Animator)ObjectAnimator.ofFloat(this.getHostView(), (String)"elevation", (float[])new float[]{this.mElevation}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat(this.getHostView(), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(this.PRESSED_ANIM_DURATION));
                set.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
                stateListAnimator.addState(this.PRESSED_ENABLED_STATE_SET, (Animator)set);
                set = new AnimatorSet();
                set.play((Animator)ObjectAnimator.ofFloat(this.getHostView(), (String)"elevation", (float[])new float[]{this.mElevation}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat(this.getHostView(), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(this.PRESSED_ANIM_DURATION));
                set.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
                stateListAnimator.addState(this.FOCUSED_ENABLED_STATE_SET, (Animator)set);
                set = new AnimatorSet();
                ArrayList<ObjectAnimator> animators = new ArrayList<ObjectAnimator>();
                animators.add(ObjectAnimator.ofFloat(this.getHostView(), (String)"elevation", (float[])new float[]{this.mElevation}).setDuration(0L));
                if (Build.VERSION.SDK_INT >= 22 && Build.VERSION.SDK_INT <= 24) {
                    animators.add(ObjectAnimator.ofFloat(this.getHostView(), (Property)View.TRANSLATION_Z, (float[])new float[]{this.getHostView().getTranslationZ()}).setDuration(this.PRESSED_ANIM_DELAY));
                }
                animators.add(ObjectAnimator.ofFloat(this.getHostView(), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(this.PRESSED_ANIM_DURATION));
                set.playSequentially((Animator[])animators.toArray(new ObjectAnimator[0]));
                set.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
                stateListAnimator.addState(this.ENABLED_STATE_SET, (Animator)set);
                set = new AnimatorSet();
                set.play((Animator)ObjectAnimator.ofFloat(this.getHostView(), (String)"elevation", (float[])new float[]{0.0f}).setDuration(0L)).with((Animator)ObjectAnimator.ofFloat(this.getHostView(), (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f}).setDuration(0L));
                set.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
                stateListAnimator.addState(this.EMPTY_STATE_SET, (Animator)set);
                this.getHostView().setStateListAnimator(stateListAnimator);
            }
        }
    }

    protected BorderDrawable getOrCreateBorder() {
        if (this.mBackgroundDrawable == null) {
            this.mBackgroundDrawable = new BorderDrawable();
            if (this.mHost != null) {
                WXViewUtils.setBackGround(this.mHost, null, this);
                if (this.mRippleBackground == null) {
                    if (this.mBoxShadowDrawable != null) {
                        WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mBoxShadowDrawable, this.mBackgroundDrawable}), this);
                    } else if (this.mInsetBoxShadowDrawable != null) {
                        WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, this.mInsetBoxShadowDrawable}), this);
                    } else {
                        WXViewUtils.setBackGround(this.mHost, this.mBackgroundDrawable, this);
                    }
                } else if (this.mBoxShadowDrawable != null) {
                    WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBoxShadowDrawable, this.mBackgroundDrawable}), this);
                } else if (this.mInsetBoxShadowDrawable != null) {
                    WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable, this.mInsetBoxShadowDrawable}), this);
                } else {
                    WXViewUtils.setBackGround(this.mHost, (Drawable)new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable}), this);
                }
            }
        }
        return this.mBackgroundDrawable;
    }

    public void setSafeLayout(WXComponent component) {
        if (TextUtils.isEmpty((CharSequence)component.getComponentType()) || TextUtils.isEmpty((CharSequence)component.getRef()) || component.getLayoutPosition() == null || component.getLayoutSize() == null) {
            return;
        }
        this.setLayout(component);
    }

    public void setLayout(WXComponent component) {
        this.setLayoutSize(component.getLayoutSize());
        this.setLayoutPosition(component.getLayoutPosition());
        this.setPaddings(component.getPadding());
        this.setMargins(component.getMargin());
        this.setBorders(component.getBorder());
        boolean isRTL = component.isLayoutRTL();
        this.setIsLayoutRTL(isRTL);
        if (isRTL != component.isLastLayoutDirectionRTL) {
            component.isLastLayoutDirectionRTL = isRTL;
            this.layoutDirectionDidChanged(isRTL);
        }
        try {
            if (this.getLayoutSize().getWidth() != 0.0f && this.getLayoutSize().getHeight() != 0.0f) {
                this.parseAnimation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean nullParent = this.mParent == null;
        int siblingOffset = nullParent ? 0 : this.mParent.getChildrenLayoutTopOffset();
        CSSShorthand parentPadding = nullParent ? new CSSShorthand() : this.mParent.getPadding();
        CSSShorthand parentBorder = nullParent ? new CSSShorthand() : this.mParent.getBorder();
        int realWidth = (int)this.getLayoutSize().getWidth();
        int realHeight = (int)this.getLayoutSize().getHeight();
        int realLeft = 0;
        int realTop = 0;
        int realRight = 0;
        if (this.isFixed()) {
            realLeft = (int)(this.getLayoutPosition().getLeft() - (float)this.getInstance().getRenderContainerPaddingLeft());
            realTop = (int)(this.getLayoutPosition().getTop() - (float)this.getInstance().getRenderContainerPaddingTop()) + siblingOffset;
        } else {
            realLeft = (int)(this.getLayoutPosition().getLeft() - parentPadding.get(CSSShorthand.EDGE.LEFT) - parentBorder.get(CSSShorthand.EDGE.LEFT));
            realTop = (int)(this.getLayoutPosition().getTop() - parentPadding.get(CSSShorthand.EDGE.TOP) - parentBorder.get(CSSShorthand.EDGE.TOP)) + siblingOffset;
        }
        realRight = (int)this.getMargin().get(CSSShorthand.EDGE.RIGHT);
        int realBottom = (int)this.getMargin().get(CSSShorthand.EDGE.BOTTOM);
        Point rawOffset = new Point((int)this.getLayoutPosition().getLeft(), (int)this.getLayoutPosition().getTop());
        if (this.mPreRealWidth == realWidth && this.mPreRealHeight == realHeight && this.mPreRealLeft == realLeft && this.mPreRealRight == realRight && this.mPreRealTop == realTop) {
            return;
        }
        if (this instanceof WXCell && realHeight >= WXPerformance.VIEW_LIMIT_HEIGHT && realWidth >= WXPerformance.VIEW_LIMIT_WIDTH) {
            this.mInstance.getApmForInstance().updateDiffStats("wxCellExceedNum", 1.0);
            ++this.mInstance.getWXPerformance().cellExceedNum;
        }
        this.mAbsoluteY = (int)(nullParent ? 0.0f : (float)this.mParent.getAbsoluteY() + this.getCSSLayoutTop());
        this.mAbsoluteX = (int)(nullParent ? 0.0f : (float)this.mParent.getAbsoluteX() + this.getCSSLayoutLeft());
        if (this.mHost == null) {
            return;
        }
        if (!(this.mHost instanceof ViewGroup) && this.mAbsoluteY + realHeight > this.mInstance.getWeexHeight() + 1) {
            if (!this.mInstance.mEnd) {
                this.mInstance.onOldFsRenderTimeLogic();
            }
            if (!this.mInstance.isNewFsEnd) {
                this.mInstance.isNewFsEnd = true;
                this.mInstance.getApmForInstance().arriveNewFsRenderTime();
            }
        }
        MeasureOutput measureOutput = this.measure(realWidth, realHeight);
        realWidth = measureOutput.width;
        realHeight = measureOutput.height;
        this.setComponentLayoutParams(realWidth, realHeight, realLeft, realTop, realRight, realBottom, rawOffset);
    }

    private void setComponentLayoutParams(int realWidth, int realHeight, int realLeft, int realTop, int realRight, int realBottom, Point rawOffset) {
        WidgetContainer ancestor;
        FlatGUIContext UIImp;
        if (this.getInstance() == null || this.getInstance().isDestroy()) {
            return;
        }
        this.updateBoxShadow(realWidth, realHeight, false);
        int width = realWidth;
        int height = realHeight;
        int left = realLeft;
        int top = realTop;
        if (this.mBoxShadowData != null && this.mBoxShadowData.getNormalShadows().size() > 0) {
            width = this.mBoxShadowData.getNormalMaxWidth();
            height = this.mBoxShadowData.getNormalMaxHeight();
            left -= this.mBoxShadowData.getNormalLeft() / 2;
            top -= this.mBoxShadowData.getNormalTop() / 2;
        }
        if ((UIImp = this.getInstance().getFlatUIContext()) != null && (ancestor = UIImp.getFlatComponentAncestor(this)) != null) {
            AndroidViewWidget widget = this instanceof FlatComponent && !((FlatComponent)((Object)this)).promoteToView(true) ? ((FlatComponent)((Object)this)).getOrCreateFlatWidget() : UIImp.getAndroidViewWidget(this);
            this.setWidgetParams(widget, UIImp, rawOffset, width, height, left, realRight, top, realBottom);
        } else if (this.mHost != null) {
            if (this.isFixed()) {
                this.setFixedHostLayoutParams(this.mHost, width, height, left, realRight, top, realBottom);
            } else {
                this.setHostLayoutParams(this.mHost, width, height, left, realRight, top, realBottom);
            }
            this.recordInteraction(realWidth, realHeight);
            this.mPreRealWidth = realWidth;
            this.mPreRealHeight = realHeight;
            this.mPreRealLeft = realLeft;
            this.mPreRealRight = realRight;
            this.mPreRealTop = realTop;
            this.onFinishLayout();
        }
    }

    protected void layoutDirectionDidChanged(boolean isRTL) {
    }

    private void recordInteraction(int realWidth, int realHeight) {
        if (!this.mIsAddElementToTree) {
            return;
        }
        this.mIsAddElementToTree = false;
        if (null == this.mParent) {
            this.interactionAbsoluteX = 0;
            this.interactionAbsoluteY = 0;
        } else {
            float cssTop = this.getCSSLayoutTop();
            float cssLeft = this.getCSSLayoutLeft();
            this.interactionAbsoluteX = (int)(this.isFixed() ? cssLeft : (float)this.mParent.interactionAbsoluteX + cssLeft);
            this.interactionAbsoluteY = (int)(this.isFixed() ? cssTop : (float)this.mParent.interactionAbsoluteY + cssTop);
        }
        if (null == this.getInstance().getApmForInstance().instanceRect) {
            this.getInstance().getApmForInstance().instanceRect = new Rect();
        }
        Rect instanceRect = this.getInstance().getApmForInstance().instanceRect;
        instanceRect.set(0, 0, this.mInstance.getWeexWidth(), this.mInstance.getWeexHeight());
        boolean inScreen = instanceRect.contains(this.interactionAbsoluteX, this.interactionAbsoluteY) || instanceRect.contains(this.interactionAbsoluteX + realWidth, this.interactionAbsoluteY) || instanceRect.contains(this.interactionAbsoluteX, this.interactionAbsoluteY + realHeight) || instanceRect.contains(this.interactionAbsoluteX + realWidth, this.interactionAbsoluteY + realHeight);
        this.mInstance.onChangeElement(this, !inScreen);
    }

    private void setWidgetParams(Widget widget, FlatGUIContext UIImp, Point rawoffset, int width, int height, int left, int right, int top, int bottom) {
        Point childOffset = new Point();
        if (this.mParent != null) {
            ViewGroup.LayoutParams lp;
            if (this.mParent instanceof FlatComponent && UIImp.getFlatComponentAncestor(this.mParent) != null && UIImp.getAndroidViewWidget(this.mParent) == null) {
                childOffset.set(rawoffset.x, rawoffset.y);
            } else {
                childOffset.set(left, top);
            }
            if (this.mParent instanceof FlatComponent && UIImp.getFlatComponentAncestor(this.mParent) != null && UIImp.getAndroidViewWidget(this.mParent) == null) {
                Point parentLayoutOffset = ((FlatComponent)((Object)this.mParent)).getOrCreateFlatWidget().getLocInFlatContainer();
                childOffset.offset(parentLayoutOffset.x, parentLayoutOffset.y);
            }
            if ((lp = this.mParent.getChildLayoutParams(this, (View)this.mHost, width, height, left, right, top, bottom)) instanceof ViewGroup.MarginLayoutParams) {
                width = lp.width;
                height = lp.height;
                left = ((ViewGroup.MarginLayoutParams)lp).leftMargin;
                right = ((ViewGroup.MarginLayoutParams)lp).rightMargin;
                top = ((ViewGroup.MarginLayoutParams)lp).topMargin;
                bottom = ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
            }
        }
        widget.setLayout(width, height, left, right, top, bottom, childOffset);
        if (widget instanceof AndroidViewWidget && ((AndroidViewWidget)widget).getView() != null) {
            this.setHostLayoutParams(((AndroidViewWidget)widget).getView(), width, height, childOffset.x, right, childOffset.y, bottom);
        }
    }

    public int getLayoutTopOffsetForSibling() {
        return 0;
    }

    protected void setHostLayoutParams(T host, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.LayoutParams lp;
        if (this.mParent == null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
            this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)params, left, top, right, bottom);
            lp = params;
        } else {
            lp = this.mParent.getChildLayoutParams(this, (View)host, width, height, left, right, top, bottom);
        }
        if (lp != null) {
            host.setLayoutParams(lp);
        }
    }

    private void setFixedHostLayoutParams(T host, int width, int height, int left, int right, int top, int bottom) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.width = width;
        params.height = height;
        this.setMarginsSupportRTL((ViewGroup.MarginLayoutParams)params, left, top, right, bottom);
        host.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mInstance.moveFixedView((View)host);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout :" + left + " " + top + " " + width + " " + height);
            WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout Left:" + this.getStyles().getLeft() + " " + (int)this.getStyles().getTop());
        }
    }

    protected void updateBoxShadow(int width, int height, boolean isRender) {
        if (!UniBoxShadowUtil.isBoxShadowEnabled() || this.mElevation > 0.0f) {
            WXLogUtils.w("BoxShadow", "box-shadow disabled");
            return;
        }
        if (this.getStyles() != null) {
            Object boxShadow = this.getStyles().get("boxShadow");
            Object shadowQuality = this.getAttrs().get("shadowQuality");
            if (boxShadow == null) {
                return;
            }
            if (width <= 0 || height <= 0) {
                return;
            }
            float quality = WXUtils.getFloat(shadowQuality, Float.valueOf(0.5f)).floatValue();
            float viewPort = this.getInstance().getInstanceViewPortWidthWithFloat();
            float[] radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            WXStyle style = this.getStyles();
            if (style != null) {
                float tl = WXUtils.getFloat(style.get("borderTopLeftRadius"), Float.valueOf(0.0f)).floatValue();
                radii[0] = WXViewUtils.getRealSubPxByWidth(tl, viewPort);
                radii[1] = WXViewUtils.getRealSubPxByWidth(tl, viewPort);
                float tr = WXUtils.getFloat(style.get("borderTopRightRadius"), Float.valueOf(0.0f)).floatValue();
                radii[2] = WXViewUtils.getRealSubPxByWidth(tr, viewPort);
                radii[3] = WXViewUtils.getRealSubPxByWidth(tr, viewPort);
                float br = WXUtils.getFloat(style.get("borderBottomRightRadius"), Float.valueOf(0.0f)).floatValue();
                radii[4] = WXViewUtils.getRealSubPxByWidth(br, viewPort);
                radii[5] = WXViewUtils.getRealSubPxByWidth(br, viewPort);
                float bl = WXUtils.getFloat(style.get("borderBottomLeftRadius"), Float.valueOf(0.0f)).floatValue();
                radii[6] = WXViewUtils.getRealSubPxByWidth(bl, viewPort);
                radii[7] = WXViewUtils.getRealSubPxByWidth(bl, viewPort);
                if (style.containsKey("borderRadius")) {
                    float radius = WXUtils.getFloat(style.get("borderRadius"), Float.valueOf(0.0f)).floatValue();
                    for (int i = 0; i < radii.length; ++i) {
                        radii[i] = WXViewUtils.getRealSubPxByWidth(radius, viewPort);
                    }
                }
            }
            if (this.mBoxShadowData != null && this.mBoxShadowData.equalsUniBoxShadowData(boxShadow.toString(), width, height, radii)) {
                return;
            }
            UniBoxShadowData boxShadowData = UniBoxShadowUtil.parseBoxShadow(width, height, boxShadow.toString(), radii, viewPort, quality);
            if (boxShadowData == null) {
                return;
            }
            this.mBoxShadowData = boxShadowData;
            UniNormalBoxShadowDrawable normalBoxShadowDrawable = UniBoxShadowUtil.getNormalBoxShadowDrawable(boxShadowData, this.getContext().getResources());
            UniInsetBoxShadowLayer insetBoxShadowDrawable = UniBoxShadowUtil.getInsetBoxShadowDrawable(boxShadowData);
            if (normalBoxShadowDrawable != null || insetBoxShadowDrawable != null) {
                if (normalBoxShadowDrawable != null && boxShadowData != null && isRender && this.mHost != null) {
                    int realWidth = boxShadowData.getNormalMaxWidth();
                    int realHeight = boxShadowData.getNormalMaxHeight();
                    boolean nullParent = this.mParent == null;
                    CSSShorthand parentPadding = nullParent ? new CSSShorthand() : this.mParent.getPadding();
                    CSSShorthand parentBorder = nullParent ? new CSSShorthand() : this.mParent.getBorder();
                    int siblingOffset = nullParent ? 0 : this.mParent.getChildrenLayoutTopOffset();
                    int realLeft = 0;
                    int realTop = 0;
                    int realRight = 0;
                    if (this.isFixed()) {
                        realLeft = (int)(this.getLayoutPosition().getLeft() - (float)this.getInstance().getRenderContainerPaddingLeft());
                        realTop = (int)(this.getLayoutPosition().getTop() - (float)this.getInstance().getRenderContainerPaddingTop()) + siblingOffset;
                    } else {
                        realLeft = (int)(this.getLayoutPosition().getLeft() - parentPadding.get(CSSShorthand.EDGE.LEFT) - parentBorder.get(CSSShorthand.EDGE.LEFT));
                        realTop = (int)(this.getLayoutPosition().getTop() - parentPadding.get(CSSShorthand.EDGE.TOP) - parentBorder.get(CSSShorthand.EDGE.TOP)) + siblingOffset;
                    }
                    realRight = (int)this.getMargin().get(CSSShorthand.EDGE.RIGHT);
                    int realBottom = (int)this.getMargin().get(CSSShorthand.EDGE.BOTTOM);
                    realLeft -= boxShadowData.getNormalLeft() / 2;
                    realTop -= boxShadowData.getNormalTop() / 2;
                    if (this.isFixed()) {
                        this.setFixedHostLayoutParams(this.mHost, realWidth, realHeight, realLeft, realRight, realTop, realBottom);
                    } else {
                        this.setHostLayoutParams(this.mHost, realWidth, realHeight, realLeft, realRight, realTop, realBottom);
                    }
                    this.setPadding(this.getPadding(), this.getBorder());
                }
                if (this.mBackgroundDrawable != null) {
                    this.clearBoxShadow();
                    LayerDrawable layerDrawable = this.mRippleBackground == null ? (normalBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{normalBoxShadowDrawable, this.mBackgroundDrawable}) : (insetBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, insetBoxShadowDrawable}) : new LayerDrawable(new Drawable[]{this.mBackgroundDrawable}))) : (normalBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{this.mRippleBackground, normalBoxShadowDrawable, this.mBackgroundDrawable}) : (insetBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable, insetBoxShadowDrawable}) : new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable})));
                    WXViewUtils.setBackGround(this.getHostView(), (Drawable)layerDrawable, this);
                    this.mBoxShadowData = boxShadowData;
                    this.mBoxShadowDrawable = normalBoxShadowDrawable;
                    this.mInsetBoxShadowDrawable = insetBoxShadowDrawable;
                } else {
                    this.clearBoxShadow();
                    this.mBoxShadowData = boxShadowData;
                    this.mBoxShadowDrawable = normalBoxShadowDrawable;
                    this.mInsetBoxShadowDrawable = insetBoxShadowDrawable;
                    this.getOrCreateBorder().updateBoxShadowData(boxShadowData);
                }
            }
        } else {
            WXLogUtils.w("Can not resolve styles");
        }
    }

    protected void clearBoxShadow() {
        Drawable drawable2;
        if (!UniBoxShadowUtil.isBoxShadowEnabled()) {
            WXLogUtils.w("BoxShadow", "box-shadow disabled");
            return;
        }
        if (this.getHostView() != null && this.mBackgroundDrawable != null && (drawable2 = this.getHostView().getBackground()) instanceof LayerDrawable) {
            if (this.mRippleBackground == null) {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mBackgroundDrawable});
                WXViewUtils.setBackGround(this.getHostView(), (Drawable)layerDrawable, this);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable});
                WXViewUtils.setBackGround(this.getHostView(), (Drawable)layerDrawable, this);
            }
        }
        if (this.mBoxShadowData != null) {
            this.mBoxShadowData = null;
        }
        if (this.mBoxShadowDrawable != null) {
            if (this.mBoxShadowDrawable.getBitmap() != null) {
                this.mBoxShadowDrawable.getBitmap().recycle();
            }
            this.mBoxShadowDrawable = null;
        }
        if (this.mInsetBoxShadowDrawable != null) {
            this.mInsetBoxShadowDrawable = null;
        }
    }

    protected void onFinishLayout() {
        Object param;
        Object object = param = this.getStyles() != null ? this.getStyles().get("backgroundImage") : null;
        if (param != null) {
            this.setBackgroundImage(param.toString());
        }
    }

    protected MeasureOutput measure(int width, int height) {
        MeasureOutput measureOutput = new MeasureOutput();
        if (this.mFixedProp != 0) {
            measureOutput.width = this.mFixedProp;
            measureOutput.height = this.mFixedProp;
        } else {
            measureOutput.width = width;
            measureOutput.height = height;
        }
        return measureOutput;
    }

    @TargetApi(value=16)
    protected void setAriaHidden(boolean isHidden) {
        T host = this.getHostView();
        if (host != null && Build.VERSION.SDK_INT >= 16) {
            host.setImportantForAccessibility(isHidden ? 2 : 1);
        }
    }

    protected void setAriaLabel(String label) {
        T host = this.getHostView();
        if (host != null) {
            host.setContentDescription((CharSequence)label);
        }
    }

    protected void setRole(String roleKey) {
        T host = this.getHostView();
        String role = roleKey;
        if (host != null && !TextUtils.isEmpty((CharSequence)roleKey)) {
            IWXAccessibilityRoleAdapter roleAdapter = WXSDKManager.getInstance().getAccessibilityRoleAdapter();
            if (roleAdapter != null) {
                role = roleAdapter.getRole(roleKey);
            }
            final String finalRole = role;
            AccessibilityDelegateCompat delegate = new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    try {
                        super.onInitializeAccessibilityNodeInfo(host, info);
                        info.setRoleDescription((CharSequence)finalRole);
                    }
                    catch (Throwable e) {
                        WXLogUtils.e("SetRole failed!");
                    }
                }
            };
            ViewCompat.setAccessibilityDelegate(host, (AccessibilityDelegateCompat)delegate);
        }
    }

    private void setFixedSize(String fixedSize) {
        ViewGroup.LayoutParams layoutParams;
        if (PROP_FS_MATCH_PARENT.equals(fixedSize)) {
            this.mFixedProp = -1;
        } else if (PROP_FS_WRAP_CONTENT.equals(fixedSize)) {
            this.mFixedProp = -2;
        } else {
            this.mFixedProp = 0;
            return;
        }
        if (this.mHost != null && (layoutParams = this.mHost.getLayoutParams()) != null) {
            layoutParams.height = this.mFixedProp;
            layoutParams.width = this.mFixedProp;
            this.mHost.setLayoutParams(layoutParams);
        }
    }

    protected void appendEventToDOM(String type) {
    }

    public View getRealView() {
        return this.mHost;
    }

    private boolean needGestureDetector(String type) {
        if (this.mHost != null) {
            for (WXGestureType.LowLevelGesture lowLevelGesture : WXGestureType.LowLevelGesture.values()) {
                if (!type.equals(((Object)lowLevelGesture).toString())) continue;
                return true;
            }
            for (Enum enum_ : WXGestureType.HighLevelGesture.values()) {
                if (!type.equals(enum_.toString())) continue;
                return true;
            }
        }
        if (WXGesture.isStopPropagation(type)) {
            return true;
        }
        if (type.equals("view_hover_event")) {
            return true;
        }
        return this.isPreventGesture();
    }

    public Scrollable getParentScroller() {
        WXComponent component = this;
        WXVContainer container;
        while ((container = component.getParent()) != null) {
            if (container instanceof Scrollable) {
                Scrollable scroller = (Scrollable)((Object)container);
                return scroller;
            }
            if (container.getRef().equals(ROOT)) {
                return null;
            }
            component = container;
        }
        return null;
    }

    @Nullable
    public Scrollable getFirstScroller() {
        if (this instanceof Scrollable) {
            return (Scrollable)((Object)this);
        }
        return null;
    }

    public WXVContainer getParent() {
        return this.mParent;
    }

    public final void createView() {
        if (!this.isLazy()) {
            this.createViewImpl();
        }
    }

    protected void createViewImpl() {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
            if (this.mHost == null && !this.isVirtualComponent()) {
                this.initView();
            }
            if (this.mHost != null) {
                ComponentObserver observer;
                if (this.mHost.getId() == -1) {
                    this.mHost.setId(WXViewUtils.generateViewId());
                }
                if ((observer = this.getInstance().getComponentObserver()) != null) {
                    observer.onViewCreated(this, (View)this.mHost);
                }
                this.invokePendingComponetMethod();
            }
            this.onHostViewInitialized(this.mHost);
        } else {
            WXLogUtils.e("createViewImpl", "Context is null");
        }
    }

    private final void invokePendingComponetMethod() {
        if (this.mPendingComponetMethodQueue.size() > 0) {
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    while (!WXComponent.this.mPendingComponetMethodQueue.isEmpty()) {
                        UniMethodData data = (UniMethodData)WXComponent.this.mPendingComponetMethodQueue.poll();
                        if (data == null) continue;
                        WXComponent.this.invoke(data.getMethod(), data.getArgs());
                    }
                }
            });
        }
    }

    @Deprecated
    protected void initView() {
        if (this.mContext != null) {
            this.mHost = this.initComponentHostView(this.mContext);
            if (this.mHost != null) {
                this.invokePendingComponetMethod();
            }
        }
    }

    protected T initComponentHostView(@NonNull Context context) {
        return null;
    }

    @CallSuper
    protected void onHostViewInitialized(T host) {
        if (this.mAnimationHolder != null) {
            this.mAnimationHolder.execute(this.mInstance, this);
        }
        this.setActiveTouchListener();
    }

    public T getHostView() {
        return this.mHost;
    }

    @Deprecated
    public View getView() {
        return this.mHost;
    }

    public int getAbsoluteY() {
        return this.mAbsoluteY;
    }

    public int getAbsoluteX() {
        return this.mAbsoluteX;
    }

    public void removeEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        if (type.equals("layeroverflow")) {
            this.removeLayerOverFlowListener(this.getRef());
        }
        if (this.getEvents() != null) {
            this.getEvents().remove(type);
        }
        if (this.mAppendEvents != null) {
            this.mAppendEvents.remove(type);
        }
        if (this.mGestureType != null) {
            this.mGestureType.remove(type);
        }
        this.removeEventFromView(type);
    }

    protected void removeEventFromView(String type) {
        if (type.equals("click") && this.getRealView() != null && this.mHostClickListeners != null) {
            if (this.mClickEventListener == null) {
                this.mClickEventListener = new OnClickListenerImp();
            }
            this.mHostClickListeners.remove(this.mClickEventListener);
            if (this.mHostClickListeners.size() < 1) {
                this.getRealView().setOnClickListener(null);
                this.getRealView().setClickable(false);
            }
        }
        Scrollable scroller = this.getParentScroller();
        if (type.equals("appear") && scroller != null) {
            scroller.unbindAppearEvent(this);
        }
        if (type.equals("disappear") && scroller != null) {
            scroller.unbindDisappearEvent(this);
        }
    }

    public void removeAllEvent() {
        if (this.getEvents().size() < 1) {
            return;
        }
        WXEvent events = this.getEvents();
        int size = events.size();
        for (int i = 0; i < size && i < events.size(); ++i) {
            String event = (String)events.get(i);
            if (event == null) continue;
            this.removeEventFromView(event);
        }
        if (this.mAppendEvents != null) {
            this.mAppendEvents.clear();
        }
        if (this.mGestureType != null) {
            this.mGestureType.clear();
        }
        this.mGesture = null;
        if (this.getRealView() != null && this.getRealView() instanceof WXGestureObservable) {
            ((WXGestureObservable)this.getRealView()).registerGestureListener(null);
        }
        if (this.mHost != null) {
            this.mHost.setOnFocusChangeListener(null);
            if (this.mHostClickListeners != null && this.mHostClickListeners.size() > 0) {
                this.mHostClickListeners.clear();
                this.mHost.setOnClickListener(null);
            }
        }
    }

    public final void removeStickyStyle() {
        Scrollable scroller;
        if (this.isSticky() && (scroller = this.getParentScroller()) != null) {
            scroller.unbindStickStyle(this);
        }
    }

    public boolean isSticky() {
        return this.getStyles().isSticky();
    }

    public boolean isFixed() {
        return this.getStyles().isFixed();
    }

    public void setDisabled(boolean disabled) {
        this.mIsDisabled = disabled;
        if (this.mHost == null) {
            return;
        }
        this.mHost.setEnabled(!disabled);
    }

    public boolean isDisabled() {
        return this.mIsDisabled;
    }

    public void setSticky(String sticky) {
        Scrollable waScroller;
        if (!TextUtils.isEmpty((CharSequence)sticky) && sticky.equals("sticky") && (waScroller = this.getParentScroller()) != null) {
            waScroller.bindStickStyle(this);
        }
    }

    public void setBackgroundColor(String color2) {
        if (!TextUtils.isEmpty((CharSequence)color2)) {
            int colorInt = WXResourceUtils.getColor(color2);
            if (this.isRippleEnabled() && Build.VERSION.SDK_INT >= 21) {
                this.mRippleBackground = this.prepareBackgroundRipple();
                if (this.mRippleBackground != null) {
                    if (this.mBackgroundDrawable == null) {
                        WXViewUtils.setBackGround(this.mHost, this.mRippleBackground, this);
                    } else {
                        LayerDrawable layerDrawable = this.mBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBoxShadowDrawable, this.mBackgroundDrawable, this.mInsetBoxShadowDrawable}) : (this.mInsetBoxShadowDrawable != null ? new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable, this.mInsetBoxShadowDrawable}) : new LayerDrawable(new Drawable[]{this.mRippleBackground, this.mBackgroundDrawable}));
                        WXViewUtils.setBackGround(this.mHost, (Drawable)layerDrawable, this);
                    }
                    return;
                }
            }
            if (colorInt != 0 || this.mBackgroundDrawable != null) {
                this.getOrCreateBorder().setColor(colorInt);
            }
        }
    }

    private Drawable prepareBackgroundRipple() {
        try {
            if (this.getStyles() != null && this.getStyles().getPesudoResetStyles() != null) {
                Map<String, Object> resetStyles = this.getStyles().getPesudoResetStyles();
                Object bgColor = resetStyles.get("backgroundColor");
                int colorInt = 0;
                if (bgColor != null && (colorInt = WXResourceUtils.getColor(bgColor.toString(), 0)) == 0) {
                    return null;
                }
                Object bg = resetStyles.get("backgroundColor:active");
                if (bg == null) {
                    return null;
                }
                int rippleColor = WXResourceUtils.getColor(bg.toString(), colorInt);
                if (Build.VERSION.SDK_INT >= 21) {
                    ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{rippleColor});
                    return new RippleDrawable(colorStateList, (Drawable)new ColorDrawable(colorInt), null){

                        public void draw(@NonNull Canvas canvas) {
                            if (WXComponent.this.mBackgroundDrawable != null) {
                                Path border = WXComponent.this.mBackgroundDrawable.getContentPath(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()));
                                canvas.clipPath(border);
                            }
                            super.draw(canvas);
                        }
                    };
                }
            }
        }
        catch (Throwable t) {
            WXLogUtils.w("Exception on create ripple: ", t);
        }
        return null;
    }

    public void setBackgroundImage(@NonNull String bgImage) {
        if ("".equals(bgImage.trim())) {
            this.getOrCreateBorder().setImage(null);
        } else {
            Shader shader = WXResourceUtils.getShader(bgImage, this.getLayoutSize().getWidth(), this.getLayoutSize().getHeight());
            this.getOrCreateBorder().setImage(shader);
        }
    }

    private boolean shouldCancelHardwareAccelerate() {
        IWXConfigAdapter adapter = WXSDKManager.getInstance().getWxConfigAdapter();
        boolean cancel_hardware_accelerate = true;
        if (adapter != null) {
            try {
                cancel_hardware_accelerate = Boolean.parseBoolean(adapter.getConfig("android_weex_test_gpu", "cancel_hardware_accelerate", "true"));
            }
            catch (Exception e) {
                WXLogUtils.e(WXLogUtils.getStackTrace(e));
            }
            WXLogUtils.i("cancel_hardware_accelerate : " + cancel_hardware_accelerate);
        }
        return cancel_hardware_accelerate;
    }

    public void setOpacity(float opacity) {
        if (opacity >= 0.0f && opacity <= 1.0f && this.mHost.getAlpha() != opacity) {
            int limit = WXRenderManager.getOpenGLRenderLimitValue();
            if (this.isLayerTypeEnabled()) {
                this.mHost.setLayerType(2, null);
            }
            if (this.isLayerTypeEnabled() && this.shouldCancelHardwareAccelerate() && limit > 0 && (this.getLayoutHeight() > (float)limit || this.getLayoutWidth() > (float)limit)) {
                this.mHost.setLayerType(0, null);
            }
            this.mHost.setAlpha(opacity);
        }
    }

    public void setBorderRadius(String key, float borderRadius) {
        if (borderRadius >= 0.0f) {
            switch (key) {
                case "borderRadius": {
                    float radius = WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidthWithFloat());
                    this.getOrCreateBorder().setBorderRadius(CSSShorthand.CORNER.ALL, radius);
                    break;
                }
                case "borderTopLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidthWithFloat()));
                    break;
                }
                case "borderTopRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidthWithFloat()));
                    break;
                }
                case "borderBottomRightRadius": {
                    this.getOrCreateBorder().setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidthWithFloat()));
                    break;
                }
                case "borderBottomLeftRadius": {
                    this.getOrCreateBorder().setBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, WXViewUtils.getRealSubPxByWidth(borderRadius, this.mInstance.getInstanceViewPortWidthWithFloat()));
                }
            }
        }
    }

    private void initOutlineProvider(final float radius) {
        if (this.useFeature() && this.getHostView() instanceof BaseFrameLayout) {
            this.getHostView().setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (WXComponent.this.getInstance().isDestroy()) {
                        return;
                    }
                    int w = view.getWidth();
                    int h = view.getHeight();
                    if (w == 0 || h == 0) {
                        return;
                    }
                    if (WXComponent.this.getOrCreateBorder().isRounded()) {
                        Rect f = new Rect(0, 0, w, h);
                        float factor = (float)w / (radius * 2.0f);
                        if (!Float.isNaN(factor) && factor < 1.0f) {
                            outline.setRoundRect(f, factor * radius);
                        } else {
                            outline.setRoundRect(f, radius);
                        }
                    }
                }
            });
            this.getHostView().setClipToOutline(true);
        }
    }

    public boolean useFeature() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public void setBorderWidth(String key, float borderWidth) {
        if (borderWidth >= 0.0f) {
            switch (key) {
                case "borderWidth": {
                    this.getOrCreateBorder().setBorderWidth(CSSShorthand.EDGE.ALL, borderWidth);
                    break;
                }
                case "borderTopWidth": {
                    this.getOrCreateBorder().setBorderWidth(CSSShorthand.EDGE.TOP, borderWidth);
                    break;
                }
                case "borderRightWidth": {
                    this.getOrCreateBorder().setBorderWidth(CSSShorthand.EDGE.RIGHT, borderWidth);
                    break;
                }
                case "borderBottomWidth": {
                    this.getOrCreateBorder().setBorderWidth(CSSShorthand.EDGE.BOTTOM, borderWidth);
                    break;
                }
                case "borderLeftWidth": {
                    this.getOrCreateBorder().setBorderWidth(CSSShorthand.EDGE.LEFT, borderWidth);
                    break;
                }
            }
        }
    }

    public void setBorderStyle(String key, String borderStyle) {
        if (!TextUtils.isEmpty((CharSequence)borderStyle)) {
            switch (key) {
                case "borderStyle": {
                    this.getOrCreateBorder().setBorderStyle(CSSShorthand.EDGE.ALL, borderStyle);
                    break;
                }
                case "borderRightStyle": {
                    this.getOrCreateBorder().setBorderStyle(CSSShorthand.EDGE.RIGHT, borderStyle);
                    break;
                }
                case "borderBottomStyle": {
                    this.getOrCreateBorder().setBorderStyle(CSSShorthand.EDGE.BOTTOM, borderStyle);
                    break;
                }
                case "borderLeftStyle": {
                    this.getOrCreateBorder().setBorderStyle(CSSShorthand.EDGE.LEFT, borderStyle);
                    break;
                }
                case "borderTopStyle": {
                    this.getOrCreateBorder().setBorderStyle(CSSShorthand.EDGE.TOP, borderStyle);
                }
            }
        }
    }

    public void setBorderColor(String key, String borderColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)borderColor) && (colorInt = WXResourceUtils.getColor(borderColor)) != Integer.MIN_VALUE) {
            switch (key) {
                case "borderColor": {
                    this.getOrCreateBorder().setBorderColor(CSSShorthand.EDGE.ALL, colorInt);
                    break;
                }
                case "borderTopColor": {
                    this.getOrCreateBorder().setBorderColor(CSSShorthand.EDGE.TOP, colorInt);
                    break;
                }
                case "borderRightColor": {
                    this.getOrCreateBorder().setBorderColor(CSSShorthand.EDGE.RIGHT, colorInt);
                    break;
                }
                case "borderBottomColor": {
                    this.getOrCreateBorder().setBorderColor(CSSShorthand.EDGE.BOTTOM, colorInt);
                    break;
                }
                case "borderLeftColor": {
                    this.getOrCreateBorder().setBorderColor(CSSShorthand.EDGE.LEFT, colorInt);
                }
            }
        }
    }

    @Nullable
    public String getVisibility() {
        try {
            return (String)this.getStyles().get("visibility");
        }
        catch (Exception e) {
            return "visible";
        }
    }

    public void setVisibility(String visibility) {
        View view = this.getRealView();
        if (view != null) {
            if (TextUtils.equals((CharSequence)visibility, (CharSequence)"visible")) {
                view.setVisibility(0);
            } else if (TextUtils.equals((CharSequence)visibility, (CharSequence)"hidden")) {
                view.setVisibility(8);
            }
        }
    }

    private void updateElevation() {
        float elevation = this.getAttrs().getElevation(this.getInstance().getInstanceViewPortWidthWithFloat());
        if (!Float.isNaN(elevation)) {
            ViewCompat.setElevation(this.getHostView(), (float)elevation);
        }
    }

    @Deprecated
    public void registerActivityStateListener() {
    }

    @Override
    public void onActivityCreate() {
    }

    @Override
    public void onActivityStart() {
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    @Override
    public void onActivityStop() {
    }

    @Override
    public void onActivityDestroy() {
        if (this.mPendingComponetMethodQueue != null) {
            this.mPendingComponetMethodQueue.clear();
        }
    }

    @Override
    public boolean onActivityBack() {
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void recycled() {
        if (this.isFixed()) {
            return;
        }
    }

    public void destroy() {
        T view;
        if (this.getInstance() == null) {
            return;
        }
        this.clearBoxShadow();
        ComponentObserver observer = this.getInstance().getComponentObserver();
        if (observer != null) {
            observer.onPreDestory(this);
        }
        if (WXEnvironment.isApkDebugable() && !WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXComponent] destroy can only be called in main thread");
        }
        if (this.mHost != null && this.mHost.getLayerType() == 2 && this.isLayerTypeEnabled()) {
            this.mHost.setLayerType(0, null);
        }
        this.removeAllEvent();
        this.removeStickyStyle();
        if (this.isFixed() && (view = this.getHostView()) != null) {
            this.getInstance().removeFixedView((View)view);
        }
        if (this.contentBoxMeasurement != null) {
            this.contentBoxMeasurement.destroy();
            this.contentBoxMeasurement = null;
        }
        this.mIsDestroyed = true;
        if (this.animations != null) {
            this.animations.clear();
        }
        if (this.mHover != null) {
            this.mHover.destroy();
            this.mHover = null;
        }
        this.mInstance = null;
        if (this.mFocusChangeListeners != null) {
            this.mFocusChangeListeners.clear();
        }
        if (this.mHostClickListeners != null) {
            this.mHostClickListeners.clear();
        }
    }

    public boolean isDestoryed() {
        return this.mIsDestroyed;
    }

    public View detachViewAndClearPreInfo() {
        T original = this.mHost;
        this.mPreRealLeft = 0;
        this.mPreRealRight = 0;
        this.mPreRealWidth = 0;
        this.mPreRealHeight = 0;
        this.mPreRealTop = 0;
        return original;
    }

    public void clearPreLayout() {
        this.mPreRealLeft = 0;
        this.mPreRealRight = 0;
        this.mPreRealWidth = 0;
        this.mPreRealHeight = 0;
        this.mPreRealTop = 0;
    }

    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        View view = this.getRealView();
        pointF.set((float)view.getScrollX(), (float)view.getScrollY());
    }

    public boolean containsGesture(WXGestureType WXGestureType2) {
        return this.mGestureType != null && this.mGestureType.contains(WXGestureType2.toString());
    }

    public boolean containsEvent(String event) {
        return this.getEvents().contains(event) || this.mAppendEvents != null && this.mAppendEvents.contains(event);
    }

    public void notifyAppearStateChange(String wxEventType, String direction) {
        if (this.containsEvent("appear") || this.containsEvent("disappear")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("direction", direction);
            this.fireEvent(wxEventType, params);
        }
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public void setUsing(boolean using) {
        this.isUsing = using;
    }

    public void readyToRender() {
        if (this.mParent != null && this.getInstance() != null && this.getInstance().isTrackComponent()) {
            this.mParent.readyToRender();
        }
    }

    public boolean isVirtualComponent() {
        return this.mType == 1;
    }

    public void removeVirtualComponent() {
    }

    public int getType() {
        return this.mType;
    }

    public boolean hasScrollParent(WXComponent component) {
        if (component.getParent() == null) {
            return true;
        }
        if (component.getParent() instanceof WXBaseScroller) {
            return false;
        }
        return this.hasScrollParent(component.getParent());
    }

    @CheckResult
    protected Object convertEmptyProperty(String propName, Object originalValue) {
        switch (propName) {
            case "backgroundColor": {
                return "transparent";
            }
            case "borderRadius": 
            case "borderBottomLeftRadius": 
            case "borderBottomRightRadius": 
            case "borderTopLeftRadius": 
            case "borderTopRightRadius": {
                return 0;
            }
            case "borderWidth": 
            case "borderTopWidth": 
            case "borderLeftWidth": 
            case "borderRightWidth": 
            case "borderBottomWidth": {
                return 0;
            }
            case "borderColor": 
            case "borderTopColor": 
            case "borderLeftColor": 
            case "borderRightColor": 
            case "borderBottomColor": {
                return "black";
            }
        }
        return originalValue;
    }

    private void setActiveTouchListener() {
        View view;
        boolean hasActivePesudo = this.getStyles().getPesudoStyles().containsKey(":active");
        if (hasActivePesudo && (view = this.getRealView()) != null) {
            boolean hasTouchConsumer = this.isConsumeTouch();
            view.setOnTouchListener((View.OnTouchListener)new TouchActivePseudoListener(this, !hasTouchConsumer));
        }
    }

    protected boolean isConsumeTouch() {
        return this.mHostClickListeners != null && this.mHostClickListeners.size() > 0 || this.mGesture != null;
    }

    @Override
    public void updateActivePseudo(boolean isSet) {
        if (this.getInstance() != null) {
            this.setPseudoClassStatus(":active", isSet);
        }
    }

    protected void setPseudoClassStatus(String clzName, boolean status) {
        Map<String, Object> resultStyles;
        WXStyle styles = this.getStyles();
        Map<String, Map<String, Object>> pesudoStyles = styles.getPesudoStyles();
        if (pesudoStyles == null || pesudoStyles.size() == 0) {
            return;
        }
        if (this.mPesudoStatus == null) {
            this.mPesudoStatus = new PesudoStatus();
        }
        if (null != (resultStyles = this.mPesudoStatus.updateStatusAndGetUpdateStyles(clzName, status, pesudoStyles, styles.getPesudoResetStyles()))) {
            if (status) {
                this.mPseudoResetGraphicSize = new GraphicSize(this.getLayoutSize().getWidth(), this.getLayoutSize().getHeight());
                if (resultStyles.keySet().contains("width")) {
                    this.getLayoutSize().setWidth(WXViewUtils.getRealPxByWidth(WXUtils.parseFloat(styles.getPesudoResetStyles().get("width:active")), this.getViewPortWidthForFloat()));
                } else if (resultStyles.keySet().contains("height")) {
                    this.getLayoutSize().setHeight(WXViewUtils.getRealPxByWidth(WXUtils.parseFloat(styles.getPesudoResetStyles().get("height:active")), this.getViewPortWidthForFloat()));
                }
            } else if (null != this.mPseudoResetGraphicSize) {
                this.setLayoutSize(this.mPseudoResetGraphicSize);
            }
        }
        this.updateStyleByPesudo(resultStyles);
    }

    private void updateStyleByPesudo(Map<String, Object> styles) {
        if (this.getInstance() == null) {
            return;
        }
        new GraphicActionUpdateStyle(this.getInstance(), this.getRef(), styles, this.getPadding(), this.getMargin(), this.getBorder(), true).executeActionOnRender();
        if (this.getLayoutWidth() != 0.0f || this.getLayoutHeight() != 0.0f) {
            if (styles.containsKey("width")) {
                WXBridgeManager.getInstance().setStyleWidth(this.getInstanceId(), this.getRef(), this.getLayoutWidth());
            } else if (styles.containsKey("height")) {
                WXBridgeManager.getInstance().setStyleHeight(this.getInstanceId(), this.getRef(), this.getLayoutHeight());
            }
        }
    }

    public int getStickyOffset() {
        return this.mStickyOffset;
    }

    public boolean canRecycled() {
        return (!this.isFixed() || !this.isSticky()) && this.getAttrs().canRecycled();
    }

    public void setStickyOffset(int stickyOffset) {
        this.mStickyOffset = stickyOffset;
    }

    public boolean isLayerTypeEnabled() {
        return this.getInstance().isLayerTypeEnabled();
    }

    public void setNeedLayoutOnAnimation(boolean need) {
        this.mNeedLayoutOnAnimation = need;
    }

    public void notifyNativeSizeChanged(int w, int h) {
        if (!this.mNeedLayoutOnAnimation) {
            return;
        }
        if (this.mBoxShadowData != null && this.mBoxShadowData.getNormalShadows().size() > 0) {
            w -= this.mBoxShadowData.getNormalLeft();
            h -= this.mBoxShadowData.getNormalTop();
        }
        WXBridgeManager manager = WXBridgeManager.getInstance();
        manager.setStyleWidth(this.getInstanceId(), this.getRef(), w);
        manager.setStyleHeight(this.getInstanceId(), this.getRef(), h);
    }

    @CallSuper
    public void onRenderFinish(int state) {
        if (WXTracing.isAvailable()) {
            double uiTime = Stopwatch.nanosToMillis(this.mTraceInfo.uiThreadNanos);
            if (state == 2 || state == 0) {
                WXTracing.TraceEvent domEvent = WXTracing.newEvent("DomExecute", this.getInstanceId(), this.mTraceInfo.rootEventId);
                domEvent.ph = "X";
                domEvent.ts = this.mTraceInfo.domThreadStart;
                domEvent.tname = "DOMThread";
                domEvent.name = this.getComponentType();
                domEvent.classname = this.getClass().getSimpleName();
                if (this.getParent() != null) {
                    domEvent.parentRef = this.getParent().getRef();
                }
                domEvent.submit();
            }
            if (state == 2 || state == 1) {
                if (this.mTraceInfo.uiThreadStart != -1L) {
                    WXTracing.TraceEvent uiEvent = WXTracing.newEvent("UIExecute", this.getInstanceId(), this.mTraceInfo.rootEventId);
                    uiEvent.ph = "X";
                    uiEvent.duration = uiTime;
                    uiEvent.ts = this.mTraceInfo.uiThreadStart;
                    uiEvent.name = this.getComponentType();
                    uiEvent.classname = this.getClass().getSimpleName();
                    if (this.getParent() != null) {
                        uiEvent.parentRef = this.getParent().getRef();
                    }
                    uiEvent.submit();
                } else if (!WXEnvironment.isApkDebugable() || !this.isLazy()) {
                    // empty if block
                }
            }
        }
    }

    protected boolean isRippleEnabled() {
        try {
            Object obj = this.getAttrs().get("rippleEnabled");
            return WXUtils.getBoolean(obj, false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isWaste() {
        return this.waste;
    }

    public void setWaste(boolean waste) {
        if (this.waste != waste) {
            this.waste = waste;
            if (!"recycle-list".equals(this.getParent().getComponentType())) {
                NativeRenderObjectUtils.nativeRenderObjectChildWaste(this.getRenderObjectPtr(), waste);
            }
            if (waste) {
                this.getStyles().put("visibility", (Object)"hidden");
                if (this.getHostView() == null) {
                    if (!this.mLazy) {
                        this.lazy(true);
                    }
                } else {
                    this.getHostView().setVisibility(8);
                }
            } else {
                this.getStyles().put("visibility", (Object)"visible");
                if (this.getHostView() == null) {
                    if (this.mLazy) {
                        if (this.mParent != null && this.mParent.isLazy()) {
                            this.lazy(false);
                        } else {
                            Statements.initLazyComponent(this, this.mParent);
                        }
                    }
                } else {
                    this.getHostView().setVisibility(0);
                }
            }
        }
    }

    public String getViewTreeKey() {
        if (this.mViewTreeKey == null) {
            this.mViewTreeKey = this.getParent() == null ? this.hashCode() + "_" + this.getRef() : this.hashCode() + "_" + this.getRef() + "_" + this.getParent().indexOf(this);
        }
        return this.mViewTreeKey;
    }

    public WXTransition getTransition() {
        return this.mTransition;
    }

    public void setTransition(WXTransition transition) {
        this.mTransition = transition;
    }

    public void addAnimationForElement(Map<String, Object> animMap) {
        if (animMap != null && !animMap.isEmpty()) {
            if (this.animations == null) {
                this.animations = new ConcurrentLinkedQueue();
            }
            this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)this.getRef(), animMap));
        }
    }

    private void parseAnimation() {
        if (null == this.animations) {
            return;
        }
        for (Pair<String, Map<String, Object>> pair : this.animations) {
            WXAnimationBean animationBean;
            if (TextUtils.isEmpty((CharSequence)((CharSequence)pair.first)) || (animationBean = this.createAnimationBean((String)pair.first, (Map)pair.second)) == null) continue;
            GraphicActionAnimation action = new GraphicActionAnimation(this.getInstance(), this.getRef(), animationBean);
            action.executeAction();
        }
        this.animations.clear();
    }

    private WXAnimationBean createAnimationBean(String ref, Map<String, Object> style) {
        if (style != null) {
            try {
                Object transform = style.get("transform");
                if (transform instanceof String && !TextUtils.isEmpty((CharSequence)((String)transform))) {
                    String transformOrigin = (String)style.get("transformOrigin");
                    WXAnimationBean animationBean = new WXAnimationBean();
                    int width = (int)this.getLayoutWidth();
                    int height = (int)this.getLayoutHeight();
                    animationBean.styles = new WXAnimationBean.Style();
                    animationBean.styles.init(transformOrigin, (String)transform, width, height, WXSDKManager.getInstanceViewPortWidth(this.getInstanceId()), this.getInstance());
                    return animationBean;
                }
            }
            catch (RuntimeException e) {
                WXLogUtils.e("", e);
                return null;
            }
        }
        return null;
    }

    public void lazy(boolean lazy) {
        this.mLazy = lazy;
    }

    public long getRenderObjectPtr() {
        if (this.getBasicComponentData().isRenderPtrEmpty()) {
            this.getBasicComponentData().setRenderObjectPr(NativeRenderObjectUtils.nativeGetRenderObject(this.getInstanceId(), this.getRef()));
        }
        return this.getBasicComponentData().getRenderObjectPr();
    }

    public void updateNativeAttr(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.getBasicComponentData().getAttrs().put(key, value);
        NativeRenderObjectUtils.nativeUpdateRenderObjectAttr(this.getRenderObjectPtr(), key, value.toString());
    }

    public void nativeUpdateAttrs(Map<String, Object> dynamic) {
        Set<Map.Entry<String, Object>> entries = dynamic.entrySet();
        for (Map.Entry<String, Object> objectEntry : entries) {
            if (objectEntry.getKey() == null) continue;
            this.updateNativeAttr(objectEntry.getKey(), objectEntry.getValue());
        }
    }

    public void updateNativeStyle(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.getBasicComponentData().getStyles().put(key, value);
        NativeRenderObjectUtils.nativeUpdateRenderObjectStyle(this.getRenderObjectPtr(), key, value.toString());
    }

    public void updateNativeStyles(Map<String, Object> dynamic) {
        Set<Map.Entry<String, Object>> entries = dynamic.entrySet();
        for (Map.Entry<String, Object> objectEntry : entries) {
            if (objectEntry.getKey() == null) continue;
            this.updateNativeStyle(objectEntry.getKey(), objectEntry.getValue());
        }
    }

    public void addLayerOverFlowListener(String ref) {
        if (this.getInstance() != null) {
            this.getInstance().addLayerOverFlowListener(ref);
        }
    }

    public void removeLayerOverFlowListener(String ref) {
        if (this.getInstance() != null) {
            this.getInstance().removeLayerOverFlowListener(ref);
        }
    }

    @WXComponentProp(name="hoverClass")
    public void hoverClass(String m) {
        JSONObject object = JSON.parseObject((String)m);
        if (object != null) {
            if (this.mHover == null) {
                this.mHover = new ViewHover(this, object);
            } else {
                this.mHover.update(object);
            }
            if (!this.getEvents().contains("view_hover_event")) {
                this.addEvent("view_hover_event");
            }
        }
    }

    @WXComponentProp(name="hoverStopPropagation")
    public void hoverStopPropagation(boolean is) {
        if (this.mHover == null) {
            this.mHover = new ViewHover(this);
        }
        this.mHover.setHoverStopPropagation(is);
        if (!this.getEvents().contains("view_hover_event")) {
            this.addEvent("view_hover_event");
        }
        if (this.mParent != null && is) {
            this.mParent.setHoverReceiveTouch(false);
        }
    }

    @WXComponentProp(name="hoverStartTime")
    public void hoverStartTime(int n) {
        if (this.mHover == null) {
            this.mHover = new ViewHover(this);
        }
        this.mHover.setHoverStartTime(n);
    }

    @WXComponentProp(name="hoverStayTime")
    public void hoverStayTime(int n) {
        if (this.mHover == null) {
            this.mHover = new ViewHover(this);
        }
        this.mHover.setHoverStayTime(n);
    }

    public void setHoverClassStatus(boolean status) {
        Map<String, Object> resultStyles = this.mHover.updateStatusAndGetUpdateStyles(status);
        if (null != resultStyles) {
            if (status) {
                boolean isWidth = resultStyles.keySet().contains("width");
                boolean isHeight = resultStyles.keySet().contains("height");
                if (isWidth || isHeight) {
                    this.mPseudoResetGraphicSize = new GraphicSize(this.getLayoutSize().getWidth(), this.getLayoutSize().getHeight());
                }
                if (isWidth) {
                    this.getLayoutSize().setWidth(WXViewUtils.getRealPxByWidth(WXUtils.parseFloat(resultStyles.get("width")), this.getViewPortWidthForFloat()));
                } else if (isHeight) {
                    this.getLayoutSize().setHeight(WXViewUtils.getRealPxByWidth(WXUtils.parseFloat(resultStyles.get("height")), this.getViewPortWidthForFloat()));
                }
            } else if (null != this.mPseudoResetGraphicSize) {
                this.setLayoutSize(this.mPseudoResetGraphicSize);
            }
        }
        this.updateStyleByPesudo(resultStyles);
    }

    public void setHoverReceiveTouch(boolean receiveTouch) {
        if (this.getHover() != null) {
            this.getHover().setReceiveTouch(receiveTouch);
        }
        if (this.mParent != null) {
            this.mParent.setHoverReceiveTouch(receiveTouch);
        }
    }

    public ViewHover getHover() {
        return this.mHover;
    }

    public boolean isPreventGesture() {
        return this.isPreventGesture;
    }

    @WXComponentProp(name="preventGesture")
    public void setPreventGesture(boolean enable) {
        this.isPreventGesture = enable;
        this.addEvent("preventGesture");
    }

    @Override
    public float getViewPortWidthForFloat() {
        if (this.getInstance() != null) {
            return this.getInstance().getInstanceViewPortWidthWithFloat();
        }
        return 720.0f;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER})
    public static @interface RenderState {
    }

    public static class MeasureOutput {
        public int width;
        public int height;
    }

    public static interface OnFocusChangeListener {
        public void onFocusChange(boolean var1);
    }

    public static interface OnClickListener {
        public void onHostViewClick();
    }

    private class OnClickListenerImp
    implements OnClickListener {
        private OnClickListenerImp() {
        }

        @Override
        public void onHostViewClick() {
            HashMap<String, Object> param = WXDataStructureUtil.newHashMapWithExpectedSize(1);
            HashMap<String, Float> position = WXDataStructureUtil.newHashMapWithExpectedSize(4);
            int[] location = new int[2];
            WXComponent.this.mHost.getLocationOnScreen(location);
            position.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth((float)location[0], WXComponent.this.mInstance.getInstanceViewPortWidthWithFloat())));
            position.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth((float)location[1], WXComponent.this.mInstance.getInstanceViewPortWidthWithFloat())));
            position.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.getLayoutWidth(), WXComponent.this.mInstance.getInstanceViewPortWidthWithFloat())));
            position.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(WXComponent.this.getLayoutHeight(), WXComponent.this.mInstance.getInstanceViewPortWidthWithFloat())));
            param.put("position", position);
            WXComponent.this.fireEvent("click", param);
        }
    }
}

