/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.demo;

import com.alibaba.fastjson.JSON;
import com.huifu.adapay.demo.BaseDemo;
import com.huifu.adapay.model.refund.Refund;
import java.util.HashMap;

public class RefundDemo
extends BaseDemo {
    public static void executeRefundTest(String paymentId) throws Exception {
        RefundDemo demo = new RefundDemo();
        Refund refund = demo.executeRefund(paymentId);
        demo.queryByPaymentId(paymentId);
        demo.queryByRefundId(refund.getId());
    }

    public Refund executeRefund(String paymentId) throws Exception {
        System.out.println("=======execute refund begin=======");
        HashMap<String, Object> refundParams = new HashMap<String, Object>(2);
        refundParams.put("refund_amt", "0.01");
        refundParams.put("app_id", "app_7d87c043-aae3-4357-9b2c-269349a980d6");
        refundParams.put("refund_order_no", "jsdk_refund_" + System.currentTimeMillis());
        Refund refund = Refund.create(paymentId, refundParams);
        System.out.println("refund result=" + JSON.toJSONString((Object)refund));
        return refund;
    }

    public Refund queryByPaymentId(String paymentId) throws Exception {
        System.out.println("=======query refund by paymentId begin=======");
        HashMap<String, Object> chargeParams = new HashMap<String, Object>(1);
        chargeParams.put("payment_id", paymentId);
        Refund refund = Refund.query(chargeParams);
        System.out.println("query refund by paymentid result=" + JSON.toJSONString((Object)refund));
        return refund;
    }

    public Refund queryByRefundId(String refundId) throws Exception {
        System.out.println("=======query refund by refundid begin=======");
        HashMap<String, Object> chargeParams = new HashMap<String, Object>(1);
        chargeParams.put("refund_id", refundId);
        Refund refund = Refund.query(chargeParams);
        System.out.println("query refund by refundid result=" + JSON.toJSONString((Object)refund));
        return refund;
    }
}

